/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.strategy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.search.strategy.AbstractSearchStrategy;
import org.eclipse.nebula.widgets.nattable.search.strategy.CellDisplayValueSearchUtil;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class SelectionSearchStrategy
extends AbstractSearchStrategy {
    private final IConfigRegistry configRegistry;
    private final String searchDirection;

    public SelectionSearchStrategy(IConfigRegistry configRegistry) {
        this(configRegistry, "forward");
    }

    public SelectionSearchStrategy(IConfigRegistry configRegistry, String searchDirection) {
        this.configRegistry = configRegistry;
        this.searchDirection = searchDirection;
    }

    public PositionCoordinate executeSearch(Object valueToMatch) {
        ILayer contextLayer = this.getContextLayer();
        if (!(contextLayer instanceof SelectionLayer)) {
            throw new RuntimeException("For the GridSearchStrategy to work it needs the selectionLayer to be passed as the contextLayer.");
        }
        SelectionLayer selectionLayer = (SelectionLayer)contextLayer;
        PositionCoordinate coordinate = CellDisplayValueSearchUtil.findCell(selectionLayer, this.configRegistry, this.getSelectedCells(selectionLayer), valueToMatch, this.getComparator(), this.isCaseSensitive());
        return coordinate;
    }

    protected PositionCoordinate[] getSelectedCells(SelectionLayer selectionLayer) {
        PositionCoordinate[] selectedCells = null;
        if (this.searchDirection.equals("backwards")) {
            List<PositionCoordinate> coordinates = Arrays.asList(selectionLayer.getSelectedCellPositions());
            Collections.reverse(coordinates);
            selectedCells = coordinates.toArray(new PositionCoordinate[0]);
        } else {
            selectedCells = selectionLayer.getSelectedCellPositions();
        }
        return selectedCells;
    }
}

