/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroup;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowGroupUtils {
    public static <T> IRowGroup<T> getRowGroupForRowIndex(IRowGroupModel<T> model, int rowIndex) {
        T row = model.getRowFromIndexCache(rowIndex);
        return model.getRowGroupForRow(row);
    }

    public static <T> IRowGroup<T> getOwnRowGroupForRowIndex(IRowGroupModel<T> model, int rowIndex) {
        T row = model.getRowFromIndexCache(rowIndex);
        IRowGroup<T> rowGroup = model.getRowGroupForRow(row);
        if (rowGroup != null && !rowGroup.getOwnMemberRows(true).contains(row)) {
            rowGroup = rowGroup.getRowGroupForRow(row);
        }
        return rowGroup;
    }

    public static <T> boolean isPartOfAGroup(IRowGroupModel<T> model, int rowIndex) {
        T row = model.getRowFromIndexCache(rowIndex);
        if (row != null) {
            return model.getRowGroupForRow(row) != null;
        }
        return false;
    }

    public static <T> boolean isInTheSameGroup(int fromRowIndex, int toRowIndex, IRowGroupModel<T> model) {
        T fromRow = model.getRowFromIndexCache(fromRowIndex);
        T toRow = model.getRowFromIndexCache(toRowIndex);
        IRowGroup<T> rowGroupFrom = RowGroupUtils.getTopMostParentGroup(model.getRowGroupForRow(fromRow));
        IRowGroup<T> rowGroupTo = RowGroupUtils.getTopMostParentGroup(model.getRowGroupForRow(toRow));
        return rowGroupFrom != null && rowGroupTo != null && rowGroupFrom.equals(rowGroupTo);
    }

    public static <T> boolean isCollapsed(IRowGroupModel<T> model, IRowGroup<T> group) {
        return group == null || group.isCollapsed() || RowGroupUtils.isAnyParentCollapsed(group);
    }

    public static <T> boolean isAnyParentCollapsed(IRowGroup<T> group) {
        boolean collapsed = false;
        if (group != null) {
            IRowGroup<T> topMostGroup = RowGroupUtils.getTopMostParentGroup(group);
            while (!collapsed && group != topMostGroup) {
                if ((group = group.getParentGroup()) == null) break;
                collapsed = group.isCollapsed();
            }
        }
        return collapsed;
    }

    public static <T> int sizeOfGroup(IRowGroupModel<T> model, int bodyRowIndex) {
        IRowGroup<T> group = RowGroupUtils.getRowGroupForRowIndex(model, bodyRowIndex);
        if (group != null) {
            return RowGroupUtils.getTopMostParentGroup(group).getMemberRows(true).size();
        }
        return 0;
    }

    public static <T> IRowGroup<T> getTopMostParentGroup(IRowGroup<T> rowGroup) {
        return rowGroup == null ? null : (rowGroup.getParentGroup() == null ? rowGroup : RowGroupUtils.getTopMostParentGroup(rowGroup.getParentGroup()));
    }

    public static <T> boolean isStaticRow(IRowGroupModel<T> model, int bodyRowIndex) {
        IRowGroup<T> group;
        T row = model.getRowFromIndexCache(bodyRowIndex);
        if (row != null && (group = model.getRowGroupForRow(row)) != null) {
            return group.getStaticMemberRows().contains(row);
        }
        return false;
    }

    public static boolean isRowIndexHiddenInUnderLyingLayer(int rowIndex, ILayer layer, IUniqueIndexLayer underlyingLayer) {
        return underlyingLayer.getRowPositionByIndex(rowIndex) == -1;
    }

    public static List<Integer> getRowPositionsInGroup(IUniqueIndexLayer layer, Collection<Integer> bodyRowIndexes) {
        ArrayList<Integer> rowPositions = new ArrayList<Integer>();
        for (Integer bodyRowIndex : bodyRowIndexes) {
            int rowPosition = layer.getRowPositionByIndex(bodyRowIndex);
            if (rowPosition == -1) continue;
            rowPositions.add(rowPosition);
        }
        return Collections.unmodifiableList(rowPositions);
    }

    public static <T> List<Integer> getRowIndexesInGroup(IRowGroupModel<T> model, int rowIndex) {
        IRowGroup<T> group = RowGroupUtils.getRowGroupForRowIndex(model, rowIndex);
        return RowGroupUtils.getRowIndexesInGroup(model, group, true);
    }

    public static <T> List<Integer> getRowIndexesInGroup(IRowGroupModel<T> model, IRowGroup<T> group, boolean includeStatic) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (T row : group.getMemberRows(includeStatic)) {
            indexes.add(model.getIndexFromRowCache(row));
        }
        return indexes;
    }

    public static <T> String getRowGroupNameForIndex(IRowGroupModel<T> model, int bodyRowIndex) {
        IRowGroup<T> group = RowGroupUtils.getRowGroupForRowIndex(model, bodyRowIndex);
        if (group != null) {
            return group.getGroupName();
        }
        return null;
    }
}

