/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.config.DefaultColumnGroupHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.SizeConfig;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.painter.layer.CellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class ColumnGroupGroupHeaderLayer
extends AbstractLayerTransform {
    private final SizeConfig rowHeightConfig = new SizeConfig(20);
    private final ColumnGroupModel model;
    private final ColumnGroupHeaderLayer columnGroupHeaderLayer;
    private final ILayerPainter layerPainter = new CellLayerPainter();

    public ColumnGroupGroupHeaderLayer(ColumnGroupHeaderLayer columnGroupHeaderLayer, SelectionLayer selectionLayer, ColumnGroupModel columnGroupModel) {
        this(columnGroupHeaderLayer, selectionLayer, columnGroupModel, true);
    }

    public ColumnGroupGroupHeaderLayer(ColumnGroupHeaderLayer columnGroupHeaderLayer, SelectionLayer selectionLayer, ColumnGroupModel columnGroupModel, boolean useDefaultConfiguration) {
        super(columnGroupHeaderLayer);
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
        this.model = columnGroupModel;
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultColumnGroupHeaderLayerConfiguration(columnGroupModel));
        }
    }

    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    public int getRowCount() {
        return this.columnGroupHeaderLayer.getRowCount() + 1;
    }

    public int getPreferredRowCount() {
        return this.columnGroupHeaderLayer.getPreferredRowCount() + 1;
    }

    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition == 0) {
            return rowPosition;
        }
        return this.columnGroupHeaderLayer.getRowIndexByPosition(rowPosition - 1);
    }

    public int getHeight() {
        return this.rowHeightConfig.getAggregateSize(1) + this.columnGroupHeaderLayer.getHeight();
    }

    public int getPreferredHeight() {
        return this.rowHeightConfig.getAggregateSize(1) + this.columnGroupHeaderLayer.getPreferredHeight();
    }

    public int getRowHeightByPosition(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.getSize(rowPosition);
        }
        return this.columnGroupHeaderLayer.getRowHeightByPosition(rowPosition - 1);
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeightConfig.setSize(0, rowHeight);
    }

    public boolean isRowPositionResizable(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.isPositionResizable(rowPosition);
        }
        return this.columnGroupHeaderLayer.isRowPositionResizable(rowPosition - 1);
    }

    public int getRowPositionByY(int y) {
        int row0Height = this.getRowHeightByPosition(0);
        if (y < row0Height) {
            return 0;
        }
        return 1 + this.columnGroupHeaderLayer.getRowPositionByY(y - row0Height);
    }

    public int getStartYOfRowPosition(int rowPosition) {
        if (rowPosition == 0) {
            return this.rowHeightConfig.getAggregateSize(rowPosition);
        }
        return this.getRowHeightByPosition(0) + this.columnGroupHeaderLayer.getStartYOfRowPosition(rowPosition - 1);
    }

    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        int bodyColumnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0) {
            if (this.model.isPartOfAGroup(bodyColumnIndex)) {
                return new LayerCell(this, this.getStartPositionOfGroup(columnPosition), rowPosition, columnPosition, rowPosition, this.getColumnSpan(columnPosition), 1);
            }
            ILayerCell underlyingCell = this.columnGroupHeaderLayer.getCellByPosition(columnPosition, rowPosition);
            return new LayerCell(this, underlyingCell.getOriginColumnPosition(), underlyingCell.getOriginRowPosition(), columnPosition, rowPosition, underlyingCell.getColumnSpan(), underlyingCell.getRowSpan() + 1);
        }
        if (rowPosition == 1) {
            ILayerCell underlyingCell = this.columnGroupHeaderLayer.getCellByPosition(columnPosition, rowPosition - 1);
            boolean partOfAGroup = this.model.isPartOfAGroup(bodyColumnIndex);
            return new LayerCell(this, underlyingCell.getOriginColumnPosition(), underlyingCell.getOriginRowPosition() + (partOfAGroup ? 1 : 0), columnPosition, rowPosition, underlyingCell.getColumnSpan(), underlyingCell.getRowSpan() + (partOfAGroup ? 0 : 1));
        }
        if (rowPosition == 2) {
            ILayerCell underlyingCell = this.columnGroupHeaderLayer.getCellByPosition(columnPosition, rowPosition - 1);
            boolean partOfAGroup = this.model.isPartOfAGroup(bodyColumnIndex) || this.columnGroupHeaderLayer.isColumnInGroup(bodyColumnIndex);
            return new LayerCell(this, underlyingCell.getOriginColumnPosition(), underlyingCell.getOriginRowPosition() + (partOfAGroup ? 1 : 0), columnPosition, rowPosition, underlyingCell.getColumnSpan(), underlyingCell.getRowSpan() + (partOfAGroup ? 0 : 1));
        }
        return null;
    }

    protected int getColumnSpan(int columnPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        if (columnGroup.isCollapsed()) {
            return columnGroup.getStaticColumnIndexes().size();
        }
        int startPositionOfGroup = this.getStartPositionOfGroup(columnPosition);
        int sizeOfGroup = columnGroup.getSize();
        int endPositionOfGroup = startPositionOfGroup + sizeOfGroup;
        List<Integer> columnIndexesInGroup = columnGroup.getMembers();
        int i = startPositionOfGroup;
        while (i < endPositionOfGroup) {
            int index = this.getColumnIndexByPosition(i);
            if (!columnIndexesInGroup.contains(index)) {
                --sizeOfGroup;
            }
            ++i;
        }
        return sizeOfGroup;
    }

    private int getStartPositionOfGroup(int columnPosition) {
        int bodyColumnIndex = this.getColumnIndexByPosition(columnPosition);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(bodyColumnIndex);
        int leastPossibleStartPositionOfGroup = columnPosition - columnGroup.getSize();
        int i = 0;
        i = leastPossibleStartPositionOfGroup;
        while (i < columnPosition) {
            if (ColumnGroupUtils.isInTheSameGroup(this.getColumnIndexByPosition(i), bodyColumnIndex, this.model)) break;
            ++i;
        }
        return i;
    }

    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            return "NORMAL";
        }
        return this.columnGroupHeaderLayer.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (rowPosition == 0 && this.model.isPartOfAGroup(columnIndex)) {
            return new LabelStack("COLUMN_GROUP_HEADER");
        }
        return this.columnGroupHeaderLayer.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        if (rowPosition == 0) {
            if (this.model.isPartOfAGroup(columnIndex)) {
                return columnGroup.getName();
            }
        } else {
            --rowPosition;
        }
        return this.columnGroupHeaderLayer.getDataValueByPosition(columnPosition, rowPosition);
    }

    public LabelStack getRegionLabelsByXY(int x, int y) {
        int columnIndex = this.getColumnIndexByPosition(this.getColumnPositionByX(x));
        if (this.model.isPartOfAGroup(columnIndex) && y < this.getRowHeightByPosition(0)) {
            return new LabelStack("COLUMN_GROUP_HEADER");
        }
        return this.columnGroupHeaderLayer.getRegionLabelsByXY(x, y - this.getRowHeightByPosition(0));
    }

    public void addColumnsIndexesToGroup(String colGroupName, int ... colIndexes) {
        this.model.addColumnsIndexesToGroup(colGroupName, colIndexes);
    }

    public void clearAllGroups() {
        this.model.clear();
    }

    public void setGroupUnbreakable(int columnIndex) {
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        columnGroup.setUnbreakable(true);
    }

    public void setGroupAsCollapsed(int columnIndex) {
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        columnGroup.setCollapsed(true);
    }
}

