/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnRename;

import org.eclipse.nebula.widgets.nattable.columnRename.ColumnRenameDialog;
import org.eclipse.nebula.widgets.nattable.columnRename.DisplayColumnRenameDialogCommand;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayColumnRenameDialogCommandHandler
extends AbstractLayerCommandHandler<DisplayColumnRenameDialogCommand> {
    private final ColumnHeaderLayer columnHeaderLayer;

    public DisplayColumnRenameDialogCommandHandler(ColumnHeaderLayer columnHeaderLayer) {
        this.columnHeaderLayer = columnHeaderLayer;
    }

    @Override
    protected boolean doCommand(DisplayColumnRenameDialogCommand command) {
        int columnPosition = command.getColumnPosition();
        String originalLabel = this.columnHeaderLayer.getOriginalColumnLabel(columnPosition);
        String renamedLabel = this.columnHeaderLayer.getRenamedColumnLabel(columnPosition);
        ColumnRenameDialog dialog = new ColumnRenameDialog(Display.getDefault().getActiveShell(), originalLabel, renamedLabel);
        Rectangle colHeaderBounds = this.columnHeaderLayer.getBoundsByPosition(columnPosition, 0);
        Point point = new Point(colHeaderBounds.x, colHeaderBounds.y + colHeaderBounds.height);
        dialog.setLocation(command.toDisplayCoordinates(point));
        dialog.open();
        if (dialog.isCancelPressed()) {
            return true;
        }
        return this.columnHeaderLayer.renameColumnPosition(columnPosition, dialog.getNewColumnLabel());
    }

    @Override
    public Class<DisplayColumnRenameDialogCommand> getCommandClass() {
        return DisplayColumnRenameDialogCommand.class;
    }
}

