/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gitlab.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;

public final class GitlabConfiguration
implements Serializable {
    private static final long serialVersionUID = -6859757478504901423L;
    private static final GitlabTaskSchema SCHEMA = GitlabTaskSchema.getDefault();
    private final String repositoryURL;
    private BigInteger userID;
    private JsonElement userDetails;
    private Map<String, JsonElement> projectDetailsMap = new HashMap<String, JsonElement>();
    private Map<Integer, JsonElement> projectIDsMap = new HashMap<Integer, JsonElement>();
    private ArrayList<JsonElement> projects = new ArrayList();
    private Map<String, JsonElement> groupsDetailsMap = new HashMap<String, JsonElement>();
    private List<JsonElement> groups = new ArrayList<JsonElement>();

    public GitlabConfiguration(String repositoryURL) {
        this.repositoryURL = repositoryURL;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public BigInteger getUserID() {
        return this.userID;
    }

    public void setUserID(BigInteger userID) {
        this.userID = userID;
    }

    public JsonElement getUserDetails() {
        return this.userDetails;
    }

    public void setUserDetails(JsonElement userDetails) {
        this.userDetails = userDetails;
    }

    public ArrayList<JsonElement> getProjects() {
        return this.projects;
    }

    public void addProject(JsonElement project) {
        this.projects.add(project);
        this.projectDetailsMap.put(project.getAsJsonObject().get("name_with_namespace").getAsString(), project);
        this.projectIDsMap.put(project.getAsJsonObject().get("id").getAsInt(), project);
    }

    public JsonElement getProjcetDetail(String project) {
        return this.projectDetailsMap.get(project);
    }

    public JsonElement getProjcetDetailFromNumber(Integer id) {
        return this.projectIDsMap.get(id);
    }

    public JsonElement getGroupDetail(String project) {
        return this.groupsDetailsMap.get(project);
    }

    public Set<String> getProjectNames() {
        return this.projectDetailsMap.keySet();
    }

    public Set<String> getGroupNames() {
        return this.groupsDetailsMap.keySet();
    }

    public List<JsonElement> getGroups() {
        return this.groups;
    }

    public void addGroup(JsonElement group) {
        this.groups.add(group);
        this.groupsDetailsMap.put(group.getAsJsonObject().get("full_path").getAsString(), group);
    }

    public boolean updateProductOptions(@NonNull TaskData taskData) {
        TaskAttribute typeAttrib;
        if (taskData == null) {
            return false;
        }
        TaskAttribute attributeProduct = taskData.getRoot().getMappedAttribute(GitlabConfiguration.SCHEMA.PRODUCT.getKey());
        if (attributeProduct == null) {
            return false;
        }
        for (JsonElement product : this.projects) {
            JsonObject productObject = (JsonObject)product;
            attributeProduct.putOption(productObject.get("id").getAsString(), productObject.get("name_with_namespace").getAsString());
        }
        TaskAttribute priorityAttrib = taskData.getRoot().getMappedAttribute(GitlabConfiguration.SCHEMA.PRIORITY.getKey());
        if (priorityAttrib != null) {
            priorityAttrib.putOption("CRITICAL", "critical");
            priorityAttrib.putOption("HIGH", "high");
            priorityAttrib.putOption("MEDIUM", "Medium");
            priorityAttrib.putOption("LOW", "low");
            priorityAttrib.putOption("UNKNOWN", "unknown");
        }
        if ((typeAttrib = taskData.getRoot().getMappedAttribute(GitlabConfiguration.SCHEMA.ISSUE_TYPE.getKey())) != null) {
            typeAttrib.putOption("issue", "Issue");
            typeAttrib.putOption("incident", "Incident");
        }
        return true;
    }

    public boolean updateQueryOptions(@NonNull TaskData taskData) {
        TaskAttribute stateAttrib;
        if (taskData == null) {
            return false;
        }
        TaskAttribute attributeGroups = taskData.getRoot().getMappedAttribute("GROUP");
        if (attributeGroups != null) {
            Set<String> groups = this.getGroupNames();
            for (String string : groups) {
                attributeGroups.putOption(string, string);
            }
        }
        if ((stateAttrib = taskData.getRoot().getMappedAttribute("STATE")) != null) {
            stateAttrib.putOption("opened", "Opened");
            stateAttrib.putOption("closed", "Closed");
            stateAttrib.putOption("", "All");
        }
        return this.updateProductOptions(taskData);
    }

    public String getGroupID(String path) {
        Optional<Object> groupId = Optional.ofNullable(this.groupsDetailsMap.get(path)).map(ma -> ma.getAsJsonObject().get("id").getAsString());
        if (groupId.isPresent()) {
            return (String)groupId.get();
        }
        return "";
    }

    public void addValidOperations(TaskData bugReport) {
        TaskAttribute attributeStatus = bugReport.getRoot().getMappedAttribute("task.common.status");
        String attributeStatusValue = attributeStatus.getValue();
        TaskAttribute operationAttribute = bugReport.getRoot().getAttribute("task.common.operation");
        if (operationAttribute == null) {
            operationAttribute = bugReport.getRoot().createAttribute("task.common.operation");
        }
        TaskOperation.applyTo((TaskAttribute)operationAttribute, (String)attributeStatusValue, (String)attributeStatusValue);
        TaskAttribute attribute = bugReport.getRoot().createAttribute("task.common.operation-opened");
        TaskOperation.applyTo((TaskAttribute)attribute, (String)attributeStatusValue, (String)attributeStatusValue);
        attribute = bugReport.getRoot().createAttribute("task.common.operation-closed");
        if (attributeStatusValue.equals("closed")) {
            TaskOperation.applyTo((TaskAttribute)attribute, (String)"reopen", (String)"Reopen");
        } else {
            TaskOperation.applyTo((TaskAttribute)attribute, (String)"close", (String)"Close");
        }
    }
}

