/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.ExtensionPointReader;
import org.eclipse.mylyn.commons.repositories.core.RepositoryCategory;

public class RepositoryCategoryContentProvider
implements ITreeContentProvider {
    private static final Map<String, RepositoryCategory> repositoryCategories = new HashMap<String, RepositoryCategory>();

    public RepositoryCategoryContentProvider() {
        InternalExtensionPointReader.initExtensions();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return repositoryCategories.values().toArray();
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    private static class InternalExtensionPointReader {
        public static final String EXTENSION_CUSTOM_CATEGORY = "categories";
        public static final String EXTENSION_TMPL_REPOSITORY_CATEGORY = "category";
        private static final String ELEMENT_REPOSITORY_CATEGORY_ID = "id";
        private static final String ELEMENT_REPOSITORY_CATEGORY_LABEL = "label";
        private static final String ELEMENT_REPOSITORY_CATEGORY_RANK = "rank";

        private InternalExtensionPointReader() {
        }

        private static void initExtensions() {
            ExtensionPointReader<RepositoryCategory> reader = new ExtensionPointReader<RepositoryCategory>("org.eclipse.mylyn.commons.repositories.ui", EXTENSION_CUSTOM_CATEGORY, EXTENSION_TMPL_REPOSITORY_CATEGORY, RepositoryCategory.class){

                protected RepositoryCategory readElement(IConfigurationElement element, MultiStatus result) {
                    return InternalExtensionPointReader.readRepositoryCategory(element);
                }
            };
            reader.read();
            List categories = reader.getItems();
            for (RepositoryCategory cat : categories) {
                repositoryCategories.put(cat.getId(), cat);
            }
        }

        private static RepositoryCategory readRepositoryCategory(IConfigurationElement element) {
            int rankInt;
            String id = element.getAttribute(ELEMENT_REPOSITORY_CATEGORY_ID);
            String label = element.getAttribute(ELEMENT_REPOSITORY_CATEGORY_LABEL);
            String rank = element.getAttribute(ELEMENT_REPOSITORY_CATEGORY_RANK);
            try {
                rankInt = Integer.parseInt(rank);
            }
            catch (NumberFormatException e) {
                rankInt = 0;
            }
            return new RepositoryCategory(id, label, rankInt);
        }
    }
}

