/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.editors.parts;

import org.eclipse.mylyn.internal.reviews.ui.editors.parts.Messages;
import org.eclipse.mylyn.tasks.core.ITask;

public class TaskReview {
    private final ITask review;

    public TaskReview(ITask review) {
        this.review = review;
    }

    public String getSummary() {
        return this.review.getSummary();
    }

    public int getCodeReviewScore() {
        String reviewScore = this.review.getAttribute(Messages.TaskEditorReviewsPart_CodeReviewAttribute);
        try {
            return Integer.parseInt(reviewScore);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getVerifiedScore() {
        String verifiedScore = this.review.getAttribute(Messages.TaskEditorReviewsPart_VerifiedAttribute);
        try {
            return Integer.parseInt(verifiedScore);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getIncomingChanges() {
        return this.review.getAttribute("INCOMING_REVIEW");
    }

    public String getUrl() {
        return this.review.getUrl();
    }

    public ITask.SynchronizationState getSyncState() {
        return this.review.getSynchronizationState();
    }

    public String getStatus() {
        return this.review.getAttribute("task.common.status");
    }
}

