/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.ant;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.mylyn.internal.wikitext.core.ant.MarkupTask;
import org.eclipse.mylyn.internal.wikitext.core.ant.Messages;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.XslfoDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;

public class MarkupToXslfoTask
extends MarkupTask {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    protected String xslfoFilenameFormat = "$1.fo";
    protected boolean overwrite = true;
    protected File file;
    protected File targetdir;
    private boolean generateBookmarks = true;
    private final XslfoDocumentBuilder.Configuration configuration = new XslfoDocumentBuilder.Configuration();

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToXslfoTask.0"));
        }
        if (this.file != null && !this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToXslfoTask.1"));
        }
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToXslfoTask.2"), this.file));
            }
            if (!this.file.isFile()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToXslfoTask.3"), this.file));
            }
            if (!this.file.canRead()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToXslfoTask.4"), this.file));
            }
        }
        MarkupLanguage markupLanguage = this.createMarkupLanguage();
        for (FileSet fileset : this.filesets) {
            File filesetBaseDir = fileset.getDir(this.getProject());
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            if (files == null) continue;
            File baseDir = ds.getBasedir();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File inputFile = new File(baseDir, file);
                try {
                    this.processFile(markupLanguage, filesetBaseDir, inputFile);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupToXslfoTask.5"), inputFile, e.getMessage()), (Throwable)e);
                }
                ++n2;
            }
        }
        if (this.file != null) {
            try {
                this.processFile(markupLanguage, this.file.getParentFile(), this.file);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToXslfoTask.6"), this.file, e.getMessage()), (Throwable)e);
            }
        }
    }

    protected String processFile(MarkupLanguage markupLanguage, File baseDir, File source) throws BuildException {
        this.log(MessageFormat.format(Messages.getString("MarkupToXslfoTask.7"), source), 3);
        String markupContent = null;
        String name = source.getName();
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        File outputFile = this.computeXslfoFile(source, name);
        if (this.targetdir != null) {
            outputFile = new File(this.targetdir, outputFile.getName());
        }
        if (!outputFile.exists() || this.overwrite || outputFile.lastModified() < source.lastModified()) {
            OutputStreamWriter out;
            if (markupContent == null) {
                markupContent = this.readFully(source);
            }
            this.performValidation(source, markupContent);
            try {
                out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)), "utf-8");
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToXslfoTask.8"), outputFile, e.getMessage()), (Throwable)e);
            }
            try {
                XslfoDocumentBuilder builder = new XslfoDocumentBuilder((Writer)out);
                XslfoDocumentBuilder.Configuration configuration = this.configuration.clone();
                if (configuration.getTitle() == null) {
                    configuration.setTitle(name);
                }
                builder.setConfiguration(configuration);
                builder.setBase(source.getParentFile().toURI());
                MarkupParser parser = new MarkupParser();
                parser.setMarkupLanguage(markupLanguage);
                parser.setBuilder((DocumentBuilder)builder);
                if (this.generateBookmarks) {
                    OutlineItem outline = new OutlineParser(markupLanguage).parse(markupContent);
                    builder.setOutline(outline);
                }
                parser.parse(markupContent);
            }
            catch (Throwable throwable) {
                try {
                    ((Writer)out).close();
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupToXslfoTask.9"), outputFile, e.getMessage()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                ((Writer)out).close();
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToXslfoTask.9"), outputFile, e.getMessage()), (Throwable)e);
            }
        }
        return markupContent;
    }

    protected File computeXslfoFile(File source, String name) {
        return new File(source.getParentFile(), this.xslfoFilenameFormat.replace("$1", name));
    }

    public String getXslfoFilenameFormat() {
        return this.xslfoFilenameFormat;
    }

    public void setXslfoFilenameFormat(String filenameFormat) {
        this.xslfoFilenameFormat = filenameFormat;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public File getTargetdir() {
        return this.targetdir;
    }

    public void setTargetdir(File targetdir) {
        this.targetdir = targetdir;
    }

    public String getAuthor() {
        return this.configuration.getAuthor();
    }

    public String getCopyright() {
        return this.configuration.getCopyright();
    }

    public String getDate() {
        return this.configuration.getDate();
    }

    public float getFontSize() {
        return this.configuration.getFontSize();
    }

    public float[] getFontSizeMultipliers() {
        return this.configuration.getFontSizeMultipliers();
    }

    public float getPageHeight() {
        return this.configuration.getPageHeight();
    }

    public float getPageMargin() {
        return this.configuration.getPageMargin();
    }

    public float getPageWidth() {
        return this.configuration.getPageWidth();
    }

    public String getSubTitle() {
        return this.configuration.getSubTitle();
    }

    public String getTitle() {
        return this.configuration.getTitle();
    }

    public String getVersion() {
        return this.configuration.getVersion();
    }

    public boolean isPageBreakOnHeading1() {
        return this.configuration.isPageBreakOnHeading1();
    }

    public boolean isPageNumbering() {
        return this.configuration.isPageNumbering();
    }

    public boolean isPanelText() {
        return this.configuration.isPanelText();
    }

    public boolean isShowExternalLinks() {
        return this.configuration.isShowExternalLinks();
    }

    public boolean isUnderlineLinks() {
        return this.configuration.isUnderlineLinks();
    }

    public void setAuthor(String author) {
        this.configuration.setAuthor(author);
    }

    public void setCopyright(String copyright) {
        this.configuration.setCopyright(copyright);
    }

    public void setDate(String date) {
        this.configuration.setDate(date);
    }

    public void setFontSize(float fontSize) {
        this.configuration.setFontSize(fontSize);
    }

    public void setFontSizeMultipliers(float[] fontSizeMultipliers) {
        this.configuration.setFontSizeMultipliers(fontSizeMultipliers);
    }

    public void setPageBreakOnHeading1(boolean pageBreakOnHeading1) {
        this.configuration.setPageBreakOnHeading1(pageBreakOnHeading1);
    }

    public void setPageHeight(float pageHeight) {
        this.configuration.setPageHeight(pageHeight);
    }

    public void setPageMargin(float pageMargin) {
        this.configuration.setPageMargin(pageMargin);
    }

    public void setPageNumbering(boolean pageNumbering) {
        this.configuration.setPageNumbering(pageNumbering);
    }

    public void setPageWidth(float pageWidth) {
        this.configuration.setPageWidth(pageWidth);
    }

    public void setPanelText(boolean panelText) {
        this.configuration.setPanelText(panelText);
    }

    public void setShowExternalLinks(boolean showExternalLinks) {
        this.configuration.setShowExternalLinks(showExternalLinks);
    }

    public void setSubTitle(String subTitle) {
        this.configuration.setSubTitle(subTitle);
    }

    public void setTitle(String title) {
        this.configuration.setTitle(title);
    }

    public void setUnderlineLinks(boolean underlineLinks) {
        this.configuration.setUnderlineLinks(underlineLinks);
    }

    public void setVersion(String version) {
        this.configuration.setVersion(version);
    }

    public boolean isGenerateBookmarks() {
        return this.generateBookmarks;
    }

    public void setGenerateBookmarks(boolean generateBookmarks) {
        this.generateBookmarks = generateBookmarks;
    }
}

