/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssParser;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssRule;
import org.eclipse.mylyn.internal.wikitext.core.util.css.ElementInfo;
import org.eclipse.mylyn.internal.wikitext.core.util.css.Stylesheet;
import org.eclipse.mylyn.internal.wikitext.ui.util.ImageCache;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.CssStyleManager;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.FontState;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.Util;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.BulletAnnotation;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.HorizontalRuleAnnotation;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.ImageAnnotation;
import org.eclipse.mylyn.wikitext.core.util.IgnoreDtdEntityResolver;
import org.eclipse.mylyn.wikitext.ui.annotation.AnchorHrefAnnotation;
import org.eclipse.mylyn.wikitext.ui.annotation.AnchorNameAnnotation;
import org.eclipse.mylyn.wikitext.ui.annotation.ClassAnnotation;
import org.eclipse.mylyn.wikitext.ui.annotation.IdAnnotation;
import org.eclipse.mylyn.wikitext.ui.annotation.TitleAnnotation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HtmlTextPresentationParser {
    private static Set<String> spanElements = new HashSet<String>();
    private static Set<String> blockElements = new HashSet<String>();
    private static Set<String> whitespaceCollapsingElements = new HashSet<String>();
    private static Stylesheet defaultStylesheet;
    private IAnnotationModel annotationModel;
    private TextPresentation presentation;
    private String text;
    private Font defaultFont;
    private Font defaultMonospaceFont;
    private Color defaultForeground;
    private Color defaultBackground;
    private char[] bulletChars = new char[]{'\u2022'};
    private CssStyleManager cssStyleManager;
    private boolean enableImages = false;
    private ImageCache imageCache = new ImageCache();
    private Stylesheet stylesheet = HtmlTextPresentationParser.getDefaultStylesheet();
    private final CssParser cssParser = new CssParser();
    private static Map<String, char[]> elementToCharacters;
    private GC gc;
    private int maxWidth;

    static {
        spanElements.add("a");
        spanElements.add("abbr");
        spanElements.add("acronym");
        spanElements.add("b");
        spanElements.add("big");
        spanElements.add("blink");
        spanElements.add("cite");
        spanElements.add("code");
        spanElements.add("del");
        spanElements.add("dfn");
        spanElements.add("em");
        spanElements.add("font");
        spanElements.add("i");
        spanElements.add("img");
        spanElements.add("ins");
        spanElements.add("label");
        spanElements.add("q");
        spanElements.add("s");
        spanElements.add("samp");
        spanElements.add("small");
        spanElements.add("span");
        spanElements.add("strike");
        spanElements.add("strong");
        spanElements.add("sub");
        spanElements.add("sup");
        spanElements.add("tt");
        spanElements.add("u");
        spanElements.add("var");
        blockElements.add("div");
        blockElements.add("dl");
        blockElements.add("form");
        blockElements.add("h1");
        blockElements.add("h2");
        blockElements.add("h3");
        blockElements.add("h4");
        blockElements.add("h5");
        blockElements.add("h6");
        blockElements.add("ol");
        blockElements.add("p");
        blockElements.add("pre");
        blockElements.add("table");
        blockElements.add("textarea");
        blockElements.add("td");
        blockElements.add("tr");
        blockElements.add("ul");
        blockElements.add("tbody");
        blockElements.add("thead");
        blockElements.add("tfoot");
        blockElements.add("li");
        blockElements.add("dd");
        blockElements.add("dt");
        whitespaceCollapsingElements.add("br");
        whitespaceCollapsingElements.add("hr");
        elementToCharacters = new HashMap<String, char[]>();
        elementToCharacters.put("p", "\n\n".toCharArray());
        elementToCharacters.put("br", "\n".toCharArray());
        elementToCharacters.put("tr", "\n".toCharArray());
        elementToCharacters.put("table", "\n\n".toCharArray());
        elementToCharacters.put("ol", "\n\n".toCharArray());
        elementToCharacters.put("ul", "\n\n".toCharArray());
        elementToCharacters.put("dl", "\n\n".toCharArray());
        elementToCharacters.put("h1", "\n\n".toCharArray());
        elementToCharacters.put("h2", "\n\n".toCharArray());
        elementToCharacters.put("h3", "\n\n".toCharArray());
        elementToCharacters.put("h4", "\n\n".toCharArray());
        elementToCharacters.put("h5", "\n\n".toCharArray());
        elementToCharacters.put("h6", "\n\n".toCharArray());
        elementToCharacters.put("blockquote", "\n\n".toCharArray());
        elementToCharacters.put("pre", "\n\n".toCharArray());
        elementToCharacters.put("th", " \t".toCharArray());
        elementToCharacters.put("td", " \t".toCharArray());
        elementToCharacters.put("dt", "\n".toCharArray());
        elementToCharacters.put("dd", "\n".toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Stylesheet getDefaultStylesheet() {
        Class<HtmlTextPresentationParser> clazz = HtmlTextPresentationParser.class;
        synchronized (HtmlTextPresentationParser.class) {
            if (defaultStylesheet == null) {
                try (Reader reader = HtmlTextPresentationParser.getDefaultStylesheetContent();){
                    defaultStylesheet = new CssParser().parse(reader);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultStylesheet;
        }
    }

    public static Reader getDefaultStylesheetContent() throws IOException {
        return new InputStreamReader(HtmlTextPresentationParser.class.getResourceAsStream("default.css"), StandardCharsets.UTF_8);
    }

    public TextPresentation getPresentation() {
        return this.presentation;
    }

    public void setPresentation(TextPresentation presentation) {
        this.presentation = presentation;
        if (presentation != null && presentation.getDefaultStyleRange() != null) {
            if (presentation.getDefaultStyleRange().font != null) {
                this.defaultFont = presentation.getDefaultStyleRange().font;
            }
            if (presentation.getDefaultStyleRange().foreground != null) {
                this.defaultForeground = presentation.getDefaultStyleRange().foreground;
            }
            if (presentation.getDefaultStyleRange().foreground != null) {
                this.defaultForeground = presentation.getDefaultStyleRange().background;
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public Font getDefaultMonospaceFont() {
        return this.defaultMonospaceFont;
    }

    public void setDefaultMonospaceFont(Font defaultMonospaceFont) {
        this.defaultMonospaceFont = defaultMonospaceFont;
    }

    public Color getDefaultForeground() {
        return this.defaultForeground;
    }

    public void setDefaultForeground(Color defaultForeground) {
        this.defaultForeground = defaultForeground;
    }

    public Color getDefaultBackground() {
        return this.defaultBackground;
    }

    public void setDefaultBackground(Color defaultBackground) {
        this.defaultBackground = defaultBackground;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public void setStylesheet(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public void setAnnotationModel(IAnnotationModel annotationModel) {
        this.annotationModel = annotationModel;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setGC(GC gc) {
        this.gc = gc;
    }

    public void parse(String xhtmlContent) throws SAXException, IOException {
        this.parse(new InputSource(new StringReader(xhtmlContent)));
    }

    public void parse(InputSource xhtmlInput) throws SAXException, IOException {
        SAXParser saxParser;
        if (this.presentation == null) {
            throw new IllegalStateException(Messages.HtmlTextPresentationParser_presentationRequired);
        }
        if (this.defaultFont == null) {
            throw new IllegalStateException(Messages.HtmlTextPresentationParser_defaultFontRequired);
        }
        this.cssStyleManager = new CssStyleManager(this.defaultFont, this.defaultMonospaceFont);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        XMLReader parser = saxParser.getXMLReader();
        parser.setEntityResolver((EntityResolver)IgnoreDtdEntityResolver.getInstance());
        parser.setContentHandler(new HtmlContentHandler());
        parser.parse(xhtmlInput);
    }

    private static String trimLeft(String text) {
        int len = text.length();
        int st = 0;
        while (st < len && text.charAt(st) <= ' ') {
            ++st;
        }
        return st > 0 ? text.substring(st, len) : text;
    }

    public List<Annotation> computePrefixAnnotations(ElementState elementState) {
        while (elementState != null) {
            if (elementState.prefixAnnotations != null) {
                List<Annotation> prefixAnnotations = elementState.prefixAnnotations;
                elementState.prefixAnnotations = null;
                return prefixAnnotations;
            }
            elementState = elementState.parent;
        }
        return null;
    }

    public char[] computePrefix(ElementState elementState) {
        while (elementState != null) {
            if (elementState.prefix != null) {
                char[] prefix = elementState.prefix;
                elementState.prefix = null;
                return prefix;
            }
            elementState = elementState.parent;
        }
        return null;
    }

    private static String trimRight(String text) {
        int len = text.length();
        while (len > 0 && text.charAt(len - 1) <= ' ') {
            --len;
        }
        return len < text.length() ? text.substring(0, len) : text;
    }

    public char[] getBulletChars() {
        return this.bulletChars;
    }

    public void setBulletChars(char[] bulletChars) {
        this.bulletChars = bulletChars;
    }

    public boolean isEnableImages() {
        return this.enableImages;
    }

    public void setEnableImages(boolean enableImages) {
        this.enableImages = enableImages;
    }

    public ImageCache getImageCache() {
        return this.imageCache;
    }

    public void setImageCache(ImageCache imageCache) {
        this.imageCache = imageCache;
    }

    private static class ElementState
    implements ElementInfo {
        String elementName;
        int childCount = 0;
        int textChildCount = 0;
        final int originalOffset;
        int offset;
        boolean skipWhitespace = true;
        boolean spanElement;
        boolean blockElement;
        boolean noWhitespaceTextContainer;
        boolean collapsesAdjacentWhitespace;
        final FontState fontState;
        int orderedListIndex = 0;
        int indentLevel = 0;
        int bulletLevel = 0;
        List<Annotation> annotations;
        char[] prefix;
        List<Annotation> prefixAnnotations;
        ElementState lastChild;
        final ElementState parent;
        private String id;
        private String[] cssClasses;
        public int textOffset;

        public ElementState(ElementState parent, String elementName, ElementState elementState, int offset, Attributes atts) {
            this.parent = parent;
            this.elementName = elementName;
            this.fontState = new FontState(elementState.fontState);
            this.offset = offset;
            this.originalOffset = offset;
            this.skipWhitespace = elementState.skipWhitespace;
            this.indentLevel = elementState.indentLevel;
            this.bulletLevel = elementState.bulletLevel;
            this.initState();
            String cssClass = null;
            int x = 0;
            while (x < atts.getLength()) {
                String localName = atts.getLocalName(x);
                if ("id".equals(localName)) {
                    this.id = atts.getValue(x);
                } else if ("class".equals(localName)) {
                    cssClass = atts.getValue(x);
                }
                if (this.id != null && cssClass != null) break;
                ++x;
            }
            if (cssClass != null) {
                this.cssClasses = cssClass.split("\\s+");
                if (this.cssClasses.length > 1) {
                    Arrays.sort(this.cssClasses);
                }
            }
        }

        public ElementState(ElementState parent, String elementName, FontState fontState, int offset) {
            this.parent = parent;
            this.elementName = elementName;
            this.fontState = new FontState(fontState);
            this.offset = offset;
            this.originalOffset = offset;
            this.initState();
        }

        private void initState() {
            String elementName = this.elementName.toLowerCase();
            this.spanElement = spanElements.contains(elementName);
            this.blockElement = blockElements.contains(elementName);
            this.collapsesAdjacentWhitespace = whitespaceCollapsingElements.contains(elementName);
            this.noWhitespaceTextContainer = "body".equals(elementName);
        }

        public void addAnnotation(Annotation annotation) {
            if (this.annotations == null) {
                this.annotations = new ArrayList<Annotation>(2);
            }
            this.annotations.add(annotation);
        }

        public void addPrefixAnnotation(Annotation annotation) {
            if (this.prefixAnnotations == null) {
                this.prefixAnnotations = new ArrayList<Annotation>(1);
            }
            this.prefixAnnotations.add(annotation);
        }

        public String getLocalName() {
            return this.elementName;
        }

        public ElementInfo getParent() {
            return this.parent;
        }

        public boolean hasCssClass(String cssClass) {
            return this.cssClasses != null && Arrays.binarySearch(this.cssClasses, cssClass) >= 0;
        }

        public boolean hasId(String id) {
            return id != null && id.equals(this.id);
        }
    }

    private class HtmlContentHandler
    implements ContentHandler {
        private final Stack<ElementState> state = new Stack();
        private int lastNewlineOffset = 0;
        private final StringBuilder out = new StringBuilder(2048);
        private final List<StyleRange> styleRanges = new ArrayList<StyleRange>();
        private final Map<Annotation, Position> annotationToPosition = new IdentityHashMap<Annotation, Position>();
        private final StringBuilder elementText = new StringBuilder();

        private HtmlContentHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.state.isEmpty()) {
                ElementState elementState = this.state.peek();
                if (elementState.noWhitespaceTextContainer || elementState.blockElement && elementState.skipWhitespace && elementState.textChildCount == 0 && elementState.childCount == 0 || elementState.lastChild != null && elementState.lastChild.collapsesAdjacentWhitespace) {
                    int skip = 0;
                    while (skip < length && Character.isWhitespace(ch[start + skip])) {
                        ++skip;
                    }
                    start += skip;
                    length -= skip;
                }
                elementState.lastChild = null;
                if (length != 0) {
                    ++elementState.textChildCount;
                    this.append(elementState, ch, start, length);
                }
            }
        }

        private void append(ElementState elementState, char[] ch, int start, int length) {
            if (elementState.skipWhitespace) {
                int previousWhitespaceIndex = Integer.MIN_VALUE;
                int x = 0;
                while (x < length) {
                    int index = start + x;
                    char c = ch[index];
                    if (Character.isWhitespace(c)) {
                        if (previousWhitespaceIndex == index - 1) {
                            previousWhitespaceIndex = index;
                        } else {
                            previousWhitespaceIndex = index;
                            this.elementText.append(c == '\t' ? c : (char)' ');
                        }
                    } else {
                        this.elementText.append(c);
                    }
                    ++x;
                }
            } else {
                this.elementText.append(ch, start, length);
            }
        }

        public void emitText(ElementState elementState, boolean elementClosing) {
            elementState.textOffset = elementState.offset;
            if (this.state.isEmpty() || this.elementText.length() == 0) {
                return;
            }
            String text = this.elementText.toString();
            if (elementState.skipWhitespace) {
                if (elementClosing) {
                    if (elementState.childCount == 0) {
                        if (elementState.blockElement) {
                            text = text.trim();
                        }
                    } else if (elementState.blockElement) {
                        text = HtmlTextPresentationParser.trimRight(text);
                    }
                } else {
                    String originalText = text;
                    if (elementState.blockElement && elementState.childCount == 0 && (text = HtmlTextPresentationParser.trimLeft(text)).length() == 0 && originalText.length() > 0) {
                        text = originalText.substring(0, 1);
                    }
                }
            }
            this.elementText.delete(0, this.elementText.length());
            if (text.length() > 0) {
                this.emitChars(elementState, text.toCharArray());
            }
        }

        private void emitChar(char c) {
            this.out.append(c);
            this.lastNewlineOffset = this.getOffset();
        }

        private void emitChars(ElementState elementState, char[] chars) {
            int x;
            int indentLevel = elementState.indentLevel;
            boolean enforceMaxWidth = HtmlTextPresentationParser.this.maxWidth > 0 && HtmlTextPresentationParser.this.gc != null;
            int lastBreakPosition = this.lastNewlineOffset + 1;
            if (enforceMaxWidth) {
                x = this.out.length() - 1;
                while (x >= 0) {
                    char ch = this.out.charAt(x);
                    if (x == this.lastNewlineOffset + 1) break;
                    if (ch == '-') {
                        lastBreakPosition = x + 1;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        lastBreakPosition = x;
                        break;
                    }
                    --x;
                }
            }
            x = 0;
            while (x < chars.length) {
                char c = chars[x];
                if (this.lastNewlineOffset == this.getOffset() && c != '\n' && c != '\r' && indentLevel > 0) {
                    int y = 0;
                    while (y < indentLevel) {
                        this.out.append('\t');
                        ++y;
                    }
                }
                if (x == 0) {
                    char[] prefix = HtmlTextPresentationParser.this.computePrefix(elementState);
                    if (prefix != null) {
                        int offset = this.out.length();
                        char[] cArray = prefix;
                        int n = prefix.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char element = cArray[n2];
                            this.out.append(element);
                            ++n2;
                        }
                        List<Annotation> prefixAnnotations = HtmlTextPresentationParser.this.computePrefixAnnotations(elementState);
                        if (prefixAnnotations != null && HtmlTextPresentationParser.this.annotationModel != null) {
                            for (Annotation annotation : prefixAnnotations) {
                                HtmlTextPresentationParser.this.annotationModel.addAnnotation(annotation, new Position(offset, 1));
                            }
                        }
                    }
                    elementState.textOffset = this.getOffset();
                }
                this.out.append(c);
                if (c == '-') {
                    lastBreakPosition = this.getOffset() + 1;
                } else if (Character.isWhitespace(c)) {
                    lastBreakPosition = this.getOffset();
                }
                if (c == '\n') {
                    this.lastNewlineOffset = this.getOffset();
                    lastBreakPosition = this.getOffset() + 1;
                } else if (enforceMaxWidth) {
                    Point extent = HtmlTextPresentationParser.this.gc.textExtent(this.out.substring(this.lastNewlineOffset + 1, this.out.length()));
                    if (extent.x >= HtmlTextPresentationParser.this.maxWidth - 2) {
                        if (lastBreakPosition <= this.getOffset()) {
                            this.out.insert(lastBreakPosition, '\n');
                            this.lastNewlineOffset = lastBreakPosition;
                            lastBreakPosition = this.lastNewlineOffset + 1;
                        } else {
                            this.out.append('\n');
                            this.lastNewlineOffset = this.getOffset();
                            lastBreakPosition = this.getOffset() + 1;
                        }
                    }
                }
                ++x;
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            char[] ch;
            ElementState elementState = this.state.peek();
            this.emitText(elementState, true);
            this.emitStyles();
            if (elementState.annotations != null) {
                for (Annotation annotation : elementState.annotations) {
                    this.annotationToPosition.put(annotation, new Position(elementState.textOffset, this.getOffset() - elementState.textOffset));
                }
            }
            if ((ch = (char[])elementToCharacters.get(localName.toLowerCase())) != null) {
                boolean skip = false;
                if (this.state.size() > 1 && (elementState.elementName.equals("ul") || elementState.elementName.equals("ol") || elementState.elementName.equals("dl"))) {
                    ElementState parentState = (ElementState)this.state.get(this.state.size() - 2);
                    if (parentState.elementName.equals("li") || parentState.elementName.equals("dt") || parentState.elementName.equals("dd")) {
                        skip = true;
                    }
                }
                if (!skip) {
                    this.emitPartial(elementState, ch);
                }
            }
            ElementState lastChild = this.state.pop();
            if (localName.equals("hr")) {
                this.emitChar('\n');
            } else if (localName.equals("img") && HtmlTextPresentationParser.this.enableImages) {
                for (Annotation annotation : elementState.annotations) {
                    char lastChar;
                    if (!(annotation instanceof ImageAnnotation)) continue;
                    ImageAnnotation imageAnnotation = (ImageAnnotation)annotation;
                    if (this.out.length() > 0 && (lastChar = this.out.charAt(this.out.length() - 1)) != '\n' && lastChar != '\r') {
                        this.emitChar('\n');
                        Position position = this.annotationToPosition.get((Object)imageAnnotation);
                        this.annotationToPosition.put(imageAnnotation, new Position(position.getOffset() + 1, position.getLength()));
                    }
                    if (imageAnnotation.getImage() == null) continue;
                    int height = imageAnnotation.getImage().getBounds().height;
                    HtmlTextPresentationParser.this.gc.setFont(HtmlTextPresentationParser.this.defaultFont);
                    Point extent = HtmlTextPresentationParser.this.gc.textExtent("\n");
                    if (extent.y <= 0) continue;
                    int numNewlines = (int)Math.ceil((double)height / (double)extent.y);
                    int x = 0;
                    while (x < numNewlines && x < 1000) {
                        this.emitChar('\n');
                        ++x;
                    }
                }
            }
            if (!this.state.isEmpty()) {
                elementState = this.state.peek();
                elementState.offset = this.getOffset();
                elementState.lastChild = lastChild;
            }
        }

        private void emitPartial(ElementState elementState, char[] ch) {
            int matchShift = -1;
            int shift = 0;
            while (shift < ch.length) {
                if (this.endsWith(this.out, ch, shift, ch.length - shift)) {
                    matchShift = shift;
                    break;
                }
                ++shift;
            }
            if (matchShift > 0) {
                char[] c2 = new char[ch.length - matchShift];
                System.arraycopy(ch, matchShift, c2, 0, c2.length);
                this.emitChars(elementState, c2);
            } else if (matchShift == -1) {
                this.emitChars(elementState, ch);
            }
        }

        private boolean endsWith(StringBuilder out, char[] ch, int offset, int length) {
            if (out.length() >= length) {
                int x = 0;
                while (x < length) {
                    if (out.charAt(out.length() - length + x) != ch[x + offset]) {
                        return false;
                    }
                    ++x;
                }
                return true;
            }
            return false;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            String url;
            final ElementState parentElementState = this.state.peek();
            this.emitText(parentElementState, false);
            this.emitStyles();
            ++parentElementState.childCount;
            final ElementState elementState = this.state.push(new ElementState(parentElementState, localName, this.state.peek(), this.getOffset(), atts));
            if ("pre".equals(localName)) {
                elementState.skipWhitespace = false;
            } else if ("ul".equals(localName) || "ol".equals(localName)) {
                ++elementState.indentLevel;
                ++elementState.bulletLevel;
            } else if ("blockquote".equals(localName) || "dd".equals(localName)) {
                ++elementState.indentLevel;
            }
            HtmlTextPresentationParser.this.stylesheet.applyTo((ElementInfo)elementState, new Stylesheet.Receiver(){

                public void apply(CssRule rule) {
                    HtmlTextPresentationParser.this.cssStyleManager.processCssStyles(elementState.fontState, parentElementState.fontState, rule);
                }
            });
            int numAtts = atts.getLength();
            int x = 0;
            while (x < numAtts) {
                String attName = atts.getLocalName(x);
                if ("style".equals(attName)) {
                    String styleValue = atts.getValue(x);
                    if (styleValue != null) {
                        Iterator ruleIterator = HtmlTextPresentationParser.this.cssParser.createRuleIterator(styleValue);
                        while (ruleIterator.hasNext()) {
                            HtmlTextPresentationParser.this.cssStyleManager.processCssStyles(elementState.fontState, parentElementState.fontState, (CssRule)ruleIterator.next());
                        }
                    }
                } else if ("id".equals(attName)) {
                    elementState.addAnnotation(new IdAnnotation(atts.getValue(x)));
                } else if ("href".equals(attName)) {
                    elementState.addAnnotation(new AnchorHrefAnnotation(atts.getValue(x)));
                } else if ("href".equals(attName)) {
                    elementState.addAnnotation(new TitleAnnotation(atts.getValue(x), localName));
                } else if ("name".equals(attName)) {
                    if ("a".equals(localName)) {
                        elementState.addAnnotation(new AnchorNameAnnotation(atts.getValue(x)));
                    }
                } else if ("class".equals(attName)) {
                    elementState.addAnnotation(new ClassAnnotation(atts.getValue(x)));
                } else if ("title".equals(attName)) {
                    elementState.addAnnotation(new TitleAnnotation(atts.getValue(x), localName));
                } else if ("start".equals(attName) && "ol".equals(localName)) {
                    try {
                        elementState.orderedListIndex = Integer.parseInt(atts.getValue(x), 10) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++x;
            }
            if ("li".equals(localName)) {
                int index;
                ElementState parentState = this.state.size() > 1 ? (ElementState)this.state.get(this.state.size() - 2) : null;
                boolean numeric = parentState == null ? false : parentState.elementName.equals("ol");
                int n = index = parentState == null ? 1 : (parentState.orderedListIndex = parentState.orderedListIndex + 1);
                if (this.lastNewlineOffset != this.getOffset()) {
                    this.emitChars(this.state.peek(), "\n".toCharArray());
                }
                if (numeric) {
                    elementState.prefix = (String.valueOf(Integer.toString(index)) + ". ").toCharArray();
                } else {
                    elementState.prefix = new char[]{this.calculateBulletChar(elementState.indentLevel), ' ', ' '};
                    elementState.addPrefixAnnotation(new BulletAnnotation(elementState.bulletLevel));
                }
            } else if ("p".equals(localName)) {
                char lastChar;
                if (this.out.length() > 0 && (lastChar = this.out.charAt(this.out.length() - 1)) != '\n') {
                    this.emitChars(this.state.peek(), "\n\n".toCharArray());
                }
            } else if ("hr".equals(localName)) {
                elementState.addAnnotation(new HorizontalRuleAnnotation());
            } else if ("img".equals(localName) && HtmlTextPresentationParser.this.enableImages && (url = atts.getValue("src")) != null && url.trim().length() > 0) {
                ImageAnnotation imageAnnotation = new ImageAnnotation(url.trim(), HtmlTextPresentationParser.this.imageCache.getMissingImage());
                elementState.addAnnotation(imageAnnotation);
                ElementState imageAnnotationAncestorState = elementState;
                while (imageAnnotationAncestorState != null) {
                    if (imageAnnotationAncestorState.annotations != null) {
                        for (Annotation annotation : imageAnnotationAncestorState.annotations) {
                            if (!(annotation instanceof AnchorHrefAnnotation)) continue;
                            imageAnnotation.setAnchorHrefAnnotation((AnchorHrefAnnotation)annotation);
                            break;
                        }
                    }
                    if (imageAnnotation.getHyperlnkAnnotation() != null) break;
                    imageAnnotationAncestorState = imageAnnotationAncestorState.parent;
                }
            }
        }

        private char calculateBulletChar(int indentLevel) {
            return HtmlTextPresentationParser.this.bulletChars[Math.min(indentLevel - 1, HtmlTextPresentationParser.this.bulletChars.length - 1)];
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (!this.state.isEmpty()) {
                ElementState elementState = this.state.peek();
                if (!elementState.skipWhitespace) {
                    ++elementState.textChildCount;
                    this.characters(ch, start, length);
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (HtmlTextPresentationParser.this.annotationModel != null) {
                for (Map.Entry<Annotation, Position> a : this.annotationToPosition.entrySet()) {
                    HtmlTextPresentationParser.this.annotationModel.addAnnotation(a.getKey(), a.getValue());
                }
            }
            this.trimTrailingWhitespace();
            HtmlTextPresentationParser.this.text = this.out.toString();
            HtmlTextPresentationParser.this.presentation.replaceStyleRanges(this.styleRanges.toArray(new StyleRange[this.styleRanges.size()]));
            if (HtmlTextPresentationParser.this.annotationModel != null) {
                String idPrefix = IdAnnotation.class.getPackage().getName();
                Iterator annotationIterator = HtmlTextPresentationParser.this.annotationModel.getAnnotationIterator();
                while (annotationIterator.hasNext()) {
                    Annotation annotation = (Annotation)annotationIterator.next();
                    if (!annotation.getType().startsWith(idPrefix) || this.annotationToPosition.containsKey(annotation)) continue;
                    annotationIterator.remove();
                }
            }
            this.state.clear();
        }

        private void trimTrailingWhitespace() {
            int length = this.out.length();
            int x = length - 1;
            while (x >= 0) {
                if (!Character.isWhitespace(this.out.charAt(x))) break;
                if (Util.annotationsIncludeOffset(HtmlTextPresentationParser.this.annotationModel, x)) {
                    return;
                }
                length = x--;
            }
            if (length != this.out.length()) {
                this.out.delete(length, this.out.length());
                Iterator<StyleRange> styleIt = this.styleRanges.iterator();
                while (styleIt.hasNext()) {
                    StyleRange styleRange = styleIt.next();
                    if (styleRange.start >= length) {
                        styleIt.remove();
                        continue;
                    }
                    int styleEnd = styleRange.start + styleRange.length;
                    if (styleEnd <= length) continue;
                    styleRange.length -= styleEnd - length;
                }
            }
        }

        @Override
        public void startDocument() throws SAXException {
            ElementState elementState = this.state.push(new ElementState(null, "<document>", new FontState(), this.getOffset()));
            elementState.fontState.foreground = HtmlTextPresentationParser.this.defaultForeground == null ? null : HtmlTextPresentationParser.this.defaultForeground.getRGB();
            elementState.fontState.background = HtmlTextPresentationParser.this.defaultBackground == null ? null : HtmlTextPresentationParser.this.defaultBackground.getRGB();
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        private void emitStyles() {
            boolean split;
            if (this.state.isEmpty()) {
                return;
            }
            ElementState elementState = this.state.peek();
            int offset = elementState.offset;
            if (offset >= this.getOffset()) {
                return;
            }
            if (elementState.fontState.equals(((ElementState)this.state.get((int)0)).fontState)) {
                return;
            }
            int length = this.getOffset() - offset;
            boolean underline = elementState.fontState.isUnderline();
            boolean strikethrough = elementState.fontState.isStrikethrough();
            boolean bl = split = offset != elementState.textOffset && (underline || strikethrough);
            if (split) {
                length = elementState.textOffset - offset;
                elementState.fontState.setStrikethrough(false);
                elementState.fontState.setUnderline(false);
            }
            StyleRange styleRange = HtmlTextPresentationParser.this.cssStyleManager.createStyleRange(elementState.fontState, offset, length);
            this.styleRanges.add(styleRange);
            if (split) {
                offset = elementState.textOffset;
                length = this.getOffset() - elementState.textOffset;
                elementState.fontState.setStrikethrough(strikethrough);
                elementState.fontState.setUnderline(underline);
                styleRange = HtmlTextPresentationParser.this.cssStyleManager.createStyleRange(elementState.fontState, offset, length);
                this.styleRanges.add(styleRange);
            }
        }

        private int getOffset() {
            return this.out.length();
        }
    }
}

