/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gerrit.common.data.AccountDashboardInfo;
import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.common.data.AccountService;
import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.ChangeListService;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.common.data.ReviewerResult;
import com.google.gerrit.common.data.SingleListChangeInfo;
import com.google.gerrit.common.data.ToggleStarRequest;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.AccountDiffPreference;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.Branch;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.ChangeMessage;
import com.google.gerrit.reviewdb.ContributorAgreement;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchLineComment;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.PatchSetInfo;
import com.google.gerrit.reviewdb.Project;
import com.google.gerrit.reviewdb.UserIdentity;
import com.google.gson.reflect.TypeToken;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwtjsonrpc.client.RemoteJsonService;
import com.google.gwtjsonrpc.client.VoidResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritAuthenticationState;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHtmlProcessor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritService;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritSystemInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritVersion;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.PatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.client.ProjectByNameComparator;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeManageService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritSystemAccount;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchDetailService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchScriptX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchSetPublishDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ProjectAdminService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ProjectDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.SubmitRecord;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritQueryResult;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AbandonInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AccountInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ActionInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AddReviewerResult;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo29;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeMessageInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommentInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommentInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ProjectInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RelatedChangeAndCommitInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RelatedChangesInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RestoreInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewerInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewerInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RevisionInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.SubmitInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.SubmitInput;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.spi.ReviewsClient;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactoryProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class GerritClient
extends ReviewsClient {
    private static final Pattern GERRIT_VERSION_PATTERN = Pattern.compile("Powered by Gerrit Code Review (.+)</p>");
    private static final String GET_LABELS_OPTION = "LABELS";
    private final String NOT_SIGNED_IN = "Not Signed In";
    private final String OK = "OK";
    private final String NEED = "NEED";
    private final String REJECT = "REJECT";
    final String MAY = "MAY";
    private final GerritHttpClient client;
    private volatile GerritConfiguration config;
    private Account myAcount;
    private Version myVersion;
    private final Map<Class<? extends RemoteJsonService>, RemoteJsonService> serviceByClass;
    private volatile boolean configRefreshed;
    private boolean restQueryAPIEnabled;

    public boolean isAuthenticationException(Throwable exception) {
        if (exception instanceof GerritException) {
            return ((GerritException)exception).getCode() == -32603 && "Invalid xsrfKey in request".equals(((GerritException)exception).getMessage());
        }
        return false;
    }

    public boolean isNotSignedInException(Throwable exception) {
        if (exception instanceof GerritException) {
            return ((GerritException)exception).getCode() == -32603 && "Not Signed In".equalsIgnoreCase(((GerritException)exception).getMessage());
        }
        return false;
    }

    public static GerritAuthenticationState authStateFromString(String token) {
        try {
            JSonSupport support = new JSonSupport();
            return (GerritAuthenticationState)support.parseResponse(token, (Type)((Object)GerritAuthenticationState.class));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String authStateToString(GerritAuthenticationState authState) {
        if (authState == null) {
            return null;
        }
        try {
            JSonSupport support = new JSonSupport();
            return support.toJson(authState);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public GerritClient(TaskRepository repository, AbstractWebLocation location) {
        this(repository, location, null, null, null);
    }

    public GerritClient(TaskRepository repository, AbstractWebLocation location, GerritConfiguration config, GerritAuthenticationState authState) {
        this(repository, location, config, authState, null);
    }

    public GerritClient(TaskRepository repository, AbstractWebLocation location, GerritConfiguration config, GerritAuthenticationState authState, String xsrfKey) {
        super(repository);
        this.client = new GerritHttpClient(location){

            @Override
            protected void sessionChanged(Cookie cookie) {
                GerritAuthenticationState authState = new GerritAuthenticationState();
                authState.setCookie(cookie);
                GerritClient.this.authStateChanged(authState);
            }
        };
        if (authState != null) {
            this.client.setXsrfCookie(authState.getCookie());
        }
        if (xsrfKey != null) {
            this.client.setXsrfKey(xsrfKey);
        }
        this.serviceByClass = new HashMap<Class<? extends RemoteJsonService>, RemoteJsonService>();
        this.config = config;
    }

    public PatchLineComment saveDraft(Patch.Key patchKey, String message, int line, short side, String parentUuid, String uuid, IProgressMonitor monitor) throws GerritException {
        PatchLineComment.Key id = new PatchLineComment.Key(patchKey, uuid);
        final PatchLineComment comment = new PatchLineComment(id, line, this.getAccount(monitor).getId(), parentUuid);
        comment.setMessage(message);
        comment.setSide(side);
        if (this.isVersion29OrLater(monitor)) {
            if (uuid == null) {
                uuid = "";
            }
            CommentInput commentInput = new CommentInput();
            commentInput.setLine(line);
            commentInput.setMessage(message);
            commentInput.setPath(patchKey.getFileName());
            if (side == 0) {
                commentInput.setSide("PARENT");
            } else {
                commentInput.setSide("REVISION");
            }
            String uri = "/changes/" + Integer.toString(patchKey.getParentKey().getParentKey().get()) + "/revisions/" + patchKey.getParentKey().get() + "/drafts";
            if (!uuid.isEmpty()) {
                uri = uri.concat("/" + uuid);
            }
            this.executePutRestRequest(uri, commentInput, (Type)((Object)CommentInput.class), null, monitor);
            return comment;
        }
        return this.execute(monitor, new Operation<PatchLineComment>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getPatchDetailService(monitor).saveDraft(comment, this);
            }
        });
    }

    public VoidResult deleteDraft(Patch.Key patchkey, String uuid, IProgressMonitor monitor) throws GerritException {
        final PatchLineComment.Key id = new PatchLineComment.Key(patchkey, uuid);
        if (this.isVersion29OrLater(monitor)) {
            CommentInput commentInput = new CommentInput();
            String uri = "/changes/" + Integer.toString(patchkey.getParentKey().getParentKey().get()) + "/revisions/" + patchkey.getParentKey().get() + "/drafts/" + uuid;
            this.executeDeleteRestRequest(uri, commentInput, (Type)((Object)CommentInput.class), null, monitor);
            return null;
        }
        return this.execute(monitor, new Operation<VoidResult>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getPatchDetailService(monitor).deleteDraft(id, this);
            }
        });
    }

    public ChangeDetail abandon(String reviewId, int patchSetId, final String message, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        if (this.hasJsonRpcApi(monitor)) {
            return this.execute(monitor, new Operation<ChangeDetail>(this){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    this.getChangeManageService(monitor).abandonChange(id, message, this);
                }
            });
        }
        String uri = "/a/changes/" + id.getParentKey().get() + "/abandon";
        this.executePostRestRequest(uri, new AbandonInput(message), (Type)((Object)ChangeInfo.class), null, monitor);
        return this.getChangeDetail(id.getParentKey().get(), monitor);
    }

    public Object getChangeInfo29(String query, Class returnClass, IProgressMonitor monitor) throws GerritException {
        return this.executeGetRestRequest(query, returnClass, monitor);
    }

    private List<PatchSet> getPatchSets29(String changeInfoId, int reviewId, IProgressMonitor monitor) throws GerritException {
        ChangeInfo29[] changeInfo;
        ArrayList<PatchSet> patchSets = new ArrayList<PatchSet>();
        String query = "/changes/?q=" + changeInfoId + "+change:" + reviewId + "&o=ALL_REVISIONS";
        ChangeInfo29[] changeInfo29Array = changeInfo = (ChangeInfo29[])this.getChangeInfo29(query, ChangeInfo29[].class, monitor);
        int n = changeInfo.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeInfo29 element = changeInfo29Array[n2];
            for (Map.Entry<String, RevisionInfo> revisionInfo : element.getRevisions().entrySet()) {
                PatchSet.Id patchSetId = new PatchSet.Id(new Change.Id(reviewId), revisionInfo.getValue().getNumber());
                patchSets.add(new PatchSet(patchSetId));
            }
            ++n2;
        }
        Collections.sort(patchSets, new Comparator<PatchSet>(){

            @Override
            public int compare(PatchSet p1, PatchSet p2) {
                return p1.getPatchSetId() - p2.getPatchSetId();
            }
        });
        return patchSets;
    }

    public RelatedChangesInfo getRelatedChanges(int reviewId, String revisionId, IProgressMonitor monitor) throws GerritException {
        String query = "/changes/" + Integer.toString(reviewId) + "/revisions/" + revisionId + "/related";
        RelatedChangesInfo relatedChangesInfo = (RelatedChangesInfo)this.getChangeInfo29(query, RelatedChangesInfo.class, monitor);
        return relatedChangesInfo;
    }

    private ChangeMessage convertChangeMessage(int reviewId, ChangeInfo changeInfo, ChangeMessageInfo changeMessageInfo) {
        Change.Id changeId = new Change.Id(reviewId);
        ChangeMessage.Key changeMessageKey = new ChangeMessage.Key(changeId, changeInfo.getId());
        AccountInfo author = changeMessageInfo.getAuthor();
        if (author == null) {
            author = GerritSystemAccount.GERRIT_SYSTEM;
        }
        Account.Id accountId = new Account.Id(author.getId());
        ChangeMessage changeMessage = new ChangeMessage(changeMessageKey, accountId, changeMessageInfo.getDate());
        changeMessage.setMessage(changeMessageInfo.getMesssage());
        return changeMessage;
    }

    private Branch.NameKey getBranchKey(ChangeInfo changeInfo) {
        Project.NameKey projectKey = new Project.NameKey(changeInfo.getProject());
        Branch.NameKey branchKey = new Branch.NameKey(projectKey, changeInfo.getBranch());
        return branchKey;
    }

    private Change createChange(String keyString, int changeIdValue, com.google.gerrit.common.data.AccountInfo accountInfo, Branch.NameKey branchKey) {
        Change.Key key = new Change.Key(keyString);
        Change.Id changeId = new Change.Id(changeIdValue);
        Change change = new Change(key, changeId, accountInfo.getId(), branchKey);
        return change;
    }

    private PatchSetInfo getPatchSetInfo(PatchSet.Id patchsetId, String subject) {
        PatchSetInfo patchSetInfo = new PatchSetInfo(patchsetId);
        patchSetInfo.setSubject(subject);
        return patchSetInfo;
    }

    private com.google.gerrit.common.data.ChangeInfo convertToGoogleChangeInfo(RelatedChangeAndCommitInfo info, com.google.gerrit.common.data.AccountInfo accountInfo, Branch.NameKey branchKey) {
        Change change = this.createChange(info.getChangeId(), info.getChangeNumber(), accountInfo, branchKey);
        PatchSet.Id patchsetId = new PatchSet.Id(change.getId(), info.getCurrentRevisionNumbe());
        PatchSetInfo patchSetInfo = this.getPatchSetInfo(patchsetId, info.getCommitInfo().getSubject());
        change.setCurrentPatchSet(patchSetInfo);
        com.google.gerrit.common.data.ChangeInfo googleChangeInfo = new com.google.gerrit.common.data.ChangeInfo(change);
        return googleChangeInfo;
    }

    public ChangeDetailX getChangeDetail29(int reviewId, IProgressMonitor monitor) throws GerritException {
        ChangeDetailX changeDetail = null;
        String query = "/changes/" + Integer.toString(reviewId) + "/detail/?o=ALL_REVISIONS&o=MESSAGES";
        ChangeInfo29 changeInfo = (ChangeInfo29)this.getChangeInfo29(query, ChangeInfo29.class, monitor);
        List<PatchSet> patchSets = this.getPatchSets29(changeInfo.getChangeId(), reviewId, monitor);
        ArrayList<ChangeMessage> listChangeMessage = new ArrayList<ChangeMessage>();
        List<ChangeMessageInfo> listChangeMessageInfo = changeInfo.getMessages();
        boolean containsMessageFromGerritSystem = false;
        for (ChangeMessageInfo changeMessageInfo : listChangeMessageInfo) {
            if (changeMessageInfo.getAuthor() == null) {
                containsMessageFromGerritSystem = true;
            }
            ChangeMessage changeMessage = this.convertChangeMessage(reviewId, changeInfo, changeMessageInfo);
            listChangeMessage.add(changeMessage);
        }
        ArrayList<com.google.gerrit.common.data.AccountInfo> listAccountInfo = new ArrayList<com.google.gerrit.common.data.AccountInfo>();
        com.google.gerrit.common.data.AccountInfo accountInfo = this.convertAuthorFrom29ToAccountInfo(changeInfo);
        listAccountInfo.add(accountInfo);
        if (containsMessageFromGerritSystem) {
            listAccountInfo.add(GerritSystemAccount.GERRIT_SYSTEM.getGerritSystemAccountInfo());
        }
        AccountInfoCache accountInfoCache = new AccountInfoCache(listAccountInfo);
        changeDetail = new ChangeDetailX();
        changeDetail.setDateCreated(changeInfo.getCreated());
        changeDetail.setLastModified(changeInfo.getUpdated());
        changeDetail.setStarred(changeInfo.getStarred() != null);
        changeDetail.setAccounts(accountInfoCache);
        changeDetail.setMessages(listChangeMessage);
        Branch.NameKey branchKey = this.getBranchKey(changeInfo);
        this.setChangeDetailDependency(reviewId, changeInfo, changeDetail, accountInfo, monitor);
        PatchSetInfo patchSetInfo = this.getPatchSetInfo(changeInfo.getCurrentPatchSetId(), changeInfo.getSubject());
        changeDetail.setApprovals(changeInfo.convertToApprovalDetails());
        changeDetail.setApprovalTypes(changeInfo.convertToApprovalTypes());
        String querysubmit = "/changes/" + Integer.toString(reviewId) + "/revisions/current/test.submit_rule?filters=SKIP";
        List<SubmitRecord> submitRecord = this.currentSubmitRecord29(querysubmit, monitor);
        changeDetail.setSubmitRecords(submitRecord);
        if (changeDetail.getApprovalTypes() == null && this.getGerritConfig() != null) {
            changeDetail.convertSubmitRecordsToApprovalTypes(this.getGerritConfig().getApprovalTypes());
        }
        changeDetail.setPatchSets(patchSets);
        List<ReviewerInfo> reviewers = this.listReviewers(reviewId, monitor);
        if (!this.hasAllReviewers(changeDetail.getAccounts(), reviewers)) {
            this.merge(changeDetail.getAccounts(), reviewers);
        }
        Change initialChange = this.createChange(changeInfo.getChangeId(), reviewId, accountInfo, branchKey);
        initialChange.setCurrentPatchSet(patchSetInfo);
        initialChange.setStatus(changeInfo.getStatus());
        changeDetail.setChange(initialChange);
        this.setActions29(reviewId, changeDetail, monitor);
        return changeDetail;
    }

    private List<SubmitRecord> currentSubmitRecord29(String uri, IProgressMonitor monitor) throws GerritException {
        SubmitRecord[] submitRecordArray;
        ArrayList<SubmitRecord> submitRecordList = new ArrayList<SubmitRecord>();
        SubmitRecord[] submitRecordArray2 = submitRecordArray = (SubmitRecord[])this.executePostRestRequest(uri, new SubmitRecord(), (Type)((Object)SubmitRecord[].class), new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                String errorMsg = this.getResponseBodyAsString(method);
                if (this.isNotPermitted(method, errorMsg) || this.isConflict(method)) {
                    throw new GerritException(NLS.bind((String)"Cannot get submit change: {0}", (Object)errorMsg));
                }
            }

            private String getResponseBodyAsString(HttpMethodBase method) {
                try {
                    return method.getResponseBodyAsString();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            private boolean isNotPermitted(HttpMethodBase method, String msg) {
                return method.getStatusCode() == 403 && "submit not permitted\n".equals(msg);
            }

            private boolean isConflict(HttpMethodBase method) {
                return method.getStatusCode() == 409;
            }
        }, monitor);
        int n = submitRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            SubmitRecord element = submitRecordArray2[n2];
            List<SubmitRecord.Label> list = null;
            if (element.getStatus().equalsIgnoreCase("OK")) {
                list = element.createLabel(element, element.getOkMap(), "OK");
            } else if (element.getStatus().equalsIgnoreCase("NOT_READY")) {
                list = element.createLabel(element, element.getNeedMap(), "NEED");
            } else if (element.getStatus().equalsIgnoreCase("REJECT")) {
                list = element.createLabel(element, element.getRejectMap(), "REJECT");
            } else if (element.getStatus().equalsIgnoreCase("MAY")) {
                list = element.createLabel(element, element.getMayMap(), "MAY");
            }
            element.setLabels(list);
            submitRecordList.add(element);
            ++n2;
        }
        return submitRecordList;
    }

    private void setChangeDetailDependency(int reviewId, ChangeInfo29 changeInfo29, ChangeDetailX changeDetail, com.google.gerrit.common.data.AccountInfo accountInfo, IProgressMonitor monitor) throws GerritException {
        ArrayList<com.google.gerrit.common.data.ChangeInfo> dependsOn = new ArrayList<com.google.gerrit.common.data.ChangeInfo>();
        ArrayList<com.google.gerrit.common.data.ChangeInfo> neededBy = new ArrayList<com.google.gerrit.common.data.ChangeInfo>();
        Branch.NameKey branchKey = this.getBranchKey(changeInfo29);
        RelatedChangesInfo relatedChangesInfo = this.getRelatedChanges(reviewId, changeInfo29.getCurrentRevision(), monitor);
        List<RelatedChangeAndCommitInfo> listCommitInfo = relatedChangesInfo.getCommitInfo();
        boolean needed = true;
        for (RelatedChangeAndCommitInfo relatedChangeAndCommitInfo : listCommitInfo) {
            if (relatedChangeAndCommitInfo.getCommitInfo().getCommit().equalsIgnoreCase(changeInfo29.getCurrentRevision())) {
                needed = false;
                continue;
            }
            if (relatedChangeAndCommitInfo.getChangeNumber() <= 0) continue;
            com.google.gerrit.common.data.ChangeInfo googleChangeInfo = this.convertToGoogleChangeInfo(relatedChangeAndCommitInfo, accountInfo, branchKey);
            if (needed) {
                neededBy.add(googleChangeInfo);
                continue;
            }
            dependsOn.add(googleChangeInfo);
        }
        changeDetail.setNeededBy(neededBy);
        changeDetail.setDependsOn(dependsOn);
    }

    public ChangeDetailX getChangeDetail(int reviewId, IProgressMonitor monitor) throws GerritException {
        final Change.Id changeId = new Change.Id(reviewId);
        ChangeDetailX changeDetail = null;
        if (this.isVersion29OrLater(monitor)) {
            changeDetail = this.getChangeDetail29(reviewId, monitor);
        } else {
            changeDetail = this.execute(monitor, new Operation<ChangeDetailX>(this){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    this.getChangeDetailService(monitor).changeDetailX(changeId, this);
                }
            });
            if (this.isVersion26OrLater(monitor)) {
                if (changeDetail.getApprovals() == null) {
                    ChangeInfo changeInfo = this.getChangeInfo(reviewId, monitor);
                    changeDetail.setApprovals(changeInfo.convertToApprovalDetails());
                    changeDetail.setApprovalTypes(changeInfo.convertToApprovalTypes());
                }
                List<ReviewerInfo> reviewers = this.listReviewers(reviewId, monitor);
                if (!this.hasAllReviewers(changeDetail.getAccounts(), reviewers)) {
                    this.merge(changeDetail.getAccounts(), reviewers);
                }
            } else if (changeDetail.getApprovalTypes() == null && this.getGerritConfig() != null) {
                changeDetail.convertSubmitRecordsToApprovalTypes(this.getGerritConfig().getApprovalTypes());
            }
            changeDetail.setDateCreated(changeDetail.getChange().getCreatedOn());
            changeDetail.setLastModified(changeDetail.getChange().getLastUpdatedOn());
        }
        return changeDetail;
    }

    private com.google.gerrit.common.data.AccountInfo convertAuthorFrom29ToAccountInfo(ChangeInfo changeInfo) {
        Account account = new Account(new Account.Id(changeInfo.getOwner().getId()));
        account.setFullName(changeInfo.getOwner().getName());
        account.setUserName(changeInfo.getOwner().getUsername());
        account.setPreferredEmail(changeInfo.getOwner().getEmail());
        com.google.gerrit.common.data.AccountInfo accountInfo = new com.google.gerrit.common.data.AccountInfo(account);
        return accountInfo;
    }

    private AccountInfo getAccountInfo(String account, IProgressMonitor monitor) throws GerritException, URIException {
        if ("Gerrit Code Review".equals(account)) {
            return GerritSystemAccount.GERRIT_SYSTEM;
        }
        String st = URIUtil.encodeQuery((String)account);
        String uri = "/accounts/" + st;
        AccountInfo accountInfo = (AccountInfo)this.executeGetRestRequest(uri, (Type)((Object)AccountInfo.class), monitor);
        return accountInfo;
    }

    private void setActions29(int reviewId, ChangeDetailX changeDetail, IProgressMonitor monitor) {
        ChangeInfo changeInfo29 = null;
        try {
            changeInfo29 = (ChangeInfo29)this.executeGetRestRequest("/changes/" + Integer.toString(reviewId) + "/?o=CURRENT_REVISION&o=CURRENT_ACTIONS", (Type)((Object)ChangeInfo29.class), monitor);
        }
        catch (GerritException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", "ChangeDetailX GerritException running rest query", (Throwable)e));
        }
        if (changeInfo29 != null) {
            if (changeInfo29.getRevisions() != null) {
                this.setRevisionActions29((ChangeInfo29)changeInfo29, changeDetail);
            }
            if (((ChangeInfo29)changeInfo29).getActions() != null) {
                this.setGlobalActions29((ChangeInfo29)changeInfo29, changeDetail);
            }
        }
    }

    private void setRevisionActions29(ChangeInfo29 changeInfo29, ChangeDetailX changeDetail) {
        for (Map.Entry<String, RevisionInfo> mapRevisions : changeInfo29.getRevisions().entrySet()) {
            if (mapRevisions.getValue().getActions() == null) continue;
            for (Map.Entry<String, ActionInfo> mapActions : mapRevisions.getValue().getActions().entrySet()) {
                if (mapActions.getKey().equalsIgnoreCase("submit")) {
                    changeDetail.setCanSubmit(mapActions.getValue().getEnabled());
                    continue;
                }
                if (!mapActions.getKey().equalsIgnoreCase("rebase")) continue;
                changeDetail.setCanRebase(mapActions.getValue().getEnabled());
            }
        }
    }

    private void setGlobalActions29(ChangeInfo29 changeInfo29, ChangeDetailX changeDetail) {
        for (Map.Entry<String, ActionInfo> mapActions : changeInfo29.getActions().entrySet()) {
            if (mapActions.getKey().equalsIgnoreCase("abandon")) {
                changeDetail.setCanAbandon(mapActions.getValue().getEnabled());
                changeDetail.setCanRestore(!mapActions.getValue().getEnabled());
                continue;
            }
            if (!mapActions.getKey().equalsIgnoreCase("restore")) continue;
            changeDetail.setCanAbandon(!mapActions.getValue().getEnabled());
            changeDetail.setCanRestore(mapActions.getValue().getEnabled());
        }
    }

    private List<ReviewerInfo> listReviewers(int reviewId, IProgressMonitor monitor) throws GerritException {
        String uri = "/changes/" + reviewId + "/reviewers/";
        TypeToken<List<ReviewerInfo>> reviewersListType = new TypeToken<List<ReviewerInfo>>(){};
        return (List)this.executeGetRestRequest(uri, reviewersListType.getType(), monitor);
    }

    private boolean hasAllReviewers(AccountInfoCache accounts, List<ReviewerInfo> reviewers) {
        for (ReviewerInfo reviewer : reviewers) {
            com.google.gerrit.common.data.AccountInfo cachedAccount = accounts.get(new Account.Id(reviewer.getId()));
            if (cachedAccount != null && !this.isAnonymous(cachedAccount)) continue;
            return false;
        }
        return true;
    }

    private boolean isAnonymous(com.google.gerrit.common.data.AccountInfo accountInfo) {
        return accountInfo.getFullName() == null && accountInfo.getPreferredEmail() == null;
    }

    private void merge(AccountInfoCache accounts, List<ReviewerInfo> reviewers) {
        HashSet<com.google.gerrit.common.data.AccountInfo> accountInfos = new HashSet<com.google.gerrit.common.data.AccountInfo>(reviewers.size());
        for (ReviewerInfo reviewer : reviewers) {
            accountInfos.add(reviewer.toAccountInfo());
        }
        AccountInfoCache accountInfoCache = new AccountInfoCache(accountInfos);
        accounts.merge(accountInfoCache);
    }

    public ChangeInfo getChangeInfo(int reviewId, IProgressMonitor monitor) throws GerritException {
        String uri = "/changes/" + reviewId + "/revisions/current/review";
        return (ChangeInfo)this.executeGetRestRequest(uri, (Type)((Object)ChangeInfo.class), monitor);
    }

    public void loadPatchSetContent(PatchSetContent patchSetContent, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id baseId = patchSetContent.getBase() != null ? patchSetContent.getBase().getId() : null;
        PatchSet.Id targetId = patchSetContent.getTarget().getId();
        if (patchSetContent.getTargetDetail() == null) {
            PatchSetDetail targetDetail = this.getPatchSetDetail(baseId, targetId, monitor);
            patchSetContent.setTargetDetail(targetDetail);
        }
        for (Patch patch : patchSetContent.getTargetDetail().getPatches()) {
            PatchScriptX patchScript = this.getPatchScript(patch.getKey(), baseId, targetId, monitor);
            if (patchScript == null) continue;
            patchSetContent.putPatchScriptByPatchKey(patch.getKey(), patchScript);
        }
    }

    public GerritConfigX getGerritConfig() {
        return this.config == null ? null : this.config.getGerritConfig();
    }

    public GerritConfiguration getConfiguration() {
        return this.config;
    }

    public GerritSystemInfo getInfo(IProgressMonitor monitor) throws GerritException {
        Version version = this.getCachedVersion(monitor);
        List<ContributorAgreement> contributorAgreements = null;
        Account account = null;
        if (!this.isAnonymous()) {
            account = this.getAccount(monitor);
        } else {
            this.executeQuery(monitor, "status:open");
        }
        this.refreshConfigOnce(monitor);
        return new GerritSystemInfo(version, contributorAgreements, account);
    }

    PatchScriptX getPatchScript(final Patch.Key key, final PatchSet.Id leftId, final PatchSet.Id rightId, IProgressMonitor monitor) throws GerritException {
        final AccountDiffPreference diffPrefs = this.createAccountDiffPreference();
        PatchScriptX patchScript = this.execute(monitor, new Operation<PatchScriptX>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getPatchDetailService(monitor).patchScriptX(key, leftId, rightId, diffPrefs, this);
            }
        });
        if (patchScript.isBinary()) {
            this.fetchLeftBinaryContent(patchScript, key, leftId, monitor);
            this.fetchRightBinaryContent(patchScript, key, rightId, monitor);
        }
        return patchScript;
    }

    protected void fetchLeftBinaryContent(PatchScriptX patchScript, Patch.Key key, PatchSet.Id leftId, IProgressMonitor monitor) throws GerritException {
        if (patchScript.getChangeType() != Patch.ChangeType.ADDED) {
            byte[] binaryContent = this.fetchBinaryContent(this.getUrlForPatchSetOrBase(key, leftId), monitor);
            patchScript.setBinaryA(binaryContent);
        }
    }

    protected void fetchRightBinaryContent(PatchScriptX patchScript, Patch.Key key, PatchSet.Id rightId, IProgressMonitor monitor) throws GerritException {
        if (patchScript.getChangeType() != Patch.ChangeType.DELETED) {
            byte[] binaryContent = this.fetchBinaryContent(this.getUrlForPatchSet(key, rightId), monitor);
            patchScript.setBinaryB(binaryContent);
        }
    }

    protected String getUrlForPatchSetOrBase(Patch.Key key, PatchSet.Id id) throws GerritException {
        if (id == null) {
            return this.getUrlForBase(key);
        }
        return this.getUrlForPatchSet(key, id);
    }

    private String getUrlForBase(Patch.Key key) throws GerritException {
        return GerritClient.encode(String.valueOf(key.toString()) + "^1");
    }

    protected String getUrlForPatchSet(Patch.Key key, PatchSet.Id id) throws GerritException {
        return GerritClient.encode(id + "," + key.getFileName() + "^0");
    }

    protected byte[] fetchBinaryContent(String url, IProgressMonitor monitor) throws GerritException {
        TypeToken<Byte[]> byteArrayType = new TypeToken<Byte[]>(){};
        byte[] bin = (byte[])this.executeGetRestRequest("/cat/" + url, byteArrayType.getType(), monitor);
        if (GerritClient.isZippedContent(bin)) {
            return GerritClient.unzip(bin);
        }
        return bin;
    }

    public static boolean isZippedContent(byte[] bin) {
        return bin != null && bin.length > 4 && bin[0] == 80 && bin[1] == 75 && bin[2] == 3 && bin[3] == 4;
    }

    public static byte[] unzip(byte[] zip) throws GerritException {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zip));
        try {
            zis.getNextEntry();
            byte[] byArray = IOUtils.toByteArray((InputStream)zis);
            return byArray;
        }
        catch (IOException e) {
            throw new GerritException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
    }

    private AccountDiffPreference createAccountDiffPreference() {
        AccountDiffPreference diffPrefs = new AccountDiffPreference(null);
        diffPrefs.setLineLength(Integer.MAX_VALUE);
        diffPrefs.setTabSize(4);
        diffPrefs.setContext((short)-1);
        diffPrefs.setIgnoreWhitespace(AccountDiffPreference.Whitespace.IGNORE_NONE);
        diffPrefs.setIntralineDifference(false);
        return diffPrefs;
    }

    private PatchSetDetail getPatchSetDetail(final PatchSet.Id idBase, final PatchSet.Id idTarget, IProgressMonitor monitor) throws GerritException {
        PatchSetDetail patchSetDetail;
        block6: {
            patchSetDetail = null;
            try {
                patchSetDetail = this.execute(monitor, new Operation<PatchSetDetail>(this){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        this.getChangeDetailService(monitor).patchSetDetail2(idBase, idTarget, this.createAccountDiffPreference(), this);
                    }
                });
            }
            catch (GerritException e) {
                try {
                    if (!this.isNoSuchServiceError(e)) {
                        throw e;
                    }
                    patchSetDetail = this.execute(monitor, new Operation<PatchSetDetail>(this){

                        @Override
                        public void execute(IProgressMonitor monitor) throws GerritException {
                            this.getChangeDetailService(monitor).patchSetDetail(idTarget, this);
                        }
                    });
                }
                catch (GerritException e2) {
                    String message = e2.getMessage();
                    if (message != null && message.contains("Error parsing request")) {
                        patchSetDetail = this.execute(monitor, new Operation<PatchSetDetail>(this){

                            @Override
                            public void execute(IProgressMonitor monitor) throws GerritException {
                                this.getChangeDetailService(monitor).patchSetDetail(idBase, idTarget, this.createAccountDiffPreference(), this);
                            }
                        });
                        break block6;
                    }
                    throw e2;
                }
            }
        }
        return patchSetDetail;
    }

    boolean isNoSuchServiceError(GerritException e) {
        String message = e.getMessage();
        return message != null && message.contains("No such service method");
    }

    public PatchSetPublishDetailX getPatchSetPublishDetail29(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        PatchSetPublishDetailX publishDetail = null;
        publishDetail = new PatchSetPublishDetailX();
        ChangeInfo changeInfo = this.getChangeInfo(id.getParentKey().get(), monitor);
        ArrayList<com.google.gerrit.common.data.AccountInfo> listAccountInfo = new ArrayList<com.google.gerrit.common.data.AccountInfo>();
        com.google.gerrit.common.data.AccountInfo accountInfo = this.convertAuthorFrom29ToAccountInfo(changeInfo);
        listAccountInfo.add(accountInfo);
        AccountInfoCache accountInfoCache = new AccountInfoCache(listAccountInfo);
        publishDetail.setAccounts(accountInfoCache);
        Branch.NameKey branchKey = this.getBranchKey(changeInfo);
        Change currentChange = this.createChange(changeInfo.getChangeId(), id.getParentKey().get(), accountInfo, branchKey);
        currentChange.setStatus(changeInfo.getStatus());
        publishDetail.setChange(currentChange);
        PatchSetInfo patchSetInfo = this.getPatchSetInfo(changeInfo.getCurrentPatchSetId(), changeInfo.getSubject());
        publishDetail.setPatchSetInfo(patchSetInfo);
        publishDetail.setLabels(changeInfo.convertToPermissionLabels());
        if (publishDetail.getGiven() == null) {
            publishDetail.setGiven(changeInfo.convertToPatchSetApprovals(id, this.getAccount(monitor)));
        }
        return publishDetail;
    }

    public PatchSetPublishDetailX getPatchSetPublishDetail(final PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        PatchSetPublishDetailX publishDetail = null;
        if (this.isVersion29OrLater(monitor)) {
            publishDetail = this.getPatchSetPublishDetail29(id, monitor);
        } else {
            publishDetail = this.execute(monitor, new Operation<PatchSetPublishDetailX>(this){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    this.getChangeDetailService(monitor).patchSetPublishDetailX(id, this);
                }
            });
            if (publishDetail.getLabels() == null && this.isVersion26OrLater(monitor)) {
                ChangeInfo changeInfo = this.getChangeInfo(id.getParentKey().get(), monitor);
                publishDetail.setLabels(changeInfo.convertToPermissionLabels());
                if (publishDetail.getGiven() == null) {
                    publishDetail.setGiven(changeInfo.convertToPatchSetApprovals(id, this.getAccount(monitor)));
                }
            }
        }
        return publishDetail;
    }

    public GerritChange getChange(String reviewId, IProgressMonitor monitor) throws GerritException {
        int id;
        GerritChange gerritChange = new GerritChange();
        try {
            id = this.id(reviewId);
        }
        catch (GerritException e) {
            List<GerritQueryResult> result = this.executeQuery(monitor, reviewId);
            if (result.size() == 1) {
                id = result.get(0).getNumber();
            }
            throw e;
        }
        ChangeDetailX changeDetail = this.getChangeDetail(id, monitor);
        ArrayList<PatchSetDetail> patchSets = new ArrayList<PatchSetDetail>(changeDetail.getPatchSets().size());
        HashMap<PatchSet.Id, PatchSetPublishDetailX> patchSetPublishDetailByPatchSetId = new HashMap<PatchSet.Id, PatchSetPublishDetailX>();
        for (PatchSet patchSet : changeDetail.getPatchSets()) {
            try {
                PatchSetDetail patchSetDetail = this.getPatchSetDetail(null, patchSet.getId(), monitor);
                patchSets.add(patchSetDetail);
                if (this.isAnonymous()) continue;
                PatchSetPublishDetailX patchSetPublishDetail = this.getPatchSetPublishDetail(patchSet.getId(), monitor);
                if (this.isVersion29OrLater(monitor)) {
                    patchSetPublishDetail.setPatchSetInfo(this.setAccountPatchSetInfo(patchSetDetail.getInfo(), monitor));
                }
                patchSetPublishDetailByPatchSetId.put(patchSet.getId(), patchSetPublishDetail);
                changeDetail.setCurrentPatchSetDetail(patchSetDetail);
            }
            catch (GerritException e) {
                this.handleMissingPatchSet(NLS.bind((String)"Patch Set {0} items for Review {1}", (Object)patchSet.getPatchSetId(), (Object)reviewId), e);
            }
        }
        gerritChange.setChangeDetail(changeDetail);
        gerritChange.setPatchSets(patchSets);
        gerritChange.setPatchSetPublishDetailByPatchSetId(patchSetPublishDetailByPatchSetId);
        return gerritChange;
    }

    private PatchSetInfo setAccountPatchSetInfo(PatchSetInfo patchSetInfo, IProgressMonitor monitor) {
        if (patchSetInfo.getAuthor().getAccount() == null) {
            patchSetInfo.setAuthor(this.setUserIdentity(patchSetInfo.getAuthor().getName(), patchSetInfo.getAuthor(), "Author", monitor));
        }
        if (patchSetInfo.getCommitter().getAccount() == null) {
            patchSetInfo.setCommitter(this.setUserIdentity(patchSetInfo.getCommitter().getName(), patchSetInfo.getCommitter(), "Committer", monitor));
        }
        return patchSetInfo;
    }

    private UserIdentity setUserIdentity(String name, UserIdentity userIdentity, String user, IProgressMonitor monitor) {
        AccountInfo accountInfo = null;
        try {
            accountInfo = this.getAccountInfo(name, monitor);
            Account.Id accountId = new Account.Id(accountInfo.getId());
            userIdentity.setAccount(accountId);
        }
        catch (GerritException gerritException) {
            if (gerritException.getMessage().indexOf(404) != 0) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.gerrit.core", NLS.bind((String)"GerritException {0} not found", (Object)user), (Throwable)gerritException));
            }
        }
        catch (URIException uriException) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", NLS.bind((String)"{0} URIException: ", (Object)user), (Throwable)uriException));
        }
        return userIdentity;
    }

    private void handleMissingPatchSet(String desc, GerritException e) {
        GerritCorePlugin.logWarning(NLS.bind((String)"Couldn't load {0}. (Perhaps the Patch Set has been removed from repository?)", (Object)desc), e);
    }

    public int id(String id) throws GerritException {
        if (id == null) {
            throw new GerritException("Invalid ID (null)");
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException numberFormatException) {
            throw new GerritException(NLS.bind((String)"Invalid ID (''{0}'')", (Object)id));
        }
    }

    public void publishComments(String reviewId, int patchSetId, final String message, final Set<ApprovalCategoryValue.Id> approvals, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        if (this.hasJsonRpcApi(monitor)) {
            this.execute(monitor, new Operation<VoidResult>(this){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    this.getPatchDetailService(monitor).publishComments(id, message, approvals, this);
                }
            });
        } else {
            ReviewInput reviewInput = new ReviewInput(message);
            Map<String, CommentInfo[]> drafts = this.listDrafts(id, monitor);
            Map<String, CommentInput[]> comments = this.convert(drafts);
            if (!comments.isEmpty()) {
                reviewInput.setComments(comments);
            }
            reviewInput.setApprovals(approvals);
            String uri = "/a/changes/" + id.getParentKey().get() + "/revisions/" + id.get() + "/review";
            this.executePostRestRequest(uri, reviewInput, (Type)((Object)ReviewInfo.class), new GerritHttpClient.ErrorHandler(){

                @Override
                public void handleError(HttpMethodBase method) throws GerritException {
                    String msg;
                    if (method.getStatusCode() == 403 && (msg = this.getResponseBodyAsString(method)).startsWith("Applying label") && msg.endsWith("is restricted")) {
                        throw new GerritException(msg);
                    }
                }

                private String getResponseBodyAsString(HttpMethodBase method) {
                    try {
                        String msg = method.getResponseBodyAsString();
                        return msg.trim();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            }, monitor);
        }
    }

    private Map<String, CommentInfo[]> listDrafts(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        String uri = "/changes/" + id.getParentKey().get() + "/revisions/" + id.get() + "/drafts/";
        TypeToken<Map<String, CommentInfo[]>> resultType = new TypeToken<Map<String, CommentInfo[]>>(){};
        return (Map)this.executeGetRestRequest(uri, resultType.getType(), monitor);
    }

    private Map<String, CommentInput[]> convert(Map<String, CommentInfo[]> commentInfos) {
        if (commentInfos == null || commentInfos.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, CommentInput[]> commentInputs = new HashMap<String, CommentInput[]>(commentInfos.size());
        Set<Map.Entry<String, CommentInfo[]>> entrySet = commentInfos.entrySet();
        for (Map.Entry<String, CommentInfo[]> entry : entrySet) {
            CommentInfo[] infos = entry.getValue();
            ArrayList<CommentInput> inputs = new ArrayList<CommentInput>(infos.length);
            CommentInfo[] commentInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                CommentInfo info = commentInfoArray[n2];
                inputs.add(new CommentInput(info));
                ++n2;
            }
            commentInputs.put(entry.getKey(), inputs.toArray(new CommentInput[inputs.size()]));
        }
        return commentInputs;
    }

    public ReviewerResult addReviewers(String reviewId, final List<String> reviewers, IProgressMonitor monitor) throws GerritException {
        Assert.isLegal((reviewers != null ? 1 : 0) != 0, (String)"reviewers cannot be null");
        final Change.Id id = new Change.Id(this.id(reviewId));
        if (this.hasJsonRpcApi(monitor)) {
            try {
                return this.execute(monitor, new Operation<ReviewerResult>(this){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        this.getPatchDetailService(monitor).addReviewers(id, reviewers, this);
                    }
                });
            }
            catch (GerritException e) {
                String message = e.getMessage();
                if (message != null && message.contains("Error parsing request")) {
                    return this.execute(monitor, new Operation<ReviewerResult>(this){

                        @Override
                        public void execute(IProgressMonitor monitor) throws GerritException {
                            this.getPatchDetailService(monitor).addReviewers(id, reviewers, false, this);
                        }
                    });
                }
                throw e;
            }
        }
        String uri = "/a/changes/" + id.get() + "/reviewers";
        HashSet<ReviewerInfo> reviewerInfos = new HashSet<ReviewerInfo>(reviewers.size());
        ReviewerResult reviewerResult = new ReviewerResult();
        for (String reviewerId : reviewers) {
            try {
                AddReviewerResult addReviewerResult = (AddReviewerResult)this.executePostRestRequest(uri, new ReviewerInput(reviewerId), (Type)((Object)AddReviewerResult.class), null, monitor);
                reviewerInfos.addAll(addReviewerResult.getReviewers());
            }
            catch (GerritHttpException e) {
                if (e.getResponseCode() != 422) continue;
                reviewerResult.addError(new ReviewerResult.Error(null, reviewerId));
            }
        }
        ChangeDetailX changeDetail = this.getChangeDetail(id.get(), monitor);
        ArrayList<ApprovalDetail> approvalDetails = new ArrayList<ApprovalDetail>(reviewerInfos.size());
        for (ReviewerInfo reviewerInfo : reviewerInfos) {
            approvalDetails.add(reviewerInfo.toApprovalDetail(changeDetail.getCurrentPatchSet()));
        }
        changeDetail.setApprovals(approvalDetails);
        reviewerResult.setChange((ChangeDetail)changeDetail);
        return reviewerResult;
    }

    public List<GerritQueryResult> queryAllReviews(IProgressMonitor monitor) throws GerritException {
        return this.executeQuery(monitor, "status:open");
    }

    public List<GerritQueryResult> queryByProject(IProgressMonitor monitor, String project) throws GerritException {
        return this.executeQuery(monitor, "status:open project:" + project);
    }

    public List<GerritQueryResult> queryMyReviews(IProgressMonitor monitor) throws GerritException {
        if (this.hasJsonRpcApi(monitor) && !this.restQueryAPIEnabled) {
            try {
                final Account account = this.getAccount(monitor);
                AccountDashboardInfo ad = this.execute(monitor, new Operation<AccountDashboardInfo>(this){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        this.getChangeListService(monitor).forAccount(account.getId(), (AsyncCallback)this);
                    }
                });
                List allMyChanges = ad.getByOwner();
                allMyChanges.addAll(ad.getForReview());
                allMyChanges.addAll(ad.getClosed());
                return this.convert(allMyChanges);
            }
            catch (GerritException e) {
                if (this.isNoSuchServiceError(e)) {
                    this.restQueryAPIEnabled = true;
                }
                throw e;
            }
        }
        return this.executeQueryRest(monitor, "owner:self OR reviewer:self", GET_LABELS_OPTION);
    }

    private boolean hasJsonRpcApi(IProgressMonitor monitor) throws GerritException {
        return !this.isVersion26OrLater(monitor);
    }

    private boolean isVersion26OrLater(IProgressMonitor monitor) throws GerritException {
        Version version = this.getCachedVersion(monitor);
        return GerritVersion.isVersion26OrLater(version);
    }

    private boolean isVersion27OrLater(IProgressMonitor monitor) throws GerritException {
        Version version = this.getCachedVersion(monitor);
        return GerritVersion.isVersion27OrLater(version);
    }

    private boolean isVersion28OrLater(IProgressMonitor monitor) throws GerritException {
        Version version = this.getCachedVersion(monitor);
        return GerritVersion.isVersion28OrLater(version);
    }

    public boolean isVersion29OrLater(IProgressMonitor monitor) throws GerritException {
        Version version = this.getCachedVersion(monitor);
        return GerritVersion.isVersion29OrLater(version);
    }

    public List<GerritQueryResult> queryWatchedReviews(IProgressMonitor monitor) throws GerritException {
        return this.executeQuery(monitor, "is:watched status:open");
    }

    private GerritConfigX refreshGerritConfig(final IProgressMonitor monitor) throws GerritException {
        try {
            GerritConfigX gerritConfig = this.client.execute(new GerritHttpClient.Request<GerritConfigX>(){

                @Override
                public HttpMethodBase createMethod() throws IOException {
                    return new GetMethod(String.valueOf(GerritClient.this.client.getUrl()) + "/");
                }

                @Override
                public GerritConfigX process(HttpMethodBase method) throws IOException {
                    InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);
                    try {
                        GerritHtmlProcessor processor = new GerritHtmlProcessor();
                        processor.parse(in, method.getResponseCharSet());
                        GerritConfigX gerritConfigX = processor.getConfig();
                        return gerritConfigX;
                    }
                    finally {
                        in.close();
                    }
                }
            }, monitor);
            if (gerritConfig == null) {
                throw new GerritException("Failed to obtain Gerrit configuration");
            }
            return gerritConfig;
        }
        catch (UnknownHostException cause) {
            GerritException e = new GerritException("Unknown host: " + cause.getMessage());
            e.initCause(cause);
            throw e;
        }
        catch (IOException cause) {
            GerritException e = new GerritException(cause.getMessage());
            e.initCause(cause);
            throw e;
        }
    }

    public GerritConfiguration refreshConfig(IProgressMonitor monitor) throws GerritException {
        Account account;
        List<Project> projects;
        GerritConfigX gerritConfig;
        block2: {
            this.configRefreshed = true;
            gerritConfig = this.refreshGerritConfig(monitor);
            projects = this.getVisibleProjects(monitor, gerritConfig);
            account = null;
            try {
                account = this.getAccount(monitor);
            }
            catch (GerritException e) {
                if (this.isNotSignedInException(e)) break block2;
                throw e;
            }
        }
        this.config = new GerritConfiguration(gerritConfig, projects, account);
        this.configurationChanged(this.config);
        return this.config;
    }

    public GerritConfiguration refreshConfigOnce(IProgressMonitor monitor) throws GerritException {
        if (!this.configRefreshed && this.config == null) {
            try {
                this.refreshConfig(monitor);
            }
            catch (GerritException gerritException) {}
        }
        return this.getConfiguration();
    }

    public ChangeDetail rebase(String reviewId, int patchSetId, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        if (this.isVersion29OrLater(monitor)) {
            return this.rebaseRest(id, monitor);
        }
        return this.execute(monitor, new Operation<ChangeDetail>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getChangeManageService(monitor).rebaseChange(id, this);
            }
        });
    }

    private ChangeDetail rebaseRest(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        String uri = "/a/changes/" + id.getParentKey().get() + "/revisions/" + id.get() + "/rebase";
        this.executePostRestRequest(uri, new ChangeInfo29(), (Type)((Object)ChangeInfo29.class), new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                String errorMsg = this.getResponseBodyAsString(method);
                if (this.isConflict(method)) {
                    throw new GerritException(errorMsg);
                }
            }

            private String getResponseBodyAsString(HttpMethodBase method) {
                try {
                    return method.getResponseBodyAsString();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            private boolean isConflict(HttpMethodBase method) {
                return method.getStatusCode() == 409;
            }
        }, monitor);
        return this.getChangeDetail(id.getParentKey().get(), monitor);
    }

    public ChangeDetail restore(String reviewId, int patchSetId, final String message, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id;
        block3: {
            id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
            if (this.hasJsonRpcApi(monitor)) {
                return this.execute(monitor, new Operation<ChangeDetail>(this){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        this.getChangeManageService(monitor).restoreChange(id, message, this);
                    }
                });
            }
            String uri = "/a/changes/" + id.getParentKey().get() + "/restore";
            try {
                this.executePostRestRequest(uri, new RestoreInput(message), (Type)((Object)ChangeInfo.class), null, monitor);
            }
            catch (GerritHttpException e) {
                if (e.getResponseCode() != 409) break block3;
                throw new GerritException("Not Found", e);
            }
        }
        return this.getChangeDetail(id.getParentKey().get(), monitor);
    }

    public ChangeDetail submit(String reviewId, int patchSetId, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        if (this.hasJsonRpcApi(monitor)) {
            return this.execute(monitor, new Operation<ChangeDetail>(this){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    this.getChangeManageService(monitor).submit(id, this);
                }
            });
        }
        return this.submitRest(id, monitor);
    }

    private ChangeDetail submitRest(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        String uri = "/a/changes/" + id.getParentKey().get() + "/revisions/" + id.get() + "/submit";
        this.executePostRestRequest(uri, new SubmitInput(true), (Type)((Object)SubmitInfo.class), new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                String errorMsg = this.getResponseBodyAsString(method);
                if (this.isNotPermitted(method, errorMsg) || this.isConflict(method)) {
                    throw new GerritException(NLS.bind((String)"Cannot submit change: {0}", (Object)errorMsg));
                }
            }

            private String getResponseBodyAsString(HttpMethodBase method) {
                try {
                    return method.getResponseBodyAsString();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            private boolean isNotPermitted(HttpMethodBase method, String msg) {
                return method.getStatusCode() == 403 && "submit not permitted\n".equals(msg);
            }

            private boolean isConflict(HttpMethodBase method) {
                return method.getStatusCode() == 409;
            }
        }, monitor);
        return this.getChangeDetail(id.getParentKey().get(), monitor);
    }

    public List<GerritQueryResult> executeQuery(IProgressMonitor monitor, String queryString) throws GerritException {
        return this.executeQuery(monitor, queryString, GET_LABELS_OPTION);
    }

    public List<GerritQueryResult> executeQuery(IProgressMonitor monitor, final String queryString, String optionString) throws GerritException {
        if (this.hasJsonRpcApi(monitor) && !this.restQueryAPIEnabled) {
            try {
                SingleListChangeInfo sl = this.execute(monitor, new Operation<SingleListChangeInfo>(this){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        this.getChangeListService(monitor).allQueryNext(queryString, "z", -1, (AsyncCallback)this);
                    }
                });
                return this.convert(sl.getChanges());
            }
            catch (GerritException e) {
                if (this.isNoSuchServiceError(e)) {
                    this.restQueryAPIEnabled = true;
                }
                throw e;
            }
        }
        return this.executeQueryRest(monitor, queryString, optionString);
    }

    private List<GerritQueryResult> convert(List<com.google.gerrit.common.data.ChangeInfo> changes) {
        ArrayList<GerritQueryResult> results = new ArrayList<GerritQueryResult>(changes.size());
        for (com.google.gerrit.common.data.ChangeInfo changeInfo : changes) {
            GerritQueryResult result = new GerritQueryResult(changeInfo);
            results.add(result);
        }
        return results;
    }

    public List<GerritQueryResult> executeQueryRest(IProgressMonitor monitor, String queryString) throws GerritException {
        return this.executeQueryRest(monitor, queryString, null);
    }

    public List<GerritQueryResult> executeQueryRest(IProgressMonitor monitor, String queryString, String optionString) throws GerritException {
        String uri = "/changes/?q=" + GerritClient.encode(queryString);
        if (StringUtils.isNotBlank((String)optionString)) {
            uri = String.valueOf(uri) + "&o=" + GerritClient.encode(optionString);
        }
        TypeToken<List<GerritQueryResult>> queryResultListType = new TypeToken<List<GerritQueryResult>>(){};
        return (List)this.executeGetRestRequest(uri, queryResultListType.getType(), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getAccount(IProgressMonitor monitor) throws GerritException {
        GerritClient gerritClient = this;
        synchronized (gerritClient) {
            if (this.myAcount != null) {
                return this.myAcount;
            }
        }
        Account account = this.executeAccount(monitor);
        GerritClient gerritClient2 = this;
        synchronized (gerritClient2) {
            this.myAcount = account;
        }
        return this.myAcount;
    }

    private Account executeAccount(IProgressMonitor monitor) throws GerritException {
        if (this.isVersion29OrLater(monitor)) {
            return this.getAccount29(monitor);
        }
        return this.execute(monitor, new Operation<Account>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getAccountService(monitor).myAccount((AsyncCallback)this);
            }
        });
    }

    private Account getAccount29(IProgressMonitor monitor) throws GerritException {
        if (this.isAnonymous()) {
            throw new GerritException("Not Signed In", -32603);
        }
        String query = "/accounts/self";
        AccountInfo accountInfo = (AccountInfo)this.executeGetRestRequest(query, (Type)((Object)AccountInfo.class), monitor);
        Account account = new Account(new Account.Id(accountInfo.getId()));
        account.setFullName(accountInfo.getName());
        account.setUserName(accountInfo.getUsername());
        account.setPreferredEmail(accountInfo.getEmail());
        return account;
    }

    private AccountService getAccountService(IProgressMonitor monitor) {
        return this.getService(AccountService.class, monitor);
    }

    private ChangeDetailService getChangeDetailService(IProgressMonitor monitor) {
        return this.getService(ChangeDetailService.class, monitor);
    }

    private ChangeListService getChangeListService(IProgressMonitor monitor) {
        return this.getService(ChangeListService.class, monitor);
    }

    private ChangeManageService getChangeManageService(IProgressMonitor monitor) {
        return this.getService(ChangeManageService.class, monitor);
    }

    private PatchDetailService getPatchDetailService(IProgressMonitor monitor) {
        return this.getService(PatchDetailService.class, monitor);
    }

    /*
     * Unable to fully structure code
     */
    private List<Project> getVisibleProjects(IProgressMonitor monitor, GerritConfig gerritConfig) throws GerritException {
        block5: {
            block6: {
                block7: {
                    result = new ArrayList<Project>();
                    try {
                        projectDetails = this.execute(monitor, new Operation<List<ProjectDetailX>>(this){

                            @Override
                            public void execute(IProgressMonitor monitor) throws GerritException {
                                this.getProjectAdminService(monitor).visibleProjectDetails(this);
                            }
                        });
                        for (ProjectDetailX projectDetail : projectDetails) {
                            if (GerritUtil.isPermissionOnlyProject(projectDetail, gerritConfig)) continue;
                            result.add(projectDetail.project);
                        }
                        break block5;
                    }
                    catch (GerritException e) {
                        if (!this.isNoSuchServiceError(e)) break block6;
                        if (!this.isVersion27OrLater(monitor)) break block7;
                        projects = this.listProjects(monitor);
                        ** for (projectName : projects.keySet())
                    }
lbl-1000:
                    // 1 sources

                    {
                        result.add(new Project(new Project.NameKey(projectName)));
                        continue;
lbl18:
                        // 1 sources

                        break block5;
                    }
                }
                projects = this.execute(monitor, new Operation<List<Project>>(this){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        this.getProjectAdminService(monitor).visibleProjects(this);
                    }
                });
                for (Project project : projects) {
                    projectDetail = new ProjectDetailX();
                    projectDetail.setProject(project);
                    if (GerritUtil.isPermissionOnlyProject(projectDetail, gerritConfig)) continue;
                    result.add(project);
                }
                break block5;
            }
            throw e;
        }
        Collections.sort(result, new ProjectByNameComparator());
        return result;
    }

    private Map<String, ProjectInfo> listProjects(IProgressMonitor monitor) throws GerritException {
        TypeToken<Map<String, ProjectInfo>> resultType = new TypeToken<Map<String, ProjectInfo>>(){};
        return (Map)this.executeGetRestRequest("/projects/", resultType.getType(), monitor);
    }

    private ProjectAdminService getProjectAdminService(IProgressMonitor monitor) {
        return this.getService(ProjectAdminService.class, monitor);
    }

    public boolean isAnonymous() {
        return this.client.isAnonymous();
    }

    protected void configurationChanged(GerritConfiguration config) {
    }

    protected void authStateChanged(GerritAuthenticationState config) {
    }

    protected <T> T execute(IProgressMonitor monitor, Operation<T> operation) throws GerritException {
        try {
            T t;
            GerritService.GerritRequest.setCurrentRequest(new GerritService.GerritRequest(monitor));
            try {
                t = this.executeOnce(monitor, operation);
            }
            catch (GerritException e) {
                block7: {
                    if (!this.isAuthenticationException(e)) break block7;
                    operation.reset();
                    T t2 = this.executeOnce(monitor, operation);
                    GerritService.GerritRequest.setCurrentRequest(null);
                    return t2;
                }
                throw e;
            }
            return t;
        }
        finally {
            GerritService.GerritRequest.setCurrentRequest(null);
        }
    }

    private <T> T executePostRestRequest(final String url, final Object input, final Type resultType, final GerritHttpClient.ErrorHandler handler, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(client.postRestRequest(url, input, resultType, handler, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    private <T> T executeGetRestRequest(final String url, final Type resultType, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(client.getRestRequest(url, resultType, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    private <T> T executePutRestRequest(final String url, final Object input, final Type resultType, final GerritHttpClient.ErrorHandler handler, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(client.putRestRequest(url, input, resultType, handler, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    private <T> T executeDeleteRestRequest(final String url, final Object input, final Type resultType, final GerritHttpClient.ErrorHandler handler, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(client.deleteRestRequest(url, input, resultType, handler, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    private <T> T executeOnce(IProgressMonitor monitor, Operation<T> operation) throws GerritException {
        operation.execute(monitor);
        if (operation.getException() instanceof GerritException) {
            throw (GerritException)operation.getException();
        }
        if (operation.getException() instanceof OperationCanceledException) {
            throw (OperationCanceledException)operation.getException();
        }
        if (operation.getException() instanceof RuntimeException) {
            throw (RuntimeException)operation.getException();
        }
        if (operation.getException() != null) {
            GerritException e = new GerritException();
            e.initCause(operation.getException());
            throw e;
        }
        return operation.getResult();
    }

    protected synchronized <T extends RemoteJsonService> T getService(Class<T> clazz, IProgressMonitor monitor) {
        Version version = Version.emptyVersion;
        try {
            version = this.getCachedVersion(monitor);
        }
        catch (GerritException gerritException) {}
        Object service = this.serviceByClass.get(clazz);
        if (service == null) {
            service = GerritService.create(clazz, this.client, version);
            this.serviceByClass.put((Class<? extends RemoteJsonService>)clazz, (RemoteJsonService)service);
        }
        return (T)((RemoteJsonService)clazz.cast(service));
    }

    public AbstractRemoteEmfFactoryProvider<IRepository, IReview> createFactoryProvider() {
        return new GerritRemoteFactoryProvider(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Version getCachedVersion(IProgressMonitor monitor) throws GerritException {
        GerritClient gerritClient = this;
        synchronized (gerritClient) {
            if (this.myVersion != null) {
                return this.myVersion;
            }
        }
        Version version = this.getVersion(monitor);
        GerritClient gerritClient2 = this;
        synchronized (gerritClient2) {
            this.myVersion = version;
        }
        return this.myVersion;
    }

    public Version getVersion(IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<Version>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    GerritHttpClient.Request<String> request = new GerritHttpClient.Request<String>(){

                        @Override
                        public HttpMethodBase createMethod() throws IOException {
                            return new GetMethod(String.valueOf(client.getUrl()) + "/tools/hooks/");
                        }

                        @Override
                        public String process(HttpMethodBase method) throws IOException {
                            String content = method.getResponseBodyAsString();
                            Matcher matcher = GERRIT_VERSION_PATTERN.matcher(content);
                            if (matcher.find()) {
                                return matcher.group(1);
                            }
                            return null;
                        }
                    };
                    String result = client.execute(request, false, monitor);
                    Version version = GerritVersion.parseGerritVersion(result);
                    this.onSuccess(version);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }
        });
    }

    public String toReviewId(String id, IProgressMonitor monitor) throws GerritException {
        try {
            Integer.parseInt(id);
            return id;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                List<GerritQueryResult> results = this.executeQuery(monitor, id);
                if (results.size() != 1) {
                    throw new GerritException(NLS.bind((String)"{0} is not a valid review ID", (Object)id));
                }
                return Integer.toString(results.get(0).getNumber());
            }
            catch (GerritException e2) {
                throw new GerritException(NLS.bind((String)"{0} is not a valid review ID", (Object)id), e2);
            }
        }
    }

    private static String encode(String string) throws GerritException {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GerritException(e);
        }
    }

    public VoidResult setStarred(String reviewId, final boolean starred, IProgressMonitor monitor) throws GerritException {
        Change.Id id = new Change.Id(this.id(reviewId));
        final ToggleStarRequest req = new ToggleStarRequest();
        req.toggle(id, starred);
        if (this.isVersion28OrLater(monitor)) {
            final String uri = "/a/accounts/self/starred.changes/" + id.get();
            return this.execute(monitor, new Operation<VoidResult>(this){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    if (starred) {
                        this.executePutRestRequest(uri, req, ToggleStarRequest.class, this.createErrorHandler(), monitor);
                    } else {
                        this.executeDeleteRestRequest(uri, req, ToggleStarRequest.class, this.createErrorHandler(), monitor);
                    }
                }
            });
        }
        return this.execute(monitor, new Operation<VoidResult>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getChangeListService(monitor).toggleStars(req, (AsyncCallback)this);
            }
        });
    }

    private GerritHttpClient.ErrorHandler createErrorHandler() {
        return new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                throw new GerritException(method.getStatusLine().getReasonPhrase());
            }
        };
    }

    private abstract class Operation<T>
    implements AsyncCallback<T> {
        private Throwable exception;
        private T result;

        private Operation() {
        }

        public abstract void execute(IProgressMonitor var1) throws GerritException;

        public Throwable getException() {
            return this.exception;
        }

        public T getResult() {
            return this.result;
        }

        public void onFailure(Throwable exception) {
            if (GerritClient.this.isAuthenticationException(exception)) {
                GerritClient.this.client.setXsrfCookie(null);
            }
            this.exception = exception;
        }

        public void onSuccess(T result) {
            this.setResult(result);
        }

        protected void setResult(T result) {
            this.result = result;
        }

        public void reset() {
            this.result = null;
            this.exception = null;
        }
    }
}

