/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.DateTimeTemplate;
import org.eclipse.mylyn.wikitext.mediawiki.core.Template;
import org.eclipse.mylyn.wikitext.mediawiki.core.TemplateResolver;

public class BuiltInTemplateResolver
extends TemplateResolver {
    private static Map<String, Template> builtInTemplates = new HashMap<String, Template>();

    static {
        BuiltInTemplateResolver.registerTemplate(new Template("mdash", "&nbsp;&mdash; "));
        BuiltInTemplateResolver.registerTemplate(new Template("mdash", "&nbsp;&mdash; "));
        BuiltInTemplateResolver.registerTemplate(new Template("ndash", "&nbsp;&ndash; "));
        BuiltInTemplateResolver.registerTemplate(new Template("emdash", "&nbsp;&mdash; "));
        BuiltInTemplateResolver.registerTemplate(new Template("endash", "&nbsp;&ndash; "));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTYEAR", "yyyy"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTMONTH", "MM"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTMONTHNAME", "MMMMMMMM"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTMONTHNAMEGEN", "MMMMMMMM"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTMONTHABBREV", "MMM"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTDAY", "dd"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTDAY2", "dd"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTDOW", "F"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTDAYNAME", "EEEEEEEE"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTTIME", "HH:mm"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTHOUR", "HH"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTWEEK", "ww"));
        BuiltInTemplateResolver.registerTemplate(new DateTimeTemplate("CURRENTTIMESTAMP", "yyyyMMddHHmmss"));
    }

    @Override
    public Template resolveTemplate(String templateName) {
        return builtInTemplates.get(templateName);
    }

    private static void registerTemplate(Template template) {
        builtInTemplates.put(template.getName(), template);
    }
}

