/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.data;

import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskAttributeTest
extends TestCase {
    private TaskAttribute attribute;

    protected void setUp() throws Exception {
        TaskRepository taskRepository = new TaskRepository("kind", "repository");
        TaskAttributeMapper mapper = new TaskAttributeMapper(taskRepository);
        TaskData data = new TaskData(mapper, "kind", "repository", "id");
        this.attribute = new TaskAttribute(data.getRoot(), "test");
    }

    public void testGetValue() {
        this.attribute.setValue("baz");
        TaskAttributeTest.assertEquals((String)"baz", (String)this.attribute.getValue());
        this.attribute.setValue("bee");
        TaskAttributeTest.assertEquals((String)"bee", (String)this.attribute.getValue());
    }

    public void testRegularValue() throws Exception {
        this.attribute.setValue("foo");
        TaskAttributeTest.assertEquals((String)"foo", (String)this.attribute.getValue());
    }

    public void testRegularValues() throws Exception {
        this.attribute.setValues(Collections.singletonList("foo"));
        TaskAttributeTest.assertEquals((String)"foo", (String)this.attribute.getValue());
    }

    public void testHasValue() {
        TaskAttributeTest.assertFalse((boolean)this.attribute.hasValue());
        this.attribute.setValue("description");
        TaskAttributeTest.assertTrue((boolean)this.attribute.hasValue());
        this.attribute.clearValues();
        TaskAttributeTest.assertFalse((boolean)this.attribute.hasValue());
        this.attribute.setValue("description");
        TaskAttributeTest.assertTrue((boolean)this.attribute.hasValue());
    }

    public void testNullValue() throws Exception {
        try {
            this.attribute.setValue(null);
            TaskAttributeTest.fail((String)"Should refuse null");
        }
        catch (Exception exception) {}
    }

    public void testNullAsValues() throws Exception {
        try {
            this.attribute.setValues(null);
            TaskAttributeTest.fail((String)"Should refuse null");
        }
        catch (Exception exception) {}
    }

    public void testNullAsList() throws Exception {
        try {
            this.attribute.setValues(Collections.singletonList(null));
            TaskAttributeTest.fail((String)"Should refuse null");
        }
        catch (Exception exception) {}
    }

    public void testNullInsideValuesList() throws Exception {
        try {
            this.attribute.setValues(Arrays.asList("foo", null, "bar"));
            TaskAttributeTest.fail((String)"Should refuse null");
        }
        catch (Exception exception) {}
    }
}

