/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.core;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.tasks.ui.util.Util;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.tests.EclipseRuntimeRequired;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguageTest;

@EclipseRuntimeRequired
public class TextileLanguageTasksTest
extends TestCase {
    private MarkupParser parser;
    private TextileLanguage markupLanguage;

    public void setUp() throws Exception {
        super.setUp();
        this.initParser();
    }

    private void initParser() throws IOException {
        this.parser = new MarkupParser();
        this.markupLanguage = new TextileLanguage();
        MarkupLanguageConfiguration configuration = Util.create((String)"bugzilla");
        this.markupLanguage.configure(configuration);
        this.parser.setMarkupLanguage((MarkupLanguage)this.markupLanguage);
    }

    public void testSubversiveBugReport() throws IOException {
        StringWriter out = new StringWriter();
        this.parser.setBuilder((DocumentBuilder)new HtmlDocumentBuilder((Writer)out));
        InputStreamReader reader = new InputStreamReader(TextileLanguageTest.class.getResourceAsStream("resources/subversive-bug-report.txt"), "utf-8");
        try {
            try {
                long time = System.currentTimeMillis();
                this.parser.parse((Reader)reader);
                long endTime = System.currentTimeMillis();
                TestUtil.println(String.format("Took %s millis", endTime - time));
            }
            catch (Throwable t) {
                t.printStackTrace();
                ((Reader)reader).close();
            }
        }
        finally {
            ((Reader)reader).close();
        }
    }
}

