/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.outline;

import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class OutlineItemTest
extends TestCase {
    public void testContains() {
        OutlineParser outlineParser = new OutlineParser((MarkupLanguage)new TextileLanguage());
        OutlineItem outline = outlineParser.parse("h1. First Header\n\nh2. First Header First Child\n\nh1. Third Header\n");
        OutlineItem firstHeader = (OutlineItem)outline.getChildren().get(0);
        OutlineItem secondHeader = (OutlineItem)outline.getChildren().get(1);
        OutlineItem firstHeaderFirstChild = (OutlineItem)firstHeader.getChildren().get(0);
        OutlineItemTest.assertTrue((boolean)outline.contains(firstHeader));
        OutlineItemTest.assertTrue((boolean)outline.contains(secondHeader));
        OutlineItemTest.assertTrue((boolean)firstHeader.contains(firstHeader));
        OutlineItemTest.assertTrue((boolean)secondHeader.contains(secondHeader));
        OutlineItemTest.assertFalse((boolean)firstHeader.contains(secondHeader));
        OutlineItemTest.assertFalse((boolean)secondHeader.contains(firstHeader));
        OutlineItemTest.assertFalse((boolean)firstHeaderFirstChild.contains(firstHeader));
        OutlineItemTest.assertTrue((boolean)firstHeader.contains(firstHeaderFirstChild));
    }

    public void testGetSectionLength() {
        OutlineParser outlineParser = new OutlineParser((MarkupLanguage)new TextileLanguage());
        String markup = "h1. First Header\n\nh2. First Header First Child\n\nh1. Third Header\n";
        OutlineItem outline = outlineParser.parse(markup);
        OutlineItem firstHeader = (OutlineItem)outline.getChildren().get(0);
        OutlineItem secondHeader = (OutlineItem)outline.getChildren().get(1);
        OutlineItem firstHeaderFirstChild = (OutlineItem)firstHeader.getChildren().get(0);
        OutlineItemTest.assertEquals((int)markup.length(), (int)outline.getSectionLength());
        OutlineItemTest.assertEquals((int)48, (int)firstHeader.getSectionLength());
        OutlineItemTest.assertEquals((int)17, (int)secondHeader.getSectionLength());
        OutlineItemTest.assertEquals((int)30, (int)firstHeaderFirstChild.getSectionLength());
    }
}

