/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.creole.internal;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.builder.AbstractMarkupDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.EntityReferences;

public class CreoleDocumentBuilder
extends AbstractMarkupDocumentBuilder {
    public CreoleDocumentBuilder(Writer out) {
        super(out);
    }

    protected AbstractMarkupDocumentBuilder.Block computeBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        switch (type) {
            case BULLETED_LIST: 
            case NUMERIC_LIST: {
                return new AbstractMarkupDocumentBuilder.NewlineDelimitedBlock((AbstractMarkupDocumentBuilder)this, type, this.doubleNewlineDelimiterCount(), 1);
            }
            case LIST_ITEM: {
                char prefixChar = this.computeCurrentListType() == DocumentBuilder.BlockType.NUMERIC_LIST ? (char)'#' : '*';
                return new ContentBlock(type, this.computePrefix(prefixChar, this.computeListLevel()) + " ", "", 1, 1);
            }
            case PARAGRAPH: {
                return new ContentBlock(type, "", "", 2, 2);
            }
            case PREFORMATTED: 
            case CODE: {
                return new ContentBlock(type, "{{{\n", "\n}}}", 2, 2, false, false);
            }
            case TABLE: {
                return new AbstractMarkupDocumentBuilder.SuffixBlock((AbstractMarkupDocumentBuilder)this, type, "\n");
            }
            case TABLE_CELL_HEADER: 
            case TABLE_CELL_NORMAL: {
                return new TableCellBlock(type);
            }
            case TABLE_ROW: {
                return new AbstractMarkupDocumentBuilder.SuffixBlock((AbstractMarkupDocumentBuilder)this, type, "|\n");
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected block type: " + type);
        return new ContentBlock(type, "", "", 2, 2);
    }

    private int doubleNewlineDelimiterCount() {
        DocumentBuilder.BlockType currentBlockType;
        if (this.currentBlock != null && ((currentBlockType = this.currentBlock.getBlockType()) == DocumentBuilder.BlockType.LIST_ITEM || currentBlockType == DocumentBuilder.BlockType.BULLETED_LIST || currentBlockType == DocumentBuilder.BlockType.NUMERIC_LIST)) {
            return 1;
        }
        return 2;
    }

    protected AbstractMarkupDocumentBuilder.Block computeSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        switch (type) {
            case LINK: {
                if (attributes instanceof LinkAttributes) {
                    return new LinkBlock((LinkAttributes)attributes);
                }
                return new ContentBlock("[[", "]]", 0, 0);
            }
            case ITALIC: 
            case EMPHASIS: 
            case MARK: {
                return new ContentBlock("//", "//");
            }
            case BOLD: 
            case STRONG: {
                return new ContentBlock("**", "**");
            }
            case DELETED: {
                return new ContentBlock("--", "--");
            }
            case CODE: {
                return new ContentBlock(null, "{{{", "}}}", 0, 0, false, false);
            }
            case UNDERLINED: {
                return new ContentBlock("__", "__");
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected span type: " + type);
        return new ContentBlock("", "", 2, 2);
    }

    protected AbstractMarkupDocumentBuilder.Block computeHeading(int level, Attributes attributes) {
        return new ContentBlock(this.computePrefix('=', level) + " ", "", 1, 2);
    }

    public void characters(String text) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void entityReference(String entity) {
        this.assertOpenBlock();
        Object literal = EntityReferences.instance().equivalentString(entity);
        if (literal == null) {
            literal = "&" + entity + ";";
        }
        try {
            this.currentBlock.write((String)literal);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void image(Attributes attributes, String url) {
        if (url != null) {
            this.assertOpenBlock();
            try {
                ContentBlock imageBlock = new ContentBlock(null, "{{", "}}", 0, 0, false, false);
                imageBlock.open();
                imageBlock.write(url);
                this.writeImageAttributes((AbstractMarkupDocumentBuilder.Block)imageBlock, attributes);
                imageBlock.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void writeImageAttributes(AbstractMarkupDocumentBuilder.Block imageBlock, Attributes attributes) throws IOException {
        if (attributes instanceof ImageAttributes) {
            if (!Strings.isNullOrEmpty((String)((ImageAttributes)attributes).getAlt())) {
                imageBlock.write(124);
                imageBlock.write(((ImageAttributes)attributes).getAlt());
            } else if (!Strings.isNullOrEmpty((String)((ImageAttributes)attributes).getTitle())) {
                imageBlock.write(124);
                imageBlock.write(((ImageAttributes)attributes).getTitle());
            }
        }
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.assertOpenBlock();
        LinkAttributes linkAttributes = new LinkAttributes();
        linkAttributes.setHref(hrefOrHashName);
        this.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)linkAttributes);
        this.characters(text);
        this.endSpan();
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        String altText = "";
        if (imageAttributes instanceof ImageAttributes && !Strings.isNullOrEmpty((String)((ImageAttributes)imageAttributes).getAlt())) {
            altText = ((ImageAttributes)imageAttributes).getAlt();
        }
        this.link(linkAttributes, href, "{{" + Strings.nullToEmpty((String)imageUrl) + "}}" + altText);
    }

    public void acronym(String text, String definition) {
        throw new UnsupportedOperationException();
    }

    public void lineBreak() {
        this.assertOpenBlock();
        try {
            if (this.currentBlock instanceof CreoleBlock) {
                ((CreoleBlock)this.currentBlock).lineBreak();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void horizontalRule() {
        this.assertOpenBlock();
        String horizontalRule = "\n----\n";
        try {
            this.currentBlock.write(horizontalRule);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void emitEscapedContent(String s) throws IOException {
        if (s != null) {
            for (int x = 0; x < s.length(); ++x) {
                this.emitEscapedContent(s.charAt(x));
            }
        }
    }

    void emitEscapedContent(int c) throws IOException {
        if (c == 126 || c == 42 || c == 35 || c == 124 || c == 61) {
            super.emitContent(126);
        }
        super.emitContent(c);
    }

    protected AbstractMarkupDocumentBuilder.Block createImplicitParagraphBlock() {
        return new ImplicitParagraphBlock();
    }

    private class TableCellBlock
    extends ContentBlock {
        public TableCellBlock(DocumentBuilder.BlockType blockType) {
            super(blockType, blockType == DocumentBuilder.BlockType.TABLE_CELL_NORMAL ? "|" : "|=", "", 0, 0, true, true);
        }

        @Override
        protected void emitContent(String content) throws IOException {
            if (Strings.isNullOrEmpty((String)content) || content.trim().isEmpty()) {
                content = " ";
            }
            super.emitContent(content);
        }
    }

    private class LinkBlock
    extends ContentBlock {
        private final LinkAttributes attributes;

        LinkBlock(LinkAttributes attributes) {
            super(null, "", "", 0, 0, true, true);
            this.attributes = attributes;
        }

        @Override
        protected void emitContent(String content) throws IOException {
            CreoleDocumentBuilder.this.emitContent("[[");
            if (!Strings.isNullOrEmpty((String)this.attributes.getHref())) {
                CreoleDocumentBuilder.this.emitContent(this.attributes.getHref());
            }
            if (!Strings.isNullOrEmpty((String)this.attributes.getHref()) && !Strings.isNullOrEmpty((String)content)) {
                CreoleDocumentBuilder.this.emitContent(124);
            }
            if (!Strings.isNullOrEmpty((String)content)) {
                CreoleDocumentBuilder.this.emitContent(content);
            }
            CreoleDocumentBuilder.this.emitContent("]]");
        }
    }

    private class ImplicitParagraphBlock
    extends ContentBlock {
        ImplicitParagraphBlock() {
            super(DocumentBuilder.BlockType.PARAGRAPH, "", "", 2, 2);
        }

        protected boolean isImplicitBlock() {
            return true;
        }
    }

    private class ContentBlock
    extends AbstractMarkupDocumentBuilder.NewlineDelimitedBlock
    implements CreoleBlock {
        protected String prefix;
        protected String suffix;
        private final boolean emitWhenEmpty;
        private final boolean escaping;

        public ContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix, int precedingNewlineCount, int trailingNewlineCount, boolean emitWhenEmpty, boolean escaping) {
            super((AbstractMarkupDocumentBuilder)CreoleDocumentBuilder.this, blockType, precedingNewlineCount, trailingNewlineCount);
            this.prefix = prefix;
            this.suffix = suffix;
            this.emitWhenEmpty = emitWhenEmpty;
            this.escaping = escaping;
        }

        public ContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix, int precedingNewlineCount, int trailingNewlineCount) {
            this(blockType, prefix, suffix, precedingNewlineCount, trailingNewlineCount, false, true);
        }

        public ContentBlock(String prefix, String suffix, int precedingNewlineCount, int trailingNewlineCount) {
            this(null, prefix, suffix, precedingNewlineCount, trailingNewlineCount);
        }

        public ContentBlock(String prefix, String suffix) {
            this(null, prefix, suffix, 0, 0);
        }

        public void write(int c) throws IOException {
            if (this.escaping) {
                CreoleDocumentBuilder.this.emitEscapedContent(c);
            } else {
                CreoleDocumentBuilder.this.emitContent(c);
            }
        }

        public void write(String s) throws IOException {
            if (this.escaping) {
                CreoleDocumentBuilder.this.emitEscapedContent(s);
            } else {
                CreoleDocumentBuilder.this.emitContent(s);
            }
        }

        public void open() throws IOException {
            super.open();
            CreoleDocumentBuilder.this.pushWriter(new StringWriter());
        }

        public void close() throws IOException {
            Writer thisContent = CreoleDocumentBuilder.this.popWriter();
            String content = thisContent.toString();
            if (this.emitWhenEmpty || content.length() > 0) {
                this.emitContent(content);
            }
            super.close();
        }

        protected void emitContent(String content) throws IOException {
            CreoleDocumentBuilder.this.emitContent(this.prefix);
            CreoleDocumentBuilder.this.emitContent(content);
            CreoleDocumentBuilder.this.emitContent(this.suffix);
        }

        @Override
        public void lineBreak() throws IOException {
            this.write("\\\\");
        }
    }

    private static interface CreoleBlock {
        public void lineBreak() throws IOException;
    }
}

