/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContextBuilder;
import org.eclipse.mylyn.wikitext.commonmark.internal.ToStringHelper;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class ReferenceDefinition
extends Inline {
    private final String href;
    private final String title;
    private final String name;

    public ReferenceDefinition(Line line, int offset, int length, String href, String title, String name) {
        super(line, offset, length);
        this.href = (String)Preconditions.checkNotNull((Object)href);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.title = title;
    }

    public String getHref() {
        return this.href;
    }

    @Override
    public void emit(DocumentBuilder builder) {
    }

    @Override
    public void createContext(ProcessingContextBuilder contextBuilder) {
        contextBuilder.referenceDefinition(this.name, this.href, this.title);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getOffset(), this.getLength(), this.name, this.href, this.title);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ReferenceDefinition other = (ReferenceDefinition)obj;
        return this.href.equals(other.href) && this.name.equals(other.name) && Objects.equals(this.title, other.title);
    }

    @Override
    public String toString() {
        return com.google.common.base.Objects.toStringHelper(ReferenceDefinition.class).add("offset", this.getOffset()).add("length", this.getLength()).add("name", (Object)this.name).add("href", (Object)ToStringHelper.toStringValue(this.href)).add("title", (Object)this.title).toString();
    }
}

