/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.discovery;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.epp.internal.mpc.ui.discovery.ShowNatureProposalsDialog;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.IMarketplaceClientConfiguration;
import org.eclipse.epp.mpc.ui.IMarketplaceClientService;
import org.eclipse.epp.mpc.ui.MarketplaceClient;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ShowNatureProposalsJob
extends UIJob {
    private final Map<String, Collection<INode>> candidates;

    ShowNatureProposalsJob(Map<String, Collection<INode>> candidates) {
        super(PlatformUI.getWorkbench().getDisplay(), Messages.MissingNatureDetector_Desc);
        this.candidates = candidates;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        ShowNatureProposalsDialog dialog = new ShowNatureProposalsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.candidates);
        if (dialog.open() == 1) {
            return Status.CANCEL_STATUS;
        }
        Set<String> natureIds = dialog.getSelectedNatures();
        IMarketplaceClientService marketplaceClientService = MarketplaceClient.getMarketplaceClientService();
        IMarketplaceClientConfiguration config = marketplaceClientService.newConfiguration();
        HashSet<INode> allNodes = new HashSet<INode>();
        for (String natureId : natureIds) {
            allNodes.addAll(this.candidates.get(natureId));
        }
        if (!allNodes.isEmpty()) {
            marketplaceClientService.open(config, allNodes);
        }
        return Status.OK_STATUS;
    }
}

