/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DropDownButton {
    private boolean showArrow;
    private Rectangle arrowBounds;
    private String padding = null;
    private final Button button;
    private List<DropDownSelectionListenerWrapper> selectionListenerWrappers;
    private final PaintListener paintListener = new PaintListener(){
        Color shadowColor;
        Color black;

        public void paintControl(PaintEvent e) {
            if (this.shadowColor == null) {
                this.shadowColor = e.display.getSystemColor(18);
            }
            if (this.black == null) {
                this.black = e.display.getSystemColor(2);
            }
            Rectangle buttonBounds = DropDownButton.this.button.getBounds();
            int arrowAreaWidth = 20;
            DropDownButton.this.arrowBounds = new Rectangle(e.x + buttonBounds.width - arrowAreaWidth, e.y, arrowAreaWidth, buttonBounds.height);
            GC gc = e.gc;
            Color oldForeground = gc.getForeground();
            Color oldBackground = gc.getBackground();
            try {
                int inset = 3;
                int lineX = ((DropDownButton)DropDownButton.this).arrowBounds.x;
                gc.setLineWidth(1);
                gc.setForeground(this.shadowColor);
                gc.setBackground(this.shadowColor);
                gc.drawLine(lineX, ((DropDownButton)DropDownButton.this).arrowBounds.y + inset - 1, lineX, e.y + buttonBounds.height - inset);
                gc.setForeground(this.black);
                gc.setBackground(this.black);
                int arrowWidth = 7;
                int arrowHeight = 4;
                int arrowX = lineX + (arrowAreaWidth - arrowWidth) / 2;
                int arrowY = ((DropDownButton)DropDownButton.this).arrowBounds.height / 2 - arrowHeight / 2 + 1;
                gc.fillPolygon(new int[]{arrowX, arrowY, arrowX + arrowWidth, arrowY, arrowX + arrowWidth / 2, arrowY + arrowHeight});
            }
            finally {
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
            }
        }
    };

    public DropDownButton(Composite parent, int style) {
        this.button = new Button(parent, 8);
    }

    private boolean isShowMenu(int x, int y) {
        return this.showArrow && this.arrowBounds != null && this.arrowBounds.contains(x, y);
    }

    public void setShowArrow(boolean showArrow) {
        this.showArrow = showArrow;
        this.updatePadding();
        if (showArrow) {
            this.button.addPaintListener(this.paintListener);
        } else {
            this.button.removePaintListener(this.paintListener);
        }
    }

    public boolean isShowArrow() {
        return this.showArrow;
    }

    public void setText(String string) {
        this.button.setText(this.pad(string));
    }

    private String pad(String string) {
        return string == null ? null : (this.padding == null ? string : String.valueOf(string) + this.padding);
    }

    private String unpad(String string) {
        return string == null ? null : (this.padding == null || !string.endsWith(this.padding) ? string : string.substring(0, string.length() - this.padding.length()));
    }

    public String getText() {
        String text = this.button.getText();
        return this.unpad(text);
    }

    public void setFont(Font font) {
        this.button.setFont(font);
        this.updatePadding();
    }

    private void updatePadding() {
        String newPadding;
        String text = this.getText();
        String currentPadding = this.padding;
        String string = newPadding = this.showArrow ? this.calculatePadding(22) : null;
        if (newPadding == null && currentPadding != null || newPadding != null && !newPadding.equals(currentPadding)) {
            this.padding = newPadding;
            this.setText(text);
        }
    }

    private String calculatePadding(int width) {
        int padSpaceWidth = this.calculateSpaceWidth();
        int count = (2 * width + padSpaceWidth - 1) / (2 * padSpaceWidth);
        switch (count) {
            case 0: {
                return null;
            }
            case 1: {
                return " ";
            }
            case 2: {
                return "  ";
            }
            case 3: {
                return "    ";
            }
            case 4: {
                return "     ";
            }
            case 5: {
                return "      ";
            }
            case 6: {
                return "       ";
            }
            case 7: {
                return "        ";
            }
            case 8: {
                return "         ";
            }
            case 9: {
                return "          ";
            }
            case 10: {
                return "           ";
            }
        }
        StringBuilder bldr = new StringBuilder("           ");
        int i = 10;
        while (i < count) {
            bldr.append(' ');
            ++i;
        }
        return bldr.toString();
    }

    private int calculateSpaceWidth() {
        GC gc = new GC((Drawable)this.button);
        try {
            gc.setFont(this.button.getFont());
            int n = gc.getAdvanceWidth(' ');
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    public Button getButton() {
        return this.button;
    }

    public void dispose() {
        this.button.dispose();
    }

    public Image getImage() {
        return this.button.getImage();
    }

    public void setImage(Image image) {
        this.button.setImage(image);
    }

    public Shell getShell() {
        return this.button.getShell();
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    public boolean isVisible() {
        return this.button.isVisible();
    }

    public void addSelectionListener(SelectionListener listener) {
        DropDownSelectionListenerWrapper wrapper = this.findWrapper(listener);
        if (wrapper == null) {
            wrapper = new DropDownSelectionListenerWrapper(listener);
            this.selectionListenerWrappers.add(wrapper);
        }
        this.button.addSelectionListener((SelectionListener)wrapper);
        this.button.addMouseListener((MouseListener)wrapper);
    }

    private DropDownSelectionListenerWrapper findWrapper(SelectionListener listener) {
        DropDownSelectionListenerWrapper wrapper = null;
        if (this.selectionListenerWrappers == null) {
            this.selectionListenerWrappers = new ArrayList<DropDownSelectionListenerWrapper>();
        }
        for (DropDownSelectionListenerWrapper existingWrapper : this.selectionListenerWrappers) {
            if (existingWrapper.getDelegate() != listener) continue;
            wrapper = existingWrapper;
            break;
        }
        return wrapper;
    }

    public void removeSelectionListener(SelectionListener listener) {
        DropDownSelectionListenerWrapper wrapper = this.findWrapper(listener);
        if (wrapper != null) {
            this.button.removeSelectionListener((SelectionListener)wrapper);
        }
        this.button.removeSelectionListener(listener);
    }

    private final class DropDownSelectionListenerWrapper
    extends MouseAdapter
    implements SelectionListener {
        private final SelectionListener delegate;
        private boolean isShowMenu;

        public DropDownSelectionListenerWrapper(SelectionListener delegate) {
            this.delegate = delegate;
        }

        public SelectionListener getDelegate() {
            return this.delegate;
        }

        public void widgetSelected(SelectionEvent e) {
            this.setArrowDetail(e);
            this.delegate.widgetSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.setArrowDetail(e);
            this.delegate.widgetDefaultSelected(e);
        }

        private void setArrowDetail(SelectionEvent e) {
            e.detail = this.isShowMenu ? 4 : 0;
            this.isShowMenu = false;
        }

        public void mouseDown(MouseEvent e) {
            this.isShowMenu = DropDownButton.this.isShowMenu(e.x, e.y);
        }
    }
}

