/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.commands;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.epp.internal.mpc.ui.catalog.FavoritesCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.FavoritesDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.commands.AbstractMarketplaceWizardCommand;
import org.eclipse.epp.internal.mpc.ui.wizards.ImportFavoritesPage;
import org.eclipse.epp.internal.mpc.ui.wizards.ImportFavoritesWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.ImportFavoritesWizardDialog;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryWizard;

public class ImportFavoritesWizardCommand
extends AbstractMarketplaceWizardCommand {
    private static final String FAVORITES_URL_PARAMETER = "favoritesUrl";
    private String favoritesUrl;

    protected ImportFavoritesWizardDialog createWizardDialog(DiscoveryWizard wizard, ExecutionEvent event) {
        return new ImportFavoritesWizardDialog(WorkbenchUtil.getShell(), (ImportFavoritesWizard)wizard);
    }

    protected ImportFavoritesWizard createWizard(MarketplaceCatalog catalog, MarketplaceCatalogConfiguration configuration, ExecutionEvent event) {
        String favoritesUrl = event.getParameter(FAVORITES_URL_PARAMETER);
        if (favoritesUrl == null) {
            favoritesUrl = this.favoritesUrl;
        }
        FavoritesCatalog favoritesCatalog = new FavoritesCatalog();
        ImportFavoritesWizard wizard = new ImportFavoritesWizard(favoritesCatalog, configuration, null);
        wizard.setInitialFavoritesUrl(favoritesUrl);
        final ImportFavoritesPage importFavoritesPage = wizard.getImportFavoritesPage();
        favoritesCatalog.getDiscoveryStrategies().add(new FavoritesDiscoveryStrategy(configuration.getCatalogDescriptor()){
            private String discoveryError;
            {
                super($anonymous0);
                this.discoveryError = null;
            }

            protected void preDiscovery() {
                this.discoveryError = null;
            }

            protected void handleDiscoveryError(CoreException ex) throws CoreException {
                this.discoveryError = ImportFavoritesPage.handleDiscoveryError(this.getFavoritesReference(), (Exception)((Object)ex));
            }

            protected void postDiscovery() {
                String errorMessage = this.discoveryError;
                this.discoveryError = null;
                importFavoritesPage.setDiscoveryError(errorMessage);
            }
        });
        return wizard;
    }

    public void setFavoritesUrl(String favoritesUrl) {
        this.favoritesUrl = favoritesUrl;
    }

    public String getFavoritesUrl() {
        return this.favoritesUrl;
    }
}

