/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.MarketplaceOrAssociateDialog;
import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.model.ISearchResult;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.IMarketplaceServiceLocator;
import org.eclipse.epp.mpc.ui.IMarketplaceClientConfiguration;
import org.eclipse.epp.mpc.ui.IMarketplaceClientService;
import org.eclipse.epp.mpc.ui.MarketplaceClient;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.ide.IUnassociatedEditorStrategy;
import org.eclipse.ui.internal.ide.SystemEditorOrTextEditorStrategy;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class AskMarketPlaceForFileSupportStrategy
implements IUnassociatedEditorStrategy {
    public IEditorDescriptor getEditorDescriptor(final String fileName, final IEditorRegistry editorRegistry) throws CoreException, OperationCanceledException {
        final IEditorDescriptor res = new SystemEditorOrTextEditorStrategy().getEditorDescriptor(fileName, editorRegistry);
        final Display display = Display.getCurrent();
        Job mpcJob = new Job(Messages.AskMarketPlaceForFileSupportStrategy_jobName){

            protected IStatus run(IProgressMonitor monitor) {
                List nodes;
                BundleContext bundleContext = MarketplaceClientUiPlugin.getBundleContext();
                ServiceReference locatorReference = bundleContext.getServiceReference(IMarketplaceServiceLocator.class);
                IMarketplaceServiceLocator locator = (IMarketplaceServiceLocator)bundleContext.getService(locatorReference);
                IMarketplaceService marketplaceService = locator.getDefaultMarketplaceService();
                String[] split = fileName.split("\\.");
                final String fileExtension = split[split.length - 1];
                final String fileExtensionLabel = fileExtension.length() == fileName.length() ? fileName : "*." + fileExtension;
                String fileExtensionTag = "fileExtension_" + fileExtension;
                try {
                    ISearchResult searchResult = marketplaceService.tagged(fileExtensionTag, monitor);
                    nodes = searchResult.getNodes();
                }
                catch (CoreException ex) {
                    MarketplaceClientUi.error(ex);
                    return Status.CANCEL_STATUS;
                }
                if (nodes.isEmpty()) {
                    return Status.OK_STATUS;
                }
                UIJob openDialog = new UIJob(Messages.AskMerketplaceForFileSupportStrategy_dialogJobName){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        Shell shell = WorkbenchUtil.getShell();
                        MarketplaceOrAssociateDialog dialog = new MarketplaceOrAssociateDialog(shell, fileExtensionLabel, res);
                        if (dialog.open() == 0) {
                            if (dialog.isShowProposals()) {
                                IMarketplaceClientService marketplaceClientService = MarketplaceClient.getMarketplaceClientService();
                                IMarketplaceClientConfiguration config = marketplaceClientService.newConfiguration();
                                marketplaceClientService.open(config, new LinkedHashSet<INode>(nodes));
                            } else if (dialog.isAssociateToExtension()) {
                                ArrayList<String> extensions = new ArrayList<String>(1);
                                extensions.add(fileExtension);
                                FileEditorMapping[] mappings = new FileEditorMapping[editorRegistry.getFileEditorMappings().length + 1];
                                System.arraycopy(editorRegistry.getFileEditorMappings(), 0, mappings, 0, mappings.length - 1);
                                FileEditorMapping newMapping = null;
                                newMapping = fileName.equals(fileExtension) ? new FileEditorMapping(fileName, null) : new FileEditorMapping(fileExtension);
                                newMapping.setDefaultEditor(res);
                                mappings[mappings.length - 1] = newMapping;
                                ((EditorRegistry)editorRegistry).setFileEditorMappings(mappings);
                                ((EditorRegistry)editorRegistry).saveAssociations();
                            }
                            return Status.OK_STATUS;
                        }
                        return Status.CANCEL_STATUS;
                    }

                    public Display getDisplay() {
                        if (display != null && !display.isDisposed()) {
                            return display;
                        }
                        return super.getDisplay();
                    }
                };
                openDialog.setPriority(10);
                openDialog.setSystem(true);
                openDialog.schedule();
                return Status.OK_STATUS;
            }
        };
        mpcJob.setPriority(10);
        mpcJob.setUser(false);
        mpcJob.schedule();
        return res;
    }
}

