/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.ChainedCredentialsProvider;

public class SynchronizedCredentialsProvider
implements CredentialsProvider {
    private final CredentialsProvider delegate;
    private final Object lock;

    public SynchronizedCredentialsProvider(CredentialsProvider delegate) {
        this.delegate = delegate;
        Object lock = SynchronizedCredentialsProvider.findLock(delegate);
        this.lock = lock == null ? this : lock;
    }

    private static Object findLock(CredentialsProvider credentialsProvider) {
        if (credentialsProvider instanceof SynchronizedCredentialsProvider) {
            return ((SynchronizedCredentialsProvider)credentialsProvider).lock;
        }
        if (credentialsProvider instanceof ChainedCredentialsProvider) {
            ChainedCredentialsProvider chain = (ChainedCredentialsProvider)credentialsProvider;
            Object lock = SynchronizedCredentialsProvider.findLock(chain.getSecond());
            if (lock != null) {
                return lock;
            }
            return SynchronizedCredentialsProvider.findLock(chain.getFirst());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(AuthScope authscope, Credentials credentials) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.setCredentials(authscope, credentials);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials getCredentials(AuthScope authscope) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.getCredentials(authscope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.clear();
        }
    }

    CredentialsProvider getDelegate() {
        return this.delegate;
    }
}

