/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.fluent.Executor;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.mpc.core.util.ProxyHelper;

final class HttpClientProxyUtil {
    private static final String PROP_HTTP_AUTH_NTLM_DOMAIN = "http.auth.ntlm.domain";
    private static final String ENV_USER_DOMAIN = "USERDOMAIN";
    private static final char BACKSLASH = '\\';
    private static final char SLASH = '/';
    private static String workstation;

    private HttpClientProxyUtil() {
    }

    public static HttpHost getProxyHost(URI uri) {
        IProxyData proxy = ProxyHelper.getProxyData(uri);
        if (proxy != null) {
            if ("HTTPS".equals(proxy.getType()) || "HTTP".equals(proxy.getType())) {
                return new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getType());
            }
            return null;
        }
        return null;
    }

    public static Executor proxyAuthentication(Executor executor, URI uri) throws IOException {
        IProxyData proxy = ProxyHelper.getProxyData(uri);
        if (proxy != null) {
            HttpHost proxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
            String proxyUserID = proxy.getUserId();
            if (proxyUserID != null) {
                String domainUserID = HttpClientProxyUtil.getNTLMUserName(proxyUserID);
                String password = proxy.getPassword();
                String domain = HttpClientProxyUtil.getNTLMUserDomain(proxyUserID);
                if (domain != null || !proxyUserID.equals(domainUserID)) {
                    String workstation = HttpClientProxyUtil.getNTLMWorkstation();
                    executor.auth(new AuthScope(proxyHost, AuthScope.ANY_REALM, "ntlm"), (Credentials)new NTCredentials(domainUserID, password, workstation, domain));
                }
                return executor.auth(new AuthScope(proxyHost, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(proxyUserID, password));
            }
        }
        return executor;
    }

    public static String getNTLMWorkstation() {
        String hostName;
        if (workstation != null) {
            return "".equals(workstation) ? null : workstation;
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (!(localHost.isLoopbackAddress() || (hostName = localHost.getHostName()) == null || "".equals(hostName) || "localhost".equals(hostName))) {
                workstation = hostName;
                return hostName;
            }
        }
        catch (UnknownHostException unknownHostException) {}
        String computerName = System.getenv("COMPUTERNAME");
        hostName = System.getenv("HOSTNAME");
        if (computerName != null) {
            if (hostName != null && !computerName.equals(hostName)) {
                if (Platform.getOS().equals("win32")) {
                    hostName = computerName;
                }
            } else {
                hostName = computerName;
            }
        }
        if (hostName != null) {
            workstation = hostName;
            return hostName;
        }
        workstation = "";
        return null;
    }

    public static String getNTLMUserDomain(String userName) {
        String domain;
        if (userName != null) {
            int pos = userName.indexOf(92);
            if (pos != -1) {
                return userName.substring(0, pos);
            }
            pos = userName.indexOf(47);
            if (pos != -1) {
                return userName.substring(0, pos);
            }
        }
        if ((domain = System.getProperty(PROP_HTTP_AUTH_NTLM_DOMAIN)) != null) {
            return domain;
        }
        domain = System.getenv(ENV_USER_DOMAIN);
        if (domain != null) {
            return domain;
        }
        return null;
    }

    public static String getNTLMUserName(String userName) {
        if (userName != null) {
            int pos = userName.indexOf(92);
            if (userName.charAt(pos + 1) == '\\') {
                ++pos;
            }
            if (pos != -1) {
                return userName.substring(pos + 1);
            }
            pos = userName.indexOf(47);
            if (userName.charAt(pos + 1) == '/') {
                ++pos;
            }
            if (pos != -1) {
                return userName.substring(pos + 1);
            }
        }
        return userName;
    }

    private static IProxyData getProxyData(IProxyService proxyService, URI uri) {
        IProxyData[] proxies;
        if (proxyService != null && (proxies = proxyService.select(uri)).length != 0) {
            return proxies[0];
        }
        return null;
    }
}

