/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epp.internal.mpc.ui.catalog.FavoritesDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.UserActionCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.FavoritesDiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.ImportFavoritesPage;
import org.eclipse.epp.internal.mpc.ui.wizards.InfoViewerItem;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDiscoveryResources;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoritesViewer
extends CatalogViewer {
    private static final String HTTPS_PREFIX = "https://";
    private static final String HTTP_PREFIX = "http://";
    private static final int MIN_URL_LENGTH = "http://".length() + 5;
    private MarketplaceDiscoveryResources discoveryResources;
    private final IMarketplaceWebBrowser browser;
    private final ImportFavoritesPage importFavoritesPage;

    public FavoritesViewer(Catalog catalog, ImportFavoritesPage page, IMarketplaceWebBrowser browser, CatalogConfiguration configuration) {
        super(catalog, (IShellProvider)page, (IRunnableContext)page.getWizard().getContainer(), configuration);
        this.importFavoritesPage = page;
        this.browser = browser;
        this.setAutomaticFind(false);
        this.setRefreshJobDelay(50L);
    }

    protected StructuredViewer doCreateViewer(Composite container) {
        StructuredViewer viewer = super.doCreateViewer(container);
        this.discoveryResources = new MarketplaceDiscoveryResources(container.getDisplay());
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FavoritesViewer.this.discoveryResources.dispose();
                FavoritesViewer.this.discoveryResources = null;
            }
        });
        super.getResources().dispose();
        viewer.setSorter(null);
        return viewer;
    }

    private static <T extends Widget> T findControl(Composite container, Class<T> type) {
        Control[] children;
        Control[] controlArray = children = container.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            T childMatch;
            Control control = controlArray[n2];
            if (type.isInstance(control)) {
                return (T)((Widget)type.cast(control));
            }
            if (control instanceof Composite && (childMatch = FavoritesViewer.findControl((Composite)control, type)) != null) {
                return childMatch;
            }
            ++n2;
        }
        return null;
    }

    protected void doCreateHeaderControls(Composite parent) {
        Label searchLabel = FavoritesViewer.findControl(parent, Label.class);
        final Text searchField = FavoritesViewer.findControl(parent, Text.class);
        if (searchLabel != null) {
            searchLabel.setText(Messages.FavoritesViewer_searchLabel);
        }
        if (searchField != null) {
            searchField.setMessage(Messages.FavoritesViewer_searchInputDescription);
            searchField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (e.keyCode == 0 && e.start == 0 && e.end == searchField.getText().length() && e.text.length() > 0) {
                        FavoritesViewer.this.filterTextChanged();
                    }
                }
            });
        }
    }

    protected void modifySelection(CatalogItem connector, boolean selected) {
        super.modifySelection(connector, selected);
    }

    public void updateCatalog() {
        List checkedItems = this.getCheckedItems();
        for (CatalogItem catalogItem : checkedItems) {
            this.modifySelection(catalogItem, false);
        }
        super.updateCatalog();
    }

    protected MarketplaceDiscoveryResources getResources() {
        return this.discoveryResources;
    }

    protected ControlListItem<?> doCreateViewerItem(Composite parent, Object element) {
        if (element instanceof MarketplaceNodeCatalogItem) {
            FavoritesDiscoveryItem discoveryItem = this.createDiscoveryItem(parent, (MarketplaceNodeCatalogItem)((Object)element));
            return discoveryItem;
        }
        if (element instanceof UserActionCatalogItem) {
            return new InfoViewerItem(parent, (DiscoveryResources)this.getResources(), this.shellProvider, (UserActionCatalogItem)((Object)element), (CatalogViewer)this);
        }
        return super.doCreateViewerItem(parent, element);
    }

    private FavoritesDiscoveryItem createDiscoveryItem(Composite parent, MarketplaceNodeCatalogItem catalogItem) {
        return new FavoritesDiscoveryItem(parent, 0, this.getResources(), this.browser, catalogItem, this);
    }

    protected Set<String> getInstalledFeatures(IProgressMonitor monitor) {
        return Collections.emptySet();
    }

    protected void doFind(String text) {
        FavoritesDiscoveryStrategy favoritesStrategy = this.findFavoritesStrategy();
        if (favoritesStrategy != null) {
            favoritesStrategy.setFavoritesReference(text);
        }
        this.updateCatalog();
    }

    private FavoritesDiscoveryStrategy findFavoritesStrategy() {
        FavoritesDiscoveryStrategy favoritesStrategy = null;
        List discoveryStrategies = this.getCatalog().getDiscoveryStrategies();
        for (AbstractDiscoveryStrategy strategy : discoveryStrategies) {
            if (!(strategy instanceof FavoritesDiscoveryStrategy)) continue;
            favoritesStrategy = (FavoritesDiscoveryStrategy)strategy;
            break;
        }
        return favoritesStrategy;
    }

    protected void catalogUpdated(boolean wasCancelled, boolean wasError) {
        super.catalogUpdated(wasCancelled, wasError);
        List items = this.getCatalog().getItems();
        for (CatalogItem catalogItem : items) {
            this.modifySelection(catalogItem, catalogItem.isSelected());
        }
    }
}

