/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.service.AbstractDataStorageService;
import org.eclipse.epp.internal.mpc.core.service.UserFavoritesService;
import org.eclipse.epp.internal.mpc.ui.catalog.FavoritesDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.FavoritesViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.service.IUserFavoritesService;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogPage;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryWizard;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.userstorage.util.ConflictException;

public class ImportFavoritesPage
extends CatalogPage {
    private final IMarketplaceWebBrowser browser;

    public ImportFavoritesPage(MarketplaceCatalog catalog, IMarketplaceWebBrowser browser) {
        super((Catalog)catalog);
        this.browser = browser;
        this.setTitle(Messages.ImportFavoritesPage_Title);
        this.setDescription(Messages.ImportFavoritesPage_Description);
    }

    public void setDiscoveryError(final String error) {
        Shell shell = this.getShell();
        Control pageControl = this.getControl();
        if (shell != null && !shell.isDisposed() && pageControl != null && !pageControl.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Shell shell = ImportFavoritesPage.this.getShell();
                    Control pageControl = ImportFavoritesPage.this.getControl();
                    if (shell != null && !shell.isDisposed() && pageControl != null && !pageControl.isDisposed()) {
                        ImportFavoritesPage.this.setErrorMessage(error);
                    }
                }
            });
        }
    }

    public static String handleDiscoveryError(String favoritesReference, Exception ex) {
        String errorMessage = null;
        if (UserFavoritesService.isInvalidFavoritesListException((Throwable)ex)) {
            boolean isUrl;
            boolean bl = isUrl = favoritesReference != null && (favoritesReference.toLowerCase().startsWith("http:") || favoritesReference.toLowerCase().startsWith("https:"));
            errorMessage = isUrl ? NLS.bind((String)Messages.ImportFavoritesActionLink_noFavoritesFoundAtUrl, (Object)favoritesReference) : NLS.bind((String)Messages.ImportFavoritesActionLink_noFavoritesFoundForUser, (Object)favoritesReference);
        } else if (UserFavoritesService.isInvalidUrlException((Throwable)ex)) {
            errorMessage = NLS.bind((String)Messages.ImportFavoritesActionLink_invalidUrl, (Object)favoritesReference);
        } else {
            String message = null;
            IStatus statusCause = MarketplaceClientCore.computeWellknownProblemStatus((Throwable)ex);
            message = statusCause != null ? statusCause.getMessage() : (ex.getMessage() != null && !"".equals(ex.getMessage()) ? ex.getMessage() : ex.getClass().getSimpleName());
            errorMessage = NLS.bind((String)Messages.ImportFavoritesActionLink_errorLoadingFavorites, (Object)message);
            MarketplaceClientCore.error((String)NLS.bind((String)Messages.ImportFavoritesActionLink_errorLoadingFavorites, (Object)message), (Throwable)ex);
        }
        return errorMessage;
    }

    protected CatalogViewer doCreateViewer(Composite parent) {
        DiscoveryWizard wizard = this.getWizard();
        FavoritesViewer viewer = new FavoritesViewer(this.getCatalog(), this, this.browser, wizard.getConfiguration());
        viewer.setMinimumHeight(480);
        viewer.createControl(parent);
        return viewer;
    }

    public void performImport() {
        this.setErrorMessage(null);
        IStructuredSelection selection = this.getViewer().getSelection();
        List importFavorites = selection.toList();
        if (importFavorites.isEmpty()) {
            return;
        }
        final IUserFavoritesService userFavoritesService = this.findUserFavoritesService();
        if (userFavoritesService == null) {
            return;
        }
        final ArrayList<INode> importNodes = new ArrayList<INode>();
        for (MarketplaceNodeCatalogItem item : importFavorites) {
            importNodes.add(item.getData());
        }
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        userFavoritesService.getStorageService().runWithLogin((Callable)new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                try {
                                    userFavoritesService.addFavorites((Collection)importNodes, monitor);
                                }
                                catch (AbstractDataStorageService.NotAuthorizedException notAuthorizedException) {
                                    ImportFavoritesPage.this.setErrorMessage(Messages.ImportFavoritesPage_unauthorizedErrorMessage);
                                }
                                catch (ConflictException conflictException) {
                                    ImportFavoritesPage.this.setErrorMessage(Messages.ImportFavoritesPage_conflictErrorMessage);
                                }
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            MarketplaceClientCore.error((Throwable)cause);
            this.setErrorMessage(NLS.bind((String)Messages.ImportFavoritesPage_unknownErrorMessage, (Object)cause));
        }
        catch (InterruptedException interruptedException) {}
    }

    private IUserFavoritesService findUserFavoritesService() {
        IUserFavoritesService userFavoritesService = null;
        for (AbstractDiscoveryStrategy strategy : this.getCatalog().getDiscoveryStrategies()) {
            if (!(strategy instanceof FavoritesDiscoveryStrategy)) continue;
            FavoritesDiscoveryStrategy favoritesStrategy = (FavoritesDiscoveryStrategy)strategy;
            userFavoritesService = favoritesStrategy.getMarketplaceService().getUserFavoritesService();
        }
        return userFavoritesService;
    }
}

