/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NoHttpResponseException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCorePlugin;
import org.eclipse.epp.internal.mpc.core.service.ServiceUnavailableException;
import org.eclipse.epp.internal.mpc.core.util.ITransport;
import org.eclipse.epp.internal.mpc.core.util.Messages;
import org.eclipse.epp.mpc.core.service.ITransportFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransportFactory
implements ITransportFactory {
    public static final String LEGACY_TRANSPORT_KEY = "org.eclipse.epp.mpc.core.service.transport.legacy";
    public static final String LEGACY_TRANSPORT_COMPONENT_NAME = "org.eclipse.epp.mpc.core.transportfactory.legacy";
    private static final String[] factoryClasses = new String[]{"org.eclipse.epp.internal.mpc.core.util.P2TransportFactory", "org.eclipse.epp.internal.mpc.core.util.Eclipse36TransportFactory", "org.eclipse.epp.internal.mpc.core.util.JavaPlatformTransportFactory"};

    @Deprecated
    public static synchronized TransportFactory instance() {
        TransportFactory legacyTransportFactory = MarketplaceClientCorePlugin.getDefault().getServiceHelper().getLegacyTransportFactory();
        if (legacyTransportFactory == null) {
            throw new IllegalStateException();
        }
        return legacyTransportFactory;
    }

    public static org.eclipse.epp.mpc.core.service.ITransport createTransport() {
        ITransportFactory transportService;
        BundleContext context = MarketplaceClientCorePlugin.getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(ITransportFactory.class);
        if (serviceReference != null && (transportService = (ITransportFactory)context.getService(serviceReference)) != null) {
            try {
                org.eclipse.epp.mpc.core.service.ITransport iTransport = transportService.getTransport();
                return iTransport;
            }
            finally {
                context.ungetService(serviceReference);
            }
        }
        throw new IllegalStateException();
    }

    public static List<ITransportFactory> listAvailableFactories() {
        ArrayList<ITransportFactory> factories = new ArrayList<ITransportFactory>();
        String[] stringArray = factoryClasses;
        int n = factoryClasses.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                TransportFactory factory;
                String factoryClass = stringArray[n2];
                try {
                    factory = (TransportFactory)Class.forName(factoryClass, true, TransportFactory.class.getClassLoader()).newInstance();
                }
                catch (Throwable throwable) {
                    break block6;
                }
                try {
                    if (factory.isAvailable()) {
                        factories.add(factory);
                    }
                }
                catch (Throwable t) {
                    MarketplaceClientCore.getLog().log((IStatus)new Status(2, "org.eclipse.epp.mpc.core", Messages.TransportFactory_transportAvailabilityError, t));
                }
            }
            ++n2;
        }
        return factories;
    }

    @Override
    public ITransport getTransport() {
        return new ITransport(){

            public InputStream stream(URI location, IProgressMonitor monitor) throws FileNotFoundException, org.eclipse.epp.mpc.core.service.ServiceUnavailableException, CoreException {
                try {
                    return TransportFactory.this.invokeStream(location, monitor);
                }
                catch (Exception e) {
                    TransportFactory.this.handleStreamExceptions(e);
                    return null;
                }
            }
        };
    }

    protected abstract boolean isAvailable();

    protected abstract InputStream invokeStream(URI var1, IProgressMonitor var2) throws Exception;

    protected void handleStreamExceptions(Exception e) throws ServiceUnavailableException, CoreException, FileNotFoundException {
        if (e instanceof InvocationTargetException) {
            InvocationTargetException targetException = (InvocationTargetException)e;
            Throwable cause = targetException.getCause();
            if (cause instanceof CoreException) {
                CoreException coreCause = (CoreException)cause;
                TransportFactory.handleServiceUnavailable(coreCause);
                throw coreCause;
            }
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.epp.mpc.core", e.getMessage(), (Throwable)e));
        }
    }

    protected static void handleServiceUnavailable(CoreException e) throws ServiceUnavailableException {
        Throwable cause;
        if (e.getStatus().getCode() == 1002 && (cause = e.getCause()) != null && (cause instanceof NoHttpResponseException || cause.getMessage() != null && cause.getMessage().indexOf("503") != -1)) {
            throw new ServiceUnavailableException((IStatus)new Status(4, "org.eclipse.epp.mpc.core", 503, Messages.DefaultMarketplaceService_serviceUnavailable503, (Throwable)e));
        }
    }

    public static final class LegacyFactory
    implements ITransportFactory {
        private ITransportFactory delegate;
        private ServiceReference<ITransportFactory> delegateReference;

        public ITransportFactory getDelegate() {
            return this.delegate;
        }

        public org.eclipse.epp.mpc.core.service.ITransport getTransport() {
            return this.delegate.getTransport();
        }

        public void activate(ComponentContext context) throws InvalidSyntaxException {
            List<ITransportFactory> availableFactories;
            BundleContext bundleContext = context.getBundleContext();
            Collection serviceReferences = bundleContext.getServiceReferences(ITransportFactory.class, "(&(org.eclipse.epp.mpc.core.service.transport.legacy=true)(!(component.name=org.eclipse.epp.mpc.core.transportfactory.legacy)))");
            if (!serviceReferences.isEmpty()) {
                for (ServiceReference serviceReference : serviceReferences) {
                    ITransportFactory service = (ITransportFactory)bundleContext.getService(serviceReference);
                    if (service instanceof TransportFactory) {
                        this.delegate = service;
                        this.delegateReference = serviceReference;
                        return;
                    }
                    bundleContext.ungetService(serviceReference);
                }
            }
            if ((availableFactories = TransportFactory.listAvailableFactories()).isEmpty()) {
                context.disableComponent(TransportFactory.LEGACY_TRANSPORT_COMPONENT_NAME);
                throw new IllegalStateException(Messages.TransportFactory_NoLegacyTransportFactoriesError);
            }
            this.delegate = availableFactories.get(0);
            this.delegateReference = null;
        }

        public void deactivate(ComponentContext context) {
            this.delegate = null;
            if (this.delegateReference != null) {
                context.getBundleContext().ungetService(this.delegateReference);
                this.delegateReference = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LegacyTransportFactoryTracker
    extends ServiceTracker<ITransportFactory, TransportFactory> {
        public LegacyTransportFactoryTracker(BundleContext context) {
            super(context, ITransportFactory.class, (ServiceTrackerCustomizer)new LegacyTransportFactoryTrackerCustomizer(context));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LegacyTransportFactoryTrackerCustomizer
    implements ServiceTrackerCustomizer<ITransportFactory, TransportFactory> {
        private final BundleContext context;
        private final Map<ServiceReference<ITransportFactory>, TransportFactory> trackedServices = new HashMap<ServiceReference<ITransportFactory>, TransportFactory>();

        private LegacyTransportFactoryTrackerCustomizer(BundleContext context) {
            this.context = context;
        }

        public TransportFactory addingService(ServiceReference<ITransportFactory> reference) {
            TransportFactory transportFactory;
            Object legacyProperty = reference.getProperty(TransportFactory.LEGACY_TRANSPORT_KEY);
            if (!Boolean.parseBoolean(String.valueOf(legacyProperty))) {
                return null;
            }
            ITransportFactory service = (ITransportFactory)this.context.getService(reference);
            if (service instanceof LegacyFactory) {
                LegacyFactory legacyFactory = (LegacyFactory)service;
                service = legacyFactory.getDelegate();
            }
            if (service instanceof TransportFactory && !this.trackedServices.containsValue(transportFactory = (TransportFactory)service)) {
                this.trackedServices.put(reference, transportFactory);
                return transportFactory;
            }
            return null;
        }

        public void modifiedService(ServiceReference<ITransportFactory> reference, TransportFactory service) {
        }

        public void removedService(ServiceReference<ITransportFactory> reference, TransportFactory service) {
            this.trackedServices.remove(reference);
        }
    }
}

