/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.epp.internal.mpc.core.ServiceHelperImpl;
import org.eclipse.epp.internal.mpc.core.util.DebugTraceUtil;
import org.eclipse.epp.internal.mpc.core.util.ProxyHelper;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.epp.mpc.core.service.ITransportFactory;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class MarketplaceClientCorePlugin
implements BundleActivator {
    public static final String DEBUG_OPTION = "/debug";
    public static final String DEBUG_FAKE_CLIENT_OPTION = "/client/fakeVersion";
    public static final String DEBUG_CLIENT_OPTIONS_PATH = "org.eclipse.epp.mpc.core/client/";
    public static final String DEBUG_CLIENT_REMOVE_OPTION = "xxx";
    public static boolean DEBUG = false;
    public static boolean DEBUG_FAKE_CLIENT = false;
    private static DebugTrace debugTrace;
    private static MarketplaceClientCorePlugin instance;
    private Bundle bundle;
    private List<ServiceRegistration<?>> serviceRegistrations;
    private ServiceHelperImpl serviceHelper;

    public void start(BundleContext context) throws Exception {
        this.bundle = context.getBundle();
        instance = this;
        ProxyHelper.acquireProxyService();
        this.registerServices(context);
        this.serviceHelper = new ServiceHelperImpl();
        this.serviceHelper.startTracking(context);
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", "org.eclipse.epp.mpc.core");
        context.registerService(DebugOptionsListener.class.getName(), (Object)new DebugOptionsListener(){

            public void optionsChanged(DebugOptions options) {
                DebugTrace debugTrace = null;
                boolean debug = options.getBooleanOption("org.eclipse.epp.mpc.core/debug", false);
                boolean fakeClient = false;
                if (debug) {
                    debugTrace = options.newDebugTrace("org.eclipse.epp.mpc.core");
                    fakeClient = options.getBooleanOption("org.eclipse.epp.mpc.core/client/fakeVersion", false);
                }
                DEBUG = debug;
                DEBUG_FAKE_CLIENT = fakeClient;
                MarketplaceClientCorePlugin.debugTrace = debugTrace;
            }
        }, props);
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceHelper.stopTracking(context);
        this.serviceHelper = null;
        this.unregisterServices();
        ProxyHelper.releaseProxyService();
        debugTrace = null;
        instance = null;
    }

    private void registerServices(BundleContext context) throws InvalidSyntaxException {
        int step;
        int maxLegacyPriority;
        ArrayList serviceRegistrations = new ArrayList();
        this.serviceRegistrations = serviceRegistrations;
        List<ITransportFactory> factories = TransportFactory.listAvailableFactories();
        if (factories.isEmpty()) {
            return;
        }
        Collection serviceReferences = context.getServiceReferences(ITransportFactory.class, null);
        int lowestPriority = Integer.MAX_VALUE;
        for (ServiceReference serviceReference : serviceReferences) {
            Object legacyProperty = serviceReference.getProperty("org.eclipse.epp.mpc.core.service.transport.legacy");
            if (legacyProperty != null) continue;
            Integer ranking = (Integer)serviceReference.getProperty("service.ranking");
            lowestPriority = Math.min(lowestPriority, ranking == null ? 0 : ranking);
        }
        if (lowestPriority >= 0) {
            maxLegacyPriority = -100;
            step = 100;
        } else {
            int available = lowestPriority - Integer.MIN_VALUE;
            step = Math.min(100, available / factories.size());
            if (step == 0) {
                step = 1;
                maxLegacyPriority = Integer.MIN_VALUE + factories.size();
            } else {
                maxLegacyPriority = lowestPriority - step;
            }
        }
        int prio = maxLegacyPriority;
        for (ITransportFactory factory : factories) {
            Hashtable<String, Constable> properties = new Hashtable<String, Constable>();
            properties.put("service.ranking", Integer.valueOf(prio));
            properties.put("org.eclipse.epp.mpc.core.service.transport.legacy", Boolean.valueOf(true));
            ServiceRegistration registration = context.registerService(ITransportFactory.class, (Object)factory, properties);
            serviceRegistrations.add(registration);
            prio -= step;
        }
    }

    private void unregisterServices() {
        List<ServiceRegistration<?>> serviceRegistrations = this.serviceRegistrations;
        this.serviceRegistrations = null;
        if (serviceRegistrations != null) {
            for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }
    }

    public ServiceHelperImpl getServiceHelper() {
        return this.serviceHelper;
    }

    public static MarketplaceClientCorePlugin getDefault() {
        return instance;
    }

    public static Bundle getBundle() {
        return instance == null ? null : MarketplaceClientCorePlugin.instance.bundle;
    }

    public static void trace(String option, String message) {
        DebugTrace trace = debugTrace;
        if (DEBUG && trace != null) {
            trace.trace(option, message);
        }
    }

    public static void trace(String option, String message, Object ... parameters) {
        DebugTrace trace = debugTrace;
        if (DEBUG && trace != null) {
            DebugTraceUtil.trace(trace, option, message, parameters);
        }
    }

    static /* synthetic */ DebugTrace access$0() {
        return debugTrace;
    }
}

