/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.epp.internal.mpc.ui.wizards.FeatureSelectionWizardPage;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDropAdapter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class MarketplaceWizardDialog
extends WizardDialog {
    private Button backButton;
    private Button nextButton;

    public MarketplaceWizardDialog(Shell parentShell, MarketplaceWizard newWizard) {
        super(null, (IWizard)newWizard);
        int shellStyle = this.getShellStyle();
        int allModal = 229376;
        shellStyle &= ~allModal;
        this.setShellStyle(shellStyle |= 0);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setData((Object)this);
        new MarketplaceDropAdapter().installDropTarget(newShell);
        final IWorkbenchListener workbenchListener = new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                Shell wizardShell = MarketplaceWizardDialog.this.getShell();
                if (wizardShell != null && !wizardShell.isDisposed()) {
                    if (forced) {
                        wizardShell.close();
                    } else {
                        boolean closed = MarketplaceWizardDialog.this.close();
                        return closed;
                    }
                }
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        };
        PlatformUI.getWorkbench().addWorkbenchListener(workbenchListener);
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PlatformUI.getWorkbench().removeWorkbenchListener(workbenchListener);
            }
        });
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        switch (id) {
            case 15: {
                this.nextButton = button;
                break;
            }
            case 14: {
                this.backButton = button;
            }
        }
        return button;
    }

    protected void backPressed() {
        IWizardPage fromPage = this.getCurrentPage();
        super.backPressed();
        if (fromPage instanceof FeatureSelectionWizardPage && ((FeatureSelectionWizardPage)fromPage).isInRemediationMode()) {
            ((FeatureSelectionWizardPage)fromPage).flipToDefaultComposite();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        AccessibleAdapter adapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Button button = (Button)((Accessible)e.getSource()).getControl();
                String text = button.getText();
                e.result = text.replace('<', ' ').replace('>', ' ');
            }
        };
        this.backButton.getAccessible().addAccessibleListener((AccessibleListener)adapter);
        this.nextButton.getAccessible().addAccessibleListener((AccessibleListener)adapter);
    }

    public MarketplaceWizard getWizard() {
        return (MarketplaceWizard)super.getWizard();
    }

    public void updateButtons() {
        super.updateButtons();
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage != null) {
            String backButtonLabel;
            boolean buttonsChanged = false;
            String nextButtonLabel = this.getNextButtonLabel(currentPage);
            if (!nextButtonLabel.equals(this.nextButton.getText())) {
                this.nextButton.setText(nextButtonLabel);
                this.setButtonLayoutData(this.nextButton);
                buttonsChanged = true;
            }
            if (!(backButtonLabel = this.getBackButtonLabel(currentPage)).equals(this.backButton.getText())) {
                this.backButton.setText(backButtonLabel);
                this.setButtonLayoutData(this.backButton);
                buttonsChanged = true;
            }
            if (buttonsChanged) {
                Composite buttonBar = this.backButton.getParent();
                buttonBar.layout(true);
            }
        }
    }

    public String getNextButtonLabel(IWizardPage page) {
        if (page == this.getWizard().getCatalogPage()) {
            return Messages.MarketplaceWizardDialog_Install_Now;
        }
        if (page == this.getWizard().getFeatureSelectionWizardPage()) {
            return Messages.MarketplaceWizardDialog_Confirm;
        }
        return IDialogConstants.NEXT_LABEL;
    }

    public String getBackButtonLabel(IWizardPage page) {
        if (page == this.getWizard().getFeatureSelectionWizardPage()) {
            return Messages.MarketplaceWizardDialog_Install_More;
        }
        return IDialogConstants.BACK_LABEL;
    }
}

