/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import org.eclipse.epp.internal.mpc.core.util.TextUtil;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalogSource;
import org.eclipse.epp.internal.mpc.ui.util.Util;
import org.eclipse.epp.internal.mpc.ui.wizards.DropDownButton;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.ItemButtonController;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDiscoveryResources;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.internal.mpc.ui.wizards.OverviewToolTip;
import org.eclipse.epp.internal.mpc.ui.wizards.RatingTooltip;
import org.eclipse.epp.internal.mpc.ui.wizards.ShareSolutionLink;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.model.ITag;
import org.eclipse.epp.mpc.core.model.ITags;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.AbstractDiscoveryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryItem<T extends CatalogItem>
extends AbstractDiscoveryItem<T>
implements PropertyChangeListener {
    private static final String MARKETPLACE_LOGIN_URL = "https://marketplace.eclipse.org/login/sso?redirect=node/{0}";
    private static final String ECLIPSE_MARKETPLACE_URL = "http://marketplace.eclipse.org/";
    private static final String INFO_HREF = "info";
    private static final String PROVIDER_PLACEHOLDER = "@PROVIDER@";
    private static final int DESCRIPTION_MARGIN_LEFT = 8;
    private static final int DESCRIPTION_MARGIN_TOP = 8;
    private static final int TAGS_MARGIN_TOP = 2;
    private static final int BUTTONBAR_MARGIN_TOP = 8;
    private static final int SEPARATOR_MARGIN_TOP = 8;
    private static final int MAX_IMAGE_HEIGHT = 86;
    private static final int MIN_IMAGE_HEIGHT = 64;
    private static final int MAX_IMAGE_WIDTH = 75;
    public static final String WIDGET_ID_KEY = String.valueOf(DiscoveryItem.class.getName()) + "::part";
    public static final String WIDGET_ID_NAME = "name";
    public static final String WIDGET_ID_DESCRIPTION = "description";
    public static final String WIDGET_ID_ICON = "description";
    public static final String WIDGET_ID_PROVIDER = "provider";
    public static final String WIDGET_ID_INSTALLS = "installs";
    public static final String WIDGET_ID_TAGS = "tags";
    public static final String WIDGET_ID_RATING = "rating";
    public static final String WIDGET_ID_SHARE = "share";
    public static final String WIDGET_ID_LEARNMORE = "learn more";
    public static final String WIDGET_ID_OVERVIEW = "overview";
    public static final String WIDGET_ID_ALREADY_INSTALLED = "already installed";
    public static final String WIDGET_ID_ACTION = "action";
    private Composite checkboxContainer;
    private final CatalogItem connector;
    private StyledText description;
    private Label iconLabel;
    private Label nameLabel;
    private final MarketplaceViewer viewer;
    private ItemButtonController buttonController;
    private StyledText installInfoLink;
    private final IMarketplaceWebBrowser browser;
    private StyledText tagsLink;
    private static Boolean browserAvailable;
    private ShareSolutionLink shareSolutionLink;

    public DiscoveryItem(Composite parent, int style, MarketplaceDiscoveryResources resources, IMarketplaceWebBrowser browser, T connector, MarketplaceViewer viewer) {
        super(parent, style, (DiscoveryResources)resources, connector);
        this.browser = browser;
        this.connector = connector;
        this.viewer = viewer;
        connector.addPropertyChangeListener((PropertyChangeListener)this);
        this.addDisposeListener(new DisposeListener((CatalogItem)connector){
            private final /* synthetic */ CatalogItem val$connector;
            {
                this.val$connector = catalogItem;
            }

            public void widgetDisposed(DisposeEvent e) {
                this.val$connector.removePropertyChangeListener((PropertyChangeListener)DiscoveryItem.this);
            }
        });
        this.createContent();
    }

    private void createContent() {
        GridLayoutFactory.swtDefaults().numColumns(4).equalWidth(false).extendedMargins(0, 0, 2, 0).spacing(0, 0).applyTo((Composite)this);
        new Label((Composite)this, 0).setText(" ");
        this.createNameLabel((Composite)this);
        this.createIconControl((Composite)this);
        this.createDescription((Composite)this);
        this.createProviderLabel((Composite)this);
        this.createTagsLabel((Composite)this);
        this.createSocialButtons((Composite)this);
        this.createInstallInfo((Composite)this);
        this.createInstallButtons((Composite)this);
        Label separator = new Label((Composite)this, 258);
        GridDataFactory.fillDefaults().indent(0, 8).grab(true, false).span(4, 1).align(4, 1).applyTo((Control)separator);
    }

    static void setWidgetId(Widget widget, String id) {
        widget.setData(WIDGET_ID_KEY, (Object)id);
    }

    private void createDescription(Composite parent) {
        this.description = this.createStyledTextLabel(parent);
        DiscoveryItem.setWidgetId((Widget)this.description, "description");
        GridDataFactory.fillDefaults().grab(true, false).indent(8, 8).span(3, 1).hint(100, -1).applyTo((Control)this.description);
        String descriptionText = this.connector.getDescription();
        int maxDescriptionLength = 162;
        descriptionText = descriptionText == null ? "" : TextUtil.stripHtmlMarkup((String)descriptionText).trim();
        if (descriptionText.length() > maxDescriptionLength) {
            int truncationIndex;
            int x = truncationIndex = maxDescriptionLength;
            while (x > 0) {
                if (Character.isWhitespace(descriptionText.charAt(x))) {
                    truncationIndex = x;
                    break;
                }
                --x;
            }
            descriptionText = String.valueOf(descriptionText.substring(0, truncationIndex)) + Messages.DiscoveryItem_truncatedTextSuffix;
        }
        descriptionText = descriptionText.replaceAll("(\\r\\n)|\\n|\\r|\\s{2,}", " ");
        this.description.setText(String.valueOf(descriptionText) + "  ");
        if (descriptionText.startsWith(Messages.DiscoveryItem_Promotion_Marker)) {
            this.description.replaceTextRange(0, Messages.DiscoveryItem_Promotion_Marker.length(), String.valueOf(Messages.DiscoveryItem_Promotion_Display) + "  - ");
            StyleRange style = new StyleRange(0, Messages.DiscoveryItem_Promotion_Display.length(), null, null, 3);
            this.description.setStyleRange(style);
        }
        this.createInfoLink(this.description);
    }

    private StyledText createStyledTextLabel(Composite parent) {
        StyledText styledText = new StyledText(parent, 74);
        styledText.setEditable(false);
        styledText.setCursor(this.getDisplay().getSystemCursor(0));
        styledText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((StyledText)e.widget).getParent().setFocus();
            }
        });
        return styledText;
    }

    private void createNameLabel(Composite parent) {
        this.nameLabel = new Label(parent, 64);
        DiscoveryItem.setWidgetId((Widget)this.nameLabel, WIDGET_ID_NAME);
        GridDataFactory.fillDefaults().indent(8, 0).span(3, 1).grab(true, false).align(1, 0x1000000).applyTo((Control)this.nameLabel);
        this.nameLabel.setFont(this.resources.getSmallHeaderFont());
        this.nameLabel.setText(TextUtil.escapeText((String)this.connector.getName()));
    }

    private void createInstallButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().indent(0, 8).align(131072, 4).applyTo((Control)composite);
        int numColumns = 1;
        boolean installed = this.connector.isInstalled();
        if (installed && this.viewer.getContentType() != MarketplaceViewer.ContentType.INSTALLED && this.viewer.getContentType() != MarketplaceViewer.ContentType.SELECTION) {
            Button alreadyInstalledButton = new Button(composite, 9);
            DiscoveryItem.setWidgetId((Widget)alreadyInstalledButton, WIDGET_ID_ALREADY_INSTALLED);
            alreadyInstalledButton.setText(Messages.DiscoveryItem_AlreadyInstalled);
            alreadyInstalledButton.setFont(JFaceResources.getFontRegistry().getItalic(""));
            Point preferredSize = alreadyInstalledButton.computeSize(-1, -1);
            int preferredWidth = preferredSize.x + 10;
            GridDataFactory.swtDefaults().align(131072, 0x1000000).minSize(preferredWidth, -1).hint(preferredWidth, -1).grab(false, true).applyTo((Control)alreadyInstalledButton);
            alreadyInstalledButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DiscoveryItem.this.viewer.setContentType(MarketplaceViewer.ContentType.INSTALLED);
                    DiscoveryItem.this.viewer.reveal(DiscoveryItem.this);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        } else if (this.hasInstallMetadata()) {
            DropDownButton dropDown = new DropDownButton(composite, 8);
            Button button = dropDown.getButton();
            DiscoveryItem.setWidgetId((Widget)button, WIDGET_ID_ACTION);
            Point preferredSize = button.computeSize(-1, -1);
            int preferredWidth = preferredSize.x + 10;
            GridDataFactory.swtDefaults().align(131072, 0x1000000).minSize(preferredWidth, -1).grab(false, true).applyTo((Control)button);
            this.buttonController = new ItemButtonController(this.viewer, this, dropDown);
        } else {
            this.installInfoLink = this.createStyledTextLabel(composite);
            DiscoveryItem.setWidgetId((Widget)this.installInfoLink, WIDGET_ID_LEARNMORE);
            this.installInfoLink.setToolTipText(Messages.DiscoveryItem_installInstructionsTooltip);
            StyleRange link = this.appendLink(this.installInfoLink, Messages.DiscoveryItem_installInstructions, 1);
            link.data = Messages.DiscoveryItem_installInstructions;
            this.hookLinkListener(this.installInfoLink, new LinkListener(){

                @Override
                protected void selected(String href) {
                    DiscoveryItem.this.browser.openUrl(((INode)DiscoveryItem.this.connector.getData()).getUrl());
                }
            });
            GridDataFactory.swtDefaults().align(131072, 0x1000000).grab(false, true).applyTo((Control)this.installInfoLink);
        }
        GridLayoutFactory.fillDefaults().numColumns(numColumns).margins(0, 0).extendedMargins(0, 5, 0, 0).spacing(5, 0).applyTo(composite);
    }

    private void createInstallInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().indent(8, 8).grab(true, false).align(1, 0x1000000).applyTo((Control)composite);
        RowLayoutFactory.fillDefaults().type(256).pack(true).applyTo(composite);
        Integer installsTotal = null;
        Integer installsRecent = null;
        if (this.connector.getData() instanceof INode) {
            INode node = (INode)this.connector.getData();
            installsTotal = node.getInstallsTotal();
            installsRecent = node.getInstallsRecent();
        }
        if (installsTotal != null || installsRecent != null) {
            StyledText installInfo = new StyledText(composite, 12);
            DiscoveryItem.setWidgetId((Widget)installInfo, WIDGET_ID_INSTALLS);
            String totalText = installsTotal == null ? Messages.DiscoveryItem_Unknown_Installs : MessageFormat.format(Messages.DiscoveryItem_Compact_Number, (int)installsTotal, (double)installsTotal.intValue() * 0.001, (double)installsTotal.intValue() * 1.0E-6);
            String recentText = installsRecent == null ? Messages.DiscoveryItem_Unknown_Installs : MessageFormat.format("{0, number}", (int)installsRecent);
            String installInfoText = NLS.bind((String)Messages.DiscoveryItem_Installs, (Object)totalText, (Object)recentText);
            int formatTotalsStart = installInfoText.indexOf(totalText);
            if (formatTotalsStart == -1) {
                installInfo.append(installInfoText);
            } else {
                if (formatTotalsStart > 0) {
                    installInfo.append(installInfoText.substring(0, formatTotalsStart));
                }
                this.appendStyled(installInfo, totalText, new StyleRange(0, 0, null, null, 1));
                installInfo.append(installInfoText.substring(formatTotalsStart + totalText.length()));
            }
        } else if (this.shareSolutionLink != null) {
            this.shareSolutionLink.setShowText(true);
        }
    }

    private void createSocialButtons(Composite parent) {
        Label spacer;
        Integer favorited = null;
        if (this.connector.getData() instanceof INode) {
            INode node = (INode)this.connector.getData();
            favorited = node.getFavorited();
        }
        if (favorited == null || this.getCatalogItemUrl() == null) {
            spacer = new Label((Composite)this, 0);
            spacer.setText(" ");
            GridDataFactory.fillDefaults().indent(0, 8).align(0x1000000, 4).applyTo((Control)spacer);
        } else {
            this.createRatingsButton(parent, favorited);
        }
        if (this.getCatalogItemUrl() != null) {
            this.shareSolutionLink = new ShareSolutionLink(parent, this.connector);
            Control shareControl = this.shareSolutionLink.getControl();
            GridDataFactory.fillDefaults().indent(8, 8).align(1, 4).applyTo(shareControl);
        } else {
            spacer = new Label((Composite)this, 0);
            spacer.setText(" ");
            GridDataFactory.fillDefaults().indent(0, 8).align(0x1000000, 4).applyTo((Control)spacer);
        }
    }

    private void createRatingsButton(Composite parent, Integer favoritedCount) {
        Button ratingsButton = new Button(parent, 8);
        ratingsButton.setImage(MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("ITEM_ICON_STAR"));
        DiscoveryItem.setWidgetId((Widget)ratingsButton, WIDGET_ID_RATING);
        int width = -1;
        ratingsButton.setText("999");
        Point pSize = ratingsButton.computeSize(-1, -1, true);
        width = pSize.x;
        ratingsButton.setText(favoritedCount.toString());
        pSize = ratingsButton.computeSize(-1, -1, true);
        width = Math.max(width, pSize.x);
        final String ratingDescription = NLS.bind((String)Messages.DiscoveryItem_Favorited_Times, (Object)ratingsButton.getText());
        ratingsButton.setToolTipText(ratingDescription);
        ratingsButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ratingDescription;
            }
        });
        final RatingTooltip ratingTooltip = RatingTooltip.shouldShowRatingTooltip() ? new RatingTooltip((Control)ratingsButton, new Runnable(){

            public void run() {
                DiscoveryItem.this.openSolutionFavorite();
            }
        }) : null;
        this.hookTooltip(ratingTooltip, (Widget)ratingsButton, (Control)ratingsButton);
        ratingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ratingTooltip != null && RatingTooltip.shouldShowRatingTooltip()) {
                    ratingTooltip.show();
                } else {
                    DiscoveryItem.this.openSolutionFavorite();
                }
            }
        });
        GridDataFactory.fillDefaults().indent(0, 8).hint(Math.min(width, 75), -1).align(0x1000000, 4).applyTo((Control)ratingsButton);
    }

    protected void openSolutionFavorite() {
        String url = this.getCatalogItemUrl();
        if (url == null) {
            MarketplaceClientUi.error(NLS.bind((String)Messages.DiscoveryItem_missingNodeUrl, (Object)this.connector.getId(), (Object)this.connector.getName()), new IllegalStateException());
            return;
        }
        if (url.startsWith(ECLIPSE_MARKETPLACE_URL)) {
            url = NLS.bind((String)MARKETPLACE_LOGIN_URL, (Object)this.connector.getId());
        }
        WorkbenchUtil.openUrl((String)url, (int)128);
    }

    private String getCatalogItemUrl() {
        Object data = this.connector.getData();
        if (data instanceof INode) {
            INode node = (INode)data;
            return node.getUrl();
        }
        return null;
    }

    private void createInfoLink(StyledText description) {
        boolean internalBrowserAvailable = this.computeBrowserAvailable((Composite)description);
        if (internalBrowserAvailable && (this.hasTooltip(this.connector) || this.connector.isInstalled())) {
            if (this.hasTooltip(this.connector)) {
                String descriptionLink = Messages.DiscoveryItem_More_Info;
                StyleRange linkRange = this.appendLink(description, descriptionLink, 1);
                linkRange.data = INFO_HREF;
                this.hookTooltip((Control)description.getParent(), (Widget)description, (Control)description, (Control)description, this.connector.getSource(), this.connector.getOverview(), null);
            }
        } else if (!internalBrowserAvailable && this.hasOverviewUrl(this.connector)) {
            String descriptionLink = Messages.DiscoveryItem_More_Info;
            StyleRange linkRange = this.appendLink(description, descriptionLink, 1);
            linkRange.data = INFO_HREF;
            this.hookLinkListener(description, new LinkListener(){

                @Override
                protected void selected(String href) {
                    if (DiscoveryItem.INFO_HREF.equals(href)) {
                        WorkbenchUtil.openUrl((String)DiscoveryItem.this.connector.getOverview().getUrl().trim(), (int)128);
                    }
                }
            });
        }
    }

    private void createIconControl(Composite parent) {
        this.checkboxContainer = new Composite(parent, 0);
        GridDataFactory.swtDefaults().indent(0, 8).align(0x1000000, 1).hint(75, -1).grab(false, true).minSize(75, 64).span(1, 3).applyTo((Control)this.checkboxContainer);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(this.checkboxContainer);
        this.iconLabel = new Label(this.checkboxContainer, 0);
        DiscoveryItem.setWidgetId((Widget)this.iconLabel, "description");
        GridDataFactory.swtDefaults().align(0x1000000, 1).grab(true, true).applyTo((Control)this.iconLabel);
        if (this.connector.getIcon() != null) {
            this.provideIconImage(this.iconLabel, this.connector.getSource(), this.connector.getIcon(), 64, true);
        } else {
            this.iconLabel.setImage(MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("NO_ICON_PROVIDED"));
        }
    }

    private void provideIconImage(final Label iconLabel, AbstractCatalogSource source, Icon icon, int size, boolean fallback) {
        String iconPath = this.getResources().getIconPath(icon, size, fallback);
        this.getResources().setImage(new MarketplaceDiscoveryResources.ImageReceiver(){

            public void setImage(Image image) {
                if (image.isDisposed() || iconLabel.isDisposed()) {
                    return;
                }
                try {
                    Rectangle bounds = image.getBounds();
                    if ((double)bounds.width < 60.0 || bounds.width > 75 || bounds.height > 86) {
                        Image scaledImage;
                        image = scaledImage = Util.scaleImage(image, 75, 86);
                        iconLabel.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                scaledImage.dispose();
                            }
                        });
                    }
                    iconLabel.setImage(image);
                }
                catch (SWTException sWTException) {}
            }
        }, source, iconPath, MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("NO_ICON_PROVIDED"));
    }

    public MarketplaceDiscoveryResources getResources() {
        return (MarketplaceDiscoveryResources)this.resources;
    }

    private StyleRange appendLink(StyledText styledText, String text, int style) {
        StyleRange range = new StyleRange(0, 0, styledText.getForeground(), null, style);
        range.underline = true;
        range.underlineStyle = 4;
        this.appendStyled(styledText, text, range);
        return range;
    }

    private void appendStyled(StyledText styledText, String text, StyleRange style) {
        style.start = styledText.getCharCount();
        style.length = text.length();
        styledText.append(text);
        styledText.setStyleRange(style);
    }

    private boolean hasOverviewUrl(CatalogItem connector) {
        return connector.getOverview() != null && connector.getOverview().getUrl() != null && connector.getOverview().getUrl().trim().length() > 0;
    }

    private synchronized boolean computeBrowserAvailable(Composite composite) {
        if (browserAvailable == null) {
            try {
                Browser browser = new Browser(composite, 0);
                browser.dispose();
                browserAvailable = true;
            }
            catch (SWTError sWTError) {
                browserAvailable = false;
            }
        }
        return browserAvailable;
    }

    private boolean hasInstallMetadata() {
        if (!this.connector.getInstallableUnits().isEmpty() && this.connector.getSiteUrl() != null) {
            try {
                URLUtil.toURI((String)this.connector.getSiteUrl());
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    protected void createProviderLabel(Composite parent) {
        StyledText providerLink = this.createStyledTextLabel(parent);
        DiscoveryItem.setWidgetId((Widget)providerLink, WIDGET_ID_PROVIDER);
        providerLink.setEditable(false);
        GridDataFactory.fillDefaults().indent(8, 8).span(3, 1).align(1, 0x1000000).grab(true, false).applyTo((Control)providerLink);
        providerLink.setForeground(this.resources.getColorDisabled());
        providerLink.setText(NLS.bind((String)Messages.DiscoveryItem_byProviderLicense, (Object)PROVIDER_PLACEHOLDER, (Object)this.connector.getLicense()));
        int providerPos = providerLink.getText().indexOf(PROVIDER_PLACEHOLDER);
        if (providerPos != -1) {
            String providerName = this.connector.getProvider();
            StyleRange range = new StyleRange(0, 0, providerLink.getForeground(), null, 0);
            if (providerName == null) {
                providerName = Messages.DiscoveryItem_UnknownProvider;
                range.fontStyle |= 2;
            } else {
                range.underline = true;
                range.underlineStyle = 4;
                this.hookLinkListener(providerLink, new LinkListener(){

                    @Override
                    protected void selected(String href) {
                        String searchTerm = href;
                        if (searchTerm.contains(" ")) {
                            searchTerm = "\"" + searchTerm + "\"";
                        }
                        DiscoveryItem.this.viewer.search(searchTerm);
                    }
                });
            }
            range.start = providerPos;
            range.length = providerName.length();
            range.data = providerName;
            providerLink.replaceTextRange(providerPos, PROVIDER_PLACEHOLDER.length(), providerName);
            providerLink.replaceStyleRanges(providerPos, range.length, new StyleRange[]{range});
        }
    }

    protected void createTagsLabel(Composite parent) {
        this.tagsLink = this.createStyledTextLabel(parent);
        DiscoveryItem.setWidgetId((Widget)this.tagsLink, WIDGET_ID_TAGS);
        this.tagsLink.setEditable(false);
        GridDataFactory.fillDefaults().indent(8, 2).span(3, 1).align(1, 1).grab(true, false).applyTo((Control)this.tagsLink);
        ITags tags = ((INode)this.connector.getData()).getTags();
        if (tags == null) {
            return;
        }
        for (ITag tag : tags.getTags()) {
            String tagName = tag.getName();
            this.appendLink((StyledText)this.tagsLink, (String)tagName, (int)0).data = tagName;
            this.tagsLink.append(" ");
        }
        this.hookLinkListener(this.tagsLink, new LinkListener(){

            @Override
            protected void selected(String href) {
                DiscoveryItem.this.viewer.doQueryForTag(href);
            }
        });
    }

    private void hookLinkListener(StyledText link, LinkListener listener) {
        link.addSelectionListener((SelectionListener)listener);
        link.addMouseListener((MouseListener)listener);
    }

    protected boolean hasTooltip(CatalogItem connector) {
        return connector.getOverview() != null && connector.getOverview().getSummary() != null && connector.getOverview().getSummary().length() > 0;
    }

    @Deprecated
    protected boolean maybeModifySelection(Operation operation) {
        return this.maybeModifySelection(operation.getOperation());
    }

    protected boolean maybeModifySelection(org.eclipse.epp.mpc.ui.Operation operation) {
        this.viewer.modifySelection(this.connector, operation);
        return true;
    }

    public boolean isSelected() {
        return ((CatalogItem)this.getData()).isSelected();
    }

    @Deprecated
    public Operation getOperation() {
        return Operation.map(this.getSelectedOperation());
    }

    public org.eclipse.epp.mpc.ui.Operation getSelectedOperation() {
        return this.viewer.getSelectionModel().getSelectedOperation((CatalogItem)this.getData());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!DiscoveryItem.this.isDisposed()) {
                        DiscoveryItem.this.refresh(true);
                    }
                }
            });
        }
    }

    protected void refresh() {
        this.refresh(false);
    }

    protected void refresh(boolean updateState) {
        Color foreground = this.getForeground();
        this.nameLabel.setForeground(foreground);
        this.description.setForeground(foreground);
        if (this.installInfoLink != null) {
            this.installInfoLink.setForeground(foreground);
        }
        if (updateState && this.buttonController != null) {
            this.buttonController.refresh();
        }
    }

    private void hookRecursively(Control control, Listener listener) {
        control.addListener(12, listener);
        control.addListener(32, listener);
        control.addListener(5, listener);
        control.addListener(7, listener);
        control.addListener(3, listener);
        control.addListener(37, listener);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.hookRecursively(child, listener);
                ++n2;
            }
        }
    }

    protected void hookTooltip(Control parent, Widget tipActivator, Control exitControl, final Control titleControl, AbstractCatalogSource source, Overview overview, Image image) {
        final OverviewToolTip toolTip = new OverviewToolTip(parent, this.browser, (MarketplaceCatalogSource)source, overview, image);
        this.hookTooltip(toolTip, tipActivator, exitControl);
        if (image != null) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    toolTip.show(titleControl);
                }
            };
            tipActivator.addListener(32, listener);
        }
        if (tipActivator instanceof StyledText) {
            StyledText link = (StyledText)tipActivator;
            this.hookLinkListener(link, new LinkListener(){

                @Override
                protected void selected(String href) {
                    toolTip.show(titleControl);
                }
            });
        } else {
            Listener selectionListener = new Listener(){

                public void handleEvent(Event event) {
                    toolTip.show(titleControl);
                }
            };
            tipActivator.addListener(13, selectionListener);
        }
    }

    private void hookTooltip(final ToolTip toolTip, Widget tipActivator, final Control exitControl) {
        if (toolTip == null) {
            return;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                toolTip.hide();
            }
        };
        tipActivator.addListener(12, listener);
        tipActivator.addListener(37, listener);
        Listener exitListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 37: {
                        toolTip.hide();
                        break;
                    }
                    case 7: {
                        Rectangle tipBounds;
                        Shell tipShell;
                        Rectangle containerBounds = exitControl.getBounds();
                        Point displayLocation = exitControl.getParent().toDisplay(containerBounds.x, containerBounds.y);
                        containerBounds.x = displayLocation.x;
                        containerBounds.y = displayLocation.y;
                        containerBounds.height += 3;
                        Point cursorLocation = Display.getCurrent().getCursorLocation();
                        if (containerBounds.contains(cursorLocation) || (tipShell = (Shell)toolTip.getData(Shell.class.getName())) != null && !tipShell.isDisposed() && (tipBounds = tipShell.getBounds()).contains(cursorLocation)) break;
                        toolTip.hide();
                    }
                }
            }
        };
        this.hookRecursively(exitControl, exitListener);
    }

    private static abstract class LinkListener
    implements MouseListener,
    SelectionListener {
        private boolean active = false;

        private LinkListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            StyledText link = (StyledText)e.getSource();
            if (link.getSelectionCount() != 0) {
                this.active = false;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            StyledText link = (StyledText)e.getSource();
            this.active = e.button == 1 && link.getSelectionCount() == 0;
        }

        public void mouseUp(MouseEvent e) {
            StyleRange style;
            int offset;
            if (!this.active) {
                return;
            }
            this.active = false;
            if (e.button != 1) {
                return;
            }
            StyledText link = (StyledText)e.getSource();
            try {
                offset = link.getOffsetAtLocation(new Point(e.x, e.y));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                offset = -1;
            }
            if (offset >= 0 && offset < link.getCharCount() && (style = link.getStyleRangeAtOffset(offset)) != null && style.data != null) {
                this.selected((String)style.data);
            }
        }

        protected abstract void selected(String var1);
    }
}

