/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui;

import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(name="org.eclipse.epp.mpc.ui.resources", service={MarketplaceClientUiResources.class})
public class MarketplaceClientUiResources {
    public static final String IU_ICON_UPDATE = "IU_ICON_UPDATE";
    public static final String IU_ICON_INSTALL = "IU_ICON_INSTALL";
    public static final String IU_ICON_UNINSTALL = "IU_ICON_UNINSTALL";
    public static final String IU_ICON_DISABLED = "IU_ICON_DISABLED";
    public static final String IU_ICON = "IU_ICON";
    public static final String IU_ICON_ERROR = "IU_ICON_ERROR";
    public static final String NEWS_ICON_UPDATE = "NEWS_ICON_UPDATE";
    public static final String NO_ICON_PROVIDED = "NO_ICON_PROVIDED";
    public static final String NO_ICON_PROVIDED_CATALOG = "NO_ICON_PROVIDED_CATALOG";
    public static final String DEFAULT_MARKETPLACE_ICON = "DEFAULT_MARKETPLACE_ICON";
    public static final String ACTION_ICON_FAVORITES = "ACTION_ICON_FAVORITES";
    public static final String ACTION_ICON_LOGIN = "ACTION_ICON_LOGIN";
    public static final String ACTION_ICON_WARNING = "ACTION_ICON_WARNING";
    public static final String ACTION_ICON_UPDATE = "ACTION_ICON_UPDATE";
    public static final String FAVORITES_LIST_ICON = "FAVORITES_LIST_ICON";
    public static final String ITEM_ICON_STAR = "ITEM_ICON_STAR";
    public static final String ITEM_ICON_STAR_SELECTED = "ITEM_ICON_STAR_SELECTED";
    public static final String ITEM_ICON_SHARE = "ITEM_ICON_SHARE";
    private static MarketplaceClientUiResources instance;
    private ResourceProvider resourceProvider;
    private AbstractUIPlugin delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext context) throws Exception {
        this.delegate = new AbstractUIPlugin(){

            protected void initializeImageRegistry(ImageRegistry reg) {
                super.initializeImageRegistry(reg);
                MarketplaceClientUiResources.this.initializeImageRegistry(reg);
            }
        };
        this.delegate.start(context.getBundleContext());
        this.resourceProvider = new ResourceProvider();
        Class<MarketplaceClientUiResources> clazz = MarketplaceClientUiResources.class;
        synchronized (MarketplaceClientUiResources.class) {
            if (instance == null) {
                instance = this;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext context) throws Exception {
        Class<MarketplaceClientUiResources> clazz = MarketplaceClientUiResources.class;
        synchronized (MarketplaceClientUiResources.class) {
            if (instance == this) {
                instance = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.resourceProvider != null) {
                this.resourceProvider.dispose();
                this.resourceProvider = null;
            }
            if (this.delegate != null) {
                this.delegate.stop(context.getBundleContext());
            }
            this.delegate = null;
            return;
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return this.delegate == null ? null : this.delegate.getPreferenceStore();
    }

    public ImageRegistry getImageRegistry() {
        return this.delegate == null ? null : this.delegate.getImageRegistry();
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public IDialogSettings getDialogSettings() {
        return this.delegate == null ? null : this.delegate.getDialogSettings();
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        imageRegistry.put(NO_ICON_PROVIDED, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/noiconprovided.png").get());
        imageRegistry.put(NO_ICON_PROVIDED_CATALOG, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/noiconprovided32.png").get());
        imageRegistry.put(DEFAULT_MARKETPLACE_ICON, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/marketplace_banner.png").get());
        imageRegistry.put(IU_ICON, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/iu_obj.png").get());
        imageRegistry.put(IU_ICON_UPDATE, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/iu_update_obj.png").get());
        imageRegistry.put(IU_ICON_INSTALL, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/iu_install_obj.png").get());
        imageRegistry.put(IU_ICON_UNINSTALL, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/iu_uninstall_obj.png").get());
        imageRegistry.put(IU_ICON_DISABLED, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/iu_disabled_obj.png").get());
        ImageDescriptor errorOverlay = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
        Image iuImage = imageRegistry.get(IU_ICON);
        DecorationOverlayIcon iuErrorIcon = new DecorationOverlayIcon(iuImage, errorOverlay, 3);
        imageRegistry.put(IU_ICON_ERROR, (ImageDescriptor)iuErrorIcon);
        imageRegistry.put(NEWS_ICON_UPDATE, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/news_update.png").get());
        imageRegistry.put(ITEM_ICON_STAR, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/star.png").get());
        imageRegistry.put(ITEM_ICON_STAR_SELECTED, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/star-selected.png").get());
        imageRegistry.put(ITEM_ICON_SHARE, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/share.png").get());
        imageRegistry.put(ACTION_ICON_FAVORITES, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/action-item-favorites.png").get());
        imageRegistry.put(ACTION_ICON_LOGIN, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/action-item-login.png").get());
        imageRegistry.put(ACTION_ICON_WARNING, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/action-item-warning.png").get());
        imageRegistry.put(ACTION_ICON_UPDATE, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/action-item-update.png").get());
        imageRegistry.put(FAVORITES_LIST_ICON, (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle(MarketplaceClientUiResources.class, (String)"icons/favorites-list.png").get());
    }

    public static synchronized MarketplaceClientUiResources getInstance() {
        if (instance == null) {
            MarketplaceClientUiResources registered;
            BundleContext bundleContext = MarketplaceClientUi.getBundleContext();
            ServiceReference serviceReference = bundleContext == null ? null : bundleContext.getServiceReference(MarketplaceClientUiResources.class);
            MarketplaceClientUiResources marketplaceClientUiResources = registered = serviceReference == null ? null : (MarketplaceClientUiResources)bundleContext.getService(serviceReference);
            if (registered != null) {
                bundleContext.ungetService(serviceReference);
            }
            if (instance == null) {
                instance = registered;
            }
        }
        return instance;
    }
}

