/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.build;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.intellij.ProjectTopics;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.graph.Graph;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.IncrementalBuilder;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.build.Source2GeneratedMapping;
import org.eclipse.xtext.common.types.descriptions.TypeResourceDescription;
import org.eclipse.xtext.idea.build.BuildEvent;
import org.eclipse.xtext.idea.build.BuildProgressReporter;
import org.eclipse.xtext.idea.build.XtextAutoBuilderComponentState;
import org.eclipse.xtext.idea.facet.AbstractFacetConfiguration;
import org.eclipse.xtext.idea.facet.AbstractFacetType;
import org.eclipse.xtext.idea.facet.FacetProvider;
import org.eclipse.xtext.idea.resource.IdeaResourceSetProvider;
import org.eclipse.xtext.idea.resource.VirtualFileURIUtil;
import org.eclipse.xtext.idea.shared.IdeaSharedInjectorProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@State(name="XtextAutoBuilderState", storages={@Storage(id="other", file="$WORKSPACE_FILE$"), @Storage(id="dir", file="$PROJECT_CONFIG_DIR$/xtextAutoBuilderState.xml", scheme=StorageScheme.DIRECTORY_BASED)})
@Log
public class XtextAutoBuilderComponent
extends AbstractProjectComponent
implements Disposable,
PersistentStateComponent<XtextAutoBuilderComponentState> {
    private volatile boolean disposed;
    private final LinkedBlockingQueue<BuildEvent> queue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<MutableCancelIndicator> cancelIndicators = new LinkedBlockingQueue();
    private Alarm alarm;
    private Project project;
    @Inject
    private Provider<IncrementalBuilder> builderProvider;
    @Inject
    private Provider<BuildProgressReporter> buildProgressReporterProvider;
    @Inject
    private IdeaResourceSetProvider resourceSetProvider;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private Provider<ChunkedResourceDescriptions> chunkedResourceDescriptionsProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private ChunkedResourceDescriptions chunkedResourceDescriptions;
    private Map<String, Source2GeneratedMapping> moduleName2GeneratedMapping = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final LinkedBlockingQueue<BuildEvent> scheduledDeletions = new LinkedBlockingQueue();
    public static boolean TEST_MODE = false;
    private boolean avoidBuildInTestMode = false;
    private volatile boolean ignoreIncomingEvents = false;
    private static final Object BUILD_MONITOR = new Object();
    private List<BuildEvent> unProcessedEvents = CollectionLiterals.newArrayList((Object[])new BuildEvent[0]);
    private static final char SEGMENT_SEPARATOR = '/';
    @Inject
    private XtextAutoBuilderComponentState.Codec codec;
    private static final Logger LOG = Logger.getLogger(XtextAutoBuilderComponent.class);

    public Iterable<URI> getGeneratedSources(final URI source) {
        Collection<Source2GeneratedMapping> _values = this.moduleName2GeneratedMapping.values();
        Functions.Function1<Source2GeneratedMapping, List<URI>> _function = new Functions.Function1<Source2GeneratedMapping, List<URI>>(){

            public List<URI> apply(Source2GeneratedMapping it) {
                return it.getGenerated(source);
            }
        };
        Iterable _map = IterableExtensions.map(_values, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        return IterableExtensions.toList((Iterable)_flatten);
    }

    public Iterable<URI> getSource4GeneratedSource(final URI generated) {
        Collection<Source2GeneratedMapping> _values = this.moduleName2GeneratedMapping.values();
        Functions.Function1<Source2GeneratedMapping, List<URI>> _function = new Functions.Function1<Source2GeneratedMapping, List<URI>>(){

            public List<URI> apply(Source2GeneratedMapping it) {
                return it.getSource(generated);
            }
        };
        Iterable _map = IterableExtensions.map(_values, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        return IterableExtensions.toList((Iterable)_flatten);
    }

    public XtextAutoBuilderComponent(final Project project) {
        super(project);
        Alarm _alarm;
        ChunkedResourceDescriptions _get;
        boolean _isUnitTestMode;
        Application _application = ApplicationManager.getApplication();
        TEST_MODE = _isUnitTestMode = _application.isUnitTestMode();
        Injector _injector = IdeaSharedInjectorProvider.getInjector();
        _injector.injectMembers((Object)this);
        this.chunkedResourceDescriptions = _get = (ChunkedResourceDescriptions)this.chunkedResourceDescriptionsProvider.get();
        this.project = project;
        this.alarm = _alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.disposed = false;
        Disposer.register((Disposable)project, (Disposable)this);
        EditorFactory _instance = EditorFactory.getInstance();
        EditorEventMulticaster _eventMulticaster = _instance.getEventMulticaster();
        _eventMulticaster.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent event) {
                boolean _notEquals;
                Document _document;
                FileDocumentManager _instance = FileDocumentManager.getInstance();
                VirtualFile file = _instance.getFile(_document = event.getDocument());
                boolean bl = _notEquals = !Objects.equal((Object)file, null);
                if (_notEquals) {
                    XtextAutoBuilderComponent.this.fileModified(file);
                } else {
                    Document _document_1 = event.getDocument();
                    String _plus = "No virtual file for document. Contents was " + _document_1;
                    LOG.info((Object)_plus);
                }
            }
        }, (Disposable)project);
        VirtualFileManager _instance_1 = VirtualFileManager.getInstance();
        _instance_1.addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void beforePropertyChange(VirtualFilePropertyEvent event) {
                String _propertyName = event.getPropertyName();
                boolean _equals = Objects.equal((Object)_propertyName, (Object)"name");
                if (_equals) {
                    VirtualFile _file = event.getFile();
                    XtextAutoBuilderComponent.this.scheduleDeletion(_file);
                }
            }

            public void propertyChanged(VirtualFilePropertyEvent event) {
                String _propertyName = event.getPropertyName();
                boolean _equals = Objects.equal((Object)_propertyName, (Object)"name");
                if (_equals) {
                    XtextAutoBuilderComponent.this.commitScheduledDeletion();
                    VirtualFile _file = event.getFile();
                    XtextAutoBuilderComponent.this.fileAdded(_file);
                }
            }

            public void contentsChanged(VirtualFileEvent event) {
                VirtualFile _file = event.getFile();
                XtextAutoBuilderComponent.this.fileModified(_file);
            }

            public void fileCreated(VirtualFileEvent event) {
                VirtualFile _file = event.getFile();
                XtextAutoBuilderComponent.this.fileAdded(_file);
            }

            public void fileDeleted(VirtualFileEvent event) {
                XtextAutoBuilderComponent.this.commitScheduledDeletion();
            }

            public void beforeFileDeletion(VirtualFileEvent event) {
                VirtualFile _file = event.getFile();
                XtextAutoBuilderComponent.this.scheduleDeletion(_file);
            }

            public void beforeFileMovement(VirtualFileMoveEvent event) {
                VirtualFile _file = event.getFile();
                XtextAutoBuilderComponent.this.scheduleDeletion(_file);
            }

            public void fileMoved(VirtualFileMoveEvent event) {
                XtextAutoBuilderComponent.this.commitScheduledDeletion();
                VirtualFile _file = event.getFile();
                XtextAutoBuilderComponent.this.fileAdded(_file);
            }
        }, (Disposable)project);
        MessageBus _messageBus = project.getMessageBus();
        MessageBusConnection connection = _messageBus.connect((Disposable)project);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                XtextAutoBuilderComponent.this.doCleanBuild();
            }
        });
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

            public void moduleAdded(Project project, Module module) {
                boolean _isInitialized = project.isInitialized();
                if (_isInitialized) {
                    XtextAutoBuilderComponent.this.doCleanBuild(module);
                }
            }

            public void moduleRemoved(Project project, Module module) {
                String _name = module.getName();
                XtextAutoBuilderComponent.this.chunkedResourceDescriptions.removeContainer(_name);
                String _name_1 = module.getName();
                XtextAutoBuilderComponent.this.moduleName2GeneratedMapping.remove(_name_1);
            }

            public void modulesRenamed(Project project, List<Module> modules, Function<Module, String> oldNameProvider) {
                for (Module module : modules) {
                    String _fun = (String)oldNameProvider.fun((Object)module);
                    XtextAutoBuilderComponent.this.chunkedResourceDescriptions.removeContainer(_fun);
                    String _name = module.getName();
                    XtextAutoBuilderComponent.this.moduleName2GeneratedMapping.remove(_name);
                    XtextAutoBuilderComponent.this.doCleanBuild(module);
                }
            }
        });
        ProjectWideFacetListenersRegistry _instance_2 = ProjectWideFacetListenersRegistry.getInstance((Project)project);
        _instance_2.registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(Facet facet) {
                boolean _isInitialized;
                boolean _not_1;
                boolean _not;
                boolean _or = false;
                boolean _isXtextFacet = XtextAutoBuilderComponent.this.isXtextFacet(facet);
                boolean bl = _not = !_isXtextFacet;
                _or = _not ? true : (_not_1 = !(_isInitialized = project.isInitialized()));
                if (_or) {
                    return;
                }
                Module _module = facet.getModule();
                XtextAutoBuilderComponent.this.doCleanBuild(_module);
            }

            public void facetRemoved(Facet facet) {
                boolean _not;
                boolean _isXtextFacet = XtextAutoBuilderComponent.this.isXtextFacet(facet);
                boolean bl = _not = !_isXtextFacet;
                if (_not) {
                    return;
                }
                Module _module = facet.getModule();
                XtextAutoBuilderComponent.this.doCleanBuild(_module);
            }

            public void facetConfigurationChanged(Facet facet) {
                boolean _not;
                boolean _isXtextFacet = XtextAutoBuilderComponent.this.isXtextFacet(facet);
                boolean bl = _not = !_isXtextFacet;
                if (_not) {
                    return;
                }
                Module _module = facet.getModule();
                XtextAutoBuilderComponent.this.doCleanBuild(_module);
            }
        }, (Disposable)this);
    }

    protected boolean isXtextFacet(Facet<?> facet) {
        FacetType facetType = facet.getType();
        return facetType instanceof AbstractFacetType;
    }

    public void dispose() {
        ChunkedResourceDescriptions _get;
        this.disposed = true;
        this.alarm.cancelAllRequests();
        this.queue.clear();
        this.chunkedResourceDescriptions = _get = (ChunkedResourceDescriptions)this.chunkedResourceDescriptionsProvider.get();
    }

    protected Project getProject() {
        return this.myProject;
    }

    public void fileModified(VirtualFile file) {
        this.enqueue(BuildEvent.Type.MODIFIED, file);
    }

    public void scheduleDeletion(VirtualFile root) {
        boolean _not;
        boolean _tripleEquals;
        ProjectFileIndex _instance = ProjectFileIndex.SERVICE.getInstance((Project)this.project);
        Module _findModule = this.findModule(root, _instance);
        boolean bl = _tripleEquals = _findModule == null;
        if (_tripleEquals) {
            return;
        }
        final ArrayList files = CollectionLiterals.newArrayList((Object[])new VirtualFile[0]);
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(VirtualFile file) {
                boolean _not;
                boolean _xblockexpression = false;
                boolean _isDirectory = file.isDirectory();
                boolean bl = _not = !_isDirectory;
                if (_not) {
                    files.add(file);
                }
                _xblockexpression = true;
                return _xblockexpression;
            }
        });
        boolean _isEmpty = files.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            BuildEvent _buildEvent = new BuildEvent(BuildEvent.Type.DELETED, (VirtualFile[])Conversions.unwrapArray((Object)files, VirtualFile.class));
            CollectionExtensions.addAll(this.scheduledDeletions, (Object[])new BuildEvent[]{_buildEvent});
        }
    }

    public void commitScheduledDeletion() {
        ArrayList scheduledEvents = CollectionLiterals.newArrayList((Object[])new BuildEvent[0]);
        this.scheduledDeletions.drainTo(scheduledEvents);
        for (BuildEvent event : scheduledEvents) {
            this.enqueue(event);
        }
    }

    public void fileAdded(VirtualFile file) {
        long _length;
        boolean _greaterThan;
        boolean _not;
        boolean _and = false;
        boolean _isDirectory = file.isDirectory();
        boolean bl = _not = !_isDirectory;
        _and = !_not ? false : (_greaterThan = (_length = file.getLength()) > 0L);
        if (_and) {
            this.enqueue(BuildEvent.Type.ADDED, file);
        } else {
            boolean _isInfoEnabled = LOG.isInfoEnabled();
            if (_isInfoEnabled) {
                String _path = file.getPath();
                String _plus = "Ignoring new empty file " + _path;
                String _plus_1 = _plus + ". Waiting for content.";
                LOG.info((Object)_plus_1);
            }
        }
    }

    protected void enqueue(BuildEvent.Type type, VirtualFile ... files) {
        Functions.Function1<VirtualFile, Boolean> _function = new Functions.Function1<VirtualFile, Boolean>(){

            public Boolean apply(VirtualFile it) {
                boolean _isExcluded = XtextAutoBuilderComponent.this.isExcluded(it);
                return !_isExcluded;
            }
        };
        Iterable filteredFiles = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)files)), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)filteredFiles);
        if (_isEmpty) {
            return;
        }
        BuildEvent _buildEvent = new BuildEvent(type, (VirtualFile[])Conversions.unwrapArray((Object)filteredFiles, VirtualFile.class));
        this.enqueue(_buildEvent);
    }

    protected void enqueue(BuildEvent buildEvent) {
        try {
            boolean _isInfoEnabled;
            boolean _isLoaded;
            boolean _not;
            boolean _and = false;
            _and = this.disposed ? false : (_not = !(_isLoaded = this.isLoaded()));
            if (_and) {
                this.queueAllResources();
            }
            if (_isInfoEnabled = LOG.isInfoEnabled()) {
                Map<URI, VirtualFile> _filesByURI = buildEvent.getFilesByURI();
                Set<URI> _keySet = _filesByURI.keySet();
                for (URI uri : _keySet) {
                    BuildEvent.Type _type = buildEvent.getType();
                    String _plus = "Queuing " + (Object)((Object)_type);
                    String _plus_1 = _plus + " - ";
                    String _plus_2 = _plus_1 + uri;
                    String _plus_3 = _plus_2 + ".";
                    LOG.info((Object)_plus_3);
                }
            }
            if (!this.disposed) {
                this.queue.put(buildEvent);
                this.doRunBuild();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void doCleanBuild() {
        ChunkedResourceDescriptions _get;
        if (this.ignoreIncomingEvents) {
            return;
        }
        this.alarm.cancelAllRequests();
        this.chunkedResourceDescriptions = _get = (ChunkedResourceDescriptions)this.chunkedResourceDescriptionsProvider.get();
        Collection<Source2GeneratedMapping> _values = this.moduleName2GeneratedMapping.values();
        Functions.Function1<Source2GeneratedMapping, List<URI>> _function = new Functions.Function1<Source2GeneratedMapping, List<URI>>(){

            public List<URI> apply(Source2GeneratedMapping it) {
                return it.getAllGenerated();
            }
        };
        Iterable _map = IterableExtensions.map(_values, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        List _list = IterableExtensions.toList((Iterable)_flatten);
        this.safeDeleteUris(_list);
        this.moduleName2GeneratedMapping.clear();
        this.queueAllResources();
        this.doRunBuild();
    }

    protected void doCleanBuild(Module module) {
        boolean _notEquals;
        if (this.ignoreIncomingEvents) {
            return;
        }
        this.alarm.cancelAllRequests();
        String _name = module.getName();
        this.chunkedResourceDescriptions.removeContainer(_name);
        String _name_1 = module.getName();
        Source2GeneratedMapping before = this.moduleName2GeneratedMapping.remove(_name_1);
        boolean bl = _notEquals = !Objects.equal((Object)before, null);
        if (_notEquals) {
            List _allGenerated = before.getAllGenerated();
            this.safeDeleteUris(_allGenerated);
        }
        this.queueAllResources(module);
        this.doRunBuild();
    }

    protected void safeDeleteUris(final List<URI> uris) {
        boolean _not;
        boolean _isEmpty = uris.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Runnable _function;
            final Application app = ApplicationManager.getApplication();
            final Runnable runnable = _function = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            XtextAutoBuilderComponent.this.ignoreIncomingEvents = true;
                            for (URI uri : uris) {
                                boolean _exists;
                                VirtualFile file = VirtualFileURIUtil.getVirtualFile(uri);
                                boolean _and = false;
                                _and = file == null ? false : (_exists = file.exists());
                                if (!_and) continue;
                                file.delete((Object)XtextAutoBuilderComponent.this);
                            }
                        }
                        finally {
                            XtextAutoBuilderComponent.this.ignoreIncomingEvents = false;
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            boolean _isDispatchThread = app.isDispatchThread();
            if (_isDispatchThread) {
                app.runWriteAction(runnable);
            } else {
                Runnable _function_1 = new Runnable(){

                    @Override
                    public void run() {
                        app.runWriteAction(runnable);
                    }
                };
                ModalityState _defaultModalityState = app.getDefaultModalityState();
                app.invokeLater(_function_1, _defaultModalityState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOperation(Procedures.Procedure0 operation) {
        if (!TEST_MODE) {
            throw new IllegalStateException("Should be used only for testing");
        }
        this.avoidBuildInTestMode = true;
        try {
            operation.apply();
        }
        finally {
            this.avoidBuildInTestMode = false;
            this.doRunBuild();
        }
    }

    protected void doRunBuild() {
        if (TEST_MODE) {
            if (!this.avoidBuildInTestMode) {
                Project _project = this.getProject();
                PsiManager _instance = PsiManager.getInstance((Project)_project);
                PsiModificationTracker _modificationTracker = _instance.getModificationTracker();
                ((PsiModificationTrackerImpl)_modificationTracker).incCounter();
                this.build();
            }
        } else {
            this.alarm.cancelAllRequests();
            Procedures.Procedure1<MutableCancelIndicator> _function = new Procedures.Procedure1<MutableCancelIndicator>(){

                public void apply(MutableCancelIndicator it) {
                    it.canceled = true;
                }
            };
            IterableExtensions.forEach(this.cancelIndicators, (Procedures.Procedure1)_function);
            Runnable _function_1 = new Runnable(){

                @Override
                public void run() {
                    XtextAutoBuilderComponent.this.build();
                }
            };
            Application _application = ApplicationManager.getApplication();
            ModalityState _defaultModalityState = _application.getDefaultModalityState();
            this.alarm.addRequest(_function_1, 200, _defaultModalityState);
        }
    }

    protected boolean isExcluded(VirtualFile file) {
        boolean _isDirectory;
        if (this.ignoreIncomingEvents) {
            boolean _isDebugEnabled = LOG.isDebugEnabled();
            if (_isDebugEnabled) {
                String _path = file.getPath();
                String _plus = "Ignoring transitive file change " + _path;
                LOG.debug((Object)_plus);
            }
            return true;
        }
        boolean _or = false;
        boolean _equals = Objects.equal((Object)file, null);
        _or = _equals ? true : (_isDirectory = file.isDirectory());
        return _or;
    }

    protected boolean isLoaded() {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        boolean _or = false;
        boolean _isEmpty = this.chunkedResourceDescriptions.isEmpty();
        boolean bl = _not = !_isEmpty;
        _or = _not ? true : (_not_1 = !(_isEmpty_1 = this.queue.isEmpty()));
        return _or;
    }

    protected void queueAllResources(Module module) {
        ModuleRootManager _instance = ModuleRootManager.getInstance((Module)module);
        ContentEntry[] entries = _instance.getContentEntries();
        Functions.Function1<ContentEntry, Set<VirtualFile>> _function = new Functions.Function1<ContentEntry, Set<VirtualFile>>(){

            public Set<VirtualFile> apply(ContentEntry it) {
                VirtualFile[] _sourceFolderFiles = it.getSourceFolderFiles();
                return IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)_sourceFolderFiles)));
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)entries)), (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        for (VirtualFile root : _flatten) {
            Procedures.Procedure1<VirtualFile> _function_1 = new Procedures.Procedure1<VirtualFile>(){

                public void apply(VirtualFile file) {
                    try {
                        boolean _exists;
                        boolean _and = false;
                        boolean _isDirectory = file.isDirectory();
                        boolean _not = !_isDirectory;
                        _and = !_not ? false : (_exists = file.exists());
                        if (_and) {
                            BuildEvent _buildEvent = new BuildEvent(BuildEvent.Type.ADDED, file);
                            XtextAutoBuilderComponent.this.queue.put(_buildEvent);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            this.visitFileTree(root, (Procedures.Procedure1<? super VirtualFile>)_function_1);
        }
    }

    protected void queueAllResources() {
        Module[] _runReadAction;
        final ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
        Application _application = ApplicationManager.getApplication();
        Computable<Module[]> _function = new Computable<Module[]>(){

            public Module[] compute() {
                return moduleManager.getModules();
            }
        };
        for (Module module : _runReadAction = (Module[])_application.runReadAction((Computable)_function)) {
            this.queueAllResources(module);
        }
    }

    public void visitFileTree(VirtualFile file, Procedures.Procedure1<? super VirtualFile> handler) {
        boolean _isDirectory = file.isDirectory();
        if (_isDirectory) {
            VirtualFile[] _children;
            for (VirtualFile child : _children = file.getChildren()) {
                this.visitFileTree(child, handler);
            }
        }
        handler.apply((Object)file);
    }

    protected void build() {
        boolean _not;
        if (this.disposed) {
            return;
        }
        boolean _isReadyToBeBuilt = this.isReadyToBeBuilt();
        boolean bl = _not = !_isReadyToBeBuilt;
        if (_not) {
            LOG.info((Object)"Project not yet initialized, wait some more");
            Runnable _function = new Runnable(){

                @Override
                public void run() {
                    XtextAutoBuilderComponent.this.build();
                }
            };
            this.alarm.addRequest(_function, 500);
        } else if (TEST_MODE) {
            this.internalBuild(null);
        } else {
            ProgressManager _instance = ProgressManager.getInstance();
            _instance.run((Task)new Task.Backgroundable(this.project, "Code Generation..."){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(ProgressIndicator indicator) {
                    indicator.setIndeterminate(true);
                    Object object = BUILD_MONITOR;
                    synchronized (object) {
                        XtextAutoBuilderComponent.this.internalBuild(indicator);
                    }
                }
            });
        }
    }

    private boolean isReadyToBeBuilt() {
        boolean _or = false;
        if (TEST_MODE) {
            _or = true;
        } else {
            DumbService _instance;
            boolean _isDumb;
            boolean _not;
            boolean _and = false;
            boolean _isInitialized = this.project.isInitialized();
            _and = !_isInitialized ? false : (_not = !(_isDumb = (_instance = DumbService.getInstance((Project)this.project)).isDumb()));
            _or = _and;
        }
        return _or;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalBuild(ProgressIndicator indicator) {
        block16: {
            this.queue.drainTo(this.unProcessedEvents);
            boolean _isEmpty = this.unProcessedEvents.isEmpty();
            if (_isEmpty) {
                return;
            }
            Application app = ApplicationManager.getApplication();
            final MutableCancelIndicator cancelIndicator = new MutableCancelIndicator(indicator);
            this.cancelIndicators.add(cancelIndicator);
            Project _project = this.getProject();
            final ModuleManager moduleManager = ModuleManager.getInstance((Project)_project);
            final BuildProgressReporter buildProgressReporter = (BuildProgressReporter)this.buildProgressReporterProvider.get();
            buildProgressReporter.setProject(this.project);
            ArrayList<BuildEvent> _arrayList = new ArrayList<BuildEvent>(this.unProcessedEvents);
            buildProgressReporter.setEvents(_arrayList);
            try {
                Computable<Graph<Module>> _function = new Computable<Graph<Module>>(){

                    public Graph<Module> compute() {
                        return moduleManager.moduleGraph();
                    }
                };
                Graph moduleGraph = (Graph)app.runReadAction((Computable)_function);
                final ArrayList deltas = CollectionLiterals.newArrayList((Object[])new IResourceDescription.Delta[0]);
                Collection _nodes = moduleGraph.getNodes();
                ArrayList sortedModules = new ArrayList(_nodes);
                ModuleCompilerUtil.sortModules((Project)this.project, sortedModules);
                for (final Module module : sortedModules) {
                    Source2GeneratedMapping _source2GeneratedMapping;
                    Source2GeneratedMapping _elvis = null;
                    String _name = module.getName();
                    Source2GeneratedMapping _get = this.moduleName2GeneratedMapping.get(_name);
                    _elvis = _get != null ? _get : (_source2GeneratedMapping = new Source2GeneratedMapping());
                    final Source2GeneratedMapping fileMappings = _elvis;
                    ResourceDescriptionsData _elvis_1 = null;
                    String _name_1 = module.getName();
                    ResourceDescriptionsData _container = this.chunkedResourceDescriptions.getContainer(_name_1);
                    if (_container != null) {
                        _elvis_1 = _container;
                    } else {
                        ResourceDescriptionsData _resourceDescriptionsData;
                        List _emptyList = CollectionLiterals.emptyList();
                        _elvis_1 = _resourceDescriptionsData = new ResourceDescriptionsData((Iterable)_emptyList);
                    }
                    ResourceDescriptionsData moduleDescriptions = _elvis_1;
                    final HashSet changedUris = CollectionLiterals.newHashSet((Object[])new URI[0]);
                    final HashSet deletedUris = CollectionLiterals.newHashSet((Object[])new URI[0]);
                    ModuleRootManager _instance = ModuleRootManager.getInstance((Module)module);
                    final VirtualFile[] contentRoots = _instance.getContentRoots();
                    LinkedHashSet<BuildEvent> events = this.getEventsForModule(this.unProcessedEvents, module);
                    boolean _or = false;
                    boolean _isEmpty_1 = ((List)Conversions.doWrapArray((Object)contentRoots)).isEmpty();
                    if (_isEmpty_1) {
                        _or = true;
                    } else {
                        boolean _isEmpty_3;
                        boolean _and = false;
                        boolean _isEmpty_2 = events.isEmpty();
                        _and = !_isEmpty_2 ? false : (_isEmpty_3 = deltas.isEmpty());
                        _or = _and;
                    }
                    if (_or) {
                        String _name_2 = module.getName();
                        String _plus = "Skipping module '" + _name_2;
                        String _plus_1 = _plus + "'. Nothing to do here.";
                        LOG.info((Object)_plus_1);
                        continue;
                    }
                    this.collectChanges(events, module, changedUris, deletedUris, deltas);
                    final ResourceDescriptionsData newIndex = moduleDescriptions.copy();
                    BuildRequest _buildRequest = new BuildRequest();
                    Procedures.Procedure1<BuildRequest> _function_1 = new Procedures.Procedure1<BuildRequest>(){

                        public void apply(BuildRequest it) {
                            XtextResourceSet _createResourceSet = XtextAutoBuilderComponent.this.createResourceSet(module, newIndex);
                            it.setResourceSet(_createResourceSet);
                            List _dirtyFiles = it.getDirtyFiles();
                            Iterables.addAll((Collection)_dirtyFiles, (Iterable)changedUris);
                            List _deletedFiles = it.getDeletedFiles();
                            Iterables.addAll((Collection)_deletedFiles, (Iterable)deletedUris);
                            List _externalDeltas = it.getExternalDeltas();
                            Iterables.addAll((Collection)_externalDeltas, (Iterable)deltas);
                            VirtualFile _head = (VirtualFile)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)contentRoots)));
                            URI _uRI = VirtualFileURIUtil.getURI(_head);
                            it.setBaseDir(_uRI);
                            Source2GeneratedMapping _copy = fileMappings.copy();
                            IndexState _indexState = new IndexState(newIndex, _copy);
                            it.setState(_indexState);
                            it.setAfterValidate((BuildRequest.IPostValidationCallback)buildProgressReporter);
                            Procedures.Procedure1<URI> _function = new Procedures.Procedure1<URI>(){

                                public void apply(URI it) {
                                    buildProgressReporter.markAsAffected(it);
                                }
                            };
                            it.setAfterDeleteFile((Procedures.Procedure1)_function);
                            it.setCancelIndicator((CancelIndicator)cancelIndicator);
                        }
                    };
                    final BuildRequest request = (BuildRequest)ObjectExtensions.operator_doubleArrow((Object)_buildRequest, (Procedures.Procedure1)_function_1);
                    IncrementalBuilder _get_1 = (IncrementalBuilder)this.builderProvider.get();
                    Functions.Function1<URI, IResourceServiceProvider> _serviceProviderProvider = this.getServiceProviderProvider(module);
                    IncrementalBuilder.Result result = _get_1.build(request, _serviceProviderProvider);
                    Runnable _function_2 = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                XtextAutoBuilderComponent.this.ignoreIncomingEvents = true;
                                XtextResourceSet _resourceSet = request.getResourceSet();
                                IdeaResourceSetProvider.VirtualFileBasedUriHandler handler = IdeaResourceSetProvider.VirtualFileBasedUriHandler.find((Notifier)_resourceSet);
                                handler.flushToDisk();
                            }
                            finally {
                                XtextAutoBuilderComponent.this.ignoreIncomingEvents = false;
                                buildProgressReporter.rehighlight();
                            }
                        }
                    };
                    ModalityState _defaultModalityState = app.getDefaultModalityState();
                    app.invokeAndWait(_function_2, _defaultModalityState);
                    String _name_3 = module.getName();
                    IndexState _indexState = result.getIndexState();
                    ResourceDescriptionsData _resourceDescriptions = _indexState.getResourceDescriptions();
                    this.chunkedResourceDescriptions.setContainer(_name_3, _resourceDescriptions);
                    String _name_4 = module.getName();
                    IndexState _indexState_1 = result.getIndexState();
                    Source2GeneratedMapping _fileMappings = _indexState_1.getFileMappings();
                    this.moduleName2GeneratedMapping.put(_name_4, _fileMappings);
                    List _affectedResources = result.getAffectedResources();
                    deltas.addAll(_affectedResources);
                    Iterables.removeAll(this.unProcessedEvents, events);
                }
                this.unProcessedEvents.clear();
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    Throwable exc = _t;
                    boolean _isOperationCanceledException = this.operationCanceledManager.isOperationCanceledException(exc);
                    if (_isOperationCanceledException) {
                        boolean _isInfoEnabled = LOG.isInfoEnabled();
                        if (_isInfoEnabled) {
                            LOG.info((Object)"Build canceled.");
                        }
                    } else {
                        LOG.error((Object)"Error during auto build.", exc);
                    }
                    break block16;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                buildProgressReporter.clearProgress();
                this.cancelIndicators.remove(cancelIndicator);
            }
        }
    }

    protected LinkedHashSet<BuildEvent> getEventsForModule(List<BuildEvent> events, Module module) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        String[] excludeRootUrls = moduleRootManager.getExcludeRootUrls();
        String[] sourceRootUrls = moduleRootManager.getSourceRootUrls();
        LinkedHashSet<BuildEvent> result = new LinkedHashSet<BuildEvent>();
        for (BuildEvent event : events) {
            Set<URI> _uRIs = event.getURIs();
            boolean _isEmpty = _uRIs.isEmpty();
            boolean _not = !_isEmpty;
            if (!_not) continue;
            Set<URI> _uRIs_1 = event.getURIs();
            URI _head = (URI)IterableExtensions.head(_uRIs_1);
            final String url = _head.toString();
            boolean _and = false;
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String it) {
                    boolean _isUrlUnderRoot = XtextAutoBuilderComponent.this.isUrlUnderRoot(url, it);
                    return !_isUrlUnderRoot;
                }
            };
            boolean _forall = IterableExtensions.forall((Iterable)((Iterable)Conversions.doWrapArray((Object)excludeRootUrls)), (Functions.Function1)_function);
            if (!_forall) {
                _and = false;
            } else {
                boolean _exists;
                Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

                    public Boolean apply(String it) {
                        return XtextAutoBuilderComponent.this.isUrlUnderRoot(url, it);
                    }
                };
                _and = _exists = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)sourceRootUrls)), (Functions.Function1)_function_1);
            }
            if (!_and) continue;
            result.add(event);
        }
        return result;
    }

    protected boolean isUrlUnderRoot(String url, String rootUrl) {
        boolean _startsWith;
        int _length_2;
        char _charAt;
        boolean _equals;
        int _length_1;
        boolean _greaterThan;
        boolean _and = false;
        boolean _and_1 = false;
        int _length = url.length();
        boolean bl = _greaterThan = _length > (_length_1 = rootUrl.length());
        _and_1 = !_greaterThan ? false : (_equals = (_charAt = url.charAt(_length_2 = rootUrl.length())) == '/');
        _and = !_and_1 ? false : (_startsWith = FileUtil.startsWith((String)url, (String)rootUrl));
        return _and;
    }

    public Functions.Function1<URI, IResourceServiceProvider> getServiceProviderProvider(final Module module) {
        Functions.Function1<URI, IResourceServiceProvider> _function = new Functions.Function1<URI, IResourceServiceProvider>(){

            public IResourceServiceProvider apply(URI it) {
                boolean _notEquals;
                IResourceServiceProvider serviceProvider = XtextAutoBuilderComponent.this.resourceServiceProviderRegistry.getResourceServiceProvider(it);
                boolean bl = _notEquals = !Objects.equal((Object)serviceProvider, null);
                if (_notEquals) {
                    boolean _notEquals_1;
                    FacetProvider facetProvider = (FacetProvider)serviceProvider.get(FacetProvider.class);
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)facetProvider, null);
                    if (_notEquals_1) {
                        boolean _notEquals_2;
                        Facet<? extends AbstractFacetConfiguration> facet = facetProvider.getFacet(module);
                        boolean bl3 = _notEquals_2 = !Objects.equal(facet, null);
                        if (_notEquals_2) {
                            return serviceProvider;
                        }
                    }
                }
                return null;
            }
        };
        return _function;
    }

    public XtextResourceSet createResourceSet(Module module, ResourceDescriptionsData newData) {
        XtextResourceSet result = this.resourceSetProvider.get(module);
        ChunkedResourceDescriptions fullIndex = ChunkedResourceDescriptions.findInEmfObject((Notifier)result);
        String _name = module.getName();
        fullIndex.setContainer(_name, newData);
        return result;
    }

    public String getContainerHandle(Module module) {
        return module.getName();
    }

    protected void collectChanges(Set<BuildEvent> events, final Module module, HashSet<URI> changedUris, HashSet<URI> deletedUris, ArrayList<IResourceDescription.Delta> deltas) {
        Application app = ApplicationManager.getApplication();
        String _name = module.getName();
        Source2GeneratedMapping fileMappings = this.moduleName2GeneratedMapping.get(_name);
        block4: for (final BuildEvent event : events) {
            BuildEvent.Type _type = event.getType();
            if (_type == null) continue;
            switch (_type) {
                case MODIFIED: 
                case ADDED: {
                    Set<URI> _uRIs = event.getURIs();
                    for (final URI uri : _uRIs) {
                        boolean _isEmpty;
                        boolean _not;
                        boolean _notEquals;
                        List _source = null;
                        if (fileMappings != null) {
                            _source = fileMappings.getSource(uri);
                        }
                        List sourceUris = _source;
                        boolean _and = false;
                        boolean bl = _notEquals = !Objects.equal((Object)sourceUris, null);
                        _and = !_notEquals ? false : (_not = !(_isEmpty = sourceUris.isEmpty()));
                        if (_and) {
                            for (URI sourceUri : sourceUris) {
                                this.consistentAdd(sourceUri, changedUris, deletedUris);
                            }
                            continue;
                        }
                        boolean _isJavaFile = this.isJavaFile(uri);
                        if (_isJavaFile) {
                            Computable<Set<IResourceDescription.Delta>> _function = new Computable<Set<IResourceDescription.Delta>>(){

                                public Set<IResourceDescription.Delta> compute() {
                                    VirtualFile _file = event.getFile(uri);
                                    return XtextAutoBuilderComponent.this.getJavaDeltas(_file, module);
                                }
                            };
                            Set _runReadAction = (Set)app.runReadAction((Computable)_function);
                            Iterables.addAll(deltas, (Iterable)_runReadAction);
                            continue;
                        }
                        this.consistentAdd(uri, changedUris, deletedUris);
                    }
                    continue block4;
                }
                case DELETED: {
                    Set<URI> _uRIs_1 = event.getURIs();
                    for (final URI uri_1 : _uRIs_1) {
                        boolean _isEmpty;
                        boolean _not;
                        boolean _notEquals;
                        List _source = null;
                        if (fileMappings != null) {
                            _source = fileMappings.getSource(uri_1);
                        }
                        List sourceUris = _source;
                        boolean _and = false;
                        boolean bl = _notEquals = !Objects.equal((Object)sourceUris, null);
                        _and = !_notEquals ? false : (_not = !(_isEmpty = sourceUris.isEmpty()));
                        if (_and) {
                            for (URI sourceUri : sourceUris) {
                                this.consistentAdd(sourceUri, changedUris, deletedUris);
                            }
                            continue;
                        }
                        boolean _isJavaFile = this.isJavaFile(uri_1);
                        if (_isJavaFile) {
                            Computable<Set<IResourceDescription.Delta>> _function = new Computable<Set<IResourceDescription.Delta>>(){

                                public Set<IResourceDescription.Delta> compute() {
                                    VirtualFile _file = event.getFile(uri_1);
                                    return XtextAutoBuilderComponent.this.getJavaDeltas(_file, module);
                                }
                            };
                            Set _runReadAction = (Set)app.runReadAction((Computable)_function);
                            Iterables.addAll(deltas, (Iterable)_runReadAction);
                            continue;
                        }
                        this.consistentAdd(uri_1, deletedUris, changedUris);
                    }
                    continue block4;
                }
            }
        }
    }

    protected void consistentAdd(URI uri, Set<URI> toBeAdded, Set<URI> toBeRemoved) {
        toBeAdded.add(uri);
        toBeRemoved.remove(uri);
    }

    public boolean isJavaFile(URI file) {
        String _fileExtension = file.fileExtension();
        return Objects.equal((Object)_fileExtension, (Object)"java");
    }

    public Set<IResourceDescription.Delta> getJavaDeltas(VirtualFile file, Module module) {
        boolean _not;
        boolean _isValid = file.isValid();
        boolean bl = _not = !_isValid;
        if (_not) {
            return CollectionLiterals.emptySet();
        }
        Project _project = module.getProject();
        PsiManager _instance = PsiManager.getInstance((Project)_project);
        PsiFile psiFile = _instance.findFile(file);
        LinkedHashSet result = CollectionLiterals.newLinkedHashSet((Object[])new IResourceDescription.Delta[0]);
        if (psiFile instanceof PsiJavaFile) {
            PsiClass[] _classes;
            for (PsiClass clazz : _classes = ((PsiJavaFile)psiFile).getClasses()) {
                String _qualifiedName = clazz.getQualifiedName();
                QualifiedName _qualifiedName_1 = this.qualifiedNameConverter.toQualifiedName(_qualifiedName);
                TypeResourceDescription.ChangedDelta _changedDelta = new TypeResourceDescription.ChangedDelta(_qualifiedName_1);
                result.add(_changedDelta);
            }
        }
        return result;
    }

    public ChunkedResourceDescriptions installCopyOfResourceDescriptions(ResourceSet resourceSet) {
        return this.chunkedResourceDescriptions.createShallowCopyWith(resourceSet);
    }

    protected Module findModule(BuildEvent it, ProjectFileIndex fileIndex) {
        Module _xblockexpression = null;
        Map<URI, VirtualFile> _filesByURI = it.getFilesByURI();
        Collection<VirtualFile> _values = _filesByURI.values();
        VirtualFile file = (VirtualFile)IterableExtensions.head(_values);
        Module _xifexpression = null;
        BuildEvent.Type _type = it.getType();
        boolean _equals = Objects.equal((Object)((Object)_type), (Object)((Object)BuildEvent.Type.DELETED));
        _xifexpression = _equals ? this.findModule(file, fileIndex) : fileIndex.getModuleForFile(file, true);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected Module findModule(VirtualFile file, ProjectFileIndex fileIndex) {
        boolean _notEquals;
        boolean _equals = Objects.equal((Object)file, null);
        if (_equals) {
            return null;
        }
        Module module = fileIndex.getModuleForFile(file, true);
        boolean bl = _notEquals = !Objects.equal((Object)module, null);
        if (_notEquals) {
            return module;
        }
        VirtualFile _parent = file.getParent();
        return this.findModule(_parent, fileIndex);
    }

    public String getComponentName() {
        return "Xtext Compiler Component";
    }

    public ChunkedResourceDescriptions getIndexState() {
        return this.chunkedResourceDescriptions;
    }

    public XtextAutoBuilderComponentState getState() {
        return this.codec.encode(this.resourceServiceProviderRegistry, this.chunkedResourceDescriptions, this.moduleName2GeneratedMapping);
    }

    public void loadState(XtextAutoBuilderComponentState state) {
        try {
            boolean _not;
            Map _extensionToFactoryMap = this.resourceServiceProviderRegistry.getExtensionToFactoryMap();
            Set installedNow = _extensionToFactoryMap.keySet();
            Set<String> installedLastTime = this.codec.decodeInstalledLanguages(state);
            boolean _equals = installedNow.equals(installedLastTime);
            boolean bl = _not = !_equals;
            if (_not) {
                ChunkedResourceDescriptions _get;
                LOG.info((Object)"Different Xtext plugins than last time. Reindexing project.");
                this.chunkedResourceDescriptions = _get = (ChunkedResourceDescriptions)this.chunkedResourceDescriptionsProvider.get();
                this.moduleName2GeneratedMapping.clear();
                this.doCleanBuild();
            } else {
                ChunkedResourceDescriptions _decodeIndex;
                boolean _isDebugEnabled = LOG.isDebugEnabled();
                if (_isDebugEnabled) {
                    LOG.debug((Object)"Loading persisted index state.");
                }
                this.chunkedResourceDescriptions = _decodeIndex = this.codec.decodeIndex(state);
                Map<String, Source2GeneratedMapping> _decodeModuleToGenerated = this.codec.decodeModuleToGenerated(state);
                this.moduleName2GeneratedMapping = _decodeModuleToGenerated;
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                ChunkedResourceDescriptions _get_1;
                Exception exc = (Exception)_t;
                LOG.error((Object)"Error loading XtextAutoBuildComponentState ", (Throwable)exc);
                this.chunkedResourceDescriptions = _get_1 = (ChunkedResourceDescriptions)this.chunkedResourceDescriptionsProvider.get();
                this.moduleName2GeneratedMapping.clear();
                this.doCleanBuild();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @FinalFieldsConstructor
    public static class MutableCancelIndicator
    implements CancelIndicator {
        private final ProgressIndicator indicator;
        private volatile boolean canceled;

        public boolean isCanceled() {
            boolean _or = false;
            if (this.canceled) {
                _or = true;
            } else {
                boolean _isCanceled = false;
                if (this.indicator != null) {
                    _isCanceled = this.indicator.isCanceled();
                }
                _or = _isCanceled;
            }
            return _or;
        }

        public boolean setCanceled(boolean canceled) {
            this.canceled = canceled;
            return this.canceled;
        }

        public MutableCancelIndicator(ProgressIndicator indicator) {
            this.indicator = indicator;
        }
    }
}

