/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.serializer;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public class SemanticSequencerExtensions {
    @Inject
    private IGrammarConstraintProvider gcp;

    public Map<IGrammarConstraintProvider.IConstraint, List<ISerializationContext>> getGrammarConstraints(Grammar grammar, EClass clazz) {
        LinkedHashMap result = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
        Map constraints = this.gcp.getConstraints(grammar);
        Set _entrySet = constraints.entrySet();
        for (Map.Entry e : _entrySet) {
            boolean _tripleEquals;
            ISerializationContext context = (ISerializationContext)e.getKey();
            IGrammarConstraintProvider.IConstraint constraint = (IGrammarConstraintProvider.IConstraint)e.getValue();
            EClass _type = constraint.getType();
            boolean bl = _tripleEquals = _type == clazz;
            if (!_tripleEquals) continue;
            List contexts = (List)result.get(constraint);
            if (contexts == null) {
                ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new ISerializationContext[0]);
                contexts = _newArrayList;
                result.put(constraint, contexts);
            }
            contexts.add(context);
        }
        return result;
    }

    protected ResourceSet cloneResourceSet(ResourceSet rs) {
        XtextResourceSet result = new XtextResourceSet();
        EPackage.Registry _packageRegistry = rs.getPackageRegistry();
        result.setPackageRegistry(_packageRegistry);
        Resource.Factory.Registry _resourceFactoryRegistry = rs.getResourceFactoryRegistry();
        result.setResourceFactoryRegistry(_resourceFactoryRegistry);
        URIConverter _uRIConverter = rs.getURIConverter();
        result.setURIConverter(_uRIConverter);
        if (rs instanceof XtextResourceSet) {
            Object _classpathURIContext = ((XtextResourceSet)rs).getClasspathURIContext();
            result.setClasspathURIContext(_classpathURIContext);
            IClasspathUriResolver _classpathUriResolver = ((XtextResourceSet)rs).getClasspathUriResolver();
            result.setClasspathUriResolver(_classpathUriResolver);
        }
        return result;
    }

    public Grammar getSuperGrammar(Grammar grammar) {
        EList _usedGrammars = grammar.getUsedGrammars();
        boolean _isEmpty = _usedGrammars.isEmpty();
        if (_isEmpty) {
            return null;
        }
        Adapter _existingAdapter = EcoreUtil.getExistingAdapter((Notifier)grammar, SuperGrammar.class);
        SuperGrammar sg = (SuperGrammar)_existingAdapter;
        if (sg != null) {
            return sg.grammar;
        }
        EList _usedGrammars_1 = grammar.getUsedGrammars();
        Grammar _head = (Grammar)IterableExtensions.head((Iterable)_usedGrammars_1);
        Resource _eResource = _head.eResource();
        URI uri = _eResource.getURI();
        Resource _eResource_1 = grammar.eResource();
        ResourceSet _resourceSet = _eResource_1.getResourceSet();
        ResourceSet _cloneResourceSet = this.cloneResourceSet(_resourceSet);
        Resource resource = _cloneResourceSet.getResource(uri, true);
        EList _contents = resource.getContents();
        EObject _head_1 = (EObject)IterableExtensions.head((Iterable)_contents);
        Grammar result = (Grammar)_head_1;
        EList _eAdapters = grammar.eAdapters();
        SuperGrammar _superGrammar = new SuperGrammar(result);
        _eAdapters.add((Object)_superGrammar);
        return result;
    }

    public Collection<IGrammarConstraintProvider.IConstraint> getGrammarConstraints(Grammar grammar) {
        if (grammar == null) {
            return CollectionLiterals.emptySet();
        }
        Map _constraints = this.gcp.getConstraints(grammar);
        return _constraints.values();
    }

    public List<ISemanticSequencerNfaProvider.ISemState> getLinearListOfMandatoryAssignments(IGrammarConstraintProvider.IConstraint constraint) {
        Nfa nfa = constraint.getNfa();
        ISemanticSequencerNfaProvider.ISemState state = (ISemanticSequencerNfaProvider.ISemState)nfa.getStart();
        ArrayList result = CollectionLiterals.newArrayList((Object[])new ISemanticSequencerNfaProvider.ISemState[0]);
        HashSet features = CollectionLiterals.newHashSet((Object[])new EStructuralFeature[0]);
        while (state != null) {
            ISemanticSequencerNfaProvider.ISemState _head;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            boolean _tripleEquals;
            ISemanticSequencerNfaProvider.ISemState _stop = (ISemanticSequencerNfaProvider.ISemState)nfa.getStop();
            boolean bl = _tripleEquals = state == _stop;
            if (_tripleEquals) {
                ArrayList _xifexpression = null;
                boolean _isEmpty = result.isEmpty();
                _xifexpression = _isEmpty ? null : result;
                return _xifexpression;
            }
            List _followers = state.getFollowers();
            int _size = _followers.size();
            boolean bl2 = _tripleNotEquals = _size != 1;
            if (_tripleNotEquals) {
                return null;
            }
            ISemanticSequencerNfaProvider.ISemState _start = (ISemanticSequencerNfaProvider.ISemState)nfa.getStart();
            boolean bl3 = _tripleNotEquals_1 = state != _start;
            if (_tripleNotEquals_1) {
                boolean _add;
                boolean _not;
                boolean _isMany;
                EStructuralFeature feature = state.getFeature();
                boolean _or = false;
                boolean _or_1 = false;
                _or_1 = feature == null ? true : (_isMany = feature.isMany());
                _or = _or_1 ? true : (_not = !(_add = features.add(feature)));
                if (_or) {
                    return null;
                }
                result.add(state);
            }
            List _followers_1 = state.getFollowers();
            state = _head = (ISemanticSequencerNfaProvider.ISemState)IterableExtensions.head((Iterable)_followers_1);
        }
        return null;
    }

    public String toAcceptMethod(IGrammarConstraintProvider.ConstraintElementType type) {
        String _switchResult = null;
        if (type != null) {
            switch (type) {
                case ASSIGNED_ACTION_CALL: {
                    _switchResult = "acceptAssignedAction";
                    break;
                }
                case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: {
                    _switchResult = "acceptAssignedCrossRefDatatype";
                    break;
                }
                case ASSIGNED_CROSSREF_ENUM_RULE_CALL: {
                    _switchResult = "acceptAssignedCrossRefEnum";
                    break;
                }
                case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: {
                    _switchResult = "acceptAssignedCrossRefTerminal";
                    break;
                }
                case ASSIGNED_CROSSREF_KEYWORD: {
                    _switchResult = "acceptAssignedCrossRefKeyword";
                    break;
                }
                case ASSIGNED_DATATYPE_RULE_CALL: {
                    _switchResult = "acceptAssignedDatatype";
                    break;
                }
                case ASSIGNED_ENUM_RULE_CALL: {
                    _switchResult = "acceptAssignedEnum";
                    break;
                }
                case ASSIGNED_KEYWORD: {
                    _switchResult = "acceptAssignedKeyword";
                    break;
                }
                case ASSIGNED_PARSER_RULE_CALL: {
                    _switchResult = "acceptAssignedParserRuleCall";
                    break;
                }
                case ASSIGNED_TERMINAL_RULE_CALL: {
                    _switchResult = "acceptAssignedTerminal";
                    break;
                }
                default: {
                    _switchResult = "<error, unknown type '" + type + "'>";
                    break;
                }
            }
        } else {
            _switchResult = "<error, unknown type '" + type + "'>";
        }
        return _switchResult;
    }

    public String toNodeType(IGrammarConstraintProvider.ConstraintElementType type) {
        String _switchResult = null;
        if (type != null) {
            switch (type) {
                case ASSIGNED_ACTION_CALL: 
                case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: 
                case ASSIGNED_CROSSREF_ENUM_RULE_CALL: 
                case ASSIGNED_CROSSREF_KEYWORD: 
                case ASSIGNED_DATATYPE_RULE_CALL: 
                case ASSIGNED_ENUM_RULE_CALL: 
                case ASSIGNED_PARSER_RULE_CALL: {
                    _switchResult = ICompositeNode.class.getSimpleName();
                    break;
                }
                case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: 
                case ASSIGNED_KEYWORD: 
                case ASSIGNED_TERMINAL_RULE_CALL: {
                    _switchResult = ILeafNode.class.getSimpleName();
                    break;
                }
                default: {
                    _switchResult = "<error, unknown type '" + type + "'>";
                    break;
                }
            }
        } else {
            _switchResult = "<error, unknown type '" + type + "'>";
        }
        return _switchResult;
    }

    @FinalFieldsConstructor
    @Accessors
    protected static class SuperGrammar
    extends AdapterImpl {
        private final Grammar grammar;

        public boolean isAdapterForType(Object type) {
            return type == SuperGrammar.class;
        }

        public SuperGrammar(Grammar grammar) {
            this.grammar = grammar;
        }

        @Pure
        public Grammar getGrammar() {
            return this.grammar;
        }
    }
}

