/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.config;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.HashMap;
import java.util.List;
import org.eclipse.xtend.core.idea.config.GradleBuildFileUtility;
import org.eclipse.xtend.core.idea.framework.XtendLibraryDescription;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.idea.util.ProjectLifecycleUtil;
import org.eclipse.xtext.util.XtextVersion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class XtendLibraryConfigurator {
    protected static final Logger LOG = Logger.getInstance((String)XtendLibraryConfigurator.class.getName());
    @Inject
    @Extension
    private GradleBuildFileUtility gradleUtils;
    @Inject
    private XtendLibraryDescription xtendLibDescr;
    private static MavenId XTEND_LIB_MAVEN_ID;
    @Inject
    @Extension
    private ProjectLifecycleUtil _projectLifecycleUtil;

    public void ensureXtendLibAvailable(ModifiableRootModel rootModel) {
        this.ensureXtendLibAvailable(rootModel, null);
    }

    public void ensureXtendLibAvailable(final ModifiableRootModel rootModel, final PsiFile context) {
        Project _project = rootModel.getProject();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                XtendLibraryConfigurator.this.doEnsureXtendLibAvailable(rootModel, context);
            }
        };
        this._projectLifecycleUtil.executeWhenProjectReady(_project, _function);
    }

    protected void doEnsureXtendLibAvailable(ModifiableRootModel rootModel, PsiFile context) {
        String _name;
        Module module = rootModel.getModule();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        Project _project = rootModel.getProject();
        JavaPsiFacade _instance = JavaPsiFacade.getInstance((Project)_project);
        PsiClass psiClass = _instance.findClass(_name = Data.class.getName(), scope);
        boolean _equals = Objects.equal((Object)psiClass, null);
        if (_equals) {
            boolean _isMavenizedModule = this.isMavenizedModule(module);
            if (_isMavenizedModule) {
                this.addMavenDependency(module, context);
            } else {
                boolean _isGradleedModule = this.gradleUtils.isGradleedModule(module);
                if (_isGradleedModule) {
                    this.addGradleDependency(module, context);
                } else {
                    this.addJavaRuntimeLibrary(module, rootModel);
                }
            }
        }
    }

    public void addGradleDependency(Module module, final PsiFile context) {
        final GroovyFile buildFile = this.gradleUtils.locateBuildFile(module);
        if (buildFile == null) {
            String _name = module.getName();
            String _plus = "Gradle build file not found in module " + _name;
            LOG.error(_plus);
            return;
        }
        Project _project = module.getProject();
        List _newImmutableList = CollectionLiterals.newImmutableList((Object[])new PsiFile[]{buildFile});
        new WriteCommandAction.Simple(_project, "Gradle: Add Xtend Runtime Library", (PsiFile[])Conversions.unwrapArray((Object)_newImmutableList, PsiFile.class)){

            protected void run() throws Throwable {
                String _xifexpression = null;
                boolean _isTestScope = false;
                if (context != null) {
                    _isTestScope = XtendLibraryConfigurator.this.isTestScope(context);
                }
                _xifexpression = _isTestScope ? "testCompile" : "compile";
                String scope = _xifexpression;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)scope, "");
                _builder.append((Object)" '");
                MavenId _xtendLibMavenId = XtendLibraryConfigurator.xtendLibMavenId();
                String _key = _xtendLibMavenId.getKey();
                _builder.append((Object)_key, "");
                _builder.append((Object)"' ");
                XtendLibraryConfigurator.this.gradleUtils.addDependency((GrStatementOwner)buildFile, _builder.toString());
            }
        }.execute();
    }

    public static MavenId xtendLibMavenId() {
        if (XTEND_LIB_MAVEN_ID == null) {
            MavenId _mavenId;
            XtextVersion _current = XtextVersion.getCurrent();
            String version = _current.getVersion();
            LOG.info("The current Xtend plugin version is " + version);
            XTEND_LIB_MAVEN_ID = _mavenId = new MavenId("org.eclipse.xtend", "org.eclipse.xtend.lib", version);
        }
        return XTEND_LIB_MAVEN_ID;
    }

    public void addJavaRuntimeLibrary(Module module, ModifiableRootModel rootModel) {
        boolean _isWritable;
        LibraryOrderEntry _findLibraryOrderEntry;
        boolean _tripleEquals;
        boolean _notEquals;
        Library library = this.createOrGetXtendJavaLibrary(rootModel, module);
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)library, null);
        _and = !_notEquals ? false : (_tripleEquals = (_findLibraryOrderEntry = rootModel.findLibraryOrderEntry(library)) == null);
        if (_and && (_isWritable = rootModel.isWritable())) {
            rootModel.addLibraryEntry(library);
        }
    }

    public void addMavenDependency(Module module, final PsiFile context) {
        Project project = module.getProject();
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
        MavenProject mavenProject = mavenProjectsManager.findProject(module);
        if (mavenProject == null) {
            return;
        }
        VirtualFile _file = mavenProject.getFile();
        final MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel((Project)project, (VirtualFile)_file);
        if (model == null) {
            return;
        }
        XmlFile _file_1 = DomUtil.getFile((DomElement)model);
        List _newImmutableList = CollectionLiterals.newImmutableList((Object[])new PsiFile[]{_file_1});
        new WriteCommandAction.Simple(project, "Add Xtend lib Maven Dependency", (PsiFile[])Conversions.unwrapArray((Object)_newImmutableList, PsiFile.class)){

            protected void run() throws Throwable {
                MavenId _xtendLibMavenId = XtendLibraryConfigurator.xtendLibMavenId();
                MavenDomDependency dependency = MavenDomUtil.createDomDependency((MavenDomProjectModel)model, null, (MavenId)_xtendLibMavenId);
                boolean _isTestScope = false;
                if (context != null) {
                    _isTestScope = XtendLibraryConfigurator.this.isTestScope(context);
                }
                if (_isTestScope) {
                    GenericDomValue _scope = dependency.getScope();
                    _scope.setStringValue("test");
                }
            }
        }.execute();
    }

    public Library createOrGetXtendJavaLibrary(ModifiableRootModel rootModel, Module module) {
        boolean _not;
        Functions.Function1<Library, Boolean> _function;
        LibraryTablesRegistrar _instance = LibraryTablesRegistrar.getInstance();
        Project _project = module.getProject();
        LibraryTable _libraryTable = _instance.getLibraryTable(_project);
        Library[] _libraries = _libraryTable.getLibraries();
        LibraryTablesRegistrar _instance_1 = LibraryTablesRegistrar.getInstance();
        LibraryTable _libraryTable_1 = _instance_1.getLibraryTable();
        Library[] _libraries_1 = _libraryTable_1.getLibraries();
        Iterable libraryTable = Iterables.concat((Iterable)((Iterable)Conversions.doWrapArray((Object)_libraries)), (Iterable)((Iterable)Conversions.doWrapArray((Object)_libraries_1)));
        Iterable xtendLibs = IterableExtensions.filter((Iterable)libraryTable, (Functions.Function1)(_function = new Functions.Function1<Library, Boolean>(){

            public Boolean apply(Library it) {
                String _name = it.getName();
                boolean _startsWith = false;
                if (_name != null) {
                    _startsWith = _name.startsWith("Xtend Library");
                }
                return _startsWith;
            }
        }));
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)xtendLibs);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1<Library, Boolean> _function_1 = new Functions.Function1<Library, Boolean>(){

                public Boolean apply(Library it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)"Xtend Library");
                }
            };
            boolean _exists = IterableExtensions.exists((Iterable)xtendLibs, (Functions.Function1)_function_1);
            if (_exists) {
                Functions.Function1<Library, Boolean> _function_2 = new Functions.Function1<Library, Boolean>(){

                    public Boolean apply(Library it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)"Xtend Library");
                    }
                };
                return (Library)IterableExtensions.findFirst((Iterable)xtendLibs, (Functions.Function1)_function_2);
            }
            return (Library)IterableExtensions.head((Iterable)xtendLibs);
        }
        NewLibraryConfiguration libDescr = this.xtendLibDescr.createLibraryDescription();
        LibraryTable _moduleLibraryTable = rootModel.getModuleLibraryTable();
        LibraryTable.ModifiableModel model = _moduleLibraryTable.getModifiableModel();
        String _defaultLibraryName = libDescr.getDefaultLibraryName();
        Library createdLib = model.createLibrary(_defaultLibraryName);
        final Library.ModifiableModel libModel = createdLib.getModifiableModel();
        HashMap<OrderRootType, List<String>> _libraryRoots = this.xtendLibDescr.libraryRoots();
        Procedures.Procedure2<OrderRootType, List<String>> _function_3 = new Procedures.Procedure2<OrderRootType, List<String>>(){

            public void apply(final OrderRootType type, List<String> roots) {
                Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

                    public void apply(String it) {
                        libModel.addRoot(it, type);
                    }
                };
                IterableExtensions.forEach(roots, (Procedures.Procedure1)_function);
            }
        };
        MapExtensions.forEach(_libraryRoots, (Procedures.Procedure2)_function_3);
        libModel.commit();
        model.commit();
        return createdLib;
    }

    protected boolean isTestScope(PsiFile context) {
        PsiFile _originalFile = context.getOriginalFile();
        VirtualFile virtualFile = _originalFile.getVirtualFile();
        if (virtualFile != null) {
            Project _project = context.getProject();
            ProjectRootManager _instance = ProjectRootManager.getInstance((Project)_project);
            ProjectFileIndex _fileIndex = _instance.getFileIndex();
            return _fileIndex.isInTestSourceContent(virtualFile);
        }
        return false;
    }

    public boolean isMavenizedModule(Module module) {
        Project _project = module.getProject();
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)_project);
        boolean _xifexpression = false;
        _xifexpression = mavenProjectsManager != null ? mavenProjectsManager.isMavenizedModule(module) : false;
        return _xifexpression;
    }
}

