/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import java.util.concurrent.BlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.generator.FileSystemAccessRequest;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class FileSystemAccessQueue
extends AdapterImpl {
    private final BlockingQueue<FileSystemAccessRequest> requestQueue;
    private final IProgressMonitor monitor;

    @FinalFieldsConstructor
    public FileSystemAccessQueue(BlockingQueue<FileSystemAccessRequest> requestQueue, IProgressMonitor monitor) {
        this.requestQueue = requestQueue;
        this.monitor = monitor;
    }

    public void sendAsync(URI uri, Runnable runMe) {
        FileSystemAccessRequest _fileSystemAccessRequest = new FileSystemAccessRequest(uri, runMe);
        this.send(_fileSystemAccessRequest);
    }

    protected FileSystemAccessRequest send(FileSystemAccessRequest request) {
        try {
            boolean _isCanceled = this.monitor.isCanceled();
            if (_isCanceled) {
                throw new OperationCanceledException();
            }
            this.requestQueue.put(request);
            return request;
        }
        catch (Throwable _t) {
            if (_t instanceof InterruptedException) {
                InterruptedException cfr_ignored_0 = (InterruptedException)_t;
                throw new OperationCanceledException();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

