/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.common.types;

import com.google.common.base.Objects;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.search.GlobalSearchScope;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.AbstractRuntimeJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IClassMirror;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;
import org.eclipse.xtext.idea.common.types.PsiBasedTypeFactory;
import org.eclipse.xtext.idea.common.types.PsiClassMirror;
import org.eclipse.xtext.idea.common.types.StubURIHelper;
import org.eclipse.xtext.psi.IPsiModelAssociator;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class StubJvmTypeProvider
extends AbstractRuntimeJvmTypeProvider {
    private final ITypeFactory<PsiClass, JvmDeclaredType> psiClassFactory;
    @Accessors
    private final Module module;
    @Extension
    @Accessors
    private final StubURIHelper uriHelper;
    @Accessors
    private final GlobalSearchScope searchScope;

    public StubJvmTypeProvider(Module module, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess, TypeResourceServices services, IPsiModelAssociator psiModelAssociator, GlobalSearchScope searchScope) {
        super(resourceSet, indexedJvmTypeAccess, services);
        PsiBasedTypeFactory _createPsiClassFactory;
        StubURIHelper _createStubURIHelper;
        this.module = module;
        this.searchScope = searchScope;
        this.uriHelper = _createStubURIHelper = this.createStubURIHelper();
        this.psiClassFactory = _createPsiClassFactory = this.createPsiClassFactory(psiModelAssociator);
    }

    public PsiBasedTypeFactory createPsiClassFactory(IPsiModelAssociator psiModelAssociator) {
        return new PsiBasedTypeFactory(this.uriHelper, psiModelAssociator);
    }

    protected StubURIHelper createStubURIHelper() {
        return new StubURIHelper();
    }

    public JvmType findTypeByName(String name) {
        return this.doFindTypeByName(name, false);
    }

    public JvmType findTypeByName(String name, boolean binaryNestedTypeDelimiter) {
        boolean _isBinaryNestedTypeDelimiter;
        JvmType _xblockexpression = null;
        JvmType result = this.doFindTypeByName(name, false);
        boolean _or = false;
        boolean _notEquals = !Objects.equal((Object)result, null);
        _or = _notEquals ? true : (_isBinaryNestedTypeDelimiter = this.isBinaryNestedTypeDelimiter(name, binaryNestedTypeDelimiter));
        if (_or) {
            return result;
        }
        AbstractJvmTypeProvider.ClassNameVariants nameVariants = new AbstractJvmTypeProvider.ClassNameVariants(name);
        while (Objects.equal((Object)result, null) && nameVariants.hasNext()) {
            JvmType _doFindTypeByName;
            String nextVariant = (String)nameVariants.next();
            result = _doFindTypeByName = this.doFindTypeByName(nextVariant, true);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public JvmType doFindTypeByName(String name, final boolean traverseNestedTypes) {
        try {
            ResourceSet _resourceSet;
            JvmType _xblockexpression = null;
            ProgressIndicatorProvider.checkCanceled();
            String normalizedName = this.normalize(name);
            final URI resourceURI = this.uriHelper.createResourceURI(normalizedName);
            final String fragment = this.uriHelper.getFragment(normalizedName);
            JvmType _switchResult = null;
            ResourceSet resourceSet = _resourceSet = this.getResourceSet();
            boolean _matched = false;
            if (!_matched && resourceSet instanceof ISynchronizable) {
                _matched = true;
                IUnitOfWork<JvmType, ResourceSet> _function = new IUnitOfWork<JvmType, ResourceSet>(){

                    public JvmType exec(ResourceSet it) throws Exception {
                        return StubJvmTypeProvider.this.findType(resourceURI, fragment, traverseNestedTypes);
                    }
                };
                _switchResult = (JvmType)((ISynchronizable)resourceSet).execute((IUnitOfWork)_function);
            }
            if (!_matched) {
                _switchResult = this.findType(resourceURI, fragment, traverseNestedTypes);
            }
            _xblockexpression = _switchResult;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String normalize(String name) {
        try {
            String _xifexpression = null;
            boolean _startsWith = name.startsWith("[");
            if (_startsWith) {
                StringCharacterIterator _stringCharacterIterator = new StringCharacterIterator(name);
                _xifexpression = SignatureParsing.parseTypeString((CharacterIterator)_stringCharacterIterator);
            } else {
                _xifexpression = name;
            }
            return _xifexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public JvmType findType(URI resourceURI, String fragment, boolean traverseNestedTypes) {
        IndexedJvmTypeAccess indexedJvmTypeAccess = this.getIndexedJvmTypeAccess();
        if (indexedJvmTypeAccess != null) {
            URI proxyURI = resourceURI.appendFragment(fragment);
            try {
                ResourceSet _resourceSet = this.getResourceSet();
                EObject candidate = indexedJvmTypeAccess.getIndexedJvmType(proxyURI, _resourceSet);
                if (candidate instanceof JvmType) {
                    return (JvmType)candidate;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof IndexedJvmTypeAccess.UnknownNestedTypeException) {
                    IndexedJvmTypeAccess.UnknownNestedTypeException e = (IndexedJvmTypeAccess.UnknownNestedTypeException)_t;
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        ProgressIndicatorProvider.checkCanceled();
        try {
            boolean _notEquals;
            ResourceSet _resourceSet_1 = this.getResourceSet();
            Resource existing = _resourceSet_1.getResource(resourceURI, false);
            boolean bl = _notEquals = !Objects.equal((Object)existing, null);
            if (_notEquals) {
                return this.findType(existing, fragment, traverseNestedTypes);
            }
            IMirror mirror = this.createMirror(resourceURI);
            boolean _equals = Objects.equal((Object)mirror, null);
            if (_equals) {
                return null;
            }
            TypeResource resource = this.doCreateResource(resourceURI);
            resource.setMirror(mirror);
            ResourceSet _resourceSet_2 = this.getResourceSet();
            EList _resources = _resourceSet_2.getResources();
            _resources.add((Object)resource);
            resource.load(null);
            return this.findType((Resource)resource, fragment, traverseNestedTypes);
        }
        catch (Throwable _t_1) {
            try {
                if (_t_1 instanceof OperationCanceledError) {
                    OperationCanceledError e_1 = (OperationCanceledError)_t_1;
                    throw e_1.getWrapped();
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    protected JvmType findType(final Resource resource, final String fragment, final boolean traverseNestedTypes) {
        Application _application = ApplicationManager.getApplication();
        Computable<JvmType> _function = new Computable<JvmType>(){

            public JvmType compute() {
                boolean _notEquals;
                EObject _eObject = resource.getEObject(fragment);
                JvmType result = (JvmType)_eObject;
                boolean _or = false;
                boolean bl = _notEquals = !Objects.equal((Object)result, null);
                if (_notEquals) {
                    _or = true;
                } else {
                    boolean bl2 = _or = !traverseNestedTypes;
                }
                if (_or) {
                    return result;
                }
                EList _contents = resource.getContents();
                EObject rootType = (EObject)IterableExtensions.head((Iterable)_contents);
                if (rootType instanceof JvmDeclaredType) {
                    URI _uRI = resource.getURI();
                    String rootTypeName = _uRI.segment(1);
                    int _length = rootTypeName.length();
                    int _plus = _length + 1;
                    String nestedTypeName = fragment.substring(_plus);
                    List segments = Strings.split((String)nestedTypeName, (String)"$");
                    return StubJvmTypeProvider.this.findNestedType((JvmDeclaredType)rootType, segments, 0);
                }
                return null;
            }
        };
        return (JvmType)_application.runReadAction((Computable)_function);
    }

    protected IMirror createMirrorForFQN(final String name) {
        Application _application = ApplicationManager.getApplication();
        Computable<IClassMirror> _function = new Computable<IClassMirror>(){

            public IClassMirror compute() {
                PsiClassMirror _xtrycatchfinallyexpression = null;
                try {
                    PsiClass _containingClass;
                    boolean _notEquals;
                    PsiClassMirror _xblockexpression = null;
                    Project _project = StubJvmTypeProvider.this.module.getProject();
                    JavaPsiFacade _instance = JavaPsiFacade.getInstance((Project)_project);
                    PsiClass psiClass = _instance.findClass(name, StubJvmTypeProvider.this.searchScope);
                    boolean _or = false;
                    boolean _equals = Objects.equal((Object)psiClass, null);
                    _or = _equals ? true : (_notEquals = !Objects.equal((Object)(_containingClass = psiClass.getContainingClass()), null));
                    if (_or) {
                        return null;
                    }
                    _xtrycatchfinallyexpression = _xblockexpression = new PsiClassMirror(psiClass, (ITypeFactory<PsiClass, JvmDeclaredType>)StubJvmTypeProvider.this.psiClassFactory);
                }
                catch (Throwable _t) {
                    if (_t instanceof IndexNotReadyException) {
                        IndexNotReadyException e = (IndexNotReadyException)_t;
                        ProcessCanceledException _processCanceledException = new ProcessCanceledException();
                        throw new OperationCanceledError((RuntimeException)_processCanceledException);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                return _xtrycatchfinallyexpression;
            }
        };
        return (IMirror)_application.runReadAction((Computable)_function);
    }

    protected GlobalSearchScope getSearchScope() {
        return this.searchScope;
    }

    @Pure
    public Module getModule() {
        return this.module;
    }

    @Pure
    public StubURIHelper getUriHelper() {
        return this.uriHelper;
    }
}

