/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.psi.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.indexing.IndexingDataKeys;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.idea.lang.IXtextLanguage;
import org.eclipse.xtext.idea.resource.IdeaResourceSetProvider;
import org.eclipse.xtext.idea.resource.PsiToEcoreAdapter;
import org.eclipse.xtext.idea.resource.PsiToEcoreTransformator;
import org.eclipse.xtext.idea.util.CancelProgressIndicator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.SyntheticCompositeNode;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.psi.PsiEObject;
import org.eclipse.xtext.psi.XtextPsiUtils;
import org.eclipse.xtext.psi.stubs.XtextFileStub;
import org.eclipse.xtext.psi.tree.IGrammarAwareElementType;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.jetbrains.annotations.NotNull;

public abstract class BaseXtextFile
extends PsiFileBase {
    public static final String GLOBAL_MODIFICATION_COUNT = "org.eclipse.xtext.psi.impl.BaseXtextFile.globalModificationCounter";
    @Inject
    protected IdeaResourceSetProvider resourceSetProvider;
    @Inject
    protected IResourceFactory resourceFactory;
    @Inject
    protected Provider<PsiToEcoreTransformator> psiToEcoreTransformatorProvider;
    @Inject
    protected OperationCanceledManager operationCanceledManager;
    protected final Object resourceCacheLock;
    protected final CachedValue<XtextResource> resourceCache;
    @Inject
    @Named(value="org.eclipse.xtext.psi.impl.BaseXtextFile.globalModificationCounter")
    protected Key globalModificationCount;

    protected BaseXtextFile(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        super(viewProvider, language);
        if (!(language instanceof IXtextLanguage)) {
            throw new IllegalArgumentException("Expected an Xtext language but got " + language.getDisplayName());
        }
        ((IXtextLanguage)language).injectMembers((Object)this);
        this.resourceCacheLock = new Object();
        this.resourceCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<XtextResource>(){

            public CachedValueProvider.Result<XtextResource> compute() {
                try {
                    XtextResource resource = BaseXtextFile.this.createResource();
                    return CachedValueProvider.Result.create((Object)resource, (Object[])new Object[]{BaseXtextFile.this.globalModificationCount, BaseXtextFile.this});
                }
                catch (OperationCanceledError e) {
                    throw e.getWrapped();
                }
            }
        }, false);
    }

    public IXtextLanguage getXtextLanguage() {
        return (IXtextLanguage)this.getLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XtextResource getResource() {
        Object object = this.resourceCacheLock;
        synchronized (object) {
            return (XtextResource)this.resourceCache.getValue();
        }
    }

    public INode getINode(ASTNode node) {
        return PsiToEcoreAdapter.get((Resource)this.getResource()).getNodesMapping().get(node);
    }

    public List<ASTNode> getASTNodes(INode node) {
        INode originalNode = this.findOriginalNode(node);
        List<ASTNode> astNodes = PsiToEcoreAdapter.get((Resource)this.getResource()).getReverseNodesMapping().get(originalNode);
        return this.filterASTNodes(node, astNodes);
    }

    protected INode findOriginalNode(INode node) {
        if (node instanceof SyntheticCompositeNode) {
            return this.findOriginalNode((INode)node.getParent());
        }
        return node;
    }

    protected List<ASTNode> filterASTNodes(INode node, List<ASTNode> astNodes) {
        if (astNodes == null) {
            return Collections.emptyList();
        }
        if (node instanceof SyntheticCompositeNode) {
            ArrayList<ASTNode> result = new ArrayList<ASTNode>();
            for (ASTNode astNode : astNodes) {
                IGrammarAwareElementType grammarAwareElementType;
                IElementType elementType = astNode.getElementType();
                if (!(elementType instanceof IGrammarAwareElementType) || (grammarAwareElementType = (IGrammarAwareElementType)elementType).getGrammarElement() != node.getGrammarElement()) continue;
                result.add(astNode);
            }
            return result;
        }
        return astNodes;
    }

    protected XtextResource createResource() {
        ProgressIndicatorProvider.checkCanceled();
        VirtualFile virtualFile = this.getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        PsiToEcoreTransformator psiToEcoreTransformator = (PsiToEcoreTransformator)this.psiToEcoreTransformatorProvider.get();
        psiToEcoreTransformator.setXtextFile(this);
        Module module = ProjectFileIndex.SERVICE.getInstance((Project)this.getProject()).getModuleForFile(this.findVirtualFile((PsiFile)this), false);
        if (module == null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this)) == null) {
            throw new IllegalStateException("Couldn't find module for " + (Object)((Object)this));
        }
        XtextResourceSet resourceSet = this.resourceSetProvider.get(module);
        XtextResource resource = (XtextResource)this.resourceFactory.createResource(this.getURI());
        resourceSet.getResources().add((Object)resource);
        resource.setParser((IParser)psiToEcoreTransformator);
        try {
            resource.load((InputStream)new ByteArrayInputStream(new byte[0]), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        psiToEcoreTransformator.getAdapter().install((Resource)resource);
        ProgressIndicatorProvider.checkCanceled();
        this.installDerivedState((Resource)resource);
        ProgressIndicatorProvider.checkCanceled();
        EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)new CancelProgressIndicator());
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installDerivedState(Resource resource) {
        ProgressIndicatorProvider.checkCanceled();
        if (resource instanceof DerivedStateAwareResource) {
            DerivedStateAwareResource derivedStateAwareResource = (DerivedStateAwareResource)resource;
            boolean deliver = derivedStateAwareResource.eDeliver();
            try {
                derivedStateAwareResource.eSetDeliver(false);
                derivedStateAwareResource.installDerivedState(false);
            }
            finally {
                derivedStateAwareResource.eSetDeliver(deliver);
            }
        }
    }

    protected VirtualFile findVirtualFile(PsiFile psiFile) {
        return XtextPsiUtils.findVirtualFile((PsiElement)psiFile);
    }

    public EObject getEObject(URI uri) {
        XtextResource resource = this.getResource();
        if (resource == null) {
            return null;
        }
        return resource.getEObject(uri.fragment());
    }

    public PsiEObject getRoot() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild instanceof PsiEObject) {
            return (PsiEObject)firstChild;
        }
        return null;
    }

    public URI getURI() {
        StubElement stub = this.getStub();
        if (stub instanceof XtextFileStub) {
            XtextFileStub xtextFileStub = (XtextFileStub)stub;
            return xtextFileStub.getUri();
        }
        return this.getPhysicalURI();
    }

    public URI getPhysicalURI() {
        PsiFile originalFile = this.getOriginalFile();
        if (originalFile != this && originalFile instanceof BaseXtextFile) {
            BaseXtextFile originalXtextFile = (BaseXtextFile)originalFile;
            return originalXtextFile.getURI();
        }
        VirtualFile virtualFile = (VirtualFile)this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            virtualFile = this.getViewProvider().getVirtualFile();
        }
        String url = virtualFile.getUrl();
        return URI.createURI((String)url);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ":" + this.getName();
    }
}

