/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.trace;

import com.google.common.base.Objects;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.internal.AbstractTrace;
import org.eclipse.xtext.idea.build.IdeaOutputConfigurationProvider;
import org.eclipse.xtext.idea.filesystem.IdeaProjectConfig;
import org.eclipse.xtext.idea.filesystem.IdeaProjectConfigProvider;
import org.eclipse.xtext.idea.filesystem.IdeaSourceFolder;
import org.eclipse.xtext.idea.resource.VirtualFileURIUtil;
import org.eclipse.xtext.idea.trace.IIdeaTrace;
import org.eclipse.xtext.idea.trace.ILocationInVirtualFile;
import org.eclipse.xtext.idea.trace.LocationInVirtualFile;
import org.eclipse.xtext.idea.trace.VirtualFileInProject;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class VirtualFileBasedTrace
extends AbstractTrace
implements IIdeaTrace {
    private VirtualFileInProject localVirtualFile;
    private IdeaOutputConfigurationProvider outputConfigurationProvider;
    private IdeaProjectConfigProvider projectConfigProvider;
    @Accessors(value={AccessorType.PROTECTED_SETTER, AccessorType.PUBLIC_GETTER})
    private IdeaProjectConfig localProjectConfig;
    @Accessors
    private VirtualFile jarRoot;

    public AbsoluteURI getLocalURI() {
        return this.getURIForVirtualFile(this.localVirtualFile);
    }

    public Module getLocalProject() {
        return this.localProjectConfig.getModule();
    }

    public VirtualFileInProject getLocalStorage() {
        return this.localVirtualFile;
    }

    protected void setLocalStorage(VirtualFileInProject localVirtualFile) {
        this.localVirtualFile = localVirtualFile;
    }

    protected void setOutputConfigurationProvider(IdeaOutputConfigurationProvider outputConfigurationProvider) {
        this.outputConfigurationProvider = outputConfigurationProvider;
    }

    protected void setProjectConfigProvider(IdeaProjectConfigProvider projectConfigProvider) {
        this.projectConfigProvider = projectConfigProvider;
    }

    protected AbsoluteURI getURIForVirtualFile(VirtualFile virtualFile) {
        URI _uRI = VirtualFileURIUtil.getURI(virtualFile);
        return new AbsoluteURI(_uRI);
    }

    protected AbsoluteURI getURIForVirtualFile(VirtualFileInProject virtualFile) {
        VirtualFile _file = virtualFile.getFile();
        return this.getURIForVirtualFile(_file);
    }

    public VirtualFileInProject findVirtualFileInProject(SourceRelativeURI srcRelativeLocation, Module module) {
        ModuleRootManager mngr = ModuleRootManager.getInstance((Module)module);
        VirtualFile[] sourceRoots = mngr.getSourceRoots(true);
        URI _uRI = srcRelativeLocation.getURI();
        String path = _uRI.path();
        for (VirtualFile sourceRoot : sourceRoots) {
            boolean _notEquals;
            VirtualFile result = sourceRoot.findFileByRelativePath(path);
            boolean bl = _notEquals = !Objects.equal((Object)result, null);
            if (!_notEquals) continue;
            Project _project = module.getProject();
            return new VirtualFileInProject(result, _project);
        }
        return null;
    }

    public AbsoluteURI resolvePath(SourceRelativeURI path) {
        Module _localProject;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)this.jarRoot, null);
        if (_notEquals) {
            String _string = path.toString();
            VirtualFile child = this.jarRoot.findFileByRelativePath(_string);
            URI uri = VirtualFileURIUtil.getURI(child);
            return new AbsoluteURI(uri);
        }
        boolean _and = false;
        boolean _isTraceToTarget = this.isTraceToTarget();
        _and = !_isTraceToTarget ? false : (_notEquals_1 = !Objects.equal((Object)(_localProject = this.getLocalProject()), null));
        if (_and) {
            Module _localProject_1 = this.getLocalProject();
            Set<OutputConfiguration> outputConfigurations = this.outputConfigurationProvider.getOutputConfigurations(_localProject_1);
            Set<? extends IdeaSourceFolder> sourceFolders = this.localProjectConfig.getSourceFolders();
            for (IdeaSourceFolder ideaSourceFolder : sourceFolders) {
                URI _uRI;
                String _string_1;
                VirtualFile file;
                String _name;
                OutputConfiguration _head;
                String _outputDirectory;
                VirtualFile _contentRoot = this.localProjectConfig.getContentRoot();
                VirtualFile outputFolder = _contentRoot.findFileByRelativePath(_outputDirectory = (_head = (OutputConfiguration)IterableExtensions.head(outputConfigurations)).getOutputDirectory(_name = ideaSourceFolder.getName()));
                if (outputFolder == null || (file = outputFolder.findFileByRelativePath(_string_1 = (_uRI = path.getURI()).toString())) == null) continue;
                URI _uRI_1 = VirtualFileURIUtil.getURI(file);
                return new AbsoluteURI(_uRI_1);
            }
        }
        return super.resolvePath(path);
    }

    public InputStream getContents(SourceRelativeURI uri, IProjectConfig projectConfig) throws IOException {
        Module _module = ((IdeaProjectConfig)projectConfig).getModule();
        return this.getContents(uri, _module);
    }

    public InputStream getContents(SourceRelativeURI uri, Module project) throws IOException {
        VirtualFileInProject file = this.findVirtualFileInProject(uri, project);
        VirtualFile _file = file.getFile();
        byte[] _contentsToByteArray = _file.contentsToByteArray();
        return new ByteArrayInputStream(_contentsToByteArray);
    }

    public Reader getContentsAsText(SourceRelativeURI uri, IProjectConfig projectConfig) throws IOException {
        Module _module = ((IdeaProjectConfig)projectConfig).getModule();
        return this.getContentsAsText(uri, _module);
    }

    public Reader getContentsAsText(SourceRelativeURI uri, Module project) throws IOException {
        VirtualFileInProject fileInProject = this.findVirtualFileInProject(uri, project);
        if (fileInProject == null) {
            String _name = project.getName();
            String _plus = "'" + _name;
            String _plus_1 = _plus + "' (";
            String _moduleFilePath = project.getModuleFilePath();
            String _plus_2 = _plus_1 + _moduleFilePath;
            String module = _plus_2 + ")";
            throw new FileNotFoundException("File '" + uri + "' not found in module " + module);
        }
        VirtualFile file = fileInProject.getFile();
        String _loadText = VfsUtil.loadText((VirtualFile)file);
        return new StringReader(_loadText);
    }

    protected Reader getLocalContentsAsText(IProjectConfig projectConfig) throws IOException {
        VirtualFile file = this.localVirtualFile.getFile();
        String _loadText = VfsUtil.loadText((VirtualFile)file);
        return new StringReader(_loadText);
    }

    public ILocationInVirtualFile getBestAssociatedLocation(ITextRegion region, VirtualFileInProject associatedVirtualFile) {
        AbsoluteURI uri = this.getURIForVirtualFile(associatedVirtualFile);
        return this.getBestAssociatedLocation(region, uri);
    }

    public Iterable<? extends ILocationInVirtualFile> getAllAssociatedLocations(ITextRegion localRegion, VirtualFileInProject associatedVirtualFile) {
        AbsoluteURI uri = this.getURIForVirtualFile(associatedVirtualFile);
        return this.getAllAssociatedLocations(localRegion, uri);
    }

    public Iterable<? extends ILocationInVirtualFile> getAllAssociatedLocations(VirtualFileInProject associatedVirtualFile) {
        AbsoluteURI uri = this.getURIForVirtualFile(associatedVirtualFile);
        return this.getAllAssociatedLocations(uri);
    }

    public ILocationInVirtualFile getBestAssociatedLocation(ITextRegion region) {
        ILocationInResource _bestAssociatedLocation = super.getBestAssociatedLocation(region);
        return (ILocationInVirtualFile)_bestAssociatedLocation;
    }

    public ILocationInVirtualFile createLocationInResource(ITextRegionWithLineInformation region, SourceRelativeURI srcRelativePath) {
        int _offset = region.getOffset();
        int _length = region.getLength();
        int _lineNumber = region.getLineNumber();
        int _endLineNumber = region.getEndLineNumber();
        return new LocationInVirtualFile(_offset, _length, _lineNumber, _endLineNumber, srcRelativePath, this);
    }

    public Iterable<? extends ILocationInVirtualFile> getAllAssociatedLocations(ITextRegion localRegion) {
        Iterable _allAssociatedLocations = super.getAllAssociatedLocations(localRegion);
        return _allAssociatedLocations;
    }

    public ILocationInVirtualFile getBestAssociatedLocation(ITextRegion localRegion, AbsoluteURI uri) {
        ILocationInResource _bestAssociatedLocation = super.getBestAssociatedLocation(localRegion, uri);
        return (ILocationInVirtualFile)_bestAssociatedLocation;
    }

    public Iterable<? extends ILocationInVirtualFile> getAllAssociatedLocations(ITextRegion localRegion, AbsoluteURI uri) {
        Iterable _allAssociatedLocations = super.getAllAssociatedLocations(localRegion, uri);
        return _allAssociatedLocations;
    }

    public Iterable<? extends ILocationInVirtualFile> getAllAssociatedLocations(AbsoluteURI uri) {
        Iterable _allAssociatedLocations = super.getAllAssociatedLocations(uri);
        return _allAssociatedLocations;
    }

    public Iterable<? extends ILocationInVirtualFile> getAllAssociatedLocations() {
        Iterable _allAssociatedLocations = super.getAllAssociatedLocations();
        return _allAssociatedLocations;
    }

    @Pure
    public IdeaProjectConfig getLocalProjectConfig() {
        return this.localProjectConfig;
    }

    protected void setLocalProjectConfig(IdeaProjectConfig localProjectConfig) {
        this.localProjectConfig = localProjectConfig;
    }

    @Pure
    public VirtualFile getJarRoot() {
        return this.jarRoot;
    }

    public void setJarRoot(VirtualFile jarRoot) {
        this.jarRoot = jarRoot;
    }
}

