/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XbaseEditorInputRedirector {
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private LanguageInfo languageInfo;
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public ITypeRoot getTypeRoot(IEditorInput it) {
        ITypeRoot _xblockexpression = null;
        Object adapter = it.getAdapter(IJavaElement.class);
        ITypeRoot _xifexpression = null;
        if (adapter instanceof ITypeRoot) {
            _xifexpression = (ITypeRoot)adapter;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public IEditorInput findOriginalSourceForOuputFolderCopy(IEditorInput input) {
        try {
            IProject _project;
            IJavaProject project;
            boolean _exists;
            IPath _fullPath;
            String _fileExtension;
            boolean _isValid;
            boolean _notEquals;
            IFile resource = ResourceUtil.getFile((IEditorInput)input);
            boolean bl = _notEquals = !Objects.equal((Object)resource, null);
            if (_notEquals && (_isValid = this.fileExtensionProvider.isValid(_fileExtension = (_fullPath = resource.getFullPath()).getFileExtension())) && (_exists = (project = JavaCore.create((IProject)(_project = resource.getProject()))).exists())) {
                IPath _fullPath_1;
                IPath _outputLocation = project.getOutputLocation();
                boolean _isPrefixOf = _outputLocation.isPrefixOf(_fullPath_1 = resource.getFullPath());
                if (_isPrefixOf) {
                    IPath _fullPath_2 = resource.getFullPath();
                    IPath _outputLocation_1 = project.getOutputLocation();
                    int _segmentCount = _outputLocation_1.segmentCount();
                    IPath relative = _fullPath_2.removeFirstSegments(_segmentCount);
                    IPackageFragmentRoot[] _packageFragmentRoots = project.getPackageFragmentRoots();
                    Functions.Function1<IPackageFragmentRoot, Boolean> _function = new Functions.Function1<IPackageFragmentRoot, Boolean>(){

                        public Boolean apply(IPackageFragmentRoot it) {
                            try {
                                int _kind = it.getKind();
                                return _kind == 1;
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_packageFragmentRoots)), (Functions.Function1)_function);
                    for (IPackageFragmentRoot source : _filter) {
                        IResource _correspondingResource = source.getCorrespondingResource();
                        IPath _projectRelativePath = _correspondingResource.getProjectRelativePath();
                        IPath fullPath = _projectRelativePath.append(relative);
                        IProject _project_1 = resource.getProject();
                        IFile newFile = _project_1.getFile(fullPath);
                        boolean _exists_1 = newFile.exists();
                        if (!_exists_1) continue;
                        return new FileEditorInput(newFile);
                    }
                }
                IClasspathEntry[] _rawClasspath = project.getRawClasspath();
                Functions.Function1<IClasspathEntry, Boolean> _function_1 = new Functions.Function1<IClasspathEntry, Boolean>(){

                    public Boolean apply(IClasspathEntry it) {
                        int _entryKind = it.getEntryKind();
                        return _entryKind == 3;
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_rawClasspath)), (Functions.Function1)_function_1);
                for (IClasspathEntry sourceFolder : _filter_1) {
                    boolean _notEquals_1;
                    boolean _and = false;
                    IPath _outputLocation_2 = sourceFolder.getOutputLocation();
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)_outputLocation_2, null);
                    if (!_notEquals_1) {
                        _and = false;
                    } else {
                        boolean _isPrefixOf_1;
                        IPath _outputLocation_3 = sourceFolder.getOutputLocation();
                        IPath _fullPath_3 = resource.getFullPath();
                        _and = _isPrefixOf_1 = _outputLocation_3.isPrefixOf(_fullPath_3);
                    }
                    if (!_and) continue;
                    IPath _fullPath_4 = resource.getFullPath();
                    IPath _outputLocation_4 = sourceFolder.getOutputLocation();
                    int _segmentCount_1 = _outputLocation_4.segmentCount();
                    IPath relative_1 = _fullPath_4.removeFirstSegments(_segmentCount_1);
                    IPackageFragmentRoot[] _findPackageFragmentRoots = project.findPackageFragmentRoots(sourceFolder);
                    IPackageFragmentRoot source_1 = (IPackageFragmentRoot)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_findPackageFragmentRoots)));
                    IResource _correspondingResource = source_1.getCorrespondingResource();
                    IPath _projectRelativePath = _correspondingResource.getProjectRelativePath();
                    IPath fullPath = _projectRelativePath.append(relative_1);
                    IProject _project_1 = resource.getProject();
                    IFile newFile = _project_1.getFile(fullPath);
                    boolean _exists_1 = newFile.exists();
                    if (!_exists_1) continue;
                    return new FileEditorInput(newFile);
                }
            }
            return input;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IEditorInput findOriginalSource(IEditorInput input) {
        boolean _notEquals;
        IFile resource = ResourceUtil.getFile((IEditorInput)input);
        boolean bl = _notEquals = !Objects.equal((Object)resource, null);
        if (_notEquals) {
            boolean _notEquals_1;
            IEditorInput original = this.findOriginalSourceForOuputFolderCopy(input);
            if (original != input) {
                return original;
            }
            ITrace trace = this.traceInformation.getTraceToSource((IStorage)resource);
            boolean _equals = Objects.equal((Object)trace, null);
            if (_equals) {
                return input;
            }
            Iterable _allAssociatedLocations = trace.getAllAssociatedLocations();
            Iterator allLocations = _allAssociatedLocations.iterator();
            ILocationInResource sourceInformation = null;
            while (allLocations.hasNext() && Objects.equal(sourceInformation, null)) {
                ILocationInResource candidate = (ILocationInResource)allLocations.next();
                LanguageInfo _language = candidate.getLanguage();
                boolean _equals_1 = this.languageInfo.equals((Object)_language);
                if (!_equals_1) continue;
                sourceInformation = candidate;
            }
            boolean _equals_1 = Objects.equal(sourceInformation, null);
            if (_equals_1) {
                return input;
            }
            IStorage originalStorage = sourceInformation.getStorage();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)originalStorage, null);
            if (_notEquals_1) {
                return EditorUtils.createEditorInput((IStorage)originalStorage);
            }
        }
        return input;
    }

    protected IPackageFragmentRoot _getPackageFragmentRoot(IJavaElement element) {
        IJavaElement _parent = element.getParent();
        return this.getPackageFragmentRoot(_parent);
    }

    protected IPackageFragmentRoot _getPackageFragmentRoot(IPackageFragmentRoot element) {
        return element;
    }

    protected IPackageFragmentRoot _getPackageFragmentRoot(Void element) {
        throw new IllegalStateException("couldn't find source package fragment root.");
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        if (element instanceof IPackageFragmentRoot) {
            return this._getPackageFragmentRoot((IPackageFragmentRoot)element);
        }
        if (element != null) {
            return this._getPackageFragmentRoot(element);
        }
        if (element == null) {
            return this._getPackageFragmentRoot((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }
}

