/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.textmate;

import com.google.common.base.Joiner;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.xtext.generator.textmate.AutoRule;
import org.eclipse.xtext.xtext.generator.textmate.BeginEndRule;
import org.eclipse.xtext.xtext.generator.textmate.IncludeRule;
import org.eclipse.xtext.xtext.generator.textmate.MatchRule;
import org.eclipse.xtext.xtext.generator.textmate.SkippedRule;
import org.eclipse.xtext.xtext.generator.textmate.TerminalRuleToTextMateRule;
import org.eclipse.xtext.xtext.generator.textmate.TextMateRule;

public class TextMateGrammar {
    @Expose
    private final List<TextMateRule> patterns;
    @Expose
    private String scopeName;
    @Expose
    private Map<String, TextMateRule> repository;
    private boolean inferPatterns = true;
    private boolean ignoreCase = false;
    private TerminalRuleToTextMateRule generator = new TerminalRuleToTextMateRule();

    public TextMateGrammar() {
        this.patterns = new ArrayList<TextMateRule>();
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public void setScopeName(String scopeName) {
        this.scopeName = scopeName;
    }

    public boolean isInferPatterns() {
        return this.inferPatterns;
    }

    public void setInferPatterns(boolean inferPatterns) {
        this.inferPatterns = inferPatterns;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public TerminalRuleToTextMateRule getGenerator() {
        return this.generator;
    }

    public void setGenerator(TerminalRuleToTextMateRule generator) {
        this.generator = generator;
    }

    public void addSkip(SkippedRule rule) {
        this.patterns.add(rule);
    }

    public void addAuto(AutoRule rule) {
        this.patterns.add(rule);
    }

    public void addMatch(MatchRule rule) {
        this.patterns.add(rule);
    }

    public void addInclude(String include) {
        this.patterns.add(new IncludeRule(include));
    }

    public void addBeginEnd(BeginEndRule rule) {
        this.patterns.add(rule);
    }

    public void addRepositoryMatch(MatchRule rule) {
        if (this.repository == null) {
            this.repository = new TreeMap<String, TextMateRule>();
        }
        this.repository.put(rule.getName(), rule);
        rule.setName(null);
    }

    public void addRepositoryBeginEnd(BeginEndRule rule) {
        if (this.repository == null) {
            this.repository = new TreeMap<String, TextMateRule>();
        }
        this.repository.put(rule.getName(), rule);
        rule.setName(null);
    }

    public void addRule(TextMateRule rule) {
        this.patterns.add(rule);
    }

    protected TextMateGrammar init(Grammar grammar) {
        Object scopeName = this.scopeName;
        if (scopeName == null) {
            scopeName = "source." + this.getLanguageName(grammar);
        }
        TextMateGrammar result = new TextMateGrammar();
        result.setScopeName((String)scopeName);
        TextMateRule keywords = this.getKeywordControlRule(grammar, this.ignoreCase);
        result.addRule(keywords);
        HashSet<String> seenTerminalRules = new HashSet<String>();
        for (TextMateRule pattern : this.patterns) {
            seenTerminalRules.add(pattern.getTerminalRule());
            if (pattern instanceof SkippedRule) continue;
            if (pattern instanceof AutoRule) {
                ((AutoRule)pattern).init(grammar, this.ignoreCase, this.generator).ifPresent(result::addRule);
                continue;
            }
            result.addRule(pattern);
        }
        if (this.inferPatterns) {
            List terminals = GrammarUtil.allTerminalRules((Grammar)grammar).stream().filter(r -> !r.isFragment()).collect(Collectors.toList());
            for (TerminalRule terminal : terminals) {
                if (!seenTerminalRules.add(terminal.getName())) continue;
                AutoRule auto = this.newAutoRule();
                auto.setTerminalRule(terminal.getName());
                auto.init(grammar, this.ignoreCase, this.generator).ifPresent(result::addRule);
            }
        }
        return result;
    }

    protected AutoRule newAutoRule() {
        return new AutoRule();
    }

    protected String getLanguageName(Grammar grammar) {
        return GrammarUtil.getSimpleName((Grammar)grammar).toLowerCase(Locale.ROOT);
    }

    protected TextMateRule getKeywordControlRule(Grammar grammar, boolean ignoreCase) {
        StringBuilder matchBuilder = new StringBuilder();
        if (ignoreCase) {
            matchBuilder.append("(?i)");
        }
        matchBuilder.append("\\b(");
        List allKeywords = GrammarUtil.getAllKeywords((Grammar)grammar).stream().filter(s -> s.matches("\\w+")).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        matchBuilder.append(Joiner.on((String)"|").join(allKeywords));
        matchBuilder.append(")\\b");
        MatchRule result = new MatchRule();
        result.setName("keyword.control." + this.getLanguageName(grammar));
        result.setMatch(matchBuilder.toString());
        return result;
    }
}

