/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.embedded;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.xtext.ui.editor.embedded.ActionActivationCode;
import org.eclipse.xtext.ui.editor.embedded.ActionDefinitionToStyledTextAction;
import org.eclipse.xtext.ui.editor.embedded.ActivationCodeTrigger;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorMessages;
import org.eclipse.xtext.ui.editor.embedded.TextViewerAction;
import org.eclipse.xtext.ui.editor.embedded.TextViewerDeleteLineAction;
import org.eclipse.xtext.ui.editor.embedded.TextViewerJoinLinesAction;
import org.eclipse.xtext.ui.editor.embedded.TextViewerMarkAction;
import org.eclipse.xtext.ui.editor.embedded.TextViewerMoveLinesAction;
import org.eclipse.xtext.ui.editor.embedded.TextViewerOperationAction;
import org.eclipse.xtext.ui.editor.embedded.TextViewerShiftAction;

public class EmbeddedEditorActions {
    public static final String EMBEDDED_TEXT_EDITOR_SCOPE = "org.eclipse.xtext.ui.embeddedTextEditorScope";
    protected static final ActionDefinitionToStyledTextAction[] ACTION_MAP = new ActionDefinitionToStyledTextAction[]{new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.lineUp", 0x1000001), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.lineDown", 0x1000002), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.lineStart", 0x1000007), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.lineEnd", 0x1000008), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.columnPrevious", 0x1000003), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.columnNext", 0x1000004), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.pageUp", 0x1000005), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.pageDown", 0x1000006), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.wordPrevious", 17039363), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.wordNext", 0x1040004), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.textStart", 17039367), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.textEnd", 17039368), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.windowStart", 17039365), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.goto.windowEnd", 17039366), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.lineUp", 0x1020001), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.lineDown", 0x1020002), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.lineStart", 16908295), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.lineEnd", 16908296), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.columnPrevious", 16908291), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.columnNext", 16908292), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.pageUp", 16908293), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.pageDown", 16908294), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.wordPrevious", 17170435), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.wordNext", 17170436), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.textStart", 17170439), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.textEnd", 17170440), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.windowStart", 17170437), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.select.windowEnd", 0x1060006), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.deletePrevious", 8), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.deleteNext", 127), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.deletePreviousWord", 262152), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.deleteNextWord", 262271), new ActionDefinitionToStyledTextAction("org.eclipse.ui.edit.text.toggleOverwrite", 0x1000009)};
    protected final Map<String, IAction> allActions = Maps.newHashMap();
    protected final ISourceViewer viewer;
    protected final IWorkbench workbench;

    public EmbeddedEditorActions(ISourceViewer viewer, IWorkbench workbench) {
        this.viewer = viewer;
        this.workbench = workbench;
        this.initialize();
    }

    protected void initialize() {
        this.createFocusAndDisposeListeners();
        this.createActions();
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EmbeddedEditorActions.this.fillContextMenu(mgr);
            }
        });
        StyledText text = this.viewer.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
        ArrayList activationCodes = Lists.newArrayList();
        this.setActionActivationCode(activationCodes, "ShiftRightTab", '\t', -1, 0);
        this.setActionActivationCode(activationCodes, "ShiftLeft", '\t', -1, 131072);
        this.viewer.getTextWidget().addVerifyKeyListener((VerifyKeyListener)new ActivationCodeTrigger(this.allActions, activationCodes));
    }

    protected void createFocusAndDisposeListeners() {
        final ArrayList handlerActivations = Lists.newArrayListWithExpectedSize((int)3);
        final IHandlerService handlerService = (IHandlerService)this.workbench.getAdapter(IHandlerService.class);
        final IContextService contextService = (IContextService)this.workbench.getAdapter(IContextService.class);
        Shell shell = this.viewer.getTextWidget().getShell();
        final ActiveShellExpression expression = new ActiveShellExpression(shell);
        final IContextActivation contextActivation = contextService.activateContext(EMBEDDED_TEXT_EDITOR_SCOPE, (Expression)expression);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                handlerService.deactivateHandlers((Collection)handlerActivations);
                contextService.deactivateContext(contextActivation);
            }
        });
        this.viewer.getTextWidget().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                handlerService.deactivateHandlers((Collection)handlerActivations);
                handlerActivations.clear();
            }

            public void focusGained(FocusEvent e) {
                for (IAction action : EmbeddedEditorActions.this.allActions.values()) {
                    handlerActivations.add(handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action), (Expression)expression, true));
                }
            }
        });
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", this.allActions.get(ITextEditorActionConstants.UNDO));
        menu.appendToGroup("group.undo", this.allActions.get(ITextEditorActionConstants.REDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", this.allActions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", this.allActions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", this.allActions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", this.allActions.get(ITextEditorActionConstants.SELECT_ALL));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.appendToGroup("group.generate", this.allActions.get("ContentAssistProposal"));
    }

    protected void setActionActivationCode(List<ActionActivationCode> activationCodes, String actionID, char activationCharacter, int activationKeyCode, int activationStateMask) {
        ActionActivationCode found = this.findActionActivationCode(activationCodes, actionID);
        if (found == null) {
            found = new ActionActivationCode(actionID);
            activationCodes.add(found);
        }
        found.fCharacter = activationCharacter;
        found.fKeyCode = activationKeyCode;
        found.fStateMask = activationStateMask;
    }

    protected ActionActivationCode findActionActivationCode(List<ActionActivationCode> activationCodes, String actionID) {
        int size = activationCodes.size();
        int i = 0;
        while (i < size) {
            ActionActivationCode code = activationCodes.get(i);
            if (actionID.equals(code.fActionId)) {
                return code;
            }
            ++i;
        }
        return null;
    }

    protected void createActions() {
        StyledText textWidget = this.viewer.getTextWidget();
        int i = 0;
        while (i < ACTION_MAP.length) {
            ActionDefinitionToStyledTextAction entry = ACTION_MAP[i];
            TextNavigationAction action = new TextNavigationAction(textWidget, entry.getAction());
            action.setActionDefinitionId(entry.getActionId());
            this.setAction(entry.getActionId(), (IAction)action);
            ++i;
        }
        TextViewerAction action = new TextViewerOperationAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.Undo.", (ITextViewer)this.viewer, 1);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.UNDO_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.setAction(ITextEditorActionConstants.UNDO, (IAction)action);
        action = new TextViewerOperationAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.Redo.", (ITextViewer)this.viewer, 2);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.REDO_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.setAction(ITextEditorActionConstants.REDO, (IAction)action);
        action = new TextViewerOperationAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.Cut.", (ITextViewer)this.viewer, 3);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.CUT_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.setAction(ITextEditorActionConstants.CUT, (IAction)action);
        action = new TextViewerOperationAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.Copy.", (ITextViewer)this.viewer, 4, true);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.COPY_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.setAction(ITextEditorActionConstants.COPY, (IAction)action);
        action = new TextViewerOperationAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.Paste.", (ITextViewer)this.viewer, 5);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.PASTE_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.setAction(ITextEditorActionConstants.PASTE, (IAction)action);
        action = new TextViewerOperationAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.Delete.", (ITextViewer)this.viewer, 6);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.DELETE_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setAction(ITextEditorActionConstants.DELETE, (IAction)action);
        action = new TextViewerDeleteLineAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.DeleteLine.", (ITextViewer)this.viewer, 0, false);
        action.setHelpContextId("org.eclipse.ui.DeleteLine_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.delete.line");
        this.setAction("DeleteLine", (IAction)action);
        action = new TextViewerDeleteLineAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.CutLine.", (ITextViewer)this.viewer, 0, true);
        action.setHelpContextId("org.eclipse.ui.CutLine_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.cut.line");
        this.setAction("CutLine", (IAction)action);
        action = new TextViewerDeleteLineAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.DeleteLineToBeginning.", (ITextViewer)this.viewer, 1, false);
        action.setHelpContextId("org.eclipse.ui.DeleteLineToBeginning_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.delete.line.to.beginning");
        this.setAction("DeleteLineToBeginning", (IAction)action);
        action = new TextViewerDeleteLineAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.CutLineToBeginning.", (ITextViewer)this.viewer, 1, true);
        action.setHelpContextId("org.eclipse.ui.CutLineToBeginning_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.cut.line.to.beginning");
        this.setAction("CutLineToBeginning", (IAction)action);
        action = new TextViewerDeleteLineAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.DeleteLineToEnd.", (ITextViewer)this.viewer, 2, false);
        action.setHelpContextId("org.eclipse.ui.DeleteLineToEnd_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.delete.line.to.end");
        this.setAction("DeleteLineToEnd", (IAction)action);
        action = new TextViewerDeleteLineAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.CutLineToEnd.", (ITextViewer)this.viewer, 2, true);
        action.setHelpContextId("org.eclipse.ui.CutLineToEnd_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.cut.line.to.end");
        this.setAction("CutLineToEnd", (IAction)action);
        action = new TextViewerJoinLinesAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.JoinLines.", (ITextViewer)this.viewer, " ");
        action.setHelpContextId("org.eclipse.ui.JoinLines_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.join.lines");
        this.setAction("JoinLines", (IAction)action);
        action = new TextViewerMarkAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.SetMark.", (ITextViewer)this.viewer, 0);
        action.setHelpContextId("org.eclipse.ui.SetMark_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.set.mark");
        this.setAction("SetMark", (IAction)action);
        action = new TextViewerMarkAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.ClearMark.", (ITextViewer)this.viewer, 1);
        action.setHelpContextId("org.eclipse.ui.ClearMark_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.clear.mark");
        this.setAction("ClearMark", (IAction)action);
        action = new TextViewerMarkAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.SwapMark.", (ITextViewer)this.viewer, 2);
        action.setHelpContextId("org.eclipse.ui.SwapMark_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.swap.mark");
        this.setAction("SwapMark", (IAction)action);
        action = new TextViewerShiftAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.ShiftRight.", (ITextViewer)this.viewer, 8);
        action.setHelpContextId("org.eclipse.ui.ShiftRight_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.shiftRight");
        this.setAction("ShiftRight", (IAction)action);
        action = new TextViewerShiftAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.ShiftRight.", (ITextViewer)this.viewer, 8){

            @Override
            public void update() {
                this.updateForTab();
            }
        };
        action.setActionDefinitionId("ShiftRightTab");
        this.setAction("ShiftRightTab", (IAction)action);
        action = new TextViewerShiftAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.ShiftLeft.", (ITextViewer)this.viewer, 9);
        action.setHelpContextId("org.eclipse.ui.ShiftLeft_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.shiftLeft");
        this.setAction("ShiftLeft", (IAction)action);
        action = new TextViewerOperationAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.ContentAssist.", (ITextViewer)this.viewer, 13);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        action = new TextViewerOperationAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.SelectAll.", (ITextViewer)this.viewer, 7, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.setAction(ITextEditorActionConstants.SELECT_ALL, (IAction)action);
        action = new TextViewerMoveLinesAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.MoveLinesUp.", (ITextViewer)this.viewer, true, false);
        action.setHelpContextId("org.eclipse.ui.move_lines_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineUp");
        this.setAction("MoveLineUp", (IAction)action);
        action = new TextViewerMoveLinesAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.MoveLinesDown.", (ITextViewer)this.viewer, false, false);
        action.setHelpContextId("org.eclipse.ui.move_lines_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineDown");
        this.setAction("MoveLineDown", (IAction)action);
        action = new TextViewerMoveLinesAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.CopyLineUp.", (ITextViewer)this.viewer, true, true);
        action.setHelpContextId("org.eclipse.ui.copy_lines_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.copyLineUp");
        this.setAction("CopyLineUp", (IAction)action);
        action = new TextViewerMoveLinesAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.CopyLineDown.", (ITextViewer)this.viewer, false, true);
        action.setHelpContextId("org.eclipse.ui.copy_lines_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.copyLineDown");
        this.setAction("CopyLineDown", (IAction)action);
        action = new TextViewerOperationAction(EmbeddedEditorMessages.getBundleForConstructedKeys(), "Editor.QuickAssist.", (ITextViewer)this.viewer, 22);
        action.setHelpContextId("org.eclipse.ui.quick_assist_action_context");
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        this.setAction("QuickAssist", (IAction)action);
    }

    protected void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            this.allActions.remove(actionID);
        } else {
            if (action.getId() == null) {
                action.setId(actionID);
            }
            this.allActions.put(actionID, action);
        }
    }

    protected IAction get(String actionId) {
        return this.allActions.get(actionId);
    }

    protected void updateAllActions() {
        for (IAction action : this.allActions.values()) {
            this.update(action);
        }
    }

    protected void updateSelectionDependentActions() {
        this.updateAllActions();
    }

    protected void updateAction(String actionId) {
        IAction action = this.get(actionId);
        this.update(action);
    }

    private void update(IAction action) {
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    public static class Factory {
        @Inject(optional=true)
        protected IWorkbench workbench;

        protected EmbeddedEditorActions createActions(ISourceViewer viewer) {
            return new EmbeddedEditorActions(viewer, this.workbench);
        }
    }
}

