/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.DescriptionUtils;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.editor.IDirtyStateManagerExtension;
import org.eclipse.xtext.ui.editor.IValidationJobScheduler;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class ValidationJobScheduler
implements IValidationJobScheduler {
    @Inject
    private IDirtyStateManager dirtyStateManager;
    @Inject
    private IResourceDescriptions resourceDescriptions;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.builder.impl.PersistentDataAwareDirtyResource.PERSISTED_DESCRIPTIONS")
    private Provider<IResourceDescriptions> builderStateProvider;
    @Inject
    private IResourceDescription.Manager resourceDescriptionManager;
    @Inject
    private DescriptionUtils descriptionUtils;

    @Override
    public void scheduleInitialValidation(IXtextDocument document) {
        if (!(document instanceof XtextDocument)) {
            return;
        }
        this.doScheduleInitialValidation((XtextDocument)document);
    }

    protected void doScheduleInitialValidation(XtextDocument document) {
        URI uri = document.getResourceURI();
        if (uri == null) {
            return;
        }
        IResourceDescription documentDescription = this.resourceDescriptions.getResourceDescription(uri);
        if (documentDescription == null) {
            return;
        }
        if (this.dirtyStateManager instanceof IDirtyStateManagerExtension && this.builderStateProvider != null) {
            IResourceDescriptions persistedDescriptions = (IResourceDescriptions)this.builderStateProvider.get();
            List<URI> dirtyResourceURIs = ((IDirtyStateManagerExtension)((Object)this.dirtyStateManager)).getDirtyResourceURIs();
            for (URI dirtyResourceURI : dirtyResourceURIs) {
                IResourceDescription persistedDescription;
                ChangedResourceDescriptionDelta delta;
                IResourceDescription dirtyDescription = this.dirtyStateManager.getDirtyResourceDescription(dirtyResourceURI);
                if (dirtyDescription == null || !this.resourceDescriptionManager.isAffected((IResourceDescription.Delta)(delta = new ChangedResourceDescriptionDelta(persistedDescription = persistedDescriptions.getResourceDescription(dirtyResourceURI), dirtyDescription)), documentDescription)) continue;
                document.checkAndUpdateAnnotations();
                return;
            }
        } else {
            Set outgoingReferences = this.descriptionUtils.collectOutgoingReferences(documentDescription);
            for (URI outgoing : outgoingReferences) {
                if (!this.isDirty(outgoing)) continue;
                document.checkAndUpdateAnnotations();
                return;
            }
        }
    }

    protected boolean isDirty(URI uri) {
        return this.dirtyStateManager.hasContent(uri);
    }

    protected IDirtyStateManager getDirtyStateManager() {
        return this.dirtyStateManager;
    }

    public void setDirtyStateManager(IDirtyStateManager dirtyStateManager) {
        this.dirtyStateManager = dirtyStateManager;
    }

    protected IResourceDescriptions getResourceDescriptions() {
        return this.resourceDescriptions;
    }

    public void setResourceDescriptions(IResourceDescriptions resourceDescriptions) {
        this.resourceDescriptions = resourceDescriptions;
    }

    protected DescriptionUtils getDescriptionUtils() {
        return this.descriptionUtils;
    }

    public void setDescriptionUtils(DescriptionUtils descriptionUtils) {
        this.descriptionUtils = descriptionUtils;
    }

    public void setBuilderStateProvider(Provider<IResourceDescriptions> provider) {
        this.builderStateProvider = provider;
    }

    public void setResourceDescriptionManager(IResourceDescription.Manager resourceDescriptionManager) {
        this.resourceDescriptionManager = resourceDescriptionManager;
    }
}

