/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.jdt;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmByteAnnotationValue;
import org.eclipse.xtext.common.types.JvmCharAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDoubleAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFloatAnnotationValue;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmLongAnnotationValue;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmShortAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractDeclaredTypeFactory;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.common.types.impl.JvmExecutableImplCustom;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.internal.Stopwatches;

public class JdtBasedTypeFactory
extends AbstractDeclaredTypeFactory
implements ITypeFactory<IType, JvmDeclaredType>,
ITypeFactory.OptionsAware<IType, JvmDeclaredType> {
    private static final Logger log = Logger.getLogger(JdtBasedTypeFactory.class);
    private final TypeURIHelper uriHelper;
    private final WorkingCopyOwner workingCopyOwner;
    private final Map<ITypeBinding, JvmType> typeProxies = new HashMap<ITypeBinding, JvmType>();
    private final Map<IMethodBinding, JvmOperation> operationProxies = new HashMap<IMethodBinding, JvmOperation>();
    private final Map<ITypeBinding, JvmAnnotationType> annotationProxies = new HashMap<ITypeBinding, JvmAnnotationType>();
    private final Map<IVariableBinding, JvmEnumerationLiteral> enumerationLiteralProxies = new HashMap<IVariableBinding, JvmEnumerationLiteral>();
    private final Map<ITypeBinding, String> qualifiedNames = new HashMap<ITypeBinding, String>();
    private final ASTParser parser = ASTParser.newParser((int)3);
    private ITypeBinding stringTypeBinding;
    private ITypeBinding classTypeBinding;
    private Stopwatches.StoppedTask resolveAnnotations = Stopwatches.forTask((String)"resolve annotations (JdtBasedTypeFactory)");
    private Stopwatches.StoppedTask resolveMembers = Stopwatches.forTask((String)"resolve members (JdtBasedTypeFactory)");
    private Stopwatches.StoppedTask resolveTypeParams = Stopwatches.forTask((String)"resolve typeParams (JdtBasedTypeFactory)");
    private Stopwatches.StoppedTask resolveBinding = Stopwatches.forTask((String)"resolve binding (JdtBasedTypeFactory)");
    private Stopwatches.StoppedTask createType = Stopwatches.forTask((String)"JdtBasedTypeFactory.createType (JdtBasedTypeFactory)");

    @Deprecated
    public JdtBasedTypeFactory(TypeURIHelper uriHelper) {
        this(uriHelper, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public JdtBasedTypeFactory(TypeURIHelper uriHelper, WorkingCopyOwner workingCopyOwner) {
        this.uriHelper = uriHelper;
        this.workingCopyOwner = workingCopyOwner;
    }

    public JvmDeclaredType createType(IType jdtType) {
        IJavaProject project = jdtType.getJavaProject();
        return this.createType(jdtType, project);
    }

    protected JvmDeclaredType createType(IType jdtType, IJavaProject javaProject) {
        if (jdtType.getDeclaringType() != null) {
            throw new IllegalArgumentException("Cannot create type from non-toplevel-type: '" + jdtType.getFullyQualifiedName() + "'.");
        }
        IBinding binding = null;
        IllegalArgumentException cause = null;
        try {
            binding = this.resolveBindings(jdtType, javaProject);
        }
        catch (IllegalArgumentException e) {
            cause = e;
        }
        if (binding == null) {
            IJavaProject fallbackProject = jdtType.getJavaProject();
            if (!fallbackProject.equals(javaProject)) {
                try {
                    binding = this.resolveBindings(jdtType, fallbackProject);
                }
                catch (IllegalArgumentException e) {
                    cause = e;
                }
                if (binding == null) {
                    throw new IllegalStateException("Could not create binding for '" + jdtType.getFullyQualifiedName() + "' in context of projects '" + javaProject.getElementName() + "' and '" + fallbackProject.getElementName() + "'.", cause);
                }
            } else {
                throw new IllegalStateException("Could not create binding for '" + jdtType.getFullyQualifiedName() + "' in context of project '" + javaProject.getElementName() + "'.", cause);
            }
        }
        if (binding instanceof ITypeBinding) {
            this.createType.start();
            ITypeBinding typeBinding = (ITypeBinding)binding;
            this.setMayTolerateMissingType(typeBinding);
            JvmDeclaredType result = this.createType(jdtType, typeBinding);
            this.clearCache();
            this.createType.stop();
            return result;
        }
        throw new IllegalStateException("Expected ITypeBinding for '" + jdtType.getFullyQualifiedName() + "', but got '" + binding.toString() + "'.", cause);
    }

    protected void setMayTolerateMissingType(ITypeBinding typeBinding) {
        try {
            Field field = typeBinding.getClass().getDeclaredField("binding");
            field.setAccessible(true);
            Object object = field.get(typeBinding);
            if (object instanceof BinaryTypeBinding) {
                BinaryTypeBinding binaryTypeBinding = (BinaryTypeBinding)object;
                Field declaredField = binaryTypeBinding.getClass().getDeclaredField("environment");
                declaredField.setAccessible(true);
                LookupEnvironment env = (LookupEnvironment)declaredField.get(binaryTypeBinding);
                env.mayTolerateMissingType = true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private IBinding resolveBindings(IType jdtType, IJavaProject javaProject) {
        ThreadLocal abortOnMissingSource = JavaModelManager.getJavaModelManager().abortOnMissingSource;
        Boolean wasAbortOnMissingSource = (Boolean)abortOnMissingSource.get();
        try {
            abortOnMissingSource.set(Boolean.TRUE);
            this.resolveBinding.start();
            this.parser.setWorkingCopyOwner(this.workingCopyOwner);
            this.parser.setIgnoreMethodBodies(true);
            this.parser.setProject(javaProject);
            Map options = javaProject.getOptions(true);
            options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "disabled");
            this.parser.setCompilerOptions(options);
            IBinding[] bindings = this.parser.createBindings(new IJavaElement[]{jdtType}, null);
            this.resolveBinding.stop();
            IBinding iBinding = bindings[0];
            return iBinding;
        }
        finally {
            abortOnMissingSource.set(wasAbortOnMissingSource);
        }
    }

    public JvmDeclaredType createType(IType type, TypeResource resource, Map<?, ?> options) {
        Object project;
        IJavaProject javaProject;
        if (resource == null) {
            return this.createType(type);
        }
        if (options != null && (javaProject = (IJavaProject)options.get("OPTION_CLASSPATH_CONTEXT")) != null) {
            return this.createType(type, javaProject);
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet instanceof XtextResourceSet && (project = ((XtextResourceSet)resourceSet).getClasspathURIContext()) instanceof IJavaProject) {
            return this.createType(type, (IJavaProject)project);
        }
        return this.createType(type);
    }

    private void clearCache() {
        this.typeProxies.clear();
        this.operationProxies.clear();
        this.annotationProxies.clear();
        this.qualifiedNames.clear();
        this.enumerationLiteralProxies.clear();
        this.stringTypeBinding = null;
        this.classTypeBinding = null;
    }

    private JvmDeclaredType createType(IType type, ITypeBinding binding) {
        StringBuilder fqn = new StringBuilder(100);
        IPackageBinding packageBinding = binding.getPackage();
        String packageName = null;
        if (packageBinding != null && !packageBinding.isUnnamed()) {
            packageName = packageBinding.getName();
            fqn.append(packageBinding.getName());
            fqn.append('.');
        }
        JvmDeclaredType result = this.createType(binding, type.getHandleIdentifier(), Lists.newArrayList(), fqn);
        result.setPackageName(packageName);
        return result;
    }

    protected JvmDeclaredType createType(ITypeBinding typeBinding, String handleIdentifier, List<String> path, StringBuilder fqn) {
        ITypeBinding[] typeParameterBindings;
        JvmAnnotationType result;
        JvmGenericType jvmGenericType;
        if (typeBinding.isAnonymous() || typeBinding.isSynthetic()) {
            throw new IllegalStateException("Cannot create type for anonymous or synthetic classes");
        }
        if (typeBinding.isAnnotation()) {
            jvmGenericType = null;
            result = TypesFactory.eINSTANCE.createJvmAnnotationType();
        } else if (typeBinding.isEnum()) {
            jvmGenericType = null;
            result = TypesFactory.eINSTANCE.createJvmEnumerationType();
        } else {
            jvmGenericType = TypesFactory.eINSTANCE.createJvmGenericType();
            result = jvmGenericType;
            jvmGenericType.setInterface(typeBinding.isInterface());
        }
        int modifiers = typeBinding.getModifiers();
        this.setTypeModifiers((JvmDeclaredType)result, modifiers);
        result.setDeprecated(typeBinding.isDeprecated());
        this.setVisibility((JvmMember)result, modifiers);
        String simpleName = typeBinding.getName();
        fqn.append(simpleName);
        int length = fqn.length();
        int size = path.size();
        path.add(simpleName);
        String qualifiedName = fqn.toString();
        result.internalSetIdentifier(qualifiedName);
        result.setSimpleName(simpleName);
        fqn.append('$');
        this.createNestedTypes(typeBinding, (JvmDeclaredType)result, handleIdentifier, path, fqn);
        fqn.setLength(length);
        fqn.append('.');
        this.createMethods(typeBinding, handleIdentifier, path, fqn, (JvmDeclaredType)result);
        this.createFields(typeBinding, fqn, (JvmDeclaredType)result);
        this.setSuperTypes(typeBinding, qualifiedName, (JvmDeclaredType)result);
        if (jvmGenericType != null && (typeParameterBindings = typeBinding.getTypeParameters()).length > 0) {
            InternalEList typeParameters = (InternalEList)jvmGenericType.getTypeParameters();
            ITypeBinding[] iTypeBindingArray = typeParameterBindings;
            int n = typeParameterBindings.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding variable = iTypeBindingArray[n2];
                typeParameters.addUnique((Object)this.createTypeParameter(variable, (JvmMember)result));
                ++n2;
            }
        }
        this.createAnnotationValues((IBinding)typeBinding, (JvmAnnotationTarget)result);
        path.remove(size);
        return result;
    }

    protected void createFields(ITypeBinding typeBinding, StringBuilder qualifiedName, JvmDeclaredType result) {
        this.resolveMembers.start();
        IVariableBinding[] declaredFields = typeBinding.getDeclaredFields();
        if (declaredFields.length > 0) {
            int length = qualifiedName.length();
            InternalEList members = (InternalEList)result.getMembers();
            IVariableBinding[] iVariableBindingArray = declaredFields;
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableBinding field = iVariableBindingArray[n2];
                if (!field.isSynthetic()) {
                    members.addUnique((Object)this.createField(qualifiedName, field));
                    qualifiedName.setLength(length);
                }
                ++n2;
            }
        }
        this.resolveMembers.stop();
    }

    protected String getQualifiedName(ITypeBinding binding) {
        String qualifiedName = this.qualifiedNames.get(binding);
        if (qualifiedName == null) {
            qualifiedName = this.uriHelper.getQualifiedName(binding);
            this.qualifiedNames.put(binding, qualifiedName);
        }
        return qualifiedName;
    }

    protected void createAnnotationValues(IBinding annotated, JvmAnnotationTarget result) {
        try {
            try {
                this.resolveAnnotations.start();
                IAnnotationBinding[] annotationBindings = annotated.getAnnotations();
                if (annotationBindings.length != 0) {
                    InternalEList annotations = (InternalEList)result.getAnnotations();
                    IAnnotationBinding[] iAnnotationBindingArray = annotationBindings;
                    int n = annotationBindings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotationBinding annotation = iAnnotationBindingArray[n2];
                        annotations.addUnique((Object)this.createAnnotationReference(annotation));
                        ++n2;
                    }
                }
            }
            catch (AbortCompilation aborted) {
                if (aborted.problem.getID() != 0x1000144) {
                    log.info((Object)("Couldn't resolve annotations of " + String.valueOf(annotated)), (Throwable)aborted);
                }
                this.resolveAnnotations.stop();
            }
        }
        finally {
            this.resolveAnnotations.stop();
        }
    }

    protected JvmAnnotationReference createAnnotationReference(IAnnotationBinding annotation) {
        IMemberValuePairBinding[] allMemberValuePairs;
        JvmAnnotationReference annotationReference = TypesFactory.eINSTANCE.createJvmAnnotationReference();
        ITypeBinding annotationType = annotation.getAnnotationType();
        annotationReference.setAnnotation(this.createAnnotationProxy(annotationType));
        InternalEList values = (InternalEList)annotationReference.getExplicitValues();
        IMemberValuePairBinding[] iMemberValuePairBindingArray = allMemberValuePairs = annotation.getDeclaredMemberValuePairs();
        int n = allMemberValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IMemberValuePairBinding memberValuePair = iMemberValuePairBindingArray[n2];
                IMethodBinding methodBinding = memberValuePair.getMethodBinding();
                if (methodBinding != null) {
                    try {
                        values.addUnique((Object)this.createAnnotationValue(annotationType, memberValuePair.getValue(), methodBinding));
                    }
                    catch (NullPointerException npe) {
                        if (methodBinding.getReturnType() != null) {
                            throw npe;
                        }
                        if (!log.isDebugEnabled()) break block5;
                        log.debug((Object)npe.getMessage(), (Throwable)npe);
                    }
                }
            }
            ++n2;
        }
        return annotationReference;
    }

    protected JvmAnnotationValue createAnnotationValue(ITypeBinding annotationType, Object value, IMethodBinding methodBinding) {
        ITypeBinding originalTypeBinding;
        ITypeBinding typeBinding = originalTypeBinding = methodBinding.getReturnType();
        if (originalTypeBinding.isArray()) {
            typeBinding = typeBinding.getComponentType();
        }
        if (typeBinding.isParameterizedType()) {
            typeBinding = typeBinding.getErasure();
        }
        JvmAnnotationValue annotationValue = this.createAnnotationValue(typeBinding, value);
        annotationValue.setOperation(this.createMethodProxy(annotationType, methodBinding));
        return annotationValue;
    }

    protected JvmAnnotationValue createAnnotationValue(ITypeBinding type, Object value) {
        if (type == this.stringTypeBinding) {
            return this.createStringAnnotationValue(value);
        }
        if (type == this.classTypeBinding) {
            return this.createTypeAnnotationValue(value);
        }
        if (type.isPrimitive()) {
            char key = type.getKey().charAt(0);
            switch (key) {
                case 'I': {
                    return this.createIntAnnotationValue(value);
                }
                case 'Z': {
                    return this.createBooleanAnnotationValue(value);
                }
                case 'J': {
                    return this.createLongAnnotationValue(value);
                }
                case 'B': {
                    return this.createByteAnnotationValue(value);
                }
                case 'S': {
                    return this.createShortAnnotationValue(value);
                }
                case 'F': {
                    return this.createFloatAnnotationValue(value);
                }
                case 'D': {
                    return this.createDoubleAnnotationValue(value);
                }
                case 'C': {
                    return this.createCharAnnotationValue(value);
                }
            }
            throw new IllegalArgumentException("Unexpected primtive type: " + String.valueOf(type));
        }
        if (type.isAnnotation()) {
            return this.createAnnotationAnnotationValue(value);
        }
        if (type.isEnum()) {
            return this.createEnumAnnotationValue(value);
        }
        String qualifiedName = this.getQualifiedName(type);
        if ("java.lang.String".equals(qualifiedName)) {
            this.stringTypeBinding = type;
            return this.createAnnotationValue(type, value);
        }
        if ("java.lang.Class".equals(qualifiedName)) {
            this.classTypeBinding = type;
            return this.createAnnotationValue(type, value);
        }
        throw new IllegalArgumentException("Unexpected type: " + String.valueOf(type));
    }

    private JvmAnnotationValue createEnumAnnotationValue(Object value) {
        JvmEnumAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmEnumAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof IVariableBinding) {
                        values.addUnique((Object)this.createEnumLiteralProxy((IVariableBinding)element));
                    }
                    ++n2;
                }
            } else if (value instanceof IVariableBinding) {
                values.addUnique((Object)this.createEnumLiteralProxy((IVariableBinding)value));
            }
        }
        return annotationValue;
    }

    private JvmAnnotationValue createAnnotationAnnotationValue(Object value) {
        JvmAnnotationAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmAnnotationAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof IAnnotationBinding) {
                        values.addUnique((Object)this.createAnnotationReference((IAnnotationBinding)element));
                    }
                    ++n2;
                }
            } else if (value instanceof IAnnotationBinding) {
                values.addUnique((Object)this.createAnnotationReference((IAnnotationBinding)value));
            }
        }
        return annotationValue;
    }

    private JvmAnnotationValue createCharAnnotationValue(Object value) {
        JvmCharAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmCharAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof Character) {
                        values.addUnique(element);
                    }
                    ++n2;
                }
            } else {
                values.addUnique(value);
            }
        }
        return annotationValue;
    }

    private JvmAnnotationValue createDoubleAnnotationValue(Object value) {
        JvmDoubleAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmDoubleAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof Double) {
                        values.addUnique(element);
                    } else if (element != null) {
                        values.addUnique((Object)((Number)element).doubleValue());
                    }
                    ++n2;
                }
            } else if (value instanceof Double) {
                values.addUnique(value);
            } else if (value instanceof Number) {
                values.addUnique((Object)((Number)value).doubleValue());
            }
        }
        return annotationValue;
    }

    private JvmAnnotationValue createFloatAnnotationValue(Object value) {
        JvmFloatAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmFloatAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof Float) {
                        values.addUnique(element);
                    } else if (element != null) {
                        values.addUnique((Object)Float.valueOf(((Number)element).floatValue()));
                    }
                    ++n2;
                }
            } else if (value instanceof Float) {
                values.addUnique(value);
            } else if (value instanceof Number) {
                values.addUnique((Object)Float.valueOf(((Number)value).floatValue()));
            }
        }
        return annotationValue;
    }

    private JvmAnnotationValue createShortAnnotationValue(Object value) {
        JvmShortAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmShortAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof Short) {
                        values.addUnique(element);
                    } else if (element != null) {
                        values.addUnique((Object)((Number)element).shortValue());
                    }
                    ++n2;
                }
            } else if (value instanceof Short) {
                values.addUnique(value);
            } else if (value instanceof Number) {
                values.addUnique((Object)((Number)value).shortValue());
            }
        }
        return annotationValue;
    }

    private JvmAnnotationValue createByteAnnotationValue(Object value) {
        JvmByteAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmByteAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof Byte) {
                        values.addUnique(element);
                    } else if (element != null) {
                        values.addUnique((Object)((Number)element).byteValue());
                    }
                    ++n2;
                }
            } else if (value instanceof Byte) {
                values.addUnique(value);
            } else if (value instanceof Number) {
                values.addUnique((Object)((Number)value).byteValue());
            }
        }
        return annotationValue;
    }

    private JvmAnnotationValue createLongAnnotationValue(Object value) {
        JvmLongAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmLongAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof Long) {
                        values.addUnique(element);
                    } else if (element != null) {
                        values.addUnique((Object)((Number)element).longValue());
                    }
                    ++n2;
                }
            } else if (value instanceof Long) {
                values.addUnique(value);
            } else if (value instanceof Number) {
                values.addUnique((Object)((Number)value).longValue());
            }
        }
        return annotationValue;
    }

    private JvmAnnotationValue createBooleanAnnotationValue(Object value) {
        JvmBooleanAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmBooleanAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof Boolean) {
                        values.addUnique(element);
                    }
                    ++n2;
                }
            } else {
                values.addUnique(value);
            }
        }
        return annotationValue;
    }

    private JvmAnnotationValue createIntAnnotationValue(Object value) {
        JvmIntAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmIntAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof Integer) {
                        values.addUnique(element);
                    } else if (element != null) {
                        values.addUnique((Object)((Number)element).intValue());
                    }
                    ++n2;
                }
            } else if (value instanceof Integer) {
                values.addUnique(value);
            } else if (value instanceof Number) {
                values.addUnique((Object)((Number)value).intValue());
            }
        }
        return annotationValue;
    }

    private JvmAnnotationValue createTypeAnnotationValue(Object value) {
        JvmTypeAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmTypeAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof ITypeBinding) {
                        values.addUnique((Object)this.createTypeReference((ITypeBinding)element));
                    }
                    ++n2;
                }
            } else if (value instanceof ITypeBinding) {
                values.addUnique((Object)this.createTypeReference((ITypeBinding)value));
            }
        }
        return annotationValue;
    }

    private JvmAnnotationValue createStringAnnotationValue(Object value) {
        JvmStringAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmStringAnnotationValue();
        if (value != null) {
            InternalEList values = (InternalEList)annotationValue.getValues();
            if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof String) {
                        values.addUnique(element);
                    }
                    ++n2;
                }
            } else {
                values.addUnique(value);
            }
        }
        return annotationValue;
    }

    protected JvmType createProxy(ITypeBinding typeBinding) {
        JvmType proxy = this.typeProxies.get(typeBinding);
        if (proxy == null) {
            if (typeBinding.isPrimitive()) {
                proxy = PRIMITIVE_PROXIES[typeBinding.getKey().charAt(0) - 66];
            } else {
                URI uri = this.uriHelper.getFullURI(typeBinding);
                proxy = (JvmType)COMMON_PROXIES.get(uri.fragment());
                if (proxy == null) {
                    proxy = TypesFactory.eINSTANCE.createJvmVoid();
                    ((InternalEObject)proxy).eSetProxyURI(uri);
                }
            }
            this.typeProxies.put(typeBinding, proxy);
        }
        return proxy;
    }

    protected JvmOperation createMethodProxy(ITypeBinding typeBinding, IMethodBinding method) {
        JvmOperation proxy = this.operationProxies.get(method);
        if (proxy == null) {
            String methodName = method.getName();
            URI uri = this.uriHelper.getFullURI(typeBinding, methodName);
            JvmOperation[] jvmOperations = (JvmOperation[])ANNOTATION_METHOD_PROXIES.get(uri.lastSegment());
            if (jvmOperations != null) {
                JvmOperation[] jvmOperationArray = jvmOperations;
                int n = jvmOperations.length;
                int n2 = 0;
                while (n2 < n) {
                    JvmOperation jvmOperation = jvmOperationArray[n2];
                    String fragment = ((InternalEObject)jvmOperation).eProxyURI().fragment();
                    if (fragment.startsWith(methodName, fragment.length() - methodName.length() - 2)) {
                        this.operationProxies.put(method, jvmOperation);
                        return jvmOperation;
                    }
                    ++n2;
                }
            }
            proxy = TypesFactory.eINSTANCE.createJvmOperation();
            ((InternalEObject)proxy).eSetProxyURI(uri);
            this.operationProxies.put(method, proxy);
        }
        return proxy;
    }

    protected JvmEnumerationLiteral createEnumLiteralProxy(IVariableBinding binding) {
        JvmEnumerationLiteral proxy = this.enumerationLiteralProxies.get(binding);
        if (proxy == null) {
            proxy = TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
            URI uri = this.uriHelper.getFullURI(binding);
            ((InternalEObject)proxy).eSetProxyURI(uri);
            this.enumerationLiteralProxies.put(binding, proxy);
        }
        return proxy;
    }

    protected JvmAnnotationType createAnnotationProxy(ITypeBinding annotation) {
        JvmAnnotationType proxy = this.annotationProxies.get(annotation);
        if (proxy == null) {
            URI uri = this.uriHelper.getFullURI(annotation);
            proxy = (JvmAnnotationType)ANNOTATION_PROXIES.get(uri.fragment());
            if (proxy == null) {
                proxy = TypesFactory.eINSTANCE.createJvmAnnotationType();
                ((InternalEObject)proxy).eSetProxyURI(uri);
            }
            this.annotationProxies.put(annotation, proxy);
        }
        return proxy;
    }

    protected void setSuperTypes(ITypeBinding binding, String qualifiedName, JvmDeclaredType result) {
        ITypeBinding superclass = binding.getSuperclass();
        InternalEList superTypes = (InternalEList)result.getSuperTypes();
        if (superclass != null) {
            superTypes.addUnique((Object)this.createTypeReference(superclass));
        }
        ITypeBinding[] iTypeBindingArray = binding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding intf = iTypeBindingArray[n2];
            superTypes.addUnique((Object)this.createTypeReference(intf));
            ++n2;
        }
        if (superTypes.isEmpty() && !"java.lang.Object".equals(qualifiedName)) {
            superTypes.addUnique((Object)this.createObjectClassReference());
        }
    }

    private String[] subpath(List<String> path) {
        int size = path.size();
        if (size < 2) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = new String[size - 1];
        int i = 1;
        while (i < size) {
            result[i - 1] = path.get(i);
            ++i;
        }
        return result;
    }

    protected void createMethods(ITypeBinding typeBinding, String handleIdentifier, List<String> path, StringBuilder qualifiedName, JvmDeclaredType result) {
        this.resolveMembers.start();
        IMethodBinding[] declaredMethods = typeBinding.getDeclaredMethods();
        if (declaredMethods.length > 0) {
            int length = qualifiedName.length();
            InternalEList members = (InternalEList)result.getMembers();
            String[] subpath = this.subpath(path);
            boolean intf = typeBinding.isInterface() && !typeBinding.isAnnotation();
            IMethodBinding[] iMethodBindingArray = declaredMethods;
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding method = iMethodBindingArray[n2];
                if (!method.isSynthetic() && !"<clinit>".equals(method.getName())) {
                    if (method.isConstructor()) {
                        members.addUnique((Object)this.createConstructor(qualifiedName, handleIdentifier, subpath, method));
                    } else {
                        JvmOperation operation = this.createOperation(qualifiedName, handleIdentifier, subpath, method);
                        if (typeBinding.isAnnotation()) {
                            this.setDefaultValue(operation, method);
                        } else if (intf && !operation.isAbstract() && !operation.isStatic()) {
                            operation.setDefault(true);
                        }
                        members.addUnique((Object)operation);
                    }
                    qualifiedName.setLength(length);
                }
                ++n2;
            }
        }
        this.resolveMembers.stop();
    }

    private void setDefaultValue(JvmOperation operation, IMethodBinding method) {
        Object defaultValue = method.getDefaultValue();
        if (defaultValue != null) {
            ITypeBinding originalTypeBinding;
            ITypeBinding typeBinding = originalTypeBinding = method.getReturnType();
            if (originalTypeBinding.isArray()) {
                typeBinding = typeBinding.getComponentType();
            }
            if (typeBinding.isParameterizedType()) {
                typeBinding = typeBinding.getErasure();
            }
            JvmAnnotationValue annotationValue = this.createAnnotationValue(typeBinding, defaultValue);
            operation.setDefaultValue(annotationValue);
            annotationValue.setOperation(operation);
        }
    }

    protected void createNestedTypes(ITypeBinding typeBinding, JvmDeclaredType result, String handleIdentifier, List<String> path, StringBuilder fqn) {
        this.resolveMembers.start();
        ITypeBinding[] declaredTypes = typeBinding.getDeclaredTypes();
        if (declaredTypes.length > 0) {
            InternalEList members = (InternalEList)result.getMembers();
            int length = fqn.length();
            ITypeBinding[] iTypeBindingArray = declaredTypes;
            int n = declaredTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding declaredType = iTypeBindingArray[n2];
                if (!declaredType.isAnonymous() && !declaredType.isSynthetic()) {
                    JvmDeclaredType nestedType = this.createType(declaredType, handleIdentifier, path, fqn);
                    if (nestedType.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
                        if (((JvmGenericType)nestedType).isInterface()) {
                            nestedType.setStatic(true);
                        }
                    } else {
                        nestedType.setStatic(true);
                    }
                    members.addUnique((Object)nestedType);
                    fqn.setLength(length);
                }
                ++n2;
            }
        }
        this.resolveMembers.stop();
    }

    protected void setTypeModifiers(JvmDeclaredType result, int modifiers) {
        result.setAbstract(Modifier.isAbstract((int)modifiers));
        result.setStatic(Modifier.isStatic((int)modifiers));
        if (result.eClass() != TypesPackage.Literals.JVM_ENUMERATION_TYPE) {
            result.setFinal(Modifier.isFinal((int)modifiers));
            if (result.eClass() == TypesPackage.Literals.JVM_ANNOTATION_TYPE || result.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)result).isInterface()) {
                result.setAbstract(true);
            }
        }
    }

    protected JvmTypeParameter createTypeParameter(ITypeBinding parameter, JvmMember container) {
        this.resolveTypeParams.start();
        JvmTypeParameter result = TypesFactory.eINSTANCE.createJvmTypeParameter();
        result.setName(parameter.getName());
        InternalEList constraints = (InternalEList)result.getConstraints();
        ITypeBinding[] typeBounds = parameter.getTypeBounds();
        if (typeBounds.length != 0) {
            ITypeBinding[] iTypeBindingArray = typeBounds;
            int n = typeBounds.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding bound = iTypeBindingArray[n2];
                JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                upperBound.setTypeReference(this.createTypeReference(bound));
                constraints.addUnique((Object)upperBound);
                ++n2;
            }
        } else {
            JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
            upperBound.setTypeReference(this.createObjectClassReference());
            constraints.addUnique((Object)upperBound);
        }
        this.resolveTypeParams.stop();
        return result;
    }

    protected JvmTypeReference createTypeReference(ITypeBinding typeBinding) {
        JvmParameterizedTypeReference result;
        if (typeBinding == null) {
            return TypesFactory.eINSTANCE.createJvmUnknownTypeReference();
        }
        if (typeBinding.isArray()) {
            ITypeBinding componentType = typeBinding.getComponentType();
            JvmTypeReference componentTypeReference = this.createTypeReference(componentType);
            JvmGenericArrayTypeReference typeReference = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
            typeReference.setComponentType(componentTypeReference);
            return typeReference;
        }
        ITypeBinding outer = null;
        if (typeBinding.isMember() && !Modifier.isStatic((int)typeBinding.getModifiers())) {
            outer = typeBinding.getDeclaringClass();
        }
        if (outer != null) {
            JvmParameterizedTypeReference outerReference = (JvmParameterizedTypeReference)this.createTypeReference(outer);
            result = TypesFactory.eINSTANCE.createJvmInnerTypeReference();
            ((JvmInnerTypeReference)result).setOuter(outerReference);
        } else {
            result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        }
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        if (typeArguments.length != 0) {
            ITypeBinding erasure = typeBinding.getErasure();
            result.setType(this.createProxy(erasure));
            InternalEList arguments = (InternalEList)result.getArguments();
            int i = 0;
            while (i < typeArguments.length) {
                JvmTypeReference argument = this.createTypeArgument(typeArguments[i]);
                arguments.addUnique((Object)argument);
                ++i;
            }
        } else {
            result.setType(this.createProxy(typeBinding));
        }
        return result;
    }

    protected JvmTypeReference createObjectClassReference() {
        JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        result.setType(OBJECT_CLASS_PROXY);
        return result;
    }

    protected JvmTypeReference createTypeArgument(ITypeBinding argument) {
        if (argument.isWildcardType()) {
            JvmWildcardTypeReference result = TypesFactory.eINSTANCE.createJvmWildcardTypeReference();
            InternalEList constraints = (InternalEList)result.getConstraints();
            JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
            ITypeBinding bound = argument.getBound();
            if (argument.isUpperbound()) {
                JvmTypeReference reference = this.createTypeReference(bound);
                upperBound.setTypeReference(reference);
                constraints.addUnique((Object)upperBound);
            } else {
                JvmTypeReference objectReference = this.createObjectClassReference();
                upperBound.setTypeReference(objectReference);
                constraints.addUnique((Object)upperBound);
                if (bound != null) {
                    JvmLowerBound lowerBound = TypesFactory.eINSTANCE.createJvmLowerBound();
                    JvmTypeReference reference = this.createTypeReference(bound);
                    lowerBound.setTypeReference(reference);
                    constraints.addUnique((Object)lowerBound);
                }
            }
            return result;
        }
        return this.createTypeReference(argument);
    }

    protected JvmField createField(StringBuilder typeName, IVariableBinding field) {
        JvmField result;
        if (!field.isEnumConstant()) {
            result = TypesFactory.eINSTANCE.createJvmField();
            Object constantValue = field.getConstantValue();
            if (constantValue != null) {
                result.setConstant(true);
                result.setConstantValue(constantValue);
            } else {
                result.setConstant(false);
            }
        } else {
            result = TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        }
        String name = field.getName();
        result.internalSetIdentifier(typeName.append(name).toString());
        result.setSimpleName(name);
        int modifiers = field.getModifiers();
        result.setFinal(Modifier.isFinal((int)modifiers));
        result.setStatic(Modifier.isStatic((int)modifiers));
        result.setTransient(Modifier.isTransient((int)modifiers));
        result.setVolatile(Modifier.isVolatile((int)modifiers));
        result.setDeprecated(field.isDeprecated());
        this.setVisibility((JvmMember)result, modifiers);
        result.setType(this.createTypeReference(field.getType()));
        this.createAnnotationValues((IBinding)field, (JvmAnnotationTarget)result);
        return result;
    }

    protected void setVisibility(JvmMember result, int modifiers) {
        if (Modifier.isPrivate((int)modifiers)) {
            result.setVisibility(JvmVisibility.PRIVATE);
        } else if (Modifier.isProtected((int)modifiers)) {
            result.setVisibility(JvmVisibility.PROTECTED);
        } else if (Modifier.isPublic((int)modifiers)) {
            result.setVisibility(JvmVisibility.PUBLIC);
        } else {
            result.setVisibility(JvmVisibility.DEFAULT);
        }
    }

    protected JvmConstructor createConstructor(StringBuilder qualifiedName, String handleIdentifier, String[] path, IMethodBinding method) {
        JvmConstructor result = TypesFactory.eINSTANCE.createJvmConstructor();
        this.enhanceGenericDeclaration((JvmExecutable)result, method.getTypeParameters());
        this.enhanceExecutable(qualifiedName, handleIdentifier, path, (JvmExecutable)result, method);
        this.createAnnotationValues((IBinding)method, (JvmAnnotationTarget)result);
        return result;
    }

    protected void enhanceExecutable(StringBuilder fqn, String handleIdentifier, String[] path, JvmExecutable result, IMethodBinding method) {
        ITypeBinding[] exceptionTypes;
        String name = method.getName();
        fqn.append(name);
        fqn.append('(');
        ITypeBinding[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            if (i != 0) {
                fqn.append(',');
            }
            fqn.append(this.getQualifiedName(parameterTypes[i]));
            ++i;
        }
        fqn.append(')');
        result.internalSetIdentifier(fqn.toString());
        result.setSimpleName(name);
        this.setVisibility((JvmMember)result, method.getModifiers());
        result.setDeprecated(method.isDeprecated());
        if (parameterTypes.length > 0) {
            result.setVarArgs(method.isVarargs());
            String[] parameterNames = null;
            ITypeBinding declaringClass = method.getDeclaringClass();
            if (declaringClass.isFromSource()) {
                parameterNames = this.getParameterNamesFromSource(fqn, method);
            } else {
                SegmentSequence signaturex = this.getSignatureAsSegmentSequence(method);
                ParameterNameInitializer initializer = this.createParameterNameInitializer(method, this.workingCopyOwner, result, handleIdentifier, path, name, signaturex);
                ((JvmExecutableImplCustom)result).setParameterNameInitializer((Runnable)initializer);
            }
            this.setParameterNamesAndAnnotations(method, parameterTypes, parameterNames, result);
        }
        if ((exceptionTypes = method.getExceptionTypes()).length > 0) {
            InternalEList exceptions = (InternalEList)result.getExceptions();
            ITypeBinding[] iTypeBindingArray = exceptionTypes;
            int n = exceptionTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding exceptionType = iTypeBindingArray[n2];
                exceptions.addUnique((Object)this.createTypeReference(exceptionType));
                ++n2;
            }
        }
    }

    protected ParameterNameInitializer createParameterNameInitializer(IMethodBinding method, WorkingCopyOwner workingCopyOwner, JvmExecutable result, String handleIdentifier, String[] path, String name, SegmentSequence signaturex) {
        if (method.isConstructor() && method.getDeclaringClass().isEnum()) {
            String syntheticParams = "Ljava/lang/String;I";
            String withoutSyntheticArgs = signaturex.toString();
            if (withoutSyntheticArgs.startsWith(syntheticParams)) {
                withoutSyntheticArgs = withoutSyntheticArgs.substring(syntheticParams.length());
            }
            return new EnumConstructorParameterNameInitializer(workingCopyOwner, result, handleIdentifier, path, name, withoutSyntheticArgs);
        }
        return new ParameterNameInitializer(workingCopyOwner, result, handleIdentifier, path, name, (CharSequence)signaturex);
    }

    private void setParameterNamesAndAnnotations(IMethodBinding method, ITypeBinding[] parameterTypes, String[] parameterNames, JvmExecutable result) {
        InternalEList parameters = (InternalEList)result.getParameters();
        int i = 0;
        while (i < parameterTypes.length) {
            IAnnotationBinding[] parameterAnnotations;
            try {
                parameterAnnotations = method.getParameterAnnotations(i);
            }
            catch (AbortCompilation aborted) {
                parameterAnnotations = null;
            }
            ITypeBinding parameterType = parameterTypes[i];
            String parameterName = parameterNames == null ? null : (i < parameterNames.length ? parameterNames[i] : "arg" + i);
            JvmFormalParameter formalParameter = this.createFormalParameter(parameterType, parameterName, parameterAnnotations);
            parameters.addUnique((Object)formalParameter);
            ++i;
        }
    }

    private SegmentSequence getSignatureAsSegmentSequence(IMethodBinding method) {
        String key = method.getKey();
        int start = key.indexOf(40);
        int end = key.lastIndexOf(41);
        SegmentSequence signaturex = SegmentSequence.create((String)";", (String)key.substring(start + 1, end));
        return signaturex;
    }

    private String[] getParameterNamesFromSource(StringBuilder fqn, IMethodBinding method) {
        String[] parameterNames = EMPTY_STRING_ARRAY;
        IMethod sourceMethod = null;
        try {
            sourceMethod = (IMethod)method.getJavaElement();
        }
        catch (IllegalArgumentException ex) {
            log.debug((Object)("Cannot locate java source method for " + String.valueOf(fqn)), (Throwable)ex);
        }
        if (sourceMethod != null) {
            try {
                parameterNames = sourceMethod.getParameterNames();
            }
            catch (JavaModelException ex) {
                log.error((Object)("Source method parameter names cannot be determined for " + String.valueOf(fqn)), (Throwable)ex);
            }
        }
        return parameterNames;
    }

    protected void enhanceGenericDeclaration(JvmExecutable result, ITypeBinding[] parameters) {
        if (parameters.length > 0) {
            InternalEList typeParameters = (InternalEList)result.getTypeParameters();
            ITypeBinding[] iTypeBindingArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding parameter = iTypeBindingArray[n2];
                typeParameters.addUnique((Object)this.createTypeParameter(parameter, (JvmMember)result));
                ++n2;
            }
        }
    }

    protected JvmOperation createOperation(StringBuilder qualifiedName, String handleIdentifier, String[] path, IMethodBinding method) {
        JvmOperation result = TypesFactory.eINSTANCE.createJvmOperation();
        this.enhanceGenericDeclaration((JvmExecutable)result, method.getTypeParameters());
        this.enhanceExecutable(qualifiedName, handleIdentifier, path, (JvmExecutable)result, method);
        int modifiers = method.getModifiers();
        result.setAbstract(Modifier.isAbstract((int)modifiers));
        result.setFinal(Modifier.isFinal((int)modifiers));
        result.setStatic(Modifier.isStatic((int)modifiers));
        result.setStrictFloatingPoint(Modifier.isStrictfp((int)modifiers));
        result.setSynchronized(Modifier.isSynchronized((int)modifiers));
        result.setNative(Modifier.isNative((int)modifiers));
        result.setReturnType(this.createTypeReference(method.getReturnType()));
        this.createAnnotationValues((IBinding)method, (JvmAnnotationTarget)result);
        return result;
    }

    protected JvmFormalParameter createFormalParameter(ITypeBinding parameterType, String paramName, IAnnotationBinding[] annotations) {
        JvmFormalParameter result = TypesFactory.eINSTANCE.createJvmFormalParameter();
        if (paramName != null) {
            result.setName(paramName);
        }
        result.setParameterType(this.createTypeReference(parameterType));
        if (annotations != null && annotations.length > 0) {
            InternalEList parameterAnnotations = (InternalEList)result.getAnnotations();
            IAnnotationBinding[] iAnnotationBindingArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotation = iAnnotationBindingArray[n2];
                parameterAnnotations.addUnique((Object)this.createAnnotationReference(annotation));
                ++n2;
            }
        }
        return result;
    }

    protected static class EnumConstructorParameterNameInitializer
    extends ParameterNameInitializer {
        protected EnumConstructorParameterNameInitializer(WorkingCopyOwner workingCopyOwner, JvmExecutable executable, String handleIdentifier, String[] path, String name, CharSequence signature) {
            super(workingCopyOwner, executable, handleIdentifier, path, name, signature);
        }

        @Override
        protected void setParameterNames(IMethod javaMethod, List<JvmFormalParameter> parameters) throws JavaModelException {
            String[] parameterNames = javaMethod.getParameterNames();
            if (parameterNames.length == parameters.size()) {
                super.setParameterNames(javaMethod, parameters);
            } else {
                int size = parameters.size();
                if (size + 2 != parameterNames.length) {
                    throw new IllegalStateException("unmatching arity for java method " + javaMethod.toString() + " and " + this.getExecutable().getIdentifier());
                }
                int i = 2;
                while (i < parameterNames.length) {
                    String string = parameterNames[i];
                    parameters.get(i - 2).setName(string);
                    ++i;
                }
            }
        }
    }

    public static class ParameterNameInitializer
    implements Runnable {
        private static final Logger log = Logger.getLogger(ParameterNameInitializer.class);
        private Stopwatches.StoppedTask resolveParamNames = Stopwatches.forTask((String)"resolve param names (JdtBasedTypeFactory)");
        private WorkingCopyOwner workingCopyOwner;
        private JvmExecutable executable;
        private String handleIdentifier;
        private String[] path;
        private String name;
        private CharSequence signature;

        protected ParameterNameInitializer(WorkingCopyOwner workingCopyOwner, JvmExecutable executable, String handleIdentifier, String[] path, String name, CharSequence signature) {
            this.workingCopyOwner = workingCopyOwner;
            this.executable = executable;
            this.handleIdentifier = handleIdentifier;
            this.path = path;
            this.name = name;
            this.signature = signature;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                this.resolveParamNames.start();
                type = this.findTypeByHandleIdentifier();
                parameters = this.executable.getParameters();
                if (type == null || (numberOfParameters = (javaMethod = this.findJavaMethod(type)).getNumberOfParameters()) == 0) ** GOTO lbl13
                try {
                    this.setParameterNames(javaMethod, (List<JvmFormalParameter>)parameters);
                    return;
                }
                catch (JavaModelException ex) {
                    if (!ex.isDoesNotExist()) {
                        ParameterNameInitializer.log.warn((Object)"IMethod.getParameterNames failed", (Throwable)ex);
                    }
lbl13:
                    // 4 sources

                    this.synthesizeNames((List<JvmFormalParameter>)parameters);
                }
            }
            finally {
                this.resolveParamNames.stop();
            }
        }

        protected void setParameterNames(IMethod javaMethod, List<JvmFormalParameter> parameters) throws JavaModelException {
            String[] parameterNames = javaMethod.getParameterNames();
            int size = parameters.size();
            if (size != parameterNames.length) {
                throw new IllegalStateException("unmatching arity for java method " + javaMethod.toString() + " and " + this.getExecutable().getIdentifier());
            }
            int i = 0;
            while (i < parameterNames.length) {
                String string = parameterNames[i];
                parameters.get(i).setName(string);
                ++i;
            }
        }

        private IMethod findJavaMethod(IType type) {
            String[] parameterTypes = Signature.getParameterTypes((String)new BindingKey("Lx;.x(" + String.valueOf(this.signature) + ")").toSignature());
            IMethod javaMethod = type.getMethod(this.name, parameterTypes);
            if (!javaMethod.exists() && type.getDeclaringType() != null) {
                String first;
                String[] augmented = new String[parameterTypes.length + 1];
                System.arraycopy(parameterTypes, 0, augmented, 1, parameterTypes.length);
                augmented[0] = first = Signature.createTypeSignature((String)type.getDeclaringType().getFullyQualifiedName(), (boolean)true);
                javaMethod = type.getMethod(this.name, augmented);
            }
            return javaMethod;
        }

        protected JvmExecutable getExecutable() {
            return this.executable;
        }

        private void synthesizeNames(List<JvmFormalParameter> parameters) {
            int i = 0;
            for (JvmFormalParameter p : parameters) {
                if (p.getName() == null) {
                    p.setName("arg" + i);
                }
                ++i;
            }
        }

        private IType findTypeByHandleIdentifier() {
            IType type = (IType)JavaCore.create((String)this.handleIdentifier, (WorkingCopyOwner)this.workingCopyOwner);
            if (type != null) {
                String[] stringArray = this.path;
                int n = this.path.length;
                int n2 = 0;
                while (n2 < n) {
                    String typeName = stringArray[n2];
                    if ((type = type.getType(typeName)) == null) break;
                    ++n2;
                }
            }
            return type;
        }
    }
}

