/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.conversion.XbaseQualifiedNameValueConverter;
import org.eclipse.xtext.xbase.imports.ConflictResolver;
import org.eclipse.xtext.xbase.imports.IUnresolvedTypeResolver;
import org.eclipse.xtext.xbase.imports.NonOverridableTypesProvider;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.imports.TypeUsage;
import org.eclipse.xtext.xbase.imports.TypeUsageCollector;
import org.eclipse.xtext.xbase.imports.TypeUsages;

public class ImportOrganizer {
    @Inject
    private RewritableImportSection.Factory importSectionFactory;
    @Inject
    private Provider<TypeUsageCollector> typeUsageCollectorProvider;
    @Inject
    private ConflictResolver conflictResolver;
    @Inject
    private NonOverridableTypesProvider nonOverridableTypesProvider;
    @Inject(optional=true)
    private IUnresolvedTypeResolver unresolvedTypeResolver;
    @Inject
    private XbaseQualifiedNameValueConverter nameValueConverter;

    public List<ReplaceRegion> getOrganizedImportChanges(XtextResource resource) {
        TypeUsageCollector typeUsageCollector = (TypeUsageCollector)this.typeUsageCollectorProvider.get();
        TypeUsages typeUsages = typeUsageCollector.collectTypeUsages(resource);
        if (this.unresolvedTypeResolver != null) {
            this.unresolvedTypeResolver.resolve(typeUsages, resource);
        }
        Map<String, JvmDeclaredType> name2type = this.conflictResolver.resolveConflicts(typeUsages, this.nonOverridableTypesProvider, resource);
        List<ReplaceRegion> changes = this.getOrganizedImportChanges(resource, name2type, typeUsages);
        this.removeNullEdits(resource, changes);
        return changes;
    }

    protected void removeNullEdits(XtextResource resource, List<ReplaceRegion> changes) {
        Iterator<ReplaceRegion> iterator = changes.iterator();
        String document = resource.getParseResult().getRootNode().getText();
        while (iterator.hasNext()) {
            ReplaceRegion region = iterator.next();
            if (!region.getText().equals(document.substring(region.getOffset(), region.getEndOffset()))) continue;
            iterator.remove();
        }
    }

    private List<ReplaceRegion> getOrganizedImportChanges(XtextResource resource, Map<String, JvmDeclaredType> resolvedConflicts, TypeUsages typeUsages) {
        JvmDeclaredType declaringType;
        RewritableImportSection oldImportSection = this.importSectionFactory.parse(resource);
        RewritableImportSection newImportSection = this.importSectionFactory.createNewEmpty(resource);
        this.addImports(resolvedConflicts, typeUsages, newImportSection);
        List<ReplaceRegion> replaceRegions = this.getReplacedUsageSites(resolvedConflicts, typeUsages, newImportSection);
        for (JvmMember extensionImport : typeUsages.getExtensionImports()) {
            declaringType = extensionImport.getDeclaringType();
            if (oldImportSection.hasStaticImport(declaringType, extensionImport.getSimpleName(), true)) {
                newImportSection.addStaticExtensionImport(extensionImport);
                continue;
            }
            newImportSection.addStaticExtensionImport(declaringType, null);
        }
        for (JvmMember staticImport : typeUsages.getStaticImports()) {
            declaringType = staticImport.getDeclaringType();
            if (oldImportSection.hasStaticImport(declaringType, staticImport.getSimpleName(), false)) {
                if (newImportSection.hasStaticImport(declaringType, staticImport.getSimpleName(), true)) continue;
                newImportSection.addStaticImport(staticImport);
                continue;
            }
            if (newImportSection.hasStaticImport(declaringType, staticImport.getSimpleName(), true)) continue;
            newImportSection.addStaticImport(declaringType, null);
        }
        replaceRegions.addAll(newImportSection.rewrite());
        return replaceRegions;
    }

    private List<ReplaceRegion> getReplacedUsageSites(Map<String, JvmDeclaredType> resolvedConflicts, TypeUsages typeUsages, RewritableImportSection newImportSection) {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<String, JvmDeclaredType> textToType : resolvedConflicts.entrySet()) {
            this.getReplacedUsagesOf(textToType, typeUsages, newImportSection, result);
        }
        return result;
    }

    private void getReplacedUsagesOf(Map.Entry<String, JvmDeclaredType> nameToType, TypeUsages typeUsages, RewritableImportSection importSection, List<ReplaceRegion> result) {
        String nameToUse = nameToType.getKey();
        JvmDeclaredType type = nameToType.getValue();
        String packageLocalName = this.getPackageLocalName(type);
        for (TypeUsage typeUsage : typeUsages.getUsages(type)) {
            ReplaceRegion replaceRegion = this.getReplaceRegion(nameToUse, packageLocalName, type, typeUsage, importSection);
            if (replaceRegion == null) continue;
            result.add(replaceRegion);
        }
    }

    private ReplaceRegion getReplaceRegion(String nameToUse, String packageLocalName, JvmDeclaredType type, TypeUsage usage, RewritableImportSection importSection) {
        if (Strings.equal((String)usage.getContextPackageName(), (String)type.getPackageName()) && type.getDeclaringType() == null) {
            if (type.eContainer() != null) {
                String declarationLocalName;
                nameToUse = declarationLocalName = this.getLocalName(type, usage.getContext());
            } else if (importSection.getImportedTypes(packageLocalName) == null) {
                nameToUse = packageLocalName;
            }
        }
        String textToUse = this.getConcreteSyntax(nameToUse, type, usage);
        return new ReplaceRegion(usage.getTextRegion(), textToUse);
    }

    private String getLocalName(JvmDeclaredType type, JvmMember context) {
        JvmMember containerCandidate = context;
        while (containerCandidate != null) {
            if (containerCandidate == type) {
                return type.getSimpleName();
            }
            if (EcoreUtil.isAncestor((EObject)containerCandidate, (EObject)type)) {
                String contextName = containerCandidate.getQualifiedName('.');
                String typeName = type.getQualifiedName('.');
                return typeName.substring(contextName.length() + 1);
            }
            EObject container = containerCandidate.eContainer();
            if (container instanceof JvmMember) {
                containerCandidate = (JvmMember)container;
                continue;
            }
            return null;
        }
        return null;
    }

    private String getConcreteSyntax(String name, JvmDeclaredType importedType, TypeUsage usage) {
        JvmDeclaredType usedType = usage.getUsedType();
        if (usedType == null) {
            String typeName = usage.getUsedTypeName();
            String suffix = this.getSuffix(usage);
            String fullTypeName = String.valueOf(typeName) + suffix;
            return this.nameValueConverter.toString(fullTypeName);
        }
        if (usedType != importedType) {
            LinkedList segments = Lists.newLinkedList();
            while (usedType != importedType) {
                segments.add(0, usedType.getSimpleName());
                usedType = usedType.getDeclaringType();
            }
            name = String.valueOf(name) + '.' + Joiner.on((char)'.').join((Iterable)segments);
        } else {
            String suffix = this.getSuffix(usage);
            name = String.valueOf(name) + suffix;
        }
        return this.nameValueConverter.toString(name);
    }

    protected String getSuffix(TypeUsage usage) {
        String suffix = usage.getSuffix();
        suffix = suffix.replace('$', '.').replace("::", ".");
        return suffix;
    }

    private void addImports(Map<String, JvmDeclaredType> resolvedConflicts, TypeUsages typeUsages, RewritableImportSection target) {
        for (Map.Entry<String, JvmDeclaredType> entry : resolvedConflicts.entrySet()) {
            Iterable<TypeUsage> usages;
            String text = entry.getKey();
            JvmDeclaredType type = entry.getValue();
            if (!this.needsImport(type, text, this.nonOverridableTypesProvider, usages = typeUsages.getUsages(type))) continue;
            target.addImport(type);
        }
    }

    protected String getPackageLocalName(JvmDeclaredType type) {
        String packageName = type.getPackageName();
        if (Strings.isEmpty((String)packageName)) {
            return type.getQualifiedName('.');
        }
        return type.getQualifiedName('.').substring(packageName.length() + 1);
    }

    protected boolean needsImport(JvmDeclaredType type, String name, NonOverridableTypesProvider nonOverridableTypesProvider, Iterable<TypeUsage> usages) {
        boolean nameEquals = type.getQualifiedName().equals(name) || type.getQualifiedName('.').equals(name);
        return !nameEquals && !this.isUsedInLocalContextOnly(type, usages, nonOverridableTypesProvider, name);
    }

    protected boolean isUsedInLocalContextOnly(JvmDeclaredType type, Iterable<TypeUsage> usages, NonOverridableTypesProvider nonOverridableTypesProvider, String name) {
        for (TypeUsage usage : usages) {
            JvmIdentifiableElement visibleType = nonOverridableTypesProvider.getVisibleType(usage.getContext(), name);
            if (visibleType != null || Strings.equal((String)usage.getContextPackageName(), (String)type.getPackageName()) && (type.getDeclaringType() == null || usage.getContext().eResource() == type.getDeclaringType().eResource())) continue;
            return false;
        }
        return true;
    }
}

