/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.shared.internal;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.BuildScheduler;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.ProjectOpenedOrClosedListener;
import org.eclipse.xtext.ui.shared.contribution.IEagerContribution;

public class ListenerRegistrar
implements IEagerContribution {
    @Inject
    private ProjectOpenedOrClosedListener listener;
    @Inject
    private IWorkspace workspace;
    @Inject
    private BuildScheduler buildManager;
    @Inject
    private IBuilderState builderState;

    public void initialize() {
        this.workspace.addResourceChangeListener((IResourceChangeListener)this.listener);
        class RecoveryBuildTrigger
        extends WorkspaceJob {
            public RecoveryBuildTrigger() {
                super("Schedule Xtext recovery build on start-up");
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (ListenerRegistrar.this.builderState.isEmpty()) {
                    ListenerRegistrar.this.buildManager.scheduleBuildIfNecessary(Arrays.asList(ListenerRegistrar.this.workspace.getRoot().getProjects()), new IBuildFlag[]{IBuildFlag.RECOVERY_BUILD});
                }
                return Status.OK_STATUS;
            }
        }
        RecoveryBuildTrigger recoveryBuildTrigger = new RecoveryBuildTrigger();
        recoveryBuildTrigger.schedule();
    }

    public void discard() {
        this.workspace.removeResourceChangeListener((IResourceChangeListener)this.listener);
    }
}

