/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.label;

import com.google.inject.Inject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.IImageHelper;

public abstract class AbstractLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IItemLabelProvider {
    private ILabelProvider delegate;
    @Inject
    private IImageHelper imageHelper;

    protected AbstractLabelProvider() {
    }

    protected AbstractLabelProvider(ILabelProvider delegate) {
        this.delegate = delegate;
    }

    public Image getImage(Object element) {
        Image image = this.convertToImage(this.doGetImage(element));
        if (image != null) {
            return image;
        }
        if (this.delegate != null && (image = this.delegate.getImage(element)) != null) {
            return image;
        }
        return this.convertToImage(this.getDefaultImage());
    }

    protected Image convertToImage(Object imageDescription) {
        if (imageDescription instanceof Image) {
            return (Image)imageDescription;
        }
        if (imageDescription instanceof ImageDescriptor) {
            return this.imageHelper.getImage((ImageDescriptor)imageDescription);
        }
        if (imageDescription instanceof String) {
            return this.imageHelper.getImage((String)imageDescription);
        }
        return null;
    }

    protected Object doGetImage(Object element) {
        return null;
    }

    protected Object getDefaultImage() {
        return null;
    }

    public StyledString getStyledText(Object element) {
        StyledString styledText = this.convertToStyledString(this.doGetText(element));
        if (styledText != null) {
            return styledText;
        }
        if (this.delegate != null && (this.delegate instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider ? (styledText = ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.delegate).getStyledText(element)) != null : (styledText = this.convertToStyledString(this.delegate.getText(element))) != null)) {
            return styledText;
        }
        return this.getDefaultStyledText();
    }

    protected StyledString convertToStyledString(Object text) {
        if (text instanceof StyledString) {
            return (StyledString)text;
        }
        if (text instanceof String) {
            return new StyledString((String)text);
        }
        return null;
    }

    public String getText(Object element) {
        String text = this.convertToString(this.doGetText(element));
        if (text != null) {
            return text;
        }
        if (this.delegate != null && (text = this.delegate.getText(element)) != null) {
            return text;
        }
        return this.getDefaultText();
    }

    protected String convertToString(Object text) {
        if (text instanceof StyledString) {
            return ((StyledString)text).getString();
        }
        if (text instanceof String) {
            return (String)text;
        }
        return null;
    }

    protected Object doGetText(Object element) {
        return null;
    }

    protected StyledString getDefaultStyledText() {
        return null;
    }

    protected String getDefaultText() {
        return null;
    }

    protected void setImageHelper(IImageHelper imageHelper) {
        this.imageHelper = imageHelper;
    }
}

