/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IDependentElementsCalculator;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.IRenamedElementTracker;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameProcessor;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.ReferenceUpdaterDispatcher;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

public class RenameElementProcessor
extends AbstractRenameProcessor {
    protected static final Logger LOG = Logger.getLogger(RenameElementProcessor.class);
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private IDependentElementsCalculator dependentElementsCalculator;
    @Inject
    private IRenameStrategy.Provider strategyProvider;
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private ReferenceUpdaterDispatcher referenceUpdaterDispatcher;
    @Inject
    private IRenamedElementTracker renameElementTracker;
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    private StatusWrapper status;
    private IRenameElementContext renameElementContext;
    private ResourceSet resourceSet;
    private URI targetElementURI;
    private EObject targetElement;
    private IRenameStrategy renameStrategy;
    private String newName;
    @Inject
    private Provider<IRefactoringUpdateAcceptor> updateAcceptorProvider;
    private ElementRenameArguments renameArguments;
    private IRefactoringUpdateAcceptor currentUpdateAcceptor;

    public boolean initialize(IRenameElementContext renameElementContext) {
        try {
            this.renameElementContext = renameElementContext;
            this.targetElementURI = renameElementContext.getTargetElementURI();
            this.resourceSet = this.createResourceSet(renameElementContext);
            this.targetElement = this.resourceSet.getEObject(this.targetElementURI, true);
            if (this.targetElement == null) {
                this.status.add(4, "Rename target element {0} can not be resolved", this.targetElementURI);
            } else if (this.isValidTargetFile(this.targetElement.eResource(), this.status)) {
                this.renameStrategy = this.createRenameElementStrategy(this.targetElement, renameElementContext);
                if (this.renameStrategy == null) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, this.status);
            throw e instanceof RuntimeException ? (RuntimeException)e : new WrappedException(e);
        }
        return true;
    }

    protected ResourceSet createResourceSet(IRenameElementContext renameElementContext) {
        IProject project = this.projectUtil.getProject(this.targetElementURI);
        if (project == null) {
            this.status.add(4, "Could not find project for ", renameElementContext.getTargetElementURI());
            return null;
        }
        return this.resourceSetProvider.get(project);
    }

    protected boolean isValidTargetFile(Resource resource, StatusWrapper status) {
        IFile targetFile = this.projectUtil.findFileStorage(resource.getURI(), true);
        if (targetFile != null) {
            return true;
        }
        status.add(4, "Rename target file cannot be accessed", new Object[0]);
        return false;
    }

    protected IRenameStrategy createRenameElementStrategy(EObject targetElement, IRenameElementContext renameElementContext) {
        IRenameStrategy result = this.strategyProvider.get(targetElement, renameElementContext);
        return result;
    }

    public IRenameStrategy getRenameElementStrategy() {
        return this.renameStrategy;
    }

    public Object[] getElements() {
        return new Object[]{this.targetElementURI};
    }

    public String getOriginalName() {
        return this.renameStrategy.getOriginalName();
    }

    public RefactoringStatus validateNewName(String newName) {
        return this.renameStrategy.validateNewName(newName);
    }

    protected String getLanguageName() {
        return this.languageName;
    }

    public String getIdentifier() {
        return String.valueOf(this.getLanguageName()) + ".ui.refactoring.Processor";
    }

    public String getProcessorName() {
        return "Rename element";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewName() {
        return this.newName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.status.getRefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.currentUpdateAcceptor = (IRefactoringUpdateAcceptor)this.updateAcceptorProvider.get();
            Iterable<URI> dependentElementURIs = this.dependentElementsCalculator.getDependentElementURIs(this.targetElement, (IProgressMonitor)progress.newChild(1));
            Map<URI, URI> original2newElementURIs = this.renameElementTracker.renameAndTrack(Iterables.concat(Collections.singleton(this.targetElementURI), dependentElementURIs), this.newName, this.resourceSet, this.renameStrategy, (IProgressMonitor)progress.newChild(1));
            this.renameStrategy.createDeclarationUpdates(this.newName, this.resourceSet, this.currentUpdateAcceptor);
            this.renameArguments = new ElementRenameArguments(this.targetElementURI, this.newName, this.renameStrategy, original2newElementURIs);
            this.referenceUpdaterDispatcher.createReferenceUpdates(this.renameArguments, this.resourceSet, this.currentUpdateAcceptor, (IProgressMonitor)progress.newChild(98));
            this.status.merge(this.currentUpdateAcceptor.getRefactoringStatus());
        }
        catch (Exception exc) {
            this.handleException(exc, this.status);
        }
        return this.status.getRefactoringStatus();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return this.currentUpdateAcceptor.createCompositeChange("Rename " + this.renameStrategy.getOriginalName() + " to " + this.newName, monitor);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RenameParticipant[] renameParticipants = ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.renameElementContext, (RenameArguments)new RenameArguments(this.newName, true), (String[])new String[]{"org.eclipse.xtext.ui.shared.xtextNature"}, (SharableParticipants)sharedParticipants);
        return renameParticipants;
    }

    protected void handleException(Exception exc, StatusWrapper status) {
        status.add(4, "Error during refactoring: {0}", exc, LOG);
    }

    protected RefactoringResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    protected StatusWrapper getStatus() {
        return this.status;
    }
}

