/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.typing.JvmExceptions;
import org.eclipse.xtext.xbase.typing.JvmOnlyTypeConformanceComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXbaseCompiler {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TypeReferenceSerializer referenceSerializer;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private IEarlyExitComputer exitComputer;
    @Inject
    private JvmOnlyTypeConformanceComputer typeConformanceComputer;
    @Inject
    private Primitives primitives;
    @Inject
    private JvmExceptions jvmExceptions;
    private PolymorphicDispatcher<Void> toJavaExprDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_toJavaExpression", (int)2, (int)2, (Object)this);
    private PolymorphicDispatcher<Void> toJavaStatementDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_toJavaStatement", (int)3, (int)3, (Object)this);
    @Inject
    private IdentifiableSimpleNameProvider nameProvider;

    protected TypeReferences getTypeReferences() {
        return this.typeReferences;
    }

    public void setTypeReferences(TypeReferences typeReferences) {
        this.typeReferences = typeReferences;
    }

    protected ITypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    protected Primitives getPrimitives() {
        return this.primitives;
    }

    public IAppendable compile(XExpression obj, IAppendable appendable, JvmTypeReference expectedReturnType) {
        return this.compile(obj, appendable, expectedReturnType, null);
    }

    public IAppendable compileAsJavaExpression(XExpression obj, IAppendable appendable, JvmTypeReference expectedType) {
        boolean needsToBeWrapped;
        boolean isPrimitiveVoidExpected = this.typeReferences.is(expectedType, Void.TYPE);
        boolean isPrimitiveVoid = this.isPrimitiveVoid(obj);
        boolean earlyExit = this.exitComputer.isEarlyExit(obj);
        boolean needsSneakyThrow = this.needsSneakyThrow(obj, Collections.<JvmTypeReference>emptySet());
        boolean bl = needsToBeWrapped = earlyExit || needsSneakyThrow || this.isVariableDeclarationRequired(obj, appendable);
        if (needsToBeWrapped) {
            appendable.openScope();
            try {
                Object thisElement = appendable.getObject("this");
                if (thisElement instanceof JvmType) {
                    appendable.declareVariable(thisElement, String.valueOf(((JvmType)thisElement).getSimpleName()) + ".this");
                    Object superElement = appendable.getObject("super");
                    if (superElement instanceof JvmType) {
                        appendable.declareVariable(superElement, String.valueOf(((JvmType)thisElement).getSimpleName()) + ".super");
                    }
                }
                appendable.append("new ");
                JvmTypeReference procedureOrFunction = null;
                procedureOrFunction = isPrimitiveVoidExpected ? this.typeReferences.getTypeForName(Procedures.Procedure0.class, (EObject)obj, new JvmTypeReference[0]) : this.typeReferences.getTypeForName(Functions.Function0.class, (EObject)obj, new JvmTypeReference[]{expectedType});
                this.referenceSerializer.serialize(procedureOrFunction, obj, appendable, false, false, true, false);
                appendable.append("() {").increaseIndentation();
                appendable.append("\npublic ");
                this.referenceSerializer.serialize(this.primitives.asWrapperTypeIfPrimitive(expectedType), obj, appendable);
                appendable.append(" apply() {").increaseIndentation();
                if (needsSneakyThrow) {
                    appendable.append("\ntry {").increaseIndentation();
                }
                this.internalToJavaStatement(obj, appendable, !isPrimitiveVoidExpected && !isPrimitiveVoid && !earlyExit);
                if (!isPrimitiveVoidExpected && !earlyExit) {
                    appendable.append("\nreturn ");
                    if (isPrimitiveVoid && !isPrimitiveVoidExpected) {
                        appendable.append("null");
                    } else {
                        this.internalToJavaExpression(obj, appendable);
                    }
                    appendable.append(";");
                }
                if (needsSneakyThrow) {
                    String name = appendable.declareSyntheticVariable(new Object(), "_e");
                    appendable.decreaseIndentation().append("\n} catch (Exception " + name + ") {").increaseIndentation();
                    appendable.append("\nthrow ");
                    appendable.append(this.typeReferences.findDeclaredType(Exceptions.class, (EObject)obj));
                    appendable.append(".sneakyThrow(");
                    appendable.append(name);
                    appendable.append(");");
                    appendable.decreaseIndentation().append("\n}");
                }
                appendable.decreaseIndentation().append("\n}");
                appendable.decreaseIndentation().append("\n}.apply()");
            }
            finally {
                appendable.closeScope();
            }
        } else {
            this.internalToJavaExpression(obj, appendable);
        }
        return appendable;
    }

    protected boolean canCompileToJavaExpression(XExpression expression, IAppendable appendable) {
        return !this.isVariableDeclarationRequired(expression, appendable);
    }

    public IAppendable compile(XExpression obj, IAppendable appendable, JvmTypeReference expectedReturnType, Set<JvmTypeReference> declaredExceptions) {
        if (declaredExceptions == null) {
            declaredExceptions = Sets.newHashSet();
        }
        boolean isPrimitiveVoidExpected = this.typeReferences.is(expectedReturnType, Void.TYPE);
        boolean isPrimitiveVoid = this.isPrimitiveVoid(obj);
        boolean earlyExit = this.exitComputer.isEarlyExit(obj);
        boolean needsSneakyThrow = this.needsSneakyThrow(obj, declaredExceptions);
        if (needsSneakyThrow) {
            appendable.append("\ntry {").increaseIndentation();
        }
        this.internalToJavaStatement(obj, appendable, !isPrimitiveVoidExpected && !isPrimitiveVoid && !earlyExit);
        if (!isPrimitiveVoidExpected && !earlyExit) {
            appendable.append("\nreturn ");
            if (isPrimitiveVoid && !isPrimitiveVoidExpected) {
                appendable.append("null");
            } else {
                this.internalToJavaExpression(obj, appendable);
            }
            appendable.append(";");
        }
        if (needsSneakyThrow) {
            String name = appendable.declareSyntheticVariable(new Object(), "_e");
            appendable.decreaseIndentation().append("\n} catch (Exception " + name + ") {").increaseIndentation();
            appendable.append("\nthrow ");
            appendable.append(this.typeReferences.findDeclaredType(Exceptions.class, (EObject)obj));
            appendable.append(".sneakyThrow(");
            appendable.append(name);
            appendable.append(");");
            appendable.decreaseIndentation().append("\n}");
        }
        return appendable;
    }

    protected boolean needsSneakyThrow(XExpression obj, Set<JvmTypeReference> declaredExceptions) {
        Iterable<JvmTypeReference> types = this.typeProvider.getThrownExceptionTypes(obj);
        Iterable<JvmTypeReference> exceptions = this.jvmExceptions.findUnhandledExceptions(obj, types, declaredExceptions);
        return !Iterables.isEmpty(exceptions);
    }

    public IAppendable compile(XBlockExpression expr, IAppendable b, JvmTypeReference expectedReturnType) {
        boolean isPrimitiveVoidExpected = this.typeReferences.is(expectedReturnType, Void.TYPE);
        boolean isPrimitiveVoid = this.isPrimitiveVoid(expr);
        boolean earlyExit = this.exitComputer.isEarlyExit(expr);
        boolean isImplicitReturn = !isPrimitiveVoidExpected && !isPrimitiveVoid && !earlyExit;
        EList<XExpression> expressions = expr.getExpressions();
        int i = 0;
        while (i < expressions.size()) {
            XExpression ex = (XExpression)expressions.get(i);
            if (i < expressions.size() - 1) {
                this.internalToJavaStatement(ex, b, false);
            } else {
                this.internalToJavaStatement(ex, b, isImplicitReturn);
                if (isImplicitReturn) {
                    b.append("\nreturn (");
                    this.internalToConvertedExpression(ex, b, null);
                    b.append(");");
                }
            }
            ++i;
        }
        return b;
    }

    protected abstract void internalToConvertedExpression(XExpression var1, IAppendable var2, JvmTypeReference var3);

    protected boolean isPrimitiveVoid(XExpression xExpression) {
        JvmTypeReference type = this.getTypeProvider().getType(xExpression);
        return this.typeReferences.is(type, Void.TYPE);
    }

    protected void internalToJavaStatement(XExpression obj, IAppendable builder, boolean isReferenced) {
        this.toJavaStatementDispatcher.invoke(new Object[]{obj, builder, isReferenced});
    }

    public void toJavaExpression(XExpression obj, IAppendable appendable) {
        this.internalToJavaExpression(obj, appendable);
    }

    public void toJavaStatement(XExpression obj, IAppendable appendable, boolean isReferenced) {
        this.internalToJavaStatement(obj, appendable, isReferenced);
    }

    protected void internalToJavaExpression(XExpression obj, IAppendable appendable) {
        this.toJavaExprDispatcher.invoke(new Object[]{obj, appendable});
    }

    public void _toJavaStatement(XExpression func, IAppendable b, boolean isReferenced) {
        throw new UnsupportedOperationException("Coudn't find a compilation strategy for expressions of type " + func.getClass().getCanonicalName());
    }

    public void _toJavaExpression(XExpression func, IAppendable b) {
        throw new UnsupportedOperationException("Coudn't find a compilation strategy for expressions of type " + func.getClass().getCanonicalName());
    }

    public void _toJavaStatement(Void func, IAppendable b, boolean isReferenced) {
        throw new NullPointerException();
    }

    public void _toJavaExpression(Void func, IAppendable b) {
        throw new NullPointerException();
    }

    protected void serialize(JvmTypeReference type, EObject context, IAppendable appendable) {
        this.serialize(type, context, appendable, false, true);
    }

    protected void serialize(JvmTypeReference type, EObject context, IAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard) {
        this.serialize(type, context, appendable, withoutConstraints, paramsToWildcard, false, true);
    }

    protected void serialize(JvmTypeReference type, EObject context, IAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard, boolean paramsToObject, boolean allowPrimitives) {
        this.referenceSerializer.serialize(type, context, appendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
    }

    protected boolean isReferenceToForeignTypeParameter(JvmTypeReference reference, EObject context) {
        JvmType type = reference.getType();
        if (type instanceof JvmTypeParameter) {
            return !this.referenceSerializer.isLocalTypeParameter(context, (JvmTypeParameter)type);
        }
        return false;
    }

    protected JvmTypeReference resolveMultiType(JvmTypeReference typeRef) {
        return this.referenceSerializer.resolveMultiType(typeRef);
    }

    protected String getVarName(Object ex, IAppendable appendable) {
        String name = appendable.getName(ex);
        return name;
    }

    public void setNameProvider(IdentifiableSimpleNameProvider nameProvider) {
        this.nameProvider = nameProvider;
    }

    protected IdentifiableSimpleNameProvider getNameProvider() {
        return this.nameProvider;
    }

    protected String getFavoriteVariableName(EObject ex) {
        if (ex instanceof XVariableDeclaration) {
            return ((XVariableDeclaration)ex).getName();
        }
        if (ex instanceof JvmFormalParameter) {
            return ((JvmFormalParameter)ex).getName();
        }
        if (ex instanceof JvmIdentifiableElement) {
            return ((JvmIdentifiableElement)ex).getSimpleName();
        }
        if (ex instanceof XAbstractFeatureCall) {
            String name = this.nameProvider.getSimpleName(((XAbstractFeatureCall)ex).getFeature());
            int indexOf = name.indexOf(40);
            if (indexOf != -1) {
                name = name.substring(0, indexOf);
            }
            if ((indexOf = name.lastIndexOf(46)) != -1) {
                name = name.substring(indexOf + 1);
            }
            if (name.startsWith("get") && name.length() > 3) {
                name = Strings.toFirstLower((String)name.substring(3));
            }
            if (name.startsWith("to") && name.length() > 2) {
                name = Strings.toFirstLower((String)name.substring(2));
            }
            return "_" + name;
        }
        if (ex instanceof XConstructorCall) {
            String name = ((XConstructorCall)ex).getConstructor().getSimpleName();
            return "_" + Strings.toFirstLower((String)name);
        }
        return "_" + Strings.toFirstLower((String)ex.eClass().getName().toLowerCase());
    }

    protected String makeJavaIdentifier(String name) {
        return name.equals("this") ? "_this" : name;
    }

    protected void declareSyntheticVariable(final XExpression expr, final IAppendable b) {
        this.declareSyntheticVariable(expr, b, new Later(){

            public void exec() {
                b.append(AbstractXbaseCompiler.this.getDefaultValueLiteral(expr));
            }
        });
    }

    protected String getDefaultValueLiteral(XExpression expr) {
        JvmTypeReference type = this.getTypeProvider().getType(expr);
        if (this.primitives.isPrimitive(type)) {
            if (this.primitives.primitiveKind((JvmPrimitiveType)type.getType()) == Primitives.Primitive.Boolean) {
                return "false";
            }
            return "(" + type.getQualifiedName() + ") 0";
        }
        return "null";
    }

    protected void declareSyntheticVariable(XExpression expr, IAppendable b, Later expression) {
        JvmTypeReference expectedType;
        JvmTypeReference type = this.getTypeProvider().getType(expr);
        if (type instanceof JvmAnyTypeReference && (expectedType = this.getTypeProvider().getExpectedType(expr)) != null && !(expectedType.getType() instanceof JvmTypeParameter)) {
            type = expectedType;
        }
        String proposedName = this.makeJavaIdentifier(this.getFavoriteVariableName(expr));
        String varName = b.declareSyntheticVariable(expr, proposedName);
        b.append("\n");
        this.serialize(type, expr, b);
        b.append(" ").append(varName).append(" = ");
        expression.exec();
        b.append(";");
    }

    protected boolean isVariableDeclarationRequired(XExpression expr, IAppendable b) {
        return true;
    }

    protected TypeConformanceComputer getTypeConformanceComputer() {
        return this.typeConformanceComputer;
    }
}

