/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hover;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.ui.XtextUIMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHover
implements IAnnotationHover,
ITextHover,
ITextHoverExtension2 {
    protected final ISourceViewer sourceViewer;

    public AbstractHover(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            throw new IllegalArgumentException();
        }
        this.sourceViewer = sourceViewer;
    }

    public IDocument getDocument() {
        return this.sourceViewer.getDocument();
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        return this.getHoverInfoInternal(lineNumber, -1);
    }

    @Deprecated
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfo2(textViewer, hoverRegion);
    }

    public String getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        int lineNumber;
        try {
            lineNumber = this.getDocument().getLineOfOffset(hoverRegion.getOffset());
        }
        catch (BadLocationException e) {
            return null;
        }
        return this.getHoverInfoInternal(lineNumber, hoverRegion.getOffset());
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        Point selection = textViewer.getSelectedRange();
        if (selection.x <= offset && offset < selection.x + selection.y) {
            return new Region(selection.x, selection.y);
        }
        return new Region(offset, 0);
    }

    protected String formatInfo(Collection<String> messages) {
        StringBuffer buffer = new StringBuffer();
        if (messages.size() > 1) {
            buffer.append(XtextUIMessages.AbstractHover_MultipleMarkers);
            Iterator<String> e = messages.iterator();
            while (e.hasNext()) {
                this.splitInfo("- " + e.next() + "\n", buffer);
            }
        } else if (messages.size() == 1) {
            this.splitInfo(messages.iterator().next(), buffer);
        }
        return buffer.toString();
    }

    protected abstract String getHoverInfoInternal(int var1, int var2);

    private String splitInfo(String message, StringBuffer buffer) {
        int pos;
        String msg = message;
        String prefix = "";
        do {
            if ((pos = msg.indexOf(" ", 60)) > -1) {
                buffer.append(String.valueOf(prefix) + msg.substring(0, pos) + "\n");
                msg = msg.substring(pos);
                prefix = "  ";
                continue;
            }
            buffer.append(String.valueOf(prefix) + msg);
        } while (pos > -1);
        return buffer.toString();
    }
}

