/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.IQVTReconcilingListener;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Messages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.SignatureUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.osgi.util.NLS;

class OverrideIndicatorManager
implements IQVTReconcilingListener {
    static final String ANNOTATION_TYPE = "org.eclipse.m2m.qvt.oml.ui.overrideIndicator";
    private IAnnotationModel fAnnotationModel;
    private Object fAnnotationModelLockObject;
    private Annotation[] fOverrideAnnotations;

    public OverrideIndicatorManager(IAnnotationModel annotationModel) {
        if (annotationModel == null) {
            throw new IllegalArgumentException();
        }
        this.fAnnotationModel = annotationModel;
        this.fAnnotationModelLockObject = this.getLockObject(this.fAnnotationModel);
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAnnotations(CompiledUnit unit, IProgressMonitor progressMonitor) {
        if (progressMonitor.isCanceled()) {
            return;
        }
        UMLReflection uml = QvtOperationalEnvFactory.INSTANCE.createEnvironment().getUMLReflection();
        Map<Annotation, Position> annotationMap = Collections.emptyMap();
        if (unit != null && unit.getUnitCST() != null) {
            for (MappingModuleCS moduleCS : unit.getUnitCST().getModules()) {
                for (MappingMethodCS methodCS : moduleCS.getMethods()) {
                    ImperativeOperation imperativeOperation;
                    if (progressMonitor.isCanceled()) {
                        return;
                    }
                    if (!(methodCS.getAst() instanceof ImperativeOperation) || (imperativeOperation = (ImperativeOperation)methodCS.getAst()).getOverridden() == null) continue;
                    String text = NLS.bind((String)Messages.OverrideAnnotationText, (Object)SignatureUtil.getOperationSignature(uml, (EOperation)imperativeOperation.getOverridden()));
                    Annotation annotation = new Annotation(ANNOTATION_TYPE, false, text);
                    Position position = new Position(methodCS.getStartOffset(), 1);
                    if (annotationMap.isEmpty()) {
                        annotationMap = new HashMap();
                    }
                    annotationMap.put(annotation, position);
                }
            }
        }
        if (progressMonitor.isCanceled()) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, annotationMap);
            } else {
                this.removeAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    this.fAnnotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            this.fOverrideAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotations() {
        if (this.fOverrideAnnotations == null) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOverrideAnnotations.length;
                while (i < length) {
                    this.fAnnotationModel.removeAnnotation(this.fOverrideAnnotations[i]);
                    ++i;
                }
            }
            this.fOverrideAnnotations = null;
        }
    }

    @Override
    public void reconciled(CompiledUnit unit, IProgressMonitor monitor) {
        this.updateAnnotations(unit, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void aboutToBeReconciled() {
    }
}

