/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LiteralExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edges;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Nodes;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.OperationRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleMappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleRegion;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.util.AbstractExtendingQVTimperativeVisitor;

public class ExpressionAnalyzer
extends AbstractExtendingQVTimperativeVisitor<SimpleNode, SimpleMappingRegion> {
    protected final @NonNull SchedulerConstants scheduler;
    private ConditionalExpressionAnalyzer conditionalExpressionAnalyzer = null;

    protected ExpressionAnalyzer(@NonNull SimpleMappingRegion context) {
        super((Object)context);
        this.scheduler = context.getSchedulerConstants();
    }

    protected void addPredicateEdge(@NonNull SimpleNode sourceNode, @NonNull Property source2targetProperty, @NonNull SimpleNode targetNode) {
        assert (sourceNode.isClassNode());
        SimpleEdge predicateEdge = sourceNode.getPredicateEdge(source2targetProperty);
        if (predicateEdge == null) {
            this.createNavigationEdge(sourceNode, source2targetProperty, targetNode);
        } else assert (predicateEdge.getTarget() == targetNode);
    }

    public @NonNull SimpleNode analyze(Visitable element) {
        SimpleNode accept = (SimpleNode)element.accept((Visitor)this);
        assert (accept != null);
        return accept;
    }

    private @NonNull SimpleNode analyzeOperationCallExp_oclAsType(@NonNull SimpleNode sourceNode, @NonNull OperationCallExp operationCallExp) {
        Type type = operationCallExp.getType();
        assert (type != null);
        CompleteClass requiredClass = this.scheduler.getEnvironmentFactory().getCompleteModel().getCompleteClass(type);
        CompleteClass predicatedClass = sourceNode.getCompleteClass();
        if (predicatedClass.conformsTo(requiredClass)) {
            sourceNode.addTypedElement((TypedElement)operationCallExp);
            return sourceNode;
        }
        for (SimpleNavigationEdge castEdge : sourceNode.getCastEdges()) {
            SimpleNode targetNode = castEdge.getTarget();
            predicatedClass = targetNode.getCompleteClass();
            if (!predicatedClass.conformsTo(requiredClass)) continue;
            targetNode.addTypedElement((TypedElement)operationCallExp);
            return targetNode;
        }
        Type castType = type;
        assert (castType != null);
        Property castProperty = this.scheduler.getCastProperty(castType);
        SimpleEdge castEdge = sourceNode.getPredicateEdge(castProperty);
        if (castEdge != null) {
            SimpleNode castNode = castEdge.getTarget();
            castNode.addTypedElement((TypedElement)operationCallExp);
            return castNode;
        }
        String name = "a" + castType.getName();
        SimpleNode castNode = this.createStepNode(name, (CallExp)operationCallExp, sourceNode);
        castEdge = this.createCastEdge(sourceNode, castProperty, castNode);
        OCLExpression argument = (OCLExpression)operationCallExp.getOwnedArguments().get(0);
        if (!(argument instanceof TypeExp)) {
            SimpleNode argumentNode = this.analyze((Visitable)argument);
            this.createArgumentEdge(argumentNode, "\u00abarg\u00bb", castNode);
        }
        return castNode;
    }

    private @NonNull SimpleNode analyzeOperationCallExp_oclIsKindOf(@NonNull SimpleNode sourceNode, @NonNull OperationCallExp operationCallExp) {
        OCLExpression argument = (OCLExpression)operationCallExp.getOwnedArguments().get(0);
        SimpleNode operationNode = null;
        if (argument instanceof TypeExp) {
            String name = String.valueOf(operationCallExp.getReferredOperation().getName()) + "\\n" + ((TypeExp)argument).getReferredType().toString();
            operationNode = this.findOperationNode(sourceNode, name, new SimpleNode[0]);
            if (operationNode == null) {
                operationNode = this.createOperationNode(name, (TypedElement)operationCallExp, sourceNode);
                this.createArgumentEdge(sourceNode, null, operationNode);
            }
        } else {
            String name = operationCallExp.getReferredOperation().getName();
            assert (name != null);
            SimpleNode argumentNode = this.analyze((Visitable)argument);
            operationNode = this.findOperationNode(sourceNode, name, argumentNode);
            if (operationNode == null) {
                operationNode = this.createOperationNode(name, (TypedElement)operationCallExp, sourceNode, argumentNode);
                this.createArgumentEdge(sourceNode, "\u00absource\u00bb", operationNode);
                this.createArgumentEdge(argumentNode, "\u00abarg\u00bb", operationNode);
            }
        }
        return operationNode;
    }

    private @NonNull SimpleNode analyzeOperationCallExp_oclContainer(@NonNull SimpleNode sourceNode, @NonNull OperationCallExp operationCallExp) {
        Type castType = operationCallExp.getType();
        assert (castType != null);
        Property oclContainerProperty = this.scheduler.getOclContainerProperty();
        SimpleEdge oclContainerEdge = sourceNode.getPredicateEdge(oclContainerProperty);
        if (oclContainerEdge != null) {
            return oclContainerEdge.getTarget();
        }
        String name = operationCallExp.getReferredOperation().getName();
        assert (name != null);
        SimpleNode oclContainerNode = this.createStepNode(name, (CallExp)operationCallExp, sourceNode);
        oclContainerEdge = this.createNavigationEdge(sourceNode, oclContainerProperty, oclContainerNode);
        return oclContainerNode;
    }

    protected @NonNull SimpleEdge createArgumentEdge(@NonNull SimpleNode sourceNode, @Nullable String name, @NonNull SimpleNode targetNode) {
        return Edges.ARGUMENT.createSimpleEdge((SimpleRegion)this.context, sourceNode, name, targetNode);
    }

    protected @NonNull SimpleEdge createCastEdge(@NonNull SimpleNode sourceNode, @NonNull Property castProperty, @NonNull SimpleNode castNode) {
        return Edges.CAST.createSimpleEdge((SimpleRegion)this.context, sourceNode, castProperty, castNode);
    }

    protected @NonNull SimpleNode createErrorNode(@NonNull String name, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        return Nodes.ERROR.createSimpleNode((SimpleRegion)this.context, name, classDatumAnalysis);
    }

    protected @NonNull SimpleEdge createIteratedEdge(@NonNull SimpleNode sourceNode, @NonNull SimpleNode targetNode) {
        return Edges.ITERATED.createSimpleEdge((SimpleRegion)this.context, sourceNode, targetNode);
    }

    protected @NonNull SimpleNode createIteratorNode(@NonNull Variable iterator, @NonNull SimpleNode sourceNode) {
        return Nodes.ITERATOR.createSimpleNode((SimpleRegion)this.context, iterator, sourceNode);
    }

    protected @NonNull SimpleNode createLetNode(@NonNull Variable letVariable, @NonNull SimpleNode inNode) {
        return Nodes.LET.createSimpleNode((SimpleRegion)this.context, letVariable, inNode);
    }

    protected @NonNull SimpleEdge createNavigationEdge(@NonNull SimpleNode sourceNode, @NonNull Property source2targetProperty, @NonNull SimpleNode targetNode) {
        return Edges.NAVIGATION.createSimpleEdge((SimpleRegion)this.context, sourceNode, source2targetProperty, targetNode);
    }

    protected @NonNull SimpleNode createNullNode(@NonNull TypedElement typedElement) {
        return Nodes.NULL.createSimpleNode((SimpleRegion)this.context, typedElement);
    }

    protected @NonNull SimpleNode createOperationNode(@NonNull String name, @NonNull TypedElement typedElement, SimpleNode ... argNodes) {
        return Nodes.OPERATION.createSimpleNode((SimpleRegion)this.context, name, typedElement, argNodes);
    }

    protected @NonNull SimpleNode createPredicatedClassNode(@NonNull SimpleNode parentNode, @NonNull NavigationAssignment navigationAssignment) {
        return Nodes.AttributeNodeRoleFactory.PREDICATED_CLASS.createSimpleNode((SimpleRegion)this.context, parentNode, navigationAssignment);
    }

    protected @NonNull SimpleNode createPredicatedClassNode(@NonNull String name, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        return Nodes.AttributeNodeRoleFactory.PREDICATED_CLASS.createSimpleNode((SimpleRegion)this.context, name, classDatumAnalysis);
    }

    protected @NonNull SimpleEdge createRealizedArgumentEdge(@NonNull SimpleNode sourceNode, @Nullable String name, @NonNull SimpleNode targetNode) {
        return Edges.ArgumentEdgeRoleFactory.REALIZED_ARGUMENT.createEdge((SimpleRegion)this.context, sourceNode, name, targetNode);
    }

    protected @NonNull SimpleNode createStepNode(@NonNull String name, @NonNull CallExp callExp, @NonNull SimpleNode sourceNode) {
        return Nodes.STEP.createSimpleNode((SimpleRegion)this.context, name, callExp, sourceNode);
    }

    private @Nullable SimpleNode findOperationNode(@NonNull SimpleNode sourceNode, @NonNull String name, SimpleNode ... argumentNodes) {
        for (SimpleEdge simpleEdge : sourceNode.getResultEdges()) {
            SimpleNode operationNode;
            SimpleNode targetNode = simpleEdge.getTarget();
            if (!targetNode.isExpression() || !(operationNode = targetNode).getName().equals(name)) continue;
            int argIndex = -1;
            for (Edge argumentEdge : targetNode.getArgumentEdges()) {
                if (argIndex == -1) {
                    if (argumentEdge != simpleEdge) {
                        operationNode = null;
                        break;
                    }
                } else if (argumentNodes == null || argumentNodes.length <= argIndex || argumentNodes[argIndex] != argumentEdge.getSource()) {
                    operationNode = null;
                    break;
                }
                ++argIndex;
            }
            if (operationNode == null || argumentNodes != null && argIndex != argumentNodes.length) continue;
            return operationNode;
        }
        return null;
    }

    private @NonNull ExpressionAnalyzer getConditionalExpressionAnalyzer() {
        ConditionalExpressionAnalyzer conditionalExpressionAnalyzer2 = this.conditionalExpressionAnalyzer;
        if (conditionalExpressionAnalyzer2 == null) {
            this.conditionalExpressionAnalyzer = conditionalExpressionAnalyzer2 = new ConditionalExpressionAnalyzer();
        }
        return conditionalExpressionAnalyzer2;
    }

    private void instantiate(@NonNull SimpleNode instantiatedNode, @NonNull Node extraNode) {
        for (NavigationEdge extraEdge : extraNode.getNavigationEdges()) {
            Node extraTargetNode = extraEdge.getTarget();
            String name = extraTargetNode.getName();
            ClassDatumAnalysis classDatumAnalysis = extraTargetNode.getClassDatumAnalysis();
            SimpleNode instantiatedTargetNode = this.createPredicatedClassNode(name, classDatumAnalysis);
            this.createNavigationEdge(instantiatedNode, extraEdge.getProperty(), instantiatedTargetNode);
            this.instantiate(instantiatedTargetNode, extraTargetNode);
        }
    }

    public @NonNull SimpleNode visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    public @NonNull SimpleNode visitCollectionLiteralExp(@NonNull CollectionLiteralExp collectionLiteralExp) {
        List ownedParts = collectionLiteralExp.getOwnedParts();
        int iSize = ownedParts.size();
        SimpleNode[] partNodes = new SimpleNode[iSize];
        int i = 0;
        while (i < iSize) {
            partNodes[i] = this.analyze((Visitable)ownedParts.get(i));
            ++i;
        }
        SimpleNode operationNode = this.createOperationNode((String)ClassUtil.nonNullState((Object)collectionLiteralExp.getKind().toString()), (TypedElement)collectionLiteralExp, partNodes);
        int i2 = 0;
        while (i2 < iSize) {
            this.createArgumentEdge((SimpleNode)ClassUtil.nonNullState((Object)partNodes[i2]), "\u00abarg" + i2 + "\u00bb", operationNode);
            ++i2;
        }
        return operationNode;
    }

    public @NonNull SimpleNode visitCollectionItem(@NonNull CollectionItem collectionItem) {
        return this.analyze((Visitable)collectionItem.getOwnedItem());
    }

    public @NonNull SimpleNode visitCollectionRange(@NonNull CollectionRange collectionRange) {
        SimpleNode firstNode = this.analyze((Visitable)collectionRange.getOwnedFirst());
        SimpleNode lastNode = this.analyze((Visitable)collectionRange.getOwnedLast());
        SimpleNode operationNode = this.createOperationNode("..", (TypedElement)collectionRange, firstNode, lastNode);
        this.createArgumentEdge(firstNode, "first", operationNode);
        this.createArgumentEdge(lastNode, "last", operationNode);
        return operationNode;
    }

    public @NonNull SimpleNode visitElement(@NonNull Element element) {
        Class oclInvalidType = this.scheduler.getStandardLibrary().getOclInvalidType();
        ClassDatumAnalysis classDatumAnalysis = this.scheduler.getClassDatumAnalysis(oclInvalidType, this.scheduler.getDomainAnalysis().getPrimitiveTypeModel());
        SimpleNode errorNode = this.createErrorNode("\u00aberror\u00bb", classDatumAnalysis);
        for (EObject eObject : element.eContents()) {
            SimpleNode node = this.analyze((Visitable)eObject);
            this.createArgumentEdge(node, "?", errorNode);
        }
        return errorNode;
    }

    public @NonNull SimpleNode visitIfExp(@NonNull IfExp ifExp) {
        ExpressionAnalyzer conditionalExpressionAnalyzer = this.getConditionalExpressionAnalyzer();
        SimpleNode conditionNode = this.analyze((Visitable)ifExp.getOwnedCondition());
        SimpleNode thenNode = conditionalExpressionAnalyzer.analyze((Visitable)ifExp.getOwnedThen());
        SimpleNode elseNode = conditionalExpressionAnalyzer.analyze((Visitable)ifExp.getOwnedElse());
        SimpleNode ifNode = this.createOperationNode("if", (TypedElement)ifExp, conditionNode, thenNode, elseNode);
        this.createArgumentEdge(conditionNode, "condition", ifNode);
        this.createArgumentEdge(thenNode, "then", ifNode);
        this.createArgumentEdge(elseNode, "else", ifNode);
        return ifNode;
    }

    public @NonNull SimpleNode visitLetExp(@NonNull LetExp letExp) {
        CompleteClass requiredClass;
        Variable ownedVariable = letExp.getOwnedVariable();
        SimpleNode initNode = this.analyze((Visitable)ownedVariable.getOwnedInit());
        assert (initNode != null);
        Type type = ownedVariable.getType();
        assert (type != null);
        CompleteClass actualClass = initNode.getCompleteClass();
        if (actualClass.conformsTo(requiredClass = ((SimpleMappingRegion)this.context).getClassDatumAnalysis((TypedElement)ownedVariable).getCompleteClass())) {
            ((SimpleMappingRegion)this.context).addVariableNode((VariableDeclaration)ownedVariable, initNode);
            initNode.addTypedElement((TypedElement)ownedVariable);
        } else {
            SimpleNode varNode = this.createLetNode(ownedVariable, initNode);
            Property castProperty = this.scheduler.getCastProperty(type);
            this.createNavigationEdge(initNode, castProperty, varNode);
        }
        return this.analyze((Visitable)letExp.getOwnedIn());
    }

    public @NonNull SimpleNode visitLiteralExp(@NonNull LiteralExp literalExp) {
        SimpleNode operationNode = this.createOperationNode((String)ClassUtil.nonNullState((Object)literalExp.toString()), (TypedElement)literalExp, new SimpleNode[0]);
        return operationNode;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull SimpleNode visitLoopExp(@NonNull LoopExp loopExp) {
        SimpleNode bodyNode;
        assert (!loopExp.isIsSafe());
        SimpleNode sourceNode = this.analyze((Visitable)loopExp.getOwnedSource());
        @NonNull List ownedIterators = ClassUtil.nullFree((List)loopExp.getOwnedIterators());
        SimpleNode[] argNodes = new SimpleNode[1 + ownedIterators.size() + (loopExp instanceof IterateExp ? 1 : 0)];
        int i = 1;
        for (Variable iterator : ownedIterators) {
            SimpleNode iteratorNode = this.createIteratorNode(iterator, sourceNode);
            Type iteratorType = iterator.getType();
            assert (iteratorType != null);
            this.createIteratedEdge(sourceNode, iteratorNode);
            argNodes[i++] = iteratorNode;
        }
        if (loopExp instanceof IterateExp) {
            Variable accumulator = ((IterateExp)loopExp).getOwnedResult();
            assert (accumulator != null);
            SimpleNode iteratorNode = this.createIteratorNode(accumulator, sourceNode);
            Type iteratorType = accumulator.getType();
            assert (iteratorType != null);
            this.createIteratedEdge(sourceNode, iteratorNode);
            argNodes[i++] = iteratorNode;
        }
        argNodes[0] = bodyNode = this.analyze((Visitable)loopExp.getOwnedBody());
        String iterationName = "\u00ab" + loopExp.getReferredIteration().getName() + "\u00bb";
        SimpleNode accumulateNode = this.createOperationNode(iterationName, (TypedElement)loopExp, argNodes);
        this.createArgumentEdge(sourceNode, "\u00absource\u00bb", accumulateNode);
        this.createArgumentEdge(bodyNode, "\u00abbody\u00bb", accumulateNode);
        i = 1;
        for (Variable iterator : ownedIterators) {
            SimpleNode iteratorNode = argNodes[i++];
            assert (iteratorNode != null);
            this.createArgumentEdge(iteratorNode, iterator.getName(), accumulateNode);
        }
        return accumulateNode;
    }

    public @NonNull SimpleNode visitMapLiteralExp(@NonNull MapLiteralExp mapLiteralExp) {
        List ownedParts = mapLiteralExp.getOwnedParts();
        int iSize = ownedParts.size();
        SimpleNode[] partNodes = new SimpleNode[iSize];
        int i = 0;
        while (i < iSize) {
            partNodes[i] = this.analyze((Visitable)ownedParts.get(i));
            ++i;
        }
        SimpleNode operationNode = this.createOperationNode((String)ClassUtil.nonNullState((Object)mapLiteralExp.getName()), (TypedElement)mapLiteralExp, partNodes);
        int i2 = 0;
        while (i2 < iSize) {
            this.createArgumentEdge((SimpleNode)ClassUtil.nonNullState((Object)partNodes[i2]), "\u00abarg" + i2 + "\u00bb", operationNode);
            ++i2;
        }
        return operationNode;
    }

    public @NonNull SimpleNode visitMapLiteralPart(@NonNull MapLiteralPart mapLiteralPart) {
        OCLExpression ownedValue = mapLiteralPart.getOwnedValue();
        assert (ownedValue != null);
        SimpleNode keyNode = this.analyze((Visitable)mapLiteralPart.getOwnedKey());
        SimpleNode valueNode = this.analyze((Visitable)ownedValue);
        SimpleNode operationNode = this.createOperationNode("Part", (TypedElement)ownedValue, keyNode, valueNode);
        this.createArgumentEdge(keyNode, "key", operationNode);
        this.createArgumentEdge(valueNode, "value", operationNode);
        return operationNode;
    }

    public @NonNull SimpleNode visitNavigationAssignment(@NonNull NavigationAssignment asNavigationAssignment) {
        Property property = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)asNavigationAssignment);
        assert (property != null);
        SimpleNode slotNode = this.analyze((Visitable)asNavigationAssignment.getSlotExpression());
        assert (slotNode.isClassNode());
        SimpleNode valueNode = this.analyze((Visitable)asNavigationAssignment.getValue());
        if (valueNode.isExpression()) {
            SimpleNode computedValueNode = valueNode;
            Type type = property.getType();
            if (type instanceof DataType) {
                valueNode = ((SimpleMappingRegion)this.context).getAssignedAttributeNode(slotNode, property);
                this.createRealizedArgumentEdge(computedValueNode, null, valueNode);
            } else {
                String name = property.getName();
                assert (name != null && type != null);
                valueNode = this.createPredicatedClassNode(slotNode, asNavigationAssignment);
                this.createArgumentEdge(computedValueNode, null, valueNode);
            }
        }
        SimpleNavigationEdge navigationEdge = slotNode.getNavigationEdge(property);
        CompleteClass valueCompleteClass = valueNode.getCompleteClass();
        Type propertyType = (Type)ClassUtil.nonNullState((Object)property.getType());
        CompleteClass targetCompleteClass = this.scheduler.getEnvironmentFactory().getCompleteModel().getCompleteClass(propertyType);
        if (!valueCompleteClass.conformsTo(targetCompleteClass) && targetCompleteClass.getPrimaryClass().getESObject() != EcorePackage.Literals.EOBJECT && !valueCompleteClass.conformsTo(targetCompleteClass)) {
            throw new IllegalStateException("Incompatible types for " + asNavigationAssignment);
        }
        ((SimpleMappingRegion)this.context).addAssignmentEdge(slotNode, property, valueNode);
        Property oppositeProperty = property.getOpposite();
        if (valueNode.isClassNode() && oppositeProperty != null && !oppositeProperty.isIsMany()) {
            ((SimpleMappingRegion)this.context).addAssignmentEdge(valueNode, oppositeProperty, slotNode);
        }
        if (navigationEdge != null) {
            ((SimpleMappingRegion)this.context).mergeInto(navigationEdge.getTarget(), valueNode);
        }
        return slotNode;
    }

    public @NonNull SimpleNode visitNavigationCallExp(@NonNull NavigationCallExp navigationCallExp) {
        assert (!navigationCallExp.isIsSafe());
        Property referredProperty = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
        assert (referredProperty != null);
        OCLExpression ownedSource = navigationCallExp.getOwnedSource();
        assert (ownedSource != null);
        SimpleNode sourceNode = this.analyze((Visitable)ownedSource);
        if (sourceNode.isClassNode()) {
            SimpleNavigationEdge navigationEdge;
            SimpleNode sourceReferenceNode = sourceNode;
            if (!referredProperty.isIsMany() && (navigationEdge = sourceReferenceNode.getNavigationEdge(referredProperty)) != null) {
                SimpleNode targetNode = navigationEdge.getTarget();
                return targetNode;
            }
            Type type = referredProperty.getType();
            if (type instanceof DataType) {
                SimpleNode attributeNode = ((SimpleMappingRegion)this.context).getPredicatedAttributeNode(sourceReferenceNode, navigationCallExp);
                this.addPredicateEdge(sourceReferenceNode, referredProperty, attributeNode);
                return attributeNode;
            }
            String name = referredProperty.getName();
            assert (name != null && type != null);
            SimpleNode targetReferenceNode = this.createStepNode(name, (CallExp)navigationCallExp, sourceNode);
            this.addPredicateEdge(sourceReferenceNode, referredProperty, targetReferenceNode);
            return targetReferenceNode;
        }
        return ((SimpleMappingRegion)this.context).getUnknownNode((TypedElement)ownedSource);
    }

    public @NonNull SimpleNode visitNullLiteralExp(@NonNull NullLiteralExp nullLiteralExp) {
        return this.createNullNode((TypedElement)nullLiteralExp);
    }

    public @NonNull SimpleNode visitOCLExpression(@NonNull OCLExpression oclExpression) {
        return ((SimpleMappingRegion)this.context).getUnknownNode((TypedElement)oclExpression);
    }

    public @NonNull SimpleNode visitOperationCallExp(@NonNull OperationCallExp operationCallExp) {
        Type returnType;
        OperationRegion operationRegion;
        List<Node> extraNodes;
        Transformation transformation;
        assert (!operationCallExp.isIsSafe());
        Operation referredOperation = operationCallExp.getReferredOperation();
        OCLExpression ownedSource = operationCallExp.getOwnedSource();
        if (ownedSource instanceof VariableExp && (transformation = QVTbaseUtil.getContainingTransformation((EObject)operationCallExp)) != null) {
            Variable thisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)this.scheduler.getStandardLibrary(), (Transformation)transformation);
            if (((VariableExp)ownedSource).getReferredVariable() == thisVariable) {
                ownedSource = null;
            }
        }
        String name = referredOperation.getName();
        if (ownedSource == null) {
            List ownedArguments = operationCallExp.getOwnedArguments();
            int iSize = ownedArguments.size();
            SimpleNode[] argNodes = new SimpleNode[iSize];
            int i = 0;
            while (i < iSize) {
                argNodes[i] = this.analyze((Visitable)ownedArguments.get(i));
                ++i;
            }
            SimpleNode operationNode = this.createOperationNode((String)ClassUtil.nonNullState((Object)name), (TypedElement)operationCallExp, argNodes);
            int i2 = 0;
            while (i2 < iSize) {
                this.createArgumentEdge((SimpleNode)ClassUtil.nonNullState((Object)argNodes[i2]), "\u00abarg" + i2 + "\u00bb", operationNode);
                ++i2;
            }
            return operationNode;
        }
        SimpleNode sourceNode = this.analyze((Visitable)ownedSource);
        OperationId operationId = referredOperation.getOperationId();
        if (operationId == this.scheduler.getOclAnyOclAsTypeId()) {
            return this.analyzeOperationCallExp_oclAsType(sourceNode, operationCallExp);
        }
        if (PivotUtil.isSameOperation((OperationId)operationId, (OperationId)this.scheduler.getOclElementOclContainerId())) {
            return this.analyzeOperationCallExp_oclContainer(sourceNode, operationCallExp);
        }
        if (PivotUtil.isSameOperation((OperationId)operationId, (OperationId)this.scheduler.getOclAnyOclIsKindOfId())) {
            return this.analyzeOperationCallExp_oclIsKindOf(sourceNode, operationCallExp);
        }
        List ownedArguments = operationCallExp.getOwnedArguments();
        int iSize = ownedArguments.size();
        SimpleNode[] argNodes = new SimpleNode[iSize + 1];
        argNodes[0] = sourceNode;
        int i = 0;
        while (i < iSize) {
            argNodes[i + 1] = this.analyze((Visitable)ownedArguments.get(i));
            ++i;
        }
        SimpleNode operationNode = this.createOperationNode((String)ClassUtil.nonNullState((Object)name), (TypedElement)operationCallExp, argNodes);
        int i3 = 0;
        while (i3 <= iSize) {
            this.createArgumentEdge((SimpleNode)ClassUtil.nonNullState((Object)argNodes[i3]), "\u00abarg" + i3 + "\u00bb", operationNode);
            ++i3;
        }
        if (referredOperation.getBodyExpression() != null && (extraNodes = (operationRegion = ((SimpleMappingRegion)this.context).getSuperRegion().analyzeOperation(operationCallExp)).getExtraNodes()).size() > 0) {
            for (Node extraNode : extraNodes) {
                ClassDatumAnalysis classDatumAnalysis = extraNode.getClassDatumAnalysis();
                SimpleNode extraGuard = ((SimpleMappingRegion)this.context).getExtraGuard(classDatumAnalysis);
                if (extraGuard != null) continue;
                extraGuard = ((SimpleMappingRegion)this.context).createExtraGuard(classDatumAnalysis);
                this.createArgumentEdge(extraGuard, extraGuard.getName(), operationNode);
                this.instantiate(extraGuard, extraNode);
            }
        }
        if ((returnType = operationCallExp.getType()) instanceof DataType) {
            return operationNode;
        }
        return operationNode;
    }

    public @NonNull SimpleNode visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment asNavigationAssignment) {
        return this.visitNavigationAssignment((NavigationAssignment)asNavigationAssignment);
    }

    public @NonNull SimpleNode visitPropertyAssignment(@NonNull PropertyAssignment asNavigationAssignment) {
        return this.visitNavigationAssignment((NavigationAssignment)asNavigationAssignment);
    }

    public @NonNull SimpleNode visitShadowExp(@NonNull ShadowExp shadowExp) {
        List ownedParts = shadowExp.getOwnedParts();
        int iSize = ownedParts.size();
        SimpleNode[] partNodes = new SimpleNode[iSize];
        int i = 0;
        while (i < iSize) {
            partNodes[i] = this.analyze((Visitable)ownedParts.get(i));
            ++i;
        }
        SimpleNode operationNode = this.createOperationNode((String)ClassUtil.nonNullState((Object)shadowExp.getType().getName()), (TypedElement)shadowExp, partNodes);
        int i2 = 0;
        while (i2 < iSize) {
            this.createArgumentEdge((SimpleNode)ClassUtil.nonNullState((Object)partNodes[i2]), "\u00abarg" + i2 + "\u00bb", operationNode);
            ++i2;
        }
        return operationNode;
    }

    public @NonNull SimpleNode visitShadowPart(@NonNull ShadowPart shadowPart) {
        SimpleNode partNode = this.analyze((Visitable)shadowPart.getOwnedInit());
        SimpleNode operationNode = this.createOperationNode((String)ClassUtil.nonNullState((Object)shadowPart.getName()), (TypedElement)shadowPart, partNode);
        this.createArgumentEdge(partNode, "\u00abarg\u00bb", operationNode);
        return operationNode;
    }

    public @NonNull SimpleNode visitTupleLiteralExp(@NonNull TupleLiteralExp tupleLiteralExp) {
        List ownedParts = tupleLiteralExp.getOwnedParts();
        int iSize = ownedParts.size();
        SimpleNode[] partNodes = new SimpleNode[iSize];
        int i = 0;
        while (i < iSize) {
            partNodes[i] = this.analyze((Visitable)ownedParts.get(i));
            ++i;
        }
        SimpleNode operationNode = this.createOperationNode((String)ClassUtil.nonNullState((Object)tupleLiteralExp.getName()), (TypedElement)tupleLiteralExp, partNodes);
        int i2 = 0;
        while (i2 < iSize) {
            this.createArgumentEdge((SimpleNode)ClassUtil.nonNullState((Object)partNodes[i2]), "\u00abarg" + i2 + "\u00bb", operationNode);
            ++i2;
        }
        return operationNode;
    }

    public @NonNull SimpleNode visitTupleLiteralPart(@NonNull TupleLiteralPart tupleLiteralPart) {
        SimpleNode partNode = this.analyze((Visitable)tupleLiteralPart.getOwnedInit());
        SimpleNode operationNode = this.createOperationNode((String)ClassUtil.nonNullState((Object)tupleLiteralPart.getName()), (TypedElement)tupleLiteralPart, partNode);
        this.createArgumentEdge(partNode, "\u00abarg\u00bb", operationNode);
        return operationNode;
    }

    public @NonNull SimpleNode visitTypeExp(@NonNull TypeExp typeExp) {
        DomainUsage domainUsage = this.scheduler.getDomainUsage((Element)typeExp);
        Type referredType = typeExp.getReferredType();
        assert (referredType != null);
        TypedModel typedModel = domainUsage.getTypedModel((Element)typeExp);
        assert (typedModel != null);
        ClassDatumAnalysis classDatumAnalysis = this.scheduler.getClassDatumAnalysis((Class)referredType, typedModel);
        String typeName = PrettyPrinter.printType((Element)classDatumAnalysis.getCompleteClass());
        SimpleNode operationNode = this.createOperationNode(typeName, (TypedElement)typeExp, new SimpleNode[0]);
        return operationNode;
    }

    public @NonNull SimpleNode visitVariableExp(@NonNull VariableExp variableExp) {
        VariableDeclaration referredVariable = variableExp.getReferredVariable();
        assert (referredVariable != null);
        return ((SimpleMappingRegion)this.context).getReferenceNode(referredVariable);
    }

    public class ConditionalExpressionAnalyzer
    extends ExpressionAnalyzer {
        protected ConditionalExpressionAnalyzer() {
            super((SimpleMappingRegion)ExpressionAnalyzer.this.context);
        }

        @Override
        protected @NonNull SimpleEdge createCastEdge(@NonNull SimpleNode sourceNode, @NonNull Property castProperty, @NonNull SimpleNode castNode) {
            return Edges.UNNAVIGABLE_CAST.createSimpleEdge((SimpleRegion)this.context, sourceNode, castProperty, castNode);
        }

        @Override
        protected @NonNull SimpleEdge createNavigationEdge(@NonNull SimpleNode sourceNode, @NonNull Property source2targetProperty, @NonNull SimpleNode targetNode) {
            return Edges.UNNAVIGABLE_NAVIGATION.createSimpleEdge((SimpleRegion)this.context, sourceNode, source2targetProperty, targetNode);
        }

        @Override
        protected @NonNull SimpleNode createStepNode(@NonNull String name, @NonNull CallExp callExp, @NonNull SimpleNode sourceNode) {
            return Nodes.UNNAVIGABLE_STEP.createSimpleNode((SimpleRegion)this.context, name, callExp, sourceNode);
        }
    }
}

