/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;

public class ClassRelationships {
    private static final @NonNull Set<@NonNull Class> EMPTY_CLASS_SET = Collections.emptySet();
    private @NonNull Map<@NonNull Class, Set<@NonNull Class>> class2superClasses = new HashMap<Class, Set<Class>>();
    private @NonNull Map<@NonNull Class, Set<@NonNull Class>> class2directSubClasses = new HashMap<Class, Set<Class>>();
    private @NonNull Map<@NonNull Class, Set<@NonNull Class>> class2allSubClasses = new HashMap<Class, Set<Class>>();
    private @NonNull Map<@NonNull Class, Set<@NonNull Class>> class2containerClasses = new HashMap<Class, Set<Class>>();
    private @NonNull Map<@NonNull Class, Set<@NonNull ContainerClass>> class2detailedContainerClasses = new HashMap<Class, Set<ContainerClass>>();
    protected @NonNull MetamodelManager mManager;
    private Deque<@NonNull Package> packageToProcess = new LinkedList<Package>();
    private Set<@NonNull Package> processedPackage = new HashSet<Package>();

    public ClassRelationships(@NonNull EnvironmentFactory ocl) {
        this.mManager = ocl.getMetamodelManager();
        ((MetamodelManagerInternal)this.mManager).getASmetamodel();
        this.initializeMaps(ocl.getMetamodelManager().getASResourceSet());
    }

    private void initializeMaps(@NonNull ResourceSet resourceSet) {
        for (Resource resource : resourceSet.getResources()) {
            for (Package aPackage : this.getInvolvedPackages(resource)) {
                Package pPackage = this.mManager.getPrimaryPackage(aPackage);
                if (this.packageToProcess.contains(pPackage)) continue;
                this.packageToProcess.add(pPackage);
            }
        }
        while (!this.packageToProcess.isEmpty()) {
            Package aPackage = this.packageToProcess.pop();
            this.computeClass2SuperClasses(aPackage);
        }
        for (Class type : this.class2superClasses.keySet()) {
            this.computeClass2SubClasses(type);
        }
        for (Class type : this.class2superClasses.keySet()) {
            this.computeClass2ContainerClasses(type);
        }
    }

    private void computeClass2SuperClasses(@NonNull Package p) {
        if (this.processedPackage.contains(p)) {
            return;
        }
        this.processedPackage.add(p);
        for (Class aClass : ClassUtil.nullFree((List)p.getOwnedClasses())) {
            this.computeClass2SuperClasses(aClass);
        }
        for (Package nestedPackage : ClassUtil.nullFree((List)p.getOwnedPackages())) {
            this.computeClass2SuperClasses(nestedPackage);
        }
    }

    private @NonNull Set<@NonNull Class> computeClass2SuperClasses(@NonNull Class aClass) {
        Set<@NonNull Class> superRels = this.class2superClasses.get(aClass);
        if (superRels != null) {
            return superRels;
        }
        superRels = new LinkedHashSet<Class>();
        this.class2superClasses.put(aClass, superRels);
        for (Class superClass : ClassUtil.nullFree((List)aClass.getSuperClasses())) {
            superRels.add(superClass);
            superRels.addAll(this.computeClass2SuperClasses(superClass));
        }
        Package classPackage = (Package)ClassUtil.nonNullState((Object)aClass.getOwningPackage());
        Package pPackage = this.mManager.getPrimaryPackage(classPackage);
        if (!this.processedPackage.contains(pPackage) && !this.packageToProcess.contains(pPackage)) {
            this.packageToProcess.add(pPackage);
        }
        return superRels;
    }

    private void computeClass2SubClasses(Class aClass) {
        Set<@NonNull Class> superClasses = this.class2superClasses.get(aClass);
        if (superClasses != null) {
            for (Class superClass : superClasses) {
                Set<Class> allSubClasses;
                if (aClass.getSuperClasses().contains(superClass)) {
                    Set<Class> directSubClasses = this.class2directSubClasses.get(superClass);
                    if (directSubClasses == null) {
                        directSubClasses = new LinkedHashSet<Class>();
                        this.class2directSubClasses.put(superClass, directSubClasses);
                    }
                    directSubClasses.add(aClass);
                }
                if ((allSubClasses = this.class2allSubClasses.get(superClass)) == null) {
                    allSubClasses = new LinkedHashSet<Class>();
                    this.class2allSubClasses.put(superClass, allSubClasses);
                }
                allSubClasses.add(aClass);
            }
        }
    }

    private void computeClass2ContainerClasses(@NonNull Class aClass) {
        for (Property property : aClass.getOwnedProperties()) {
            Type propType = this.getType((TypedElement)property);
            if (!property.isIsComposite() || !(propType instanceof Class)) continue;
            Class isClass = propType.isClass();
            assert (isClass != null);
            this.addContainerClassForTypeAndSubtypes(aClass, property, isClass);
        }
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.mManager.getEnvironmentFactory();
    }

    private List<Package> getInvolvedPackages(Resource resource) {
        ArrayList<Model> oclRoots = new ArrayList<Model>();
        for (EObject root : resource.getContents()) {
            if (!(root instanceof Model)) continue;
            oclRoots.add((Model)root);
        }
        ArrayList<Package> result = new ArrayList<Package>();
        for (Model root : oclRoots) {
            for (Package pckg : root.getOwnedPackages()) {
                result.add(pckg);
            }
        }
        return result;
    }

    protected Type getType(TypedElement typedElement) {
        Type type = typedElement.getType();
        if (type instanceof CollectionType) {
            type = ((CollectionType)type).getElementType();
        }
        return type;
    }

    private void addContainerClassForTypeAndSubtypes(@NonNull Class containerClass, @NonNull Property containmentProperty, @NonNull Class type) {
        Set<@NonNull ContainerClass> detailedContainerClasses = this.class2detailedContainerClasses.get(type);
        Set<@NonNull Class> containerClasses = this.class2containerClasses.get(type);
        if (detailedContainerClasses == null) {
            detailedContainerClasses = new LinkedHashSet<ContainerClass>();
            this.class2detailedContainerClasses.put(type, detailedContainerClasses);
        }
        if (containerClasses == null) {
            containerClasses = new LinkedHashSet<Class>();
            this.class2containerClasses.put(type, containerClasses);
        }
        detailedContainerClasses.add(new ContainerClass(containerClass, containmentProperty));
        containerClasses.add(containerClass);
        for (Class subType : this.getDirectSubClasses(type)) {
            this.addContainerClassForTypeAndSubtypes(containerClass, containmentProperty, subType);
        }
    }

    public @NonNull Set<@NonNull Class> getAllSuperClasses(@NonNull Class type) {
        Class primaryType = this.mManager.getPrimaryClass(type);
        Set<@NonNull Class> allSuperClasses = this.class2superClasses.get(primaryType);
        return allSuperClasses == null ? EMPTY_CLASS_SET : (Set)ClassUtil.nonNullState(Collections.unmodifiableSet(allSuperClasses));
    }

    public @NonNull Set<@NonNull Class> getAllSubClasses(@NonNull Class type) {
        Class primaryType = this.mManager.getPrimaryClass(type);
        Set<@NonNull Class> allSubClasses = this.class2allSubClasses.get(primaryType);
        return allSubClasses == null ? EMPTY_CLASS_SET : (Set)ClassUtil.nonNullState(Collections.unmodifiableSet(allSubClasses));
    }

    public @NonNull Set<@NonNull Class> getDirectSubClasses(@NonNull Class type) {
        Class primaryType = this.mManager.getPrimaryClass(type);
        Set<@NonNull Class> directSubClasses = this.class2directSubClasses.get(primaryType);
        return directSubClasses == null ? EMPTY_CLASS_SET : (Set)ClassUtil.nonNullState(Collections.unmodifiableSet(directSubClasses));
    }

    public @NonNull Set<@NonNull Class> getContainerClasses(@NonNull Class type) {
        Class primaryType = this.mManager.getPrimaryClass(type);
        Set<@NonNull Class> containerClasses = this.class2containerClasses.get(primaryType);
        return containerClasses == null ? EMPTY_CLASS_SET : (Set)ClassUtil.nonNullState(Collections.unmodifiableSet(containerClasses));
    }

    public @NonNull Set<@NonNull ContainerClass> getDetailedContainerClasses(@NonNull Class type) {
        Class primaryType = this.mManager.getPrimaryClass(type);
        Set<@NonNull ContainerClass> containerClasses = this.class2detailedContainerClasses.get(primaryType);
        return (Set)ClassUtil.nonNullState(containerClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(containerClasses));
    }

    public static class ContainerClass {
        private @NonNull Class containerClass;
        private @NonNull Property containmentProperty;

        public ContainerClass(@NonNull Class containerClass, @NonNull Property containmentProperty) {
            this.containerClass = containerClass;
            this.containmentProperty = containmentProperty;
        }

        public @NonNull Class getContainerClass() {
            return this.containerClass;
        }

        public @NonNull Property getContainmentProperty() {
            return this.containmentProperty;
        }

        public @NonNull String toString() {
            return String.valueOf(this.containerClass.getName()) + " - " + this.containmentProperty.getName();
        }
    }
}

